/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class MessageOutputStream
extends OutputStream {
    private final I2PAppContext _context;
    private final Log _log;
    private byte[] _buf;
    private int _valid;
    private final Object _dataLock;
    private final DataReceiver _dataReceiver;
    private final AtomicReference<IOException> _streamError = new AtomicReference();
    private final AtomicBoolean _closed = new AtomicBoolean();
    private long _written;
    private int _writeTimeout;
    private ByteCache _dataCache;
    private final Flusher _flusher;
    private volatile long _lastBuffered;
    private final int _passiveFlushDelay;
    private volatile int _nextBufferSize;
    private static final int DEFAULT_PASSIVE_FLUSH_DELAY = 250;

    public MessageOutputStream(I2PAppContext ctx, SimpleTimer2 timer, DataReceiver receiver, int bufSize) {
        this(ctx, timer, receiver, bufSize, 250);
    }

    public MessageOutputStream(I2PAppContext ctx, SimpleTimer2 timer, DataReceiver receiver, int bufSize, int passiveFlushDelay) {
        this._dataCache = ByteCache.getInstance((int)128, (int)bufSize);
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageOutputStream.class);
        this._buf = this._dataCache.acquire().getData();
        this._dataReceiver = receiver;
        this._dataLock = new Object();
        this._writeTimeout = -1;
        this._passiveFlushDelay = passiveFlushDelay;
        this._nextBufferSize = -1;
        this._flusher = new Flusher(timer);
    }

    public void setWriteTimeout(int ms) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Changing write timeout from " + this._writeTimeout + " to " + ms);
        }
        this._writeTimeout = ms;
    }

    public int getWriteTimeout() {
        return this._writeTimeout;
    }

    public void setBufferSize(int size) {
        this._nextBufferSize = size;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this._closed.get()) {
            throw new IOException("Already closed");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("write(b[], " + off + ", " + len + ") ");
        }
        int cur = off;
        int remaining = len;
        long begin = this._context.clock().now();
        while (remaining > 0) {
            WriteStatus ws = null;
            if (this._closed.get()) {
                throw new IOException("closed underneath us");
            }
            Object object = this._dataLock;
            synchronized (object) {
                if (this._buf == null) {
                    throw new IOException("closed (buffer went away)");
                }
                if (this._valid + remaining < this._buf.length) {
                    System.arraycopy(b, cur, this._buf, this._valid, remaining);
                    this._valid += remaining;
                    cur += remaining;
                    this._written += (long)remaining;
                    remaining = 0;
                    this._lastBuffered = this._context.clock().now();
                    if (this._passiveFlushDelay > 0) {
                        this._flusher.enqueue();
                    }
                } else {
                    int toWrite = this._buf.length - this._valid;
                    System.arraycopy(b, cur, this._buf, this._valid, toWrite);
                    remaining -= toWrite;
                    cur += toWrite;
                    this._valid = this._buf.length;
                    if (this._log.shouldLog(20)) {
                        this._log.info("write() direct valid = " + this._valid);
                    }
                    ws = this._dataReceiver.writeData(this._buf, 0, this._valid);
                    this._written += (long)this._valid;
                    this._valid = 0;
                    this.throwAnyError();
                    this.locked_updateBufferSize();
                }
            }
            if (ws != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Waiting " + this._writeTimeout + "ms for accept of " + ws);
                }
                try {
                    ws.waitForAccept(this._writeTimeout);
                }
                catch (InterruptedException ie) {
                    InterruptedIOException ioe2 = new InterruptedIOException("Interrupted write");
                    ioe2.initCause(ie);
                    throw ioe2;
                }
                if (!ws.writeAccepted()) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Write not accepted of " + ws);
                    }
                    if (this._writeTimeout > 0) {
                        throw new InterruptedIOException("Write not accepted within timeout: " + ws);
                    }
                    throw new IOException("Write not accepted into the queue: " + ws);
                }
                if (!this._log.shouldLog(20)) continue;
                this._log.info("After waitForAccept of " + ws);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Queued " + len + " without sending to the receiver");
        }
        long elapsed = this._context.clock().now() - begin;
        if (elapsed > 10000L && this._log.shouldLog(20)) {
            this._log.info("wtf, took " + elapsed + "ms to write to the stream?", (Throwable)new Exception("foo"));
        }
        this.throwAnyError();
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
        this.throwAnyError();
    }

    private final void locked_updateBufferSize() {
        int size = this._nextBufferSize;
        if (size > 0) {
            this._dataCache.release(new ByteArray(this._buf));
            this._dataCache = ByteCache.getInstance((int)128, (int)size);
            ByteArray ba = this._dataCache.acquire();
            this._buf = ba.getData();
            this._nextBufferSize = -1;
        }
    }

    public void flush() throws IOException {
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean wait_for_accept_only) throws IOException {
        long begin = this._context.clock().now();
        WriteStatus ws = null;
        if (this._log.shouldLog(20) && this._valid > 0) {
            this._log.info("flush() valid = " + this._valid);
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (this._buf == null) {
                this._dataLock.notifyAll();
                throw new IOException("closed (buffer went away)");
            }
            if (!wait_for_accept_only) {
                ws = this._dataReceiver.writeData(this._buf, 0, this._valid);
                this._written += (long)this._valid;
                this._valid = 0;
                this.locked_updateBufferSize();
                this._dataLock.notifyAll();
            }
        }
        if (wait_for_accept_only) {
            this.flushAvailable(this._dataReceiver, true);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("before waiting " + this._writeTimeout + "ms for completion of " + ws);
        }
        try {
            if (this._closed.get() && (this._writeTimeout > 300000 || this._writeTimeout <= 0)) {
                ws.waitForCompletion(300000);
            } else if (this._writeTimeout <= 0 || this._writeTimeout > 300000) {
                ws.waitForCompletion(300000);
            } else {
                ws.waitForCompletion(this._writeTimeout);
            }
        }
        catch (InterruptedException ie) {
            InterruptedIOException ioe2 = new InterruptedIOException("Interrupted flush");
            ioe2.initCause(ie);
            throw ioe2;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("after waiting " + this._writeTimeout + "ms for completion of " + ws);
        }
        if (ws.writeFailed() && this._writeTimeout > 0) {
            throw new InterruptedIOException("Timed out during write");
        }
        if (ws.writeFailed()) {
            throw new IOException("Write failed");
        }
        long elapsed = this._context.clock().now() - begin;
        if (elapsed > 10000L && this._log.shouldLog(10)) {
            this._log.debug("wtf, took " + elapsed + "ms to flush the stream?\n" + ws, (Throwable)new Exception("bar"));
        }
        this.throwAnyError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this._closed.compareAndSet(false, true)) {
            Object object = this._dataLock;
            synchronized (object) {
                this._dataLock.notifyAll();
            }
            this._log.logCloseLoop(new Object[]{"MOS"});
            return;
        }
        this._flusher.cancel();
        this.flush(false);
        if (this._log.shouldLog(10)) {
            this._log.debug("Output stream closed after writing " + this._written);
        }
        ByteArray ba = null;
        Object object = this._dataLock;
        synchronized (object) {
            if (this._buf != null) {
                ba = new ByteArray(this._buf);
                this._buf = null;
                this._valid = 0;
                this.locked_updateBufferSize();
            }
            this._dataLock.notifyAll();
        }
        if (ba != null) {
            this._dataCache.release(ba);
        }
    }

    public void closeInternal() {
        if (!this._closed.compareAndSet(false, true)) {
            this._log.logCloseLoop(new Object[]{"close internal"});
            return;
        }
        this._flusher.cancel();
        this._streamError.compareAndSet(null, new IOException("Closed internally"));
        this.clearData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearData(boolean shouldFlush) {
        ByteArray ba = null;
        if (this._log.shouldLog(20) && this._valid > 0) {
            this._log.info("clearData() valid = " + this._valid);
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (this._valid > 0 && shouldFlush) {
                this._dataReceiver.writeData(this._buf, 0, this._valid);
            }
            this._written += (long)this._valid;
            this._valid = 0;
            if (this._buf != null) {
                ba = new ByteArray(this._buf);
                this._buf = null;
                this._valid = 0;
            }
            this._dataLock.notifyAll();
        }
        if (ba != null) {
            this._dataCache.release(ba);
        }
    }

    public boolean getClosed() {
        return this._closed.get();
    }

    private void throwAnyError() throws IOException {
        IOException ioe = this._streamError.getAndSet(null);
        if (ioe != null) {
            IOException ioe2 = new IOException("Output stream error");
            ioe2.initCause(ioe);
            throw ioe2;
        }
    }

    void streamErrorOccurred(IOException ioe) {
        this._streamError.compareAndSet(null, ioe);
        this.clearData(false);
    }

    void flushAvailable(DataReceiver target) throws IOException {
        this.flushAvailable(target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAvailable(DataReceiver target, boolean blocking) throws IOException {
        long afterAccept;
        WriteStatus ws = null;
        long before = System.currentTimeMillis();
        if (this._log.shouldLog(20) && this._valid > 0) {
            this._log.info("flushAvailable() valid = " + this._valid);
        }
        Object object = this._dataLock;
        synchronized (object) {
            ws = target.writeData(this._buf, 0, this._valid);
            this._written += (long)this._valid;
            this._valid = 0;
            this.locked_updateBufferSize();
            this._dataLock.notifyAll();
        }
        long afterBuild = System.currentTimeMillis();
        if (afterBuild - before > 1000L && this._log.shouldLog(10)) {
            this._log.debug("Took " + (afterBuild - before) + "ms to build a packet?  " + ws);
        }
        if (blocking && ws != null) {
            try {
                ws.waitForAccept(this._writeTimeout);
            }
            catch (InterruptedException ie) {
                InterruptedIOException ioe2 = new InterruptedIOException("Interrupted flush");
                ioe2.initCause(ie);
                throw ioe2;
            }
            if (ws.writeFailed()) {
                throw new IOException("Flush available failed");
            }
            if (!ws.writeAccepted()) {
                throw new InterruptedIOException("Flush available timed out (" + this._writeTimeout + "ms)");
            }
        }
        if ((afterAccept = System.currentTimeMillis()) - afterBuild > 1000L && this._log.shouldLog(20)) {
            this._log.info("Took " + (afterAccept - afterBuild) + "ms to accept a packet? " + ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (!this._closed.compareAndSet(false, true)) {
            this._log.logCloseLoop(new Object[]{"destroy()"});
            return;
        }
        this._flusher.cancel();
        Object object = this._dataLock;
        synchronized (object) {
            this._dataLock.notifyAll();
        }
    }

    public static interface DataReceiver {
        public WriteStatus writeData(byte[] var1, int var2, int var3);

        public boolean writeInProcess();
    }

    private class Flusher
    extends SimpleTimer2.TimedEvent {
        private boolean _enqueued;

        public Flusher(SimpleTimer2 timer) {
            super(timer);
        }

        public void enqueue() {
            if (!this._enqueued) {
                this.forceReschedule(MessageOutputStream.this._passiveFlushDelay);
                if (MessageOutputStream.this._log.shouldLog(10)) {
                    MessageOutputStream.this._log.debug("Enqueueing the flusher for " + MessageOutputStream.this._passiveFlushDelay + "ms out");
                }
            } else if (MessageOutputStream.this._log.shouldLog(10)) {
                MessageOutputStream.this._log.debug("NOT enqueing the flusher");
            }
            this._enqueued = true;
        }

        public void timeReached() {
            if (MessageOutputStream.this._closed.get()) {
                return;
            }
            this._enqueued = false;
            long timeLeft = MessageOutputStream.this._lastBuffered + (long)MessageOutputStream.this._passiveFlushDelay - MessageOutputStream.this._context.clock().now();
            if (MessageOutputStream.this._log.shouldLog(10)) {
                MessageOutputStream.this._log.debug("flusher time reached: left = " + timeLeft);
            }
            if (timeLeft > 0L) {
                this.enqueue();
            } else if (MessageOutputStream.this._dataReceiver.writeInProcess()) {
                this.enqueue();
            } else {
                this.doFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFlush() {
            boolean sent = false;
            WriteStatus ws = null;
            Object object = MessageOutputStream.this._dataLock;
            synchronized (object) {
                long flushTime = MessageOutputStream.this._lastBuffered + (long)MessageOutputStream.this._passiveFlushDelay;
                if (MessageOutputStream.this._valid > 0 && flushTime <= MessageOutputStream.this._context.clock().now()) {
                    if (MessageOutputStream.this._log.shouldLog(20)) {
                        MessageOutputStream.this._log.info("doFlush() valid = " + MessageOutputStream.this._valid);
                    }
                    if (MessageOutputStream.this._buf != null) {
                        ws = MessageOutputStream.this._dataReceiver.writeData(MessageOutputStream.this._buf, 0, MessageOutputStream.this._valid);
                        MessageOutputStream.this._written += MessageOutputStream.this._valid;
                        MessageOutputStream.this._valid = 0;
                        MessageOutputStream.this.locked_updateBufferSize();
                        MessageOutputStream.this._dataLock.notifyAll();
                        sent = true;
                    }
                } else if (MessageOutputStream.this._log.shouldLog(20) && MessageOutputStream.this._valid > 0) {
                    MessageOutputStream.this._log.info("doFlush() rejected... valid = " + MessageOutputStream.this._valid);
                }
            }
            if (sent && MessageOutputStream.this._log.shouldLog(20)) {
                MessageOutputStream.this._log.info("Passive flush of " + ws);
            }
        }
    }

    public static interface WriteStatus {
        public void waitForCompletion(int var1) throws IOException, InterruptedException;

        public void waitForAccept(int var1) throws IOException, InterruptedException;

        public boolean writeAccepted();

        public boolean writeFailed();

        public boolean writeSuccessful();
    }
}

