/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectionKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.impl.MessageInputStream;
import net.i2p.client.streaming.impl.MessageOutputStream;

public class MessageChannel
extends SelectableChannel
implements ReadableByteChannel,
WritableByteChannel {
    private final MessageInputStream in;
    private final MessageOutputStream out;
    private boolean _isRegistered;
    private SelectionKey whichKey;
    private SelectorProvider provider;
    private Selector sel;
    private Object lock;
    private final I2PSocket socket;

    MessageChannel(I2PSocket socket) {
        try {
            this.socket = socket;
            this.in = (MessageInputStream)socket.getInputStream();
            this.out = (MessageOutputStream)socket.getOutputStream();
            this.in.setReadTimeout(0);
            this.out.setWriteTimeout(0);
            this.out.setBufferSize(4096);
        }
        catch (IOException ex) {
            Logger.getLogger(MessageChannel.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public SelectorProvider provider() {
        return this.provider;
    }

    public int validOps() {
        return 5;
    }

    public boolean isRegistered() {
        return this._isRegistered;
    }

    public SelectionKey keyFor(Selector arg0) {
        return this.whichKey;
    }

    public SelectionKey register(final Selector sel, final int ops, Object lock) throws ClosedChannelException {
        this.sel = sel;
        this.provider = sel.provider();
        this.lock = lock;
        this._isRegistered = true;
        final MessageChannel that = this;
        AbstractSelectionKey key = new AbstractSelectionKey(){
            int operations;
            {
                this.operations = ops;
            }

            public SelectableChannel channel() {
                return that;
            }

            public Selector selector() {
                return sel;
            }

            public int interestOps() {
                return this.operations;
            }

            public SelectionKey interestOps(int ops2) {
                this.operations = ops2;
                return this;
            }

            public int readyOps() {
                int readyOps = 0;
                if ((this.operations & 1) != 0) {
                    try {
                        if (MessageChannel.this.in.available() > 0) {
                            readyOps |= 1;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((this.operations & 4) != 0 && !MessageChannel.this.out.getClosed()) {
                    readyOps |= 4;
                }
                return readyOps;
            }
        };
        key.attach(lock);
        sel.keys().add(key);
        return key;
    }

    public SelectableChannel configureBlocking(boolean blocking) throws IOException {
        if (!blocking) {
            return this;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isBlocking() {
        return false;
    }

    public Object blockingLock() {
        return this.lock;
    }

    protected void implCloseChannel() throws IOException {
        this.socket.close();
    }

    public int read(ByteBuffer buf) throws IOException {
        int amount = 0;
        while (true) {
            byte[] lbuf;
            int samount;
            if ((samount = this.in.read(lbuf = new byte[buf.remaining()])) <= 0) {
                this.close();
            }
            if (samount == 0) break;
            amount += samount;
            buf.put(lbuf, 0, samount);
        }
        return amount;
    }

    public int write(ByteBuffer buf) throws IOException {
        int written = 0;
        while (buf.remaining() != 0) {
            byte[] lbuf = new byte[Math.min(buf.remaining(), 4096)];
            buf.get(lbuf);
            try {
                this.out.write(lbuf, 0, lbuf.length);
                written += lbuf.length;
            }
            catch (InterruptedIOException ex) {
                buf.put(lbuf);
                return written;
            }
        }
        return written;
    }
}

