/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.I2PServerSocketFull;
import net.i2p.client.streaming.impl.I2PSocketFull;
import net.i2p.client.streaming.impl.PcapWriter;
import net.i2p.client.streaming.impl.StandardServerSocket;
import net.i2p.client.streaming.impl.StandardSocket;
import net.i2p.client.streaming.impl.TooManyStreamsException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2PSocketManagerFull
implements I2PSocketManager {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final I2PServerSocketFull _serverSocket;
    private StandardServerSocket _realServerSocket;
    private final ConnectionOptions _defaultOptions;
    private long _acceptTimeout;
    private String _name;
    private static final AtomicInteger __managerId = new AtomicInteger();
    private final ConnectionManager _connectionManager;
    private final AtomicBoolean _isDestroyed = new AtomicBoolean();
    private static final long ACCEPT_TIMEOUT_DEFAULT = 5000L;
    private static final Object _pcapInitLock = new Object();
    private static boolean _pcapInitialized;
    static PcapWriter pcapWriter;
    static final String PROP_PCAP = "i2p.streaming.pcap";
    private static final String PCAP_FILE = "streaming.pcap";

    public I2PSocketManagerFull() {
        throw new UnsupportedOperationException();
    }

    public void init(I2PAppContext context, I2PSession session, Properties opts, String name) {
        throw new UnsupportedOperationException();
    }

    public I2PSocketManagerFull(I2PAppContext context, I2PSession session, Properties opts, String name) {
        this._context = context;
        this._session = session;
        this._log = this._context.logManager().getLog(I2PSocketManagerFull.class);
        this._name = name + " " + __managerId.incrementAndGet();
        this._acceptTimeout = 5000L;
        this._defaultOptions = new ConnectionOptions(opts);
        this._connectionManager = new ConnectionManager(this._context, this._session, this._defaultOptions);
        this._serverSocket = new I2PServerSocketFull(this);
        if (this._log.shouldLog(20)) {
            this._log.info("Socket manager created.  \ndefault options: " + this._defaultOptions + "\noriginal properties: " + opts);
        }
        I2PSocketManagerFull.debugInit(context);
    }

    public I2PSocketOptions buildOptions() {
        return this.buildOptions(null);
    }

    public I2PSocketOptions buildOptions(Properties opts) {
        ConnectionOptions curOpts = new ConnectionOptions(this._defaultOptions);
        curOpts.setProperties(opts);
        return curOpts;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    public I2PSocket receiveSocket() throws I2PException, SocketTimeoutException {
        this.verifySession();
        Connection con = this._connectionManager.getConnectionHandler().accept(this._connectionManager.getSoTimeout());
        if (this._log.shouldLog(10)) {
            this._log.debug("receiveSocket() called: " + con);
        }
        if (con != null) {
            I2PSocketFull sock = new I2PSocketFull(con, this._context);
            con.setSocket(sock);
            return sock;
        }
        if (this._connectionManager.getSoTimeout() == -1L) {
            return null;
        }
        throw new SocketTimeoutException("I2PSocket timed out");
    }

    public boolean ping(Destination peer, long timeoutMs) {
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("bad timeout");
        }
        return this._connectionManager.ping(peer, this._defaultOptions.getLocalPort(), this._defaultOptions.getPort(), timeoutMs);
    }

    public boolean ping(Destination peer, int localPort, int remotePort, long timeoutMs) {
        if (localPort < 0 || localPort > 65535 || remotePort < 0 || remotePort > 65535) {
            throw new IllegalArgumentException("bad port");
        }
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("bad timeout");
        }
        return this._connectionManager.ping(peer, localPort, remotePort, timeoutMs);
    }

    public void setAcceptTimeout(long ms) {
        this._acceptTimeout = ms;
    }

    public long getAcceptTimeout() {
        return this._acceptTimeout;
    }

    public void setDefaultOptions(I2PSocketOptions options) {
        if (!(options instanceof ConnectionOptions)) {
            throw new IllegalArgumentException();
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Changing options from:\n " + this._defaultOptions + "\nto:\n " + options);
        }
        this._defaultOptions.updateAll((ConnectionOptions)options);
        this._connectionManager.updateOptions();
    }

    public I2PSocketOptions getDefaultOptions() {
        return this._defaultOptions;
    }

    public I2PServerSocket getServerSocket() {
        this._connectionManager.setAllowIncomingConnections(true);
        return this._serverSocket;
    }

    public synchronized ServerSocket getStandardServerSocket() throws IOException {
        if (this._realServerSocket == null) {
            this._realServerSocket = new StandardServerSocket(this._serverSocket);
        }
        this._connectionManager.setAllowIncomingConnections(true);
        return this._realServerSocket;
    }

    private void verifySession() throws I2PException {
        if (this._isDestroyed.get()) {
            throw new I2PException("Session was closed");
        }
        if (!this._connectionManager.getSession().isClosed()) {
            return;
        }
        this._connectionManager.getSession().connect();
    }

    public I2PSocket connect(Destination peer, I2PSocketOptions options) throws I2PException, NoRouteToHostException {
        Connection con;
        this.verifySession();
        if (options == null) {
            options = this._defaultOptions;
        }
        ConnectionOptions opts = null;
        opts = options instanceof ConnectionOptions ? new ConnectionOptions((ConnectionOptions)options) : new ConnectionOptions(options);
        if (this._log.shouldLog(20)) {
            this._log.info("Connecting to " + peer.calculateHash().toBase64().substring(0, 6) + " with options: " + opts);
        }
        if ((con = this._connectionManager.connect(peer, opts)) == null) {
            throw new TooManyStreamsException("Too many streams, max " + this._defaultOptions.getMaxConns());
        }
        I2PSocketFull socket = new I2PSocketFull(con, this._context);
        con.setSocket(socket);
        if (con.getConnectionError() != null) {
            con.disconnect(false);
            throw new NoRouteToHostException(con.getConnectionError());
        }
        return socket;
    }

    public I2PSocket connect(Destination peer) throws I2PException, NoRouteToHostException {
        return this.connect(peer, this._defaultOptions);
    }

    public Socket connectToSocket(Destination peer) throws IOException {
        return this.connectToSocket(peer, this._defaultOptions);
    }

    public Socket connectToSocket(Destination peer, int timeout) throws IOException {
        ConnectionOptions opts = new ConnectionOptions(this._defaultOptions);
        opts.setConnectTimeout(timeout);
        if (timeout > 0) {
            opts.setConnectDelay(-1);
        }
        return this.connectToSocket(peer, opts);
    }

    private Socket connectToSocket(Destination peer, I2PSocketOptions options) throws IOException {
        try {
            I2PSocket sock = this.connect(peer, options);
            return new StandardSocket(sock);
        }
        catch (I2PException i2pe) {
            IOException ioe = new IOException("connect fail");
            ioe.initCause(i2pe);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySocketManager() {
        if (!this._isDestroyed.compareAndSet(false, true)) {
            this._log.logCloseLoop(new Object[]{"I2PSocketManager", this.getName()});
            return;
        }
        this._connectionManager.setAllowIncomingConnections(false);
        this._connectionManager.shutdown();
        if (this._session != null && !this._session.isClosed()) {
            try {
                this._session.destroySession();
            }
            catch (I2PSessionException ise) {
                this._log.warn("Unable to destroy the session", (Throwable)ise);
            }
            PcapWriter pcap = null;
            Object object = _pcapInitLock;
            synchronized (object) {
                pcap = pcapWriter;
            }
            if (pcap != null) {
                pcap.flush();
            }
        }
    }

    public boolean isDestroyed() {
        return this._isDestroyed.get();
    }

    public Set<I2PSocket> listSockets() {
        Set<Connection> connections = this._connectionManager.listConnections();
        HashSet<I2PSocket> rv = new HashSet<I2PSocket>(connections.size());
        for (Connection con : connections) {
            if (con.getSocket() == null) continue;
            rv.add(con.getSocket());
        }
        return rv;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void addDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._connectionManager.getMessageHandler().addDisconnectListener(lsnr);
    }

    public void removeDisconnectListener(I2PSocketManager.DisconnectListener lsnr) {
        this._connectionManager.getMessageHandler().removeDisconnectListener(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugInit(I2PAppContext ctx) {
        if (!ctx.getBooleanProperty(PROP_PCAP)) {
            return;
        }
        Object object = _pcapInitLock;
        synchronized (object) {
            if (!_pcapInitialized) {
                try {
                    pcapWriter = new PcapWriter(ctx, PCAP_FILE);
                }
                catch (IOException ioe) {
                    System.err.println("pcap init ioe: " + ioe);
                }
                _pcapInitialized = true;
            }
        }
    }
}

