/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.apps.systray.SysTray;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.data.DataHelper;
import net.i2p.desktopgui.Main;
import net.i2p.jetty.I2PLogger;
import net.i2p.router.RouterContext;
import net.i2p.router.app.RouterApp;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.LocaleWebAppHandler;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.PluginStopper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.WebAppStarter;
import net.i2p.util.Addresses;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.PortMapper;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SystemVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

public class RouterConsoleRunner
implements RouterApp {
    private final RouterContext _context;
    private final ClientAppManager _mgr;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private static Server _server;
    private String _listenPort;
    private String _listenHost;
    private String _sslListenPort;
    private String _sslListenHost;
    private String _webAppsDir;
    private static final String DEFAULT_WEBAPP_CONFIG_FILENAME = "webapps.config";
    private static final DigestAuthenticator authenticator;
    public static final String JETTY_REALM = "i2prouter";
    private static final String JETTY_ROLE = "routerAdmin";
    public static final String PROP_CONSOLE_PW = "routerconsole.auth.i2prouter";
    public static final String PROP_PW_ENABLE = "routerconsole.auth.enable";
    public static final String ROUTERCONSOLE = "routerconsole";
    public static final String PREFIX = "webapps.";
    public static final String ENABLED = ".startOnLoad";
    private static final String PROP_KEYSTORE_PASSWORD = "routerconsole.keystorePassword";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String PROP_KEY_PASSWORD = "routerconsole.keyPassword";
    public static final int DEFAULT_LISTEN_PORT = 7657;
    private static final String DEFAULT_LISTEN_HOST = "127.0.0.1";
    private static final String DEFAULT_WEBAPPS_DIR = "./webapps/";
    private static final String USAGE = "Bad RouterConsoleRunner arguments, check clientApp.0.args in your clients.config file! Usage: [[port host[,host]] [-s sslPort [host[,host]]] [webAppsDir]]";
    private static final int MIN_THREADS = 1;
    private static final int MAX_THREADS = 24;
    private static final int MAX_IDLE_TIME = 90000;
    private static final String THREAD_NAME = "RouterConsole Jetty";

    public RouterConsoleRunner(RouterContext ctx, ClientAppManager mgr, String[] args) {
        this._context = ctx;
        this._mgr = mgr;
        if (args.length == 0) {
            this._listenPort = Integer.toString(7657);
        } else {
            boolean ssl = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-s")) {
                    ssl = true;
                    continue;
                }
                if (!ssl && this._listenPort == null) {
                    this._listenPort = args[i];
                    continue;
                }
                if (!ssl && this._listenHost == null) {
                    this._listenHost = args[i];
                    continue;
                }
                if (ssl && this._sslListenPort == null) {
                    this._sslListenPort = args[i];
                    continue;
                }
                if (ssl && this._sslListenHost == null) {
                    this._sslListenHost = args[i];
                    continue;
                }
                if (this._webAppsDir == null) {
                    this._webAppsDir = args[i];
                    continue;
                }
                System.err.println(USAGE);
                throw new IllegalArgumentException(USAGE);
            }
        }
        if (this._listenHost == null) {
            this._listenHost = DEFAULT_LISTEN_HOST;
        }
        if (this._sslListenHost == null) {
            this._sslListenHost = this._listenHost;
        }
        if (this._webAppsDir == null) {
            this._webAppsDir = DEFAULT_WEBAPPS_DIR;
        }
        if (this._listenPort == null && this._sslListenPort == null) {
            System.err.println(USAGE);
            throw new IllegalArgumentException(USAGE);
        }
        this._state = ClientAppState.INITIALIZED;
    }

    public static void main(String[] args) {
        List<RouterContext> contexts = RouterContext.listContexts();
        if (contexts == null || contexts.isEmpty()) {
            throw new IllegalStateException("no router context");
        }
        RouterConsoleRunner runner = new RouterConsoleRunner(contexts.get(0), null, args);
        runner.startup();
    }

    @Override
    public synchronized void startup() {
        this.changeState(ClientAppState.STARTING);
        RouterConsoleRunner.startTrayApp(this._context);
        this.startConsole();
    }

    @Override
    public synchronized void shutdown(String[] args) {
        if (this._state == ClientAppState.STOPPED) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        if (PluginStarter.pluginsEnabled(this._context)) {
            new I2PAppThread(new PluginStopper(this._context), "PluginStopper").start();
        }
        try {
            _server.stop();
        }
        catch (Exception ie) {
            // empty catch block
        }
        PortMapper portMapper = this._context.portMapper();
        portMapper.unregister("console");
        portMapper.unregister("https_console");
        this.changeState(ClientAppState.STOPPED);
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return "console";
    }

    @Override
    public String getDisplayName() {
        return "Router Console";
    }

    private synchronized void changeState(ClientAppState state) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify(this, state, null, null);
        }
    }

    static Server getConsoleServer() {
        return _server;
    }

    private static void startTrayApp(I2PAppContext ctx) {
        try {
            boolean recentJava = SystemVersion.isJava6();
            boolean desktopguiEnabled = ctx.getBooleanProperty("desktopgui.enabled");
            if (recentJava && desktopguiEnabled) {
                System.setProperty("java.awt.headless", Boolean.toString(GraphicsEnvironment.isHeadless()));
                String[] args = new String[]{};
                Main.beginStartup((String[])args);
            } else {
                System.setProperty("java.awt.headless", "true");
                if (SystemVersion.isWindows() && !Boolean.getBoolean("systray.disable") && !SystemVersion.is64Bit()) {
                    SysTray.getInstance();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void startConsole() {
        File app;
        boolean workDirCreated;
        SecureDirectory workDir = new SecureDirectory(this._context.getTempDir(), "jetty-work");
        boolean workDirRemoved = FileUtil.rmdir(workDir, false);
        if (!workDirRemoved) {
            System.err.println("ERROR: Unable to remove Jetty temporary work directory");
        }
        if (!(workDirCreated = ((File)workDir).mkdirs())) {
            System.err.println("ERROR: Unable to create Jetty temporary work directory");
        }
        System.setProperty("jetty.class.path", this._context.getBaseDir() + "/lib/routerconsole.jar");
        _server = new Server();
        _server.setGracefulShutdown(1000);
        try {
            CustomThreadPoolExecutor ctp = new CustomThreadPoolExecutor();
            _server.setThreadPool((ThreadPool)ctp);
        }
        catch (Throwable t) {
            System.out.println("INFO: Jetty concurrent ThreadPool unavailable, using QueuedThreadPool");
            QueuedThreadPool qtp = new QueuedThreadPool(24);
            qtp.setMinThreads(1);
            qtp.setMaxIdleTimeMs(90000);
            _server.setThreadPool((ThreadPool)qtp);
        }
        HandlerCollection hColl = new HandlerCollection();
        ContextHandlerCollection chColl = new ContextHandlerCollection();
        _server.setHandler((Handler)hColl);
        hColl.addHandler((Handler)chColl);
        hColl.addHandler((Handler)new DefaultHandler());
        String log = this._context.getProperty("routerconsole.log");
        if (log != null) {
            File logFile = new File(log);
            if (!logFile.isAbsolute()) {
                logFile = new File(this._context.getLogDir(), "logs/" + log);
            }
            try {
                RequestLogHandler rhl = new RequestLogHandler();
                rhl.setRequestLog((RequestLog)new NCSARequestLog(logFile.getAbsolutePath()));
                hColl.addHandler((Handler)rhl);
            }
            catch (Exception ioe) {
                System.err.println("ERROR: Unable to create Jetty log: " + ioe);
            }
        }
        boolean rewrite = false;
        Properties props = this.webAppProperties();
        if (props.isEmpty()) {
            props.setProperty("webapps.routerconsole.startOnLoad", "true");
            rewrite = true;
        }
        if (!(app = new File(this._webAppsDir)).isAbsolute()) {
            app = new File(this._context.getBaseDir(), this._webAppsDir);
            try {
                this._webAppsDir = app.getCanonicalPath();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (!this._webAppsDir.endsWith("/")) {
            this._webAppsDir = this._webAppsDir + '/';
        }
        LocaleWebAppHandler rootWebApp = null;
        ServletHandler rootServletHandler = null;
        ArrayList<Object> connectors = new ArrayList<Object>(4);
        try {
            int boundAddresses = 0;
            SortedSet<String> addresses = Addresses.getAllAddresses();
            boolean bl = addresses.contains("0.0.0.0");
            boolean hasIPV6 = addresses.contains("0:0:0:0:0:0:0:0");
            int lport = 0;
            if (this._listenPort != null) {
                try {
                    lport = Integer.parseInt(this._listenPort);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (lport <= 0) {
                    System.err.println("Bad routerconsole port " + this._listenPort);
                }
            }
            if (lport > 0) {
                StringTokenizer tok = new StringTokenizer(this._listenHost, " ,");
                while (tok.hasMoreTokens()) {
                    String host = tok.nextToken().trim();
                    try {
                        SocketConnector lsnr;
                        InetAddress test = InetAddress.getByName(host);
                        if (!hasIPV6 && !(test instanceof Inet4Address)) {
                            throw new IOException("IPv6 addresses unsupported");
                        }
                        if (!bl && test instanceof Inet4Address) {
                            throw new IOException("IPv4 addresses unsupported");
                        }
                        ServerSocket testSock = null;
                        try {
                            testSock = new ServerSocket();
                            InetSocketAddress isa = new InetSocketAddress(host, 0);
                            testSock.bind(isa);
                        }
                        finally {
                            if (testSock != null) {
                                try {
                                    testSock.close();
                                }
                                catch (IOException ioe) {}
                            }
                        }
                        if (SystemVersion.isJava6() && !SystemVersion.isGNU()) {
                            SelectChannelConnector slsnr = new SelectChannelConnector();
                            slsnr.setUseDirectBuffers(false);
                            lsnr = slsnr;
                        } else {
                            lsnr = new SocketConnector();
                        }
                        lsnr.setHost(host);
                        lsnr.setPort(lport);
                        lsnr.setMaxIdleTime(90000);
                        lsnr.setName("ConsoleSocket");
                        lsnr.setAcceptors(1);
                        connectors.add(lsnr);
                        ++boundAddresses;
                    }
                    catch (Exception ioe) {
                        System.err.println("Unable to bind routerconsole to " + host + " port " + this._listenPort + ": " + ioe);
                        System.err.println("You may ignore this warning if the console is still available at http://localhost:" + this._listenPort);
                    }
                }
                this._context.portMapper().register("console", lport);
            }
            int sslPort = 0;
            if (this._sslListenPort != null) {
                try {
                    sslPort = Integer.parseInt(this._sslListenPort);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (sslPort <= 0) {
                    System.err.println("Bad routerconsole SSL port " + this._sslListenPort);
                }
            }
            if (sslPort > 0) {
                File keyStore = new File(this._context.getConfigDir(), "keystore/console.ks");
                if (this.verifyKeyStore(keyStore)) {
                    SslContextFactory sslFactory = new SslContextFactory(keyStore.getAbsolutePath());
                    sslFactory.setKeyStorePassword(this._context.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD));
                    sslFactory.setKeyManagerPassword(this._context.getProperty(PROP_KEY_PASSWORD, "thisWontWork"));
                    StringTokenizer tok = new StringTokenizer(this._sslListenHost, " ,");
                    while (tok.hasMoreTokens()) {
                        String host = tok.nextToken().trim();
                        try {
                            SslSocketConnector ssll;
                            SslSocketConnector sssll;
                            InetAddress test = InetAddress.getByName(host);
                            if (!hasIPV6 && !(test instanceof Inet4Address)) {
                                throw new IOException("IPv6 addresses unsupported");
                            }
                            if (!bl && test instanceof Inet4Address) {
                                throw new IOException("IPv4 addresses unsupported");
                            }
                            ServerSocket testSock = null;
                            try {
                                testSock = new ServerSocket();
                                InetSocketAddress isa = new InetSocketAddress(host, 0);
                                testSock.bind(isa);
                            }
                            finally {
                                if (testSock != null) {
                                    try {
                                        testSock.close();
                                    }
                                    catch (IOException ioe) {}
                                }
                            }
                            if (SystemVersion.isJava6() && !SystemVersion.isGNU()) {
                                sssll = new SslSelectChannelConnector(sslFactory);
                                sssll.setUseDirectBuffers(false);
                                ssll = sssll;
                            } else {
                                ssll = sssll = new SslSocketConnector(sslFactory);
                            }
                            ssll.setHost(host);
                            ssll.setPort(sslPort);
                            ssll.setMaxIdleTime(90000);
                            ssll.setName("ConsoleSocket");
                            ssll.setAcceptors(1);
                            connectors.add(ssll);
                            ++boundAddresses;
                        }
                        catch (Exception e) {
                            System.err.println("Unable to bind routerconsole to " + host + " port " + sslPort + " for SSL: " + e);
                            if (SystemVersion.isGNU()) {
                                System.err.println("Probably because GNU classpath does not support Sun keystores");
                            }
                            System.err.println("You may ignore this warning if the console is still available at https://localhost:" + sslPort);
                        }
                    }
                    this._context.portMapper().register("https_console", sslPort);
                } else {
                    System.err.println("Unable to create or access keystore for SSL: " + keyStore.getAbsolutePath());
                }
            }
            if (boundAddresses <= 0) {
                System.err.println("Unable to bind routerconsole to any address on port " + this._listenPort + (sslPort > 0 ? " or SSL port " + sslPort : ""));
                return;
            }
            SecureDirectory tmpdir = new SecureDirectory(workDir, "routerconsole-" + (this._listenPort != null ? this._listenPort : this._sslListenPort));
            ((File)tmpdir).mkdir();
            rootServletHandler = new ServletHandler();
            rootWebApp = new LocaleWebAppHandler(this._context, "/", this._webAppsDir + ROUTERCONSOLE + ".war", tmpdir, rootServletHandler);
            RouterConsoleRunner.initialize(this._context, (WebAppContext)rootWebApp.getHandler());
            chColl.addHandler((Handler)rootWebApp);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        Resource.setDefaultUseCaches((boolean)false);
        try {
            _server.start();
        }
        catch (Throwable me) {
            System.err.println("Error starting the Router Console server: " + me);
            me.printStackTrace();
        }
        if (_server.isRunning()) {
            boolean error = false;
            for (Connector connector : connectors) {
                try {
                    _server.addConnector(connector);
                    connector.start();
                }
                catch (Throwable me) {
                    try {
                        _server.removeConnector(connector);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    System.err.println("WARNING: Error starting " + connector + ": " + me);
                    me.printStackTrace();
                    error = true;
                }
            }
            if (error) {
                System.err.println("WARNING: Error starting one or more listeners of the Router Console server.\nIf your console is still accessible at http://127.0.0.1:" + this._listenPort + "/,\n" + "this may be a problem only with binding to the IPV6 address ::1.\n" + "If so, you may ignore this error, or remove the\n" + "\"::1,\" in the \"clientApp.0.args\" line of the clients.config file.");
            }
        }
        ArrayList<String> notStarted = new ArrayList<String>();
        if (_server.isRunning()) {
            File dir = new File(this._webAppsDir);
            String[] stringArray = dir.list(WarFilenameFilter.instance());
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String appName = stringArray[i].substring(0, stringArray[i].lastIndexOf(".war"));
                    String enabled = props.getProperty(PREFIX + appName + ENABLED);
                    if (!"false".equals(enabled)) {
                        try {
                            String path = new File(dir, stringArray[i]).getCanonicalPath();
                            WebAppStarter.startWebApp(this._context, chColl, appName, path);
                            if (enabled != null) continue;
                            props.setProperty(PREFIX + appName + ENABLED, "true");
                            rewrite = true;
                        }
                        catch (Throwable t) {
                            System.err.println("ERROR: Failed to start " + appName + ' ' + t);
                            t.printStackTrace();
                            notStarted.add(appName);
                        }
                        continue;
                    }
                    notStarted.add(appName);
                }
                this.changeState(ClientAppState.RUNNING);
                if (this._mgr != null) {
                    this._mgr.register(this);
                }
            }
        } else {
            System.err.println("ERROR: Router console did not start, not starting webapps");
            this.changeState(ClientAppState.START_FAILED);
        }
        if (rewrite) {
            RouterConsoleRunner.storeWebAppProperties(this._context, props);
        }
        if (rootServletHandler != null && notStarted.size() > 0) {
            void var15_27;
            ServletHolder noWebApp = rootServletHandler.getServlet("net.i2p.router.web.jsp.nowebapp_jsp");
            boolean bl = false;
            while (var15_27 < notStarted.size()) {
                try {
                    if (noWebApp != null) {
                        String path = '/' + (String)notStarted.get((int)var15_27);
                        rootServletHandler.addServletWithMapping(noWebApp, path + ".jsp");
                        rootServletHandler.addServletWithMapping(noWebApp, path + "/*");
                    } else {
                        System.err.println("Can't find nowebapp.jsp?");
                    }
                }
                catch (Throwable me) {
                    System.err.println(me);
                    me.printStackTrace();
                }
                ++var15_27;
            }
        }
        I2PAppThread t = new I2PAppThread(new StatSummarizer(), "StatSummarizer", true);
        t.setPriority(4);
        t.start();
        ConsoleUpdateManager consoleUpdateManager = new ConsoleUpdateManager(this._context, this._mgr, null);
        consoleUpdateManager.start();
        if (PluginStarter.pluginsEnabled(this._context)) {
            t = new I2PAppThread(new PluginStarter(this._context), "PluginStarter", true);
            t.setPriority(4);
            t.start();
        }
        if (this._mgr == null) {
            this._context.addShutdownTask(new ServerShutdown());
        }
        ConfigServiceHandler.registerSignalHandler(this._context);
    }

    private boolean verifyKeyStore(File ks) {
        if (ks.exists()) {
            boolean rv;
            boolean bl = rv = this._context.getProperty(PROP_KEY_PASSWORD) != null;
            if (!rv) {
                System.err.println("Console SSL error, must set routerconsole.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
            }
            return rv;
        }
        return this.createKeyStore(ks);
    }

    private boolean createKeyStore(File ks) {
        String keyPassword = KeyStoreUtil.randomString();
        String cname = KeyStoreUtil.randomString() + ".console.i2p.net";
        boolean success = KeyStoreUtil.createKeys(ks, "console", cname, "Console", keyPassword);
        if (success && (success = ks.exists())) {
            try {
                HashMap<String, String> changes = new HashMap<String, String>();
                changes.put(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
                changes.put(PROP_KEY_PASSWORD, keyPassword);
                this._context.router().saveConfig(changes, null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (success) {
            System.err.println("Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath() + "\n" + "The certificate name was generated randomly, and is not associated with your " + "IP address, host name, router identity, or destination keys.");
        } else {
            System.err.println("Failed to create console SSL keystore.\nThis is for the Sun/Oracle keytool, others may be incompatible.\nIf you create the keystore manually, you must add routerconsole.keystorePassword and routerconsole.keyPassword to " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
        }
        return success;
    }

    static void initialize(RouterContext ctx, WebAppContext context) {
        ConstraintSecurityHandler sec = new ConstraintSecurityHandler();
        ArrayList<ConstraintMapping> constraints = new ArrayList<ConstraintMapping>(4);
        ConsolePasswordManager mgr = new ConsolePasswordManager(ctx);
        boolean enable = ctx.getBooleanProperty(PROP_PW_ENABLE);
        if (enable) {
            Map<String, String> userpw = mgr.getMD5(PROP_CONSOLE_PW);
            if (userpw.isEmpty()) {
                enable = false;
                ctx.router().saveConfig(PROP_CONSOLE_PW, "false");
            } else {
                HashLoginService realm = new HashLoginService(JETTY_REALM);
                sec.setLoginService((LoginService)realm);
                sec.setAuthenticator((Authenticator)authenticator);
                for (Map.Entry<String, String> e : userpw.entrySet()) {
                    String user = e.getKey();
                    String pw = e.getValue();
                    realm.putUser(user, Credential.getCredential((String)("MD5:" + pw)), new String[]{JETTY_ROLE});
                    Constraint constraint = new Constraint(user, JETTY_ROLE);
                    constraint.setAuthenticate(true);
                    ConstraintMapping cm = new ConstraintMapping();
                    cm.setConstraint(constraint);
                    cm.setPathSpec("/");
                    constraints.add(cm);
                }
            }
        }
        Constraint sc = new Constraint();
        sc.setName("No trace");
        ConstraintMapping cm = new ConstraintMapping();
        cm.setMethod("TRACE");
        cm.setConstraint(sc);
        cm.setPathSpec("/");
        constraints.add(cm);
        sc = new Constraint();
        sc.setName("No options");
        cm = new ConstraintMapping();
        cm.setMethod("OPTIONS");
        cm.setConstraint(sc);
        cm.setPathSpec("/");
        constraints.add(cm);
        ConstraintMapping[] cmarr = constraints.toArray(new ConstraintMapping[constraints.size()]);
        sec.setConstraintMappings(cmarr);
        context.setSecurityHandler((SecurityHandler)sec);
    }

    private Properties webAppProperties() {
        return RouterConsoleRunner.webAppProperties(this._context.getConfigDir().getAbsolutePath());
    }

    public static Properties webAppProperties(I2PAppContext ctx) {
        return RouterConsoleRunner.webAppProperties(ctx.getConfigDir().getAbsolutePath());
    }

    public static Properties webAppProperties(String dir) {
        Properties rv = new Properties();
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(dir, webappConfigFile);
        try {
            DataHelper.loadProps(rv, cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return rv;
    }

    public static void storeWebAppProperties(RouterContext ctx, Properties props) {
        String webappConfigFile = DEFAULT_WEBAPP_CONFIG_FILENAME;
        File cfgFile = new File(ctx.getConfigDir(), webappConfigFile);
        try {
            DataHelper.storeProps(props, cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    static {
        try {
            Log.setLog((Logger)new I2PLogger());
        }
        catch (Throwable t) {
            System.err.println("INFO: I2P Jetty logging class not found, logging to wrapper log");
        }
        authenticator = new DigestAuthenticator();
        authenticator.setMaxNonceAge(604800000L);
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName(RouterConsoleRunner.THREAD_NAME);
            rv.setDaemon(true);
            return rv;
        }
    }

    private static class CustomThreadPoolExecutor
    extends ExecutorThreadPool {
        public CustomThreadPoolExecutor() {
            super((ExecutorService)new ThreadPoolExecutor(1, 24, 90000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
        }
    }

    private class ServerShutdown
    implements Runnable {
        private ServerShutdown() {
        }

        @Override
        public void run() {
            RouterConsoleRunner.this.shutdown(null);
        }
    }

    static class WarFilenameFilter
    implements FilenameFilter {
        private static final WarFilenameFilter _filter = new WarFilenameFilter();

        WarFilenameFilter() {
        }

        public static WarFilenameFilter instance() {
            return _filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".war") && !name.equals("routerconsole.war");
        }
    }
}

