/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.data.Base64;
import net.i2p.data.Hash;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.web.FormHandler;

public class ConfigPeerHandler
extends FormHandler {
    private String _peer;
    private String _speed;
    private String _capacity;

    @Override
    protected void processForm() {
        if ("Save Configuration".equals(this._action)) {
            this._context.router().saveConfig();
            this.addFormNotice("Settings saved - not really!!!!!");
        } else if (this._action.equals(this._("Ban peer until restart"))) {
            Hash h = this.getHash();
            if (h != null) {
                this._context.banlist().banlistRouterForever(h, this._("Manually banned via {0}"), "<a href=\"configpeer\">configpeer</a>");
                this.addFormNotice(this._("Peer") + " " + this._peer + " " + this._("banned until restart"));
                return;
            }
            this.addFormError(this._("Invalid peer"));
        } else if (this._action.equals(this._("Unban peer"))) {
            Hash h = this.getHash();
            if (h != null) {
                if (this._context.banlist().isBanlisted(h)) {
                    this._context.banlist().unbanlistRouter(h);
                    this.addFormNotice(this._("Peer") + " " + this._peer + " " + this._("unbanned"));
                } else {
                    this.addFormNotice(this._("Peer") + " " + this._peer + " " + this._("is not currently banned"));
                }
                return;
            }
            this.addFormError(this._("Invalid peer"));
        } else if (this._action.equals(this._("Adjust peer bonuses"))) {
            Hash h = this.getHash();
            if (h != null) {
                PeerProfile prof = this._context.profileOrganizer().getProfile(h);
                if (prof != null) {
                    try {
                        prof.setSpeedBonus(Long.parseLong(this._speed));
                    }
                    catch (NumberFormatException nfe) {
                        this.addFormError(this._("Bad speed value"));
                    }
                    try {
                        prof.setCapacityBonus(Long.parseLong(this._capacity));
                    }
                    catch (NumberFormatException nfe) {
                        this.addFormError(this._("Bad capacity value"));
                    }
                    this.addFormNotice("Bonuses adjusted for " + this._peer);
                } else {
                    this.addFormError("No profile exists for " + this._peer);
                }
                return;
            }
            this.addFormError(this._("Invalid peer"));
        } else if (this._action.startsWith("Check")) {
            this.addFormError(this._("Unsupported"));
        }
    }

    private Hash getHash() {
        byte[] b;
        if (this._peer != null && this._peer.length() == 44 && (b = Base64.decode(this._peer)) != null) {
            return new Hash(b);
        }
        return null;
    }

    public void setPeer(String peer) {
        this._peer = peer;
    }

    public void setSpeed(String bonus) {
        this._speed = bonus;
    }

    public void setCapacity(String bonus) {
        this._capacity = bonus;
    }
}

