/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.FormHandler;
import net.i2p.util.Addresses;

public class ConfigNetHandler
extends FormHandler {
    private String _hostname;
    private boolean _saveRequested;
    private boolean _recheckReachabilityRequested;
    private boolean _requireIntroductions;
    private boolean _hiddenMode;
    private boolean _dynamicKeys;
    private String _ntcpHostname;
    private String _ntcpPort;
    private String _tcpPort;
    private String _udpHost1;
    private String _udpHost2;
    private String _udpPort;
    private String _udpAutoIP;
    private String _ntcpAutoIP;
    private boolean _ntcpAutoPort;
    private boolean _upnp;
    private boolean _laptop;
    private String _inboundRate;
    private String _inboundBurstRate;
    private String _inboundBurst;
    private String _outboundRate;
    private String _outboundBurstRate;
    private String _outboundBurst;
    private String _sharePct;
    private boolean _ratesOnly;
    private boolean _udpDisabled;
    private String _ipv6Mode;
    private final Map<String, String> changes = new HashMap<String, String>();
    private static final String PROP_HIDDEN = "router.isHidden";
    private static final int DEF_BURST_PCT = 10;
    private static final int DEF_BURST_TIME = 20;

    @Override
    protected void processForm() {
        if (this._saveRequested || this._action != null && this._("Save changes").equals(this._action)) {
            this.saveChanges();
        }
    }

    public void setSave(String moo) {
        this._saveRequested = true;
    }

    public void setRecheckReachability(String moo) {
        this._recheckReachabilityRequested = true;
    }

    public void setRequireIntroductions(String moo) {
        this._requireIntroductions = true;
    }

    public void setDynamicKeys(String moo) {
        this._dynamicKeys = true;
    }

    public void setEnableloadtesting(String moo) {
    }

    public void setUdpAutoIP(String mode) {
        this._udpAutoIP = mode;
        this._hiddenMode = "hidden".equals(mode);
    }

    public void setNtcpAutoIP(String mode) {
        this._ntcpAutoIP = mode;
    }

    public void setNtcpAutoPort(String mode) {
        this._ntcpAutoPort = mode.equals("2");
    }

    public void setUpnp(String moo) {
        this._upnp = true;
    }

    public void setLaptop(String moo) {
        this._laptop = true;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname != null ? hostname.trim() : null;
    }

    public void setTcpPort(String port) {
        this._tcpPort = port != null ? port.trim() : null;
    }

    public void setNtcphost(String host) {
        this._ntcpHostname = host != null ? host.trim() : null;
    }

    public void setNtcpport(String port) {
        this._ntcpPort = port != null ? port.trim() : null;
    }

    public void setUdpHost1(String host) {
        this._udpHost1 = host != null ? host.trim() : null;
    }

    public void setUdpPort(String port) {
        this._udpPort = port != null ? port.trim() : null;
    }

    public void setInboundrate(String rate) {
        this._inboundRate = rate != null ? rate.trim() : null;
    }

    public void setInboundburstrate(String rate) {
        this._inboundBurstRate = rate != null ? rate.trim() : null;
    }

    public void setInboundburstfactor(String factor) {
        this._inboundBurst = factor != null ? factor.trim() : null;
    }

    public void setOutboundrate(String rate) {
        this._outboundRate = rate != null ? rate.trim() : null;
    }

    public void setOutboundburstrate(String rate) {
        this._outboundBurstRate = rate != null ? rate.trim() : null;
    }

    public void setOutboundburstfactor(String factor) {
        this._outboundBurst = factor != null ? factor.trim() : null;
    }

    public void setSharePercentage(String pct) {
        this._sharePct = pct != null ? pct.trim() : null;
    }

    public void setRatesOnly(String foo) {
        this._ratesOnly = true;
    }

    public void setDisableUDP(String foo) {
        this._udpDisabled = true;
    }

    public void setIpv6(String mode) {
        this._ipv6Mode = mode;
    }

    private void saveChanges() {
        boolean saved;
        boolean restartRequired = false;
        boolean error = false;
        ArrayList<String> removes = new ArrayList<String>();
        if (!this._ratesOnly) {
            String oldPort;
            String oldUdp = this._context.getProperty("i2np.udp.addressSources", this._context.router().isHidden() ? "hidden" : UDPTransport.DEFAULT_SOURCES);
            String oldUHost = this._context.getProperty("i2np.udp.host", "");
            if (this._udpAutoIP != null) {
                String uhost = "";
                if (this._udpAutoIP.equals("fixed")) {
                    if (this._settings == null) {
                        this._settings = Collections.EMPTY_MAP;
                    }
                    TreeSet<String> addrs = new TreeSet<String>();
                    for (Object o : this._settings.keySet()) {
                        String v;
                        String k = (String)o;
                        if (!k.startsWith("addr_") || (v = k.substring(5)).length() <= 0) continue;
                        addrs.add(v);
                    }
                    if (this.getJettyString("addrnew") != null && this._udpHost1 != null && this._udpHost1.length() > 0) {
                        if (this.verifyAddress(this._udpHost1)) {
                            addrs.add(this._udpHost1);
                        } else {
                            error = true;
                        }
                    }
                    int tot = addrs.size();
                    int i = 0;
                    if (tot > 0) {
                        StringBuilder buf = new StringBuilder(128);
                        for (String addr : addrs) {
                            buf.append(addr);
                            if (++i >= tot) continue;
                            buf.append(',');
                        }
                        uhost = buf.toString();
                        this.changes.put("i2np.udp.host", uhost);
                    } else {
                        this._udpAutoIP = UDPTransport.DEFAULT_SOURCES;
                        removes.add("i2np.udp.host");
                    }
                } else if (oldUHost.length() > 0) {
                    removes.add("i2np.udp.host");
                }
                this.changes.put("i2np.udp.addressSources", this._udpAutoIP);
                if (!oldUdp.equals(this._udpAutoIP) || !oldUHost.equals(uhost)) {
                    this.addFormNotice(this._("Updating IP address"));
                    restartRequired = true;
                }
            }
            if (this._ipv6Mode != null) {
                String udp6;
                String tcp6 = this._context.getProperty("i2np.ntcp.ipv6");
                if (tcp6 == null) {
                    tcp6 = TransportUtil.DEFAULT_IPV6_CONFIG.toConfigString();
                }
                if ((udp6 = this._context.getProperty("i2np.udp.ipv6")) == null) {
                    udp6 = TransportUtil.DEFAULT_IPV6_CONFIG.toConfigString();
                }
                boolean ch = false;
                if (!this._ipv6Mode.equals(tcp6)) {
                    this.changes.put("i2np.ntcp.ipv6", this._ipv6Mode);
                    ch = true;
                }
                if (!this._ipv6Mode.equals(udp6)) {
                    this.changes.put("i2np.udp.ipv6", this._ipv6Mode);
                    ch = true;
                }
                if (ch) {
                    this.addFormNotice(this._("Updating IPv6 setting"));
                }
            }
            String oldNHost = this._context.getProperty("i2np.ntcp.hostname", "");
            String oldNPort = this._context.getProperty("i2np.ntcp.port", "");
            String oldAutoHost = this._context.getProperty("i2np.ntcp.autoip", "true");
            String sAutoPort = this._context.getProperty("i2np.ntcp.autoport", "true");
            boolean oldAutoPort = Boolean.parseBoolean(sAutoPort);
            if (this._ntcpHostname == null) {
                this._ntcpHostname = "";
            }
            if (this._ntcpPort == null) {
                this._ntcpPort = "";
            }
            if (this._ntcpAutoIP == null) {
                this._ntcpAutoIP = "true";
            }
            if (!oldAutoHost.equals(this._ntcpAutoIP) || !oldNHost.equalsIgnoreCase(this._ntcpHostname)) {
                boolean valid = true;
                if ("disabled".equals(this._ntcpAutoIP)) {
                    this.addFormNotice(this._("Disabling TCP completely"));
                } else if ("false".equals(this._ntcpAutoIP) && this._ntcpHostname.length() > 0) {
                    valid = this.verifyAddress(this._ntcpHostname);
                    if (valid) {
                        this.changes.put("i2np.ntcp.hostname", this._ntcpHostname);
                        this.addFormNotice(this._("Updating TCP address to {0}", this._ntcpHostname));
                    } else {
                        error = true;
                    }
                } else {
                    removes.add("i2np.ntcp.hostname");
                    if ("false".equals(this._ntcpAutoIP)) {
                        this.addFormNotice(this._("Disabling inbound TCP"));
                    } else {
                        this.addFormNotice(this._("Updating inbound TCP address to auto"));
                    }
                }
                if (valid) {
                    this.changes.put("i2np.ntcp.autoip", this._ntcpAutoIP);
                    this.changes.put("i2np.ntcp.enable", "" + !"disabled".equals(this._ntcpAutoIP));
                    restartRequired = true;
                }
            }
            if (oldAutoPort != this._ntcpAutoPort || !oldNPort.equals(this._ntcpPort)) {
                if (this._ntcpPort.length() > 0 && !this._ntcpAutoPort) {
                    int port = Addresses.getPort(this._ntcpPort);
                    if (port != 0) {
                        this.changes.put("i2np.ntcp.port", this._ntcpPort);
                        this.addFormNotice(this._("Updating TCP port to {0}", this._ntcpPort));
                        if (port < 1024) {
                            this.addFormError(this._("Warning - ports less than 1024 are not recommended"));
                            error = true;
                        }
                    } else {
                        this.addFormError(this._("Invalid port") + ": " + this._ntcpPort);
                        error = true;
                    }
                } else {
                    removes.add("i2np.ntcp.port");
                    this.addFormNotice(this._("Updating inbound TCP port to auto"));
                }
                this.changes.put("i2np.ntcp.autoport", "" + this._ntcpAutoPort);
                restartRequired = true;
            }
            if (this._udpPort != null && this._udpPort.length() > 0 && !(oldPort = this._context.getProperty("i2np.udp.internalPort", "unset")).equals(this._udpPort)) {
                int port = Addresses.getPort(this._udpPort);
                if (port != 0) {
                    this.changes.put("i2np.udp.internalPort", this._udpPort);
                    this.changes.put("i2np.udp.port", this._udpPort);
                    this.addFormNotice(this._("Updating UDP port to {0}", this._udpPort));
                    if (port < 1024) {
                        this.addFormError(this._("Warning - ports less than 1024 are not recommended"));
                        error = true;
                    } else {
                        restartRequired = true;
                    }
                } else {
                    this.addFormError(this._("Invalid port") + ": " + this._udpPort);
                    error = true;
                }
            }
        }
        boolean ratesUpdated = this.updateRates();
        boolean switchRequired = false;
        if (!this._ratesOnly) {
            boolean bl = switchRequired = this._hiddenMode != this._context.router().isHidden();
            if (switchRequired) {
                this.changes.put(PROP_HIDDEN, "" + this._hiddenMode);
                if (this._hiddenMode) {
                    this.addFormError(this._("Gracefully restarting into Hidden Router Mode"));
                } else {
                    this.addFormError(this._("Gracefully restarting to exit Hidden Router Mode"));
                }
            }
            this.changes.put("router.dynamicKeys", "" + this._dynamicKeys);
            if (Boolean.parseBoolean(this._context.getProperty("i2np.upnp.enable")) != this._upnp) {
                if (this._upnp) {
                    this.addFormNotice(this._("Enabling UPnP"));
                } else {
                    this.addFormNotice(this._("Disabling UPnP"));
                }
                this.addFormNotice(this._("Restart required to take effect"));
            }
            this.changes.put("i2np.upnp.enable", "" + this._upnp);
            if (Boolean.parseBoolean(this._context.getProperty("i2np.laptopMode")) != this._laptop) {
                if (this._laptop) {
                    this.addFormNotice(this._("Enabling laptop mode"));
                } else {
                    this.addFormNotice(this._("Disabling laptop mode"));
                }
            }
            this.changes.put("i2np.laptopMode", "" + this._laptop);
            if (this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable") != !this._udpDisabled) {
                if (this._udpDisabled) {
                    this.addFormNotice(this._("Disabling UDP"));
                } else {
                    this.addFormNotice(this._("Enabling UDP"));
                }
                restartRequired = true;
            }
            this.changes.put("i2np.udp.enable", "" + !this._udpDisabled);
            if (this._requireIntroductions) {
                this.changes.put("i2np.udp.forceIntroducers", "true");
                this.addFormNotice(this._("Requiring SSU introducers"));
            } else {
                removes.add("i2np.udp.forceIntroducers");
            }
        }
        if (saved = this._context.router().saveConfig(this.changes, removes)) {
            this.addFormNotice(this._("Configuration saved successfully"));
        } else {
            this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
        if (ratesUpdated) {
            this._context.bandwidthLimiter().reinitialize();
        }
        if (saved && !error) {
            if (switchRequired) {
                this.hiddenSwitch();
            } else if (restartRequired) {
                this.addFormNotice("Performing a soft restart");
                this._context.router().restart();
            }
        }
    }

    private boolean verifyAddress(String addr) {
        if (addr == null || addr.length() <= 0) {
            return false;
        }
        byte[] iab = Addresses.getIP(addr);
        if (iab == null) {
            this.addFormError(this._("Invalid address") + ": " + addr);
            return false;
        }
        boolean rv = TransportUtil.isPubliclyRoutable(iab, true);
        if (!rv) {
            this.addFormError(this._("The hostname or IP {0} is not publicly routable", addr));
        }
        return rv;
    }

    private void hiddenSwitch() {
        ConfigServiceHandler.registerWrapperNotifier(this._context, 5, false);
        this._context.router().shutdownGracefully(5);
    }

    private boolean updateRates() {
        int kb;
        String old;
        boolean updated = false;
        boolean bwUpdated = false;
        if (!(this._sharePct == null || (old = this._context.router().getConfigSetting("router.sharePercentage")) != null && old.equals(this._sharePct))) {
            this.changes.put("router.sharePercentage", this._sharePct);
            this.addFormNotice(this._("Updating bandwidth share percentage"));
            updated = true;
        }
        if (this._inboundRate != null && this._inboundRate.length() > 0 && !this._inboundRate.equals(this._context.getProperty("i2np.bandwidth.inboundKBytesPerSecond", "96"))) {
            this.changes.put("i2np.bandwidth.inboundKBytesPerSecond", this._inboundRate);
            try {
                int rate = Integer.parseInt(this._inboundRate) * 110 / 100;
                kb = 20 * rate;
                this.changes.put("i2np.bandwidth.inboundBurstKBytesPerSecond", "" + rate);
                this.changes.put("i2np.bandwidth.inboundBurstKBytes", "" + kb);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            bwUpdated = true;
        }
        if (this._outboundRate != null && this._outboundRate.length() > 0 && !this._outboundRate.equals(this._context.getProperty("i2np.bandwidth.outboundKBytesPerSecond", "40"))) {
            this.changes.put("i2np.bandwidth.outboundKBytesPerSecond", this._outboundRate);
            try {
                int rate = Integer.parseInt(this._outboundRate) * 110 / 100;
                kb = 20 * rate;
                this.changes.put("i2np.bandwidth.outboundBurstKBytesPerSecond", "" + rate);
                this.changes.put("i2np.bandwidth.outboundBurstKBytes", "" + kb);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            bwUpdated = true;
        }
        if (bwUpdated) {
            this.addFormNotice(this._("Updated bandwidth limits"));
            updated = true;
        }
        return updated;
    }
}

