/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppState;
import net.i2p.data.DataHelper;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppStarter;
import net.i2p.util.Addresses;

public class ConfigClientsHelper
extends HelperBase {
    private String _edit;
    public static final String BIND_ALL_INTERFACES = "i2cp.tcp.bindAllInterfaces";
    public static final String PROP_DISABLE_EXTERNAL = "i2cp.disableInterface";
    public static final String PROP_ENABLE_SSL = "i2cp.SSL";
    public static final String PROP_AUTH = "i2cp.auth";

    public String getPort() {
        return this._context.getProperty("i2cp.port", Integer.toString(7654));
    }

    public String i2cpModeChecked(int mode) {
        boolean disabled = this._context.getBooleanProperty(PROP_DISABLE_EXTERNAL);
        boolean ssl = this._context.getBooleanProperty(PROP_ENABLE_SSL);
        if (mode == 0 && disabled || mode == 1 && !disabled && !ssl || mode == 2 && !disabled && ssl) {
            return "checked=\"checked\"";
        }
        return "";
    }

    public String getAuth() {
        boolean enabled = this._context.getBooleanProperty(PROP_AUTH);
        if (enabled) {
            return "checked=\"checked\"";
        }
        return "";
    }

    public String[] intfcAddresses() {
        ArrayList<String> al = new ArrayList<String>(Addresses.getAllAddresses());
        return al.toArray(new String[al.size()]);
    }

    public boolean isIFSelected(String addr) {
        boolean bindAll = this._context.getBooleanProperty(BIND_ALL_INTERFACES);
        if (bindAll && addr.equals("0.0.0.0") || addr.equals("::")) {
            return true;
        }
        String host = this._context.getProperty("i2cp.hostname", "127.0.0.1");
        return host.equals(addr);
    }

    public void setEdit(String edit) {
        if (edit == null) {
            return;
        }
        String xStart = this._("Edit");
        if (edit.startsWith(xStart + "<span class=hide> ") && edit.endsWith("</span>")) {
            this._edit = edit.substring(xStart.length() + 18, edit.length() - 7);
        } else if (edit.startsWith("Edit ")) {
            this._edit = edit.substring(5);
        } else if (edit.startsWith(xStart + ' ')) {
            this._edit = edit.substring(xStart.length() + 1);
        } else if (this._("Add Client").equals(edit)) {
            this._edit = "new";
        }
    }

    public String getForm1() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table>\n<tr><th align=\"right\">").append(this._("Client")).append("</th><th>").append(this._("Run at Startup?")).append("</th><th>").append(this._("Control")).append("</th><th align=\"left\">").append(this._("Class and arguments")).append("</th></tr>\n");
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        for (int cur = 0; cur < clients.size(); ++cur) {
            boolean showStop;
            boolean showStart;
            ClientAppConfig ca = clients.get(cur);
            boolean isConsole = ca.className.equals("net.i2p.router.web.RouterConsoleRunner");
            if (isConsole) {
                showStart = false;
                showStop = false;
            } else {
                ClientApp clientApp = this._context.routerAppManager().getClientApp(ca.className, LoadClientAppsJob.parseArgs(ca.args));
                showStart = clientApp == null;
                showStop = clientApp != null && clientApp.getState() == ClientAppState.RUNNING;
            }
            this.renderForm(buf, "" + cur, ca.clientName, false, !ca.disabled, false, RouterConsoleRunner.class.getName().equals(ca.className), ca.className + (ca.args != null ? " " + ca.args : ""), ("" + cur).equals(this._edit), !showStop, false, showStop, !isConsole, showStart);
        }
        if ("new".equals(this._edit)) {
            this.renderForm(buf, "" + clients.size(), "", false, false, false, false, "", true, false, false, false, false, false);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public String getForm2() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table>\n<tr><th align=\"right\">").append(this._("WebApp")).append("</th><th>").append(this._("Run at Startup?")).append("</th><th>").append(this._("Control")).append("</th><th align=\"left\">").append(this._("Description")).append("</th></tr>\n");
        Properties props = RouterConsoleRunner.webAppProperties(this._context);
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        for (String string : keys) {
            if (!string.startsWith("webapps.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("webapps.".length(), string.lastIndexOf(".startOnLoad"));
            String val = props.getProperty(string);
            boolean isRunning = WebAppStarter.isWebAppRunning(app);
            this.renderForm(buf, app, app, !"addressbook".equals(app), "true".equals(val), "routerconsole".equals(app), "routerconsole".equals(app), app + ".war", false, false, false, isRunning, false, !isRunning);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public boolean showPlugins() {
        return PluginStarter.pluginsEnabled(this._context);
    }

    public String getForm3() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table>\n<tr><th align=\"right\">").append(this._("Plugin")).append("</th><th>").append(this._("Run at Startup?")).append("</th><th>").append(this._("Control")).append("</th><th align=\"left\">").append(this._("Description")).append("</th></tr>\n");
        Properties props = PluginStarter.pluginProperties();
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        for (String string : keys) {
            String updateURL;
            Properties appProps;
            if (!string.startsWith("plugin.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("plugin.".length(), string.lastIndexOf(".startOnLoad"));
            String val = props.getProperty(string);
            if (val.equals("deleted") || (appProps = PluginStarter.pluginProperties(this._context, app)).isEmpty()) continue;
            StringBuilder desc = new StringBuilder(256);
            desc.append("<table border=\"0\">").append("<tr><td><b>").append(this._("Version")).append("</b></td><td>").append(ConfigClientsHelper.stripHTML(appProps, "version")).append("<tr><td><b>").append(this._("Signed by")).append("</b></td><td>");
            String s = ConfigClientsHelper.stripHTML(appProps, "signer");
            if (s != null) {
                if (s.indexOf("@") > 0) {
                    desc.append("<a href=\"mailto:").append(s).append("\">").append(s).append("</a>");
                } else {
                    desc.append(s);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "date")) != null) {
                long ms = 0L;
                try {
                    ms = Long.parseLong(s);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (ms > 0L) {
                    String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(ms));
                    desc.append("<tr><td><b>").append(this._("Date")).append("</b></td><td>").append(date);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "author")) != null) {
                desc.append("<tr><td><b>").append(this._("Author")).append("</b></td><td>");
                if (s.indexOf("@") > 0) {
                    desc.append("<a href=\"mailto:").append(s).append("\">").append(s).append("</a>");
                } else {
                    desc.append(s);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "description_" + Messages.getLanguage(this._context))) == null) {
                s = ConfigClientsHelper.stripHTML(appProps, "description");
            }
            if (s != null) {
                desc.append("<tr><td><b>").append(this._("Description")).append("</b></td><td>").append(s);
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "license")) != null) {
                desc.append("<tr><td><b>").append(this._("License")).append("</b></td><td>").append(s);
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "websiteURL")) != null) {
                desc.append("<tr><td>").append("<a href=\"").append(s).append("\">").append(this._("Website")).append("</a><td>&nbsp;");
            }
            if ((updateURL = ConfigClientsHelper.stripHTML(appProps, "updateURL")) != null) {
                desc.append("<tr><td>").append("<a href=\"").append(updateURL).append("\">").append(this._("Update link")).append("</a><td>&nbsp;");
            }
            desc.append("</table>");
            boolean enableStop = !Boolean.parseBoolean(appProps.getProperty("disableStop"));
            boolean enableStart = !PluginStarter.isPluginRunning(app, this._context);
            this.renderForm(buf, app, app, false, "true".equals(val), false, false, desc.toString(), false, false, updateURL != null, enableStop &= PluginStarter.isPluginRunning(app, this._context), true, enableStart);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    private void renderForm(StringBuilder buf, String index, String name, boolean urlify, boolean enabled, boolean ro, boolean preventDisable, String desc, boolean edit, boolean showEditButton, boolean showUpdateButton, boolean showStopButton, boolean showDeleteButton, boolean showStartButton) {
        String escapeddesc = DataHelper.escapeHTML(desc);
        buf.append("<tr><td class=\"mediumtags\" align=\"right\" width=\"25%\">");
        if (urlify && enabled) {
            String link = "/";
            if (!"routerconsole".equals(name)) {
                link = link + name + "/";
            }
            buf.append("<a href=\"").append(link).append("\">").append(this._(name)).append("</a>");
        } else if (edit && !ro) {
            buf.append("<input type=\"text\" name=\"name").append(index).append("\" value=\"");
            if (name.length() > 0) {
                buf.append(this._(name));
            }
            buf.append("\" >");
        } else if (name.length() > 0) {
            buf.append(this._(name));
        }
        buf.append("</td><td align=\"center\" width=\"10%\"><input type=\"checkbox\" class=\"optbox\" name=\"").append(index).append(".enabled\" value=\"true\" ");
        if (enabled) {
            buf.append("checked=\"checked\" ");
            if (ro || preventDisable) {
                buf.append("disabled=\"disabled\" ");
            }
        }
        buf.append("></td><td align=\"center\" width=\"15%\">");
        if (showStartButton && !ro && !edit) {
            buf.append("<button type=\"submit\" class=\"Xaccept\" name=\"action\" value=\"Start ").append(index).append("\" >").append(this._("Start")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (showStopButton && !edit) {
            buf.append("<button type=\"submit\" class=\"Xstop\" name=\"action\" value=\"Stop ").append(index).append("\" >").append(this._("Stop")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (showEditButton && !edit && !ro) {
            buf.append("<button type=\"submit\" class=\"Xadd\" name=\"edit\" value=\"Edit ").append(index).append("\" >").append(this._("Edit")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (showUpdateButton && !edit && !ro) {
            buf.append("<button type=\"submit\" class=\"Xcheck\" name=\"action\" value=\"Check ").append(index).append("\" >").append(this._("Check for updates")).append("<span class=hide> ").append(index).append("</span></button>");
            buf.append("<button type=\"submit\" class=\"Xdownload\" name=\"action\" value=\"Update ").append(index).append("\" >").append(this._("Update")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (showDeleteButton && !edit && !ro) {
            buf.append("<button type=\"submit\" class=\"Xdelete\" name=\"action\" value=\"Delete ").append(index).append("\" onclick=\"if (!confirm('").append(this._("Are you sure you want to delete {0}?", this._(name))).append("')) { return false; }\">").append(this._("Delete")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        buf.append("</td><td align=\"left\" width=\"50%\">");
        if (edit && !ro) {
            buf.append("<input type=\"text\" size=\"80\" spellcheck=\"false\" name=\"desc").append(index).append("\" value=\"");
            buf.append(escapeddesc);
            buf.append("\" >");
        } else {
            buf.append(desc);
        }
        buf.append("</td></tr>\n");
    }

    public static String stripHTML(Properties props, String key) {
        String orig = props.getProperty(key);
        if (orig == null) {
            return null;
        }
        String t1 = orig.replace('<', ' ');
        String rv = t1.replace('>', ' ');
        return rv;
    }
}

