/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppState;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.UpdateHandler;
import net.i2p.router.web.WebAppStarter;
import net.i2p.update.UpdateType;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

public class ConfigClientsHandler
extends FormHandler {
    @Override
    protected void processForm() {
        String app;
        if (this._action.length() <= 0) {
            String url = this.getJettyString("pluginURL");
            this._action = url != null && url.length() > 0 ? "Install Plugin" : "Save Client Configuration";
        }
        if (this._action.equals(this._("Save Client Configuration"))) {
            this.saveClientChanges();
            return;
        }
        if (this._action.equals(this._("Save Interface Configuration"))) {
            this.saveInterfaceChanges();
            return;
        }
        if (this._action.equals(this._("Save WebApp Configuration"))) {
            this.saveWebAppChanges();
            return;
        }
        if (this._action.equals(this._("Save Plugin Configuration"))) {
            this.savePluginChanges();
            return;
        }
        if (this._action.equals(this._("Install Plugin"))) {
            this.installPlugin();
            return;
        }
        if (this._action.equals(this._("Update All Installed Plugins"))) {
            this.updateAllPlugins();
            return;
        }
        if (this._action.startsWith("Start ")) {
            app = this._action.substring(6);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.startClient(appnum);
            } else {
                List<String> plugins = PluginStarter.getPlugins();
                if (plugins.contains(app)) {
                    this.startPlugin(app);
                } else {
                    this.startWebApp(app);
                }
            }
            return;
        }
        if (this._action.startsWith("Delete ")) {
            app = this._action.substring(7);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.deleteClient(appnum);
            } else {
                try {
                    PluginStarter.stopPlugin(this._context, app);
                }
                catch (ClassNotFoundException cnfe) {
                }
                catch (Throwable e) {
                    this.addFormError(this._("Error stopping plugin {0}", app) + ": " + e);
                    this._log.error("Error stopping plugin " + app, e);
                }
                try {
                    PluginStarter.deletePlugin(this._context, app);
                    this.addFormNotice(this._("Deleted plugin {0}", app));
                }
                catch (Throwable e) {
                    this.addFormError(this._("Error deleting plugin {0}", app) + ": " + e);
                    this._log.error("Error deleting plugin " + app, e);
                }
            }
            return;
        }
        if (this._action.startsWith("Stop ")) {
            app = this._action.substring(5);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.stopClient(appnum);
            } else {
                List<String> plugins = PluginStarter.getPlugins();
                if (plugins.contains(app)) {
                    try {
                        PluginStarter.stopPlugin(this._context, app);
                        this.addFormNotice(this._("Stopped plugin {0}", app));
                    }
                    catch (Throwable e) {
                        this.addFormError(this._("Error stopping plugin {0}", app) + ": " + e);
                        this._log.error("Error stopping plugin " + app, e);
                    }
                } else {
                    WebAppStarter.stopWebApp(app);
                    this.addFormNotice(this._("Stopped webapp {0}", app));
                }
            }
            return;
        }
        if (this._action.startsWith("Update ")) {
            app = this._action.substring(7);
            this.updatePlugin(app);
            return;
        }
        if (this._action.startsWith("Check ")) {
            app = this._action.substring(6);
            this.checkPlugin(app);
            return;
        }
        String xStart = this._("Start");
        if (this._action.toLowerCase(Locale.US).startsWith(xStart + "<span class=hide> ") && this._action.toLowerCase(Locale.US).endsWith("</span>")) {
            String app2 = this._action.substring(xStart.length() + 18, this._action.length() - 7);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app2);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.startClient(appnum);
            } else {
                List<String> plugins = PluginStarter.getPlugins();
                if (plugins.contains(app2)) {
                    this.startPlugin(app2);
                } else {
                    this.startWebApp(app2);
                }
            }
        }
    }

    private void saveClientChanges() {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        for (int cur = 0; cur < clients.size(); ++cur) {
            String desc;
            ClientAppConfig ca = clients.get(cur);
            Object val = this._settings.get(cur + ".enabled");
            if (!RouterConsoleRunner.class.getName().equals(ca.className)) {
                boolean bl = ca.disabled = val == null;
            }
            if ((desc = this.getJettyString("desc" + cur)) == null) continue;
            int spc = desc.indexOf(" ");
            String clss = desc;
            String args = null;
            if (spc >= 0) {
                clss = desc.substring(0, spc);
                args = desc.substring(spc + 1);
            }
            ca.className = clss;
            ca.args = args;
            ca.clientName = this.getJettyString("name" + cur);
        }
        int newClient = clients.size();
        String newDesc = this.getJettyString("desc" + newClient);
        if (newDesc != null && newDesc.trim().length() > 0) {
            String name;
            int spc = newDesc.indexOf(" ");
            String clss = newDesc;
            String args = null;
            if (spc >= 0) {
                clss = newDesc.substring(0, spc);
                args = newDesc.substring(spc + 1);
            }
            if ((name = this.getJettyString("name" + newClient)) == null || name.trim().length() <= 0) {
                name = "new client";
            }
            ClientAppConfig ca = new ClientAppConfig(clss, name, args, 120000L, this._settings.get(newClient + ".enabled") != null);
            clients.add(ca);
            this.addFormNotice(this._("New client added") + ": " + name + " (" + clss + ").");
        }
        ClientAppConfig.writeClientAppConfig(this._context, clients);
        this.addFormNotice(this._("Client configuration saved successfully"));
    }

    private void stopClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i >= clients.size()) {
            this.addFormError(this._("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.get(i);
        ClientApp clientApp = this._context.routerAppManager().getClientApp(ca.className, LoadClientAppsJob.parseArgs(ca.args));
        if (clientApp != null && clientApp.getState() == ClientAppState.RUNNING) {
            try {
                clientApp.shutdown(null);
                this.addFormNotice(this._("Client {0} stopped", ca.clientName));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                }
            }
            catch (Throwable t) {
                this.addFormError("Cannot stop client " + ca.className + ": " + t);
                this._log.error("Error stopping client " + ca.className, t);
            }
        } else {
            this.addFormError("Cannot stop client " + i + ": " + ca.className);
        }
    }

    private void startClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i >= clients.size()) {
            this.addFormError(this._("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.get(i);
        LoadClientAppsJob.runClient(ca.className, ca.clientName, LoadClientAppsJob.parseArgs(ca.args), this._context, this._log);
        this.addFormNotice(this._("Client {0} started", ca.clientName));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private void deleteClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i < 0 || i >= clients.size()) {
            this.addFormError(this._("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.remove(i);
        ClientAppConfig.writeClientAppConfig(this._context, clients);
        this.addFormNotice(this._("Client {0} deleted", ca.clientName));
    }

    private void saveWebAppChanges() {
        Properties props = RouterConsoleRunner.webAppProperties(this._context);
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith("webapps.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("webapps.".length(), string.lastIndexOf(".startOnLoad"));
            Object val = this._settings.get(app + ".enabled");
            if ("routerconsole".equals(app)) continue;
            props.setProperty(string, "" + (val != null));
        }
        RouterConsoleRunner.storeWebAppProperties(this._context, props);
        this.addFormNotice(this._("WebApp configuration saved."));
    }

    private void savePluginChanges() {
        Properties props = PluginStarter.pluginProperties();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith("plugin.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("plugin.".length(), string.lastIndexOf(".startOnLoad"));
            Object val = this._settings.get(app + ".enabled");
            props.setProperty(string, "" + (val != null));
        }
        PluginStarter.storePluginProperties(props);
        this.addFormNotice(this._("Plugin configuration saved."));
    }

    private void startWebApp(String app) {
        ContextHandlerCollection s = WebAppStarter.getConsoleServer();
        if (s != null) {
            try {
                File path = new File(this._context.getBaseDir(), "webapps");
                path = new File(path, app + ".war");
                WebAppStarter.startWebApp(this._context, s, app, path.getAbsolutePath());
                this.addFormNotice(this._("WebApp") + " <a href=\"/" + app + "/\">" + this._(app) + "</a> " + this._("started") + '.');
            }
            catch (Throwable e) {
                this.addFormError(this._("Failed to start") + ' ' + this._(app) + " " + e + '.');
                this._log.error("Failed to start webapp " + app, e);
            }
            return;
        }
        this.addFormError(this._("Failed to find server."));
    }

    private void installPlugin() {
        String url = this.getJettyString("pluginURL");
        if (url == null || url.length() <= 0) {
            this.addFormError(this._("No plugin URL specified."));
            return;
        }
        this.installPlugin(null, url);
    }

    private void updatePlugin(String app) {
        Properties props = PluginStarter.pluginProperties(this._context, app);
        String url = props.getProperty("updateURL");
        if (url == null) {
            this.addFormError(this._("No update URL specified for {0}", app));
            return;
        }
        this.installPlugin(app, url);
    }

    private void updateAllPlugins() {
        if (NewsHelper.isAnyUpdateInProgress()) {
            this.addFormError(this._("Plugin or update download already in progress."));
            return;
        }
        this.addFormNotice(this._("Updating all plugins"));
        PluginStarter.updateAll(this._context);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void installPlugin(String app, String url) {
        URI uri;
        ConsoleUpdateManager mgr = UpdateHandler.updateManager(this._context);
        if (mgr == null) {
            this.addFormError("Update manager not registered, cannot install");
            return;
        }
        if (mgr.isUpdateInProgress()) {
            this.addFormError(this._("Plugin or update download already in progress."));
            return;
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException use) {
            this.addFormError(this._("Bad URL {0}", url));
            return;
        }
        if (mgr.installPlugin(app, uri)) {
            this.addFormNotice(this._("Downloading plugin from {0}", url));
        } else {
            this.addFormError("Cannot install, check logs");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private void checkPlugin(String app) {
        ConsoleUpdateManager mgr = UpdateHandler.updateManager(this._context);
        if (mgr == null) {
            this.addFormError("Update manager not registered, cannot check");
            return;
        }
        mgr.check(UpdateType.PLUGIN, app);
        this.addFormNotice(this._("Checking plugin {0} for updates", app));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startPlugin(String app) {
        try {
            PluginStarter.startPlugin(this._context, app);
            this.addFormNotice(this._("Started plugin {0}", app));
        }
        catch (Throwable e) {
            this.addFormError(this._("Error starting plugin {0}", app) + ": " + e);
            this._log.error("Error starting plugin " + app, e);
        }
    }

    private void saveInterfaceChanges() {
        String intfc;
        HashMap<String, String> changes = new HashMap<String, String>();
        String port = this.getJettyString("port");
        if (port != null) {
            changes.put("i2cp.port", port);
        }
        if ((intfc = this.getJettyString("interface")) != null) {
            changes.put("i2cp.hostname", intfc);
        }
        String user = this.getJettyString("user");
        String pw = this.getJettyString("pw");
        if (user != null && pw != null && user.length() > 0 && pw.length() > 0) {
            ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
            mgr.saveHash("i2cp.auth", user, pw);
            this.addFormNotice(this._("Added user {0}", user));
        }
        String mode = this.getJettyString("mode");
        boolean disabled = "0".equals(mode);
        boolean ssl = "2".equals(mode);
        changes.put("i2cp.disableInterface", Boolean.toString(disabled));
        changes.put("i2cp.SSL", Boolean.toString(ssl));
        changes.put("i2cp.auth", Boolean.toString(this._settings.get("auth") != null));
        boolean all = "0.0.0.0".equals(intfc) || "0:0:0:0:0:0:0:0".equals(intfc) || "::".equals(intfc);
        changes.put("i2cp.tcp.bindAllInterfaces", Boolean.toString(all));
        if (this._context.router().saveConfig(changes, null)) {
            this.addFormNotice(this._("Interface configuration saved"));
            this.addFormNotice(this._("Restart required to take effect"));
        } else {
            this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }
}

