/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv3DatagramSession;
import net.i2p.sam.SAMv3RawSession;
import net.i2p.sam.SAMv3StreamSession;
import net.i2p.util.I2PAppThread;

public class SAMv3Handler
extends SAMv1Handler {
    private Session session;
    public static final SessionsDB sSessionsHash = new SessionsDB();
    private boolean stolenSocket;
    private boolean streamForwardingSocket;

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties());
    }

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps);
        this._log.debug("SAM version 3 handler instantiated");
    }

    @Override
    public boolean verifVersion() {
        return this.verMajor == 3 && this.verMinor == 0;
    }

    public String getClientIP() {
        return this.socket.socket().getInetAddress().getHostAddress();
    }

    public void stealSocket() {
        this.stolenSocket = true;
        this.stopHandling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        String msg = null;
        String domain = null;
        String opcode = null;
        boolean canContinue = false;
        this.thread.setName("SAMv3Handler " + this._id);
        this._log.debug("SAM handling started");
        try {
            InputStream in = this.getClientSocket().socket().getInputStream();
            while (true) {
                if (this.shouldStop()) {
                    this._log.debug("Stop request found");
                    break;
                }
                String line = DataHelper.readLine(in);
                if (line == null) {
                    this._log.debug("Connection closed by client (line read : null)");
                    break;
                }
                msg = line.trim();
                if (this._log.shouldLog(10)) {
                    this._log.debug("New message received: [" + msg + "]");
                }
                if (msg.equals("")) {
                    this._log.debug("Ignoring newline");
                    continue;
                }
                StringTokenizer tok = new StringTokenizer(msg, " ");
                if (tok.countTokens() < 2) {
                    this._log.debug("Error in message format");
                    break;
                }
                domain = tok.nextToken();
                opcode = tok.nextToken();
                if (this._log.shouldLog(10)) {
                    this._log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                }
                Properties props = SAMUtils.parseParams(tok);
                if (domain.equals("STREAM")) {
                    canContinue = this.execStreamMessage(opcode, props);
                } else if (domain.equals("SESSION")) {
                    if (this.i2cpProps != null) {
                        props.putAll((Map<?, ?>)this.i2cpProps);
                    }
                    canContinue = this.execSessionMessage(opcode, props);
                } else if (domain.equals("DEST")) {
                    canContinue = this.execDestMessage(opcode, props);
                } else if (domain.equals("NAMING")) {
                    canContinue = this.execNamingMessage(opcode, props);
                } else {
                    if (!domain.equals("DATAGRAM")) {
                        this._log.debug("Unrecognized message domain: \"" + domain + "\"");
                        break;
                    }
                    canContinue = this.execDatagramMessage(opcode, props);
                }
                if (!canContinue) break;
            }
        }
        catch (IOException e) {
            this._log.debug("Caught IOException (" + e.getMessage() + ") for message [" + msg + "]", e);
        }
        catch (Exception e) {
            this._log.error("Unexpected exception for message [" + msg + "]", e);
        }
        finally {
            this._log.debug("Stopping handler");
            if (!this.stolenSocket) {
                try {
                    this.closeClientSocket();
                }
                catch (IOException e) {
                    this._log.error("Error closing socket: " + e.getMessage());
                }
            }
            if (this.streamForwardingSocket && this.getStreamSession() != null) {
                try {
                    ((SAMv3StreamSession)this.streamSession).stopForwardingIncoming();
                }
                catch (SAMException e) {
                    this._log.error("Error while stopping forwarding connections: " + e.getMessage());
                }
                catch (InterruptedIOException e) {
                    this._log.error("Interrupted while stopping forwarding connections: " + e.getMessage());
                }
            }
            this.die();
        }
    }

    protected void die() {
        SessionRecord rec = null;
        if (this.session != null) {
            this.session.close();
            rec = sSessionsHash.get(this.session.getNick());
        }
        if (rec != null) {
            rec.getThreadGroup().interrupt();
            while (rec.getThreadGroup().activeCount() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            rec.getThreadGroup().destroy();
            sSessionsHash.del(this.session.getNick());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean execSessionMessage(String opcode, Properties props) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 44[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SAMv3StreamSession newSAMStreamSession(String login) throws IOException, DataFormatException, SAMException {
        return new SAMv3StreamSession(login);
    }

    private SAMv3RawSession newSAMRawSession(String login) throws IOException, DataFormatException, SAMException, I2PSessionException {
        return new SAMv3RawSession(login);
    }

    private SAMv3DatagramSession newSAMDatagramSession(String login) throws IOException, DataFormatException, SAMException, I2PSessionException {
        return new SAMv3DatagramSession(login);
    }

    @Override
    protected boolean execStreamMessage(String opcode, Properties props) {
        String nick = null;
        SessionRecord rec = null;
        if (this.session != null) {
            this._log.error("STREAM message received, but this session is a master session");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "master session cannot be used for streams");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        nick = props.getProperty("ID");
        if (nick == null) {
            this._log.debug("SESSION ID parameter not specified");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "ID not specified");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        props.remove("ID");
        rec = sSessionsHash.get(nick);
        if (rec == null) {
            this._log.debug("STREAM SESSION ID does not exist");
            try {
                this.notifyStreamResult(true, "INVALID_ID", "STREAM SESSION ID does not exist");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        this.streamSession = rec.getHandler().streamSession;
        if (this.streamSession == null) {
            this._log.debug("specified ID is not a stream session");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "specified ID is not a STREAM session");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("ACCEPT")) {
            return this.execStreamAccept(props);
        }
        if (opcode.equals("FORWARD")) {
            return this.execStreamForwardIncoming(props);
        }
        this._log.debug("Unrecognized RAW message opcode: \"" + opcode + "\"");
        try {
            this.notifyStreamResult(true, "I2P_ERROR", "Unrecognized RAW message opcode: " + opcode);
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean execStreamConnect(Properties props) {
        try {
            if (props == null) {
                this.notifyStreamResult(true, "I2P_ERROR", "No parameters specified in STREAM CONNECT message");
                this._log.debug("No parameters specified in STREAM CONNECT message");
                return false;
            }
            boolean verbose = props.getProperty("SILENT", "false").equals("false");
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                this.notifyStreamResult(verbose, "I2P_ERROR", "Destination not specified in RAW SEND message");
                this._log.debug("Destination not specified in RAW SEND message");
                return false;
            }
            props.remove("DESTINATION");
            try {
                ((SAMv3StreamSession)this.streamSession).connect(this, dest, props);
                return true;
            }
            catch (DataFormatException e) {
                this._log.debug("Invalid destination in STREAM CONNECT message");
                this.notifyStreamResult(verbose, "INVALID_KEY", null);
            }
            catch (ConnectException e) {
                this._log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "CONNECTION_REFUSED", null);
            }
            catch (NoRouteToHostException e) {
                this._log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "CANT_REACH_PEER", null);
            }
            catch (InterruptedIOException e) {
                this._log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "TIMEOUT", null);
            }
            catch (I2PException e) {
                this._log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean execStreamForwardIncoming(Properties props) {
        try {
            try {
                this.streamForwardingSocket = true;
                ((SAMv3StreamSession)this.streamSession).startForwardingIncoming(props);
                this.notifyStreamResult(true, "OK", null);
                return true;
            }
            catch (SAMException e) {
                this._log.debug("Forwarding STREAM connections failed: " + e.getMessage());
                this.notifyStreamResult(true, "I2P_ERROR", "Forwarding failed : " + e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean execStreamAccept(Properties props) {
        boolean verbose = props.getProperty("SILENT", "false").equals("false");
        try {
            try {
                this.notifyStreamResult(verbose, "OK", null);
                ((SAMv3StreamSession)this.streamSession).accept(this, verbose);
                return true;
            }
            catch (InterruptedIOException e) {
                this._log.debug("STREAM ACCEPT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "TIMEOUT", e.getMessage());
            }
            catch (I2PException e) {
                this._log.debug("STREAM ACCEPT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
            catch (SAMException e) {
                this._log.debug("STREAM ACCEPT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "ALREADY_ACCEPTING", null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void notifyStreamResult(boolean verbose, String result, String message) throws IOException {
        if (!verbose) {
            return;
        }
        String out = "STREAM STATUS RESULT=" + result;
        if (message != null) {
            out = out + " MESSAGE=\"" + message + "\"";
        }
        if (!this.writeString(out = out + '\n')) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamIncomingConnection(Destination d) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString(d.toBase64() + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static void notifyStreamIncomingConnection(SocketChannel client, Destination d) throws IOException {
        if (!SAMv3Handler.writeString(d.toBase64() + "\n", client)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static class DatagramServer {
        private static DatagramServer _instance;
        private static DatagramChannel server;

        public static DatagramServer getInstance() throws IOException {
            return DatagramServer.getInstance(new Properties());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DatagramServer getInstance(Properties props) throws IOException {
            Class<DatagramServer> clazz = DatagramServer.class;
            synchronized (DatagramServer.class) {
                if (_instance == null) {
                    _instance = new DatagramServer(props);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return _instance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DatagramServer(Properties props) throws IOException {
            Class<DatagramServer> clazz = DatagramServer.class;
            synchronized (DatagramServer.class) {
                int port;
                if (server == null) {
                    server = DatagramChannel.open();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                String host = props.getProperty("sam.udp.host", "0.0.0.0");
                String portStr = props.getProperty("sam.udp.port", "7655");
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    port = Integer.parseInt("7655");
                }
                server.socket().bind(new InetSocketAddress(host, port));
                new I2PAppThread(new Listener(server), "DatagramListener").start();
                return;
            }
        }

        public void send(SocketAddress addr, ByteBuffer msg) throws IOException {
            server.send(msg, addr);
        }

        static class Listener
        implements Runnable {
            private final DatagramChannel server;

            public Listener(DatagramChannel server) {
                this.server = server;
            }

            @Override
            public void run() {
                ByteBuffer inBuf = ByteBuffer.allocateDirect(33792);
                while (!Thread.interrupted()) {
                    inBuf.clear();
                    try {
                        this.server.receive(inBuf);
                    }
                    catch (IOException e) {
                        break;
                    }
                    inBuf.flip();
                    ByteBuffer outBuf = ByteBuffer.wrap(new byte[inBuf.remaining()]);
                    outBuf.put(inBuf);
                    outBuf.flip();
                    new I2PAppThread(new MessageDispatcher(outBuf.array()), "MessageDispatcher").start();
                }
            }
        }
    }

    private static class MessageDispatcher
    implements Runnable {
        private final ByteArrayInputStream is;

        public MessageDispatcher(byte[] buf) {
            this.is = new ByteArrayInputStream(buf);
        }

        @Override
        public void run() {
            try {
                String header = DataHelper.readLine(this.is).trim();
                StringTokenizer tok = new StringTokenizer(header, " ");
                if (tok.countTokens() != 3) {
                    return;
                }
                String version = tok.nextToken();
                if (!"3.0".equals(version)) {
                    return;
                }
                String nick = tok.nextToken();
                String dest = tok.nextToken();
                byte[] data = new byte[this.is.available()];
                this.is.read(data);
                SessionRecord rec = sSessionsHash.get(nick);
                if (rec != null) {
                    rec.getHandler().session.sendBytes(dest, data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static interface Session {
        public String getNick();

        public void close();

        public boolean sendBytes(String var1, byte[] var2) throws DataFormatException;
    }

    public static class SessionRecord {
        private final String m_dest;
        private final Properties m_props;
        private ThreadGroup m_threadgroup;
        private final SAMv3Handler m_handler;

        public SessionRecord(String dest, Properties props, SAMv3Handler handler) {
            this.m_dest = dest;
            this.m_props = new Properties();
            this.m_props.putAll((Map<?, ?>)props);
            this.m_handler = handler;
        }

        public SessionRecord(SessionRecord in) {
            this.m_dest = in.getDest();
            this.m_props = in.getProps();
            this.m_threadgroup = in.getThreadGroup();
            this.m_handler = in.getHandler();
        }

        public synchronized String getDest() {
            return this.m_dest;
        }

        public synchronized Properties getProps() {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)this.m_props);
            return this.m_props;
        }

        public synchronized SAMv3Handler getHandler() {
            return this.m_handler;
        }

        public synchronized ThreadGroup getThreadGroup() {
            return this.m_threadgroup;
        }

        public synchronized void createThreadGroup(String name) {
            if (this.m_threadgroup == null) {
                this.m_threadgroup = new ThreadGroup(name);
            }
        }
    }

    public static class SessionsDB {
        static final long serialVersionUID = 1L;
        private final HashMap<String, SessionRecord> map = new HashMap();

        public synchronized boolean put(String nick, SessionRecord session) throws ExistingId, ExistingDest {
            if (this.map.containsKey(nick)) {
                throw new ExistingId();
            }
            for (SessionRecord r : this.map.values()) {
                if (!r.getDest().equals(session.getDest())) continue;
                throw new ExistingDest();
            }
            if (!this.map.containsKey(nick)) {
                session.createThreadGroup("SAM session " + nick);
                this.map.put(nick, session);
                return true;
            }
            return false;
        }

        public synchronized boolean del(String nick) {
            SessionRecord rec = this.map.get(nick);
            if (rec != null) {
                this.map.remove(nick);
                return true;
            }
            return false;
        }

        public synchronized SessionRecord get(String nick) {
            return this.map.get(nick);
        }

        public synchronized boolean containsKey(String nick) {
            return this.map.containsKey(nick);
        }

        static class ExistingDest
        extends Exception {
            static final long serialVersionUID = 1L;

            ExistingDest() {
            }
        }

        static class ExistingId
        extends Exception {
            static final long serialVersionUID = 1L;

            ExistingId() {
            }
        }
    }
}

