/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.Set;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Certificate;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.util.RemovableSingletonSet;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

class TestJob
extends JobImpl {
    private final Log _log;
    private final TunnelPool _pool;
    private final PooledTunnelCreatorConfig _cfg;
    private boolean _found;
    private TunnelInfo _outTunnel;
    private TunnelInfo _replyTunnel;
    private PooledTunnelCreatorConfig _otherTunnel;
    private SessionTag _encryptTag;
    private static final int TEST_DELAY = 40000;

    public TestJob(RouterContext ctx, PooledTunnelCreatorConfig cfg, TunnelPool pool) {
        super(ctx);
        this._log = ctx.logManager().getLog(TestJob.class);
        this._cfg = cfg;
        this._pool = pool != null ? pool : cfg.getTunnelPool();
        if (this._pool == null && this._log.shouldLog(40)) {
            this._log.error("Invalid tunnel test configuration: no pool for " + cfg, (Throwable)new Exception("origin"));
        }
        this.getTiming().setStartAfter((long)this.getDelay() + ctx.clock().now());
    }

    public String getName() {
        return "Test tunnel";
    }

    public void runJob() {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        long lag = this.getContext().jobQueue().getMaxLag();
        if (lag > 3000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Deferring test of " + this._cfg + " due to job lag = " + lag);
            }
            this.getContext().statManager().addRateData("tunnel.testAborted", (long)this._cfg.getLength(), 0L);
            this.scheduleRetest();
            return;
        }
        if (this.getContext().router().gracefulShutdownInProgress()) {
            return;
        }
        this._found = false;
        this._replyTunnel = null;
        this._outTunnel = null;
        if (this._cfg.isInbound()) {
            this._replyTunnel = this._cfg;
            this._outTunnel = this.getContext().tunnelManager().selectOutboundTunnel();
            this._otherTunnel = (PooledTunnelCreatorConfig)this._outTunnel;
        } else {
            this._replyTunnel = this.getContext().tunnelManager().selectInboundTunnel();
            this._outTunnel = this._cfg;
            this._otherTunnel = (PooledTunnelCreatorConfig)this._replyTunnel;
        }
        if (this._replyTunnel == null || this._outTunnel == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Insufficient tunnels to test " + this._cfg + " with: " + this._replyTunnel + " / " + this._outTunnel);
            }
            this.getContext().statManager().addRateData("tunnel.testAborted", (long)this._cfg.getLength(), 0L);
            this.scheduleRetest();
        } else {
            int testPeriod = this.getTestPeriod();
            long testExpiration = this.getContext().clock().now() + (long)testPeriod;
            DeliveryStatusMessage m = new DeliveryStatusMessage(this.getContext());
            m.setArrival(this.getContext().clock().now());
            m.setMessageExpiration(testExpiration);
            m.setMessageId(this.getContext().random().nextLong(0xFFFFFFFFL));
            ReplySelector sel = new ReplySelector(this.getContext(), m.getMessageId(), testExpiration);
            OnTestReply onReply = new OnTestReply(this.getContext());
            OnTestTimeout onTimeout = new OnTestTimeout(this.getContext());
            OutNetMessage msg = this.getContext().messageRegistry().registerPending(sel, onReply, onTimeout);
            onReply.setSentMessage(msg);
            this.sendTest(m);
        }
    }

    private void sendTest(I2NPMessage m) {
        SessionTag encryptTag;
        PayloadGarlicConfig payload = new PayloadGarlicConfig();
        payload.setCertificate(Certificate.NULL_CERT);
        payload.setId(this.getContext().random().nextLong(0xFFFFFFFFL));
        payload.setPayload(m);
        payload.setRecipient(this.getContext().router().getRouterInfo());
        payload.setDeliveryInstructions(DeliveryInstructions.LOCAL);
        payload.setExpiration(m.getMessageExpiration());
        SessionKey encryptKey = this.getContext().keyGenerator().generateSessionKey();
        this._encryptTag = encryptTag = new SessionTag(true);
        SessionKey sentKey = new SessionKey();
        Set<SessionTag> sentTags = null;
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(this.getContext(), (GarlicConfig)payload, sentKey, sentTags, this.getContext().keyManager().getPublicKey(), encryptKey, encryptTag);
        if (msg == null) {
            this.scheduleRetest();
            return;
        }
        RemovableSingletonSet<SessionTag> encryptTags = new RemovableSingletonSet<SessionTag>(encryptTag);
        if (this._cfg.isInbound() && !this._pool.getSettings().isExploratory()) {
            SessionKeyManager skm = this.getContext().clientManager().getClientSessionKeyManager(this._pool.getSettings().getDestination());
            if (skm != null) {
                skm.tagsReceived(encryptKey, encryptTags);
            }
        } else {
            this.getContext().sessionKeyManager().tagsReceived(encryptKey, encryptTags);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending garlic test of " + this._outTunnel + " / " + this._replyTunnel);
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, this._outTunnel.getSendTunnelId(0), this._replyTunnel.getReceiveTunnelId(0), this._replyTunnel.getPeer(0));
    }

    public void testSuccessful(int ms) {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        this.getContext().statManager().addRateData("tunnel.testSuccessLength", (long)this._cfg.getLength(), 0L);
        this.getContext().statManager().addRateData("tunnel.testSuccessTime", (long)ms, 0L);
        this._outTunnel.incrementVerifiedBytesTransferred(1024);
        this.noteSuccess(ms, this._outTunnel);
        this.noteSuccess(ms, this._replyTunnel);
        this._cfg.testJobSuccessful(ms);
        if (this._otherTunnel.getLength() > 1) {
            this._otherTunnel.testJobSuccessful(ms);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Tunnel test successful in " + ms + "ms: " + this._cfg);
        }
        this.scheduleRetest();
    }

    private void noteSuccess(long ms, TunnelInfo tunnel) {
        if (tunnel != null) {
            for (int i = 0; i < tunnel.getLength(); ++i) {
                this.getContext().profileManager().tunnelTestSucceeded(tunnel.getPeer(i), ms);
            }
        }
    }

    private void testFailed(long timeToFail) {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        if (this._found) {
            this.noteSuccess(timeToFail, this._outTunnel);
            this.noteSuccess(timeToFail, this._replyTunnel);
        }
        if (this._pool.getSettings().isExploratory()) {
            this.getContext().statManager().addRateData("tunnel.testExploratoryFailedTime", timeToFail, timeToFail);
        } else {
            this.getContext().statManager().addRateData("tunnel.testFailedTime", timeToFail, timeToFail);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Tunnel test failed in " + timeToFail + "ms: " + this._cfg);
        }
        boolean keepGoing = this._cfg.tunnelFailed();
        if (this._otherTunnel.getLength() > 1) {
            this._otherTunnel.tunnelFailed();
        }
        if (keepGoing) {
            this.scheduleRetest(true);
        } else if (this._pool.getSettings().isExploratory()) {
            this.getContext().statManager().addRateData("tunnel.testExploratoryFailedCompletelyTime", timeToFail, timeToFail);
        } else {
            this.getContext().statManager().addRateData("tunnel.testFailedCompletelyTime", timeToFail, timeToFail);
        }
    }

    private int getDelay() {
        return 40000 + this.getContext().random().nextInt(13333);
    }

    private int getTestPeriod() {
        Rate r;
        if (this._outTunnel == null || this._replyTunnel == null) {
            return 15000;
        }
        RateStat tspt = this.getContext().statManager().getRate("transport.sendProcessingTime");
        if (tspt != null && (r = tspt.getRate(60000L)) != null) {
            int delay = 3 * (int)r.getAverageValue();
            return delay + 2500 * (this._outTunnel.getLength() + this._replyTunnel.getLength());
        }
        return 15000;
    }

    private void scheduleRetest() {
        this.scheduleRetest(false);
    }

    private void scheduleRetest(boolean asap) {
        if (this._pool == null || !this._pool.isAlive()) {
            return;
        }
        if (asap) {
            if (this._cfg.getExpiration() > this.getContext().clock().now() + 60000L) {
                this.requeue(10000 + this.getContext().random().nextInt(10000));
            }
        } else {
            int delay = this.getDelay();
            if (this._cfg.getExpiration() > this.getContext().clock().now() + (long)delay + (long)(3 * this.getTestPeriod())) {
                this.requeue(delay);
            }
        }
    }

    private class OnTestReply
    extends JobImpl
    implements ReplyJob {
        private long _successTime;
        private OutNetMessage _sentMessage;

        public OnTestReply(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Tunnel test success";
        }

        public void setSentMessage(OutNetMessage m) {
            this._sentMessage = m;
        }

        public void runJob() {
            if (this._sentMessage != null) {
                this.getContext().messageRegistry().unregisterPending(this._sentMessage);
            }
            if (this._successTime < (long)TestJob.this.getTestPeriod()) {
                TestJob.this.testSuccessful((int)this._successTime);
            } else {
                TestJob.this.testFailed(this._successTime);
            }
            TestJob.this._found = true;
        }

        public void setMessage(I2NPMessage message) {
            this._successTime = this.getContext().clock().now() - ((DeliveryStatusMessage)message).getArrival();
        }

        public String toString() {
            StringBuilder rv = new StringBuilder(64);
            rv.append("Testing tunnel ").append(TestJob.this._cfg.toString());
            rv.append(" successful after ").append(this._successTime);
            return rv.toString();
        }
    }

    private class OnTestTimeout
    extends JobImpl {
        private final long _started;

        public OnTestTimeout(RouterContext ctx) {
            super(ctx);
            this._started = ctx.clock().now();
        }

        public String getName() {
            return "Tunnel test timeout";
        }

        public void runJob() {
            if (TestJob.this._log.shouldLog(30)) {
                TestJob.this._log.warn("Timeout: found? " + TestJob.this._found);
            }
            if (!TestJob.this._found) {
                if (TestJob.this._cfg.isInbound() && !TestJob.this._pool.getSettings().isExploratory()) {
                    SessionKeyManager skm = this.getContext().clientManager().getClientSessionKeyManager(TestJob.this._pool.getSettings().getDestination());
                    if (skm != null) {
                        skm.consumeTag(TestJob.this._encryptTag);
                    }
                } else {
                    this.getContext().sessionKeyManager().consumeTag(TestJob.this._encryptTag);
                }
                TestJob.this.testFailed(this.getContext().clock().now() - this._started);
            }
        }

        public String toString() {
            StringBuilder rv = new StringBuilder(64);
            rv.append("Testing tunnel ").append(TestJob.this._cfg.toString());
            rv.append(" timed out");
            return rv.toString();
        }
    }

    private class ReplySelector
    implements MessageSelector {
        private final RouterContext _context;
        private final long _id;
        private final long _expiration;

        public ReplySelector(RouterContext ctx, long id, long expiration) {
            this._context = ctx;
            this._id = id;
            this._expiration = expiration;
            TestJob.this._found = false;
        }

        public boolean continueMatching() {
            return !TestJob.this._found && this._context.clock().now() < this._expiration;
        }

        public long getExpiration() {
            return this._expiration;
        }

        public boolean isMatch(I2NPMessage message) {
            if (message instanceof DeliveryStatusMessage) {
                return ((DeliveryStatusMessage)message).getMessageId() == this._id;
            }
            return false;
        }

        public String toString() {
            StringBuilder rv = new StringBuilder(64);
            rv.append("Testing tunnel ").append(TestJob.this._cfg.toString()).append(" waiting for ");
            rv.append(this._id).append(" found? ").append(TestJob.this._found);
            return rv.toString();
        }
    }
}

