/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.util.Log;

class OutboundReceiver
implements TunnelGateway.Receiver {
    private final RouterContext _context;
    private final Log _log;
    private final TunnelCreatorConfig _config;
    private RouterInfo _nextHopCache;
    private final int _priority;
    private static final long MAX_LOOKUP_TIME = 15000L;
    private static final int PRIORITY = 425;

    public OutboundReceiver(RouterContext ctx, TunnelCreatorConfig cfg) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundReceiver.class);
        this._config = cfg;
        this._nextHopCache = this._context.netDb().lookupRouterInfoLocally(this._config.getPeer(1));
        this._priority = 425 + cfg.getPriority();
    }

    public long receiveEncrypted(byte[] encrypted) {
        RouterInfo ri;
        TunnelDataMessage msg = new TunnelDataMessage(this._context);
        msg.setData(encrypted);
        msg.setTunnelId(this._config.getConfig(0).getSendTunnel());
        if (this._log.shouldLog(10)) {
            this._log.debug("received encrypted, sending out " + this._config + ": " + msg);
        }
        if ((ri = this._nextHopCache) == null) {
            ri = this._context.netDb().lookupRouterInfoLocally(this._config.getPeer(1));
        }
        if (ri != null) {
            this._nextHopCache = ri;
            this.send(msg, ri);
            return msg.getUniqueId();
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("lookup of " + this._config.getPeer(1) + " required for " + msg);
        }
        this._context.netDb().lookupRouterInfo(this._config.getPeer(1), new SendJob(this._context, msg), new FailedJob(this._context), 15000L);
        return -1L;
    }

    public Hash getSendTo() {
        return this._config.getPeer(1);
    }

    private void send(TunnelDataMessage msg, RouterInfo ri) {
        if (this._log.shouldLog(10)) {
            this._log.debug("forwarding encrypted data out " + this._config + ": " + msg.getUniqueId());
        }
        OutNetMessage m = new OutNetMessage(this._context, msg, msg.getMessageExpiration(), this._priority, ri);
        this._context.outNetMessagePool().add(m);
        this._config.incrementProcessedMessages();
    }

    private class FailedJob
    extends JobImpl {
        public FailedJob(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "OBGW lookup fail";
        }

        public void runJob() {
            if (OutboundReceiver.this._log.shouldLog(30)) {
                OutboundReceiver.this._log.warn("lookup of " + OutboundReceiver.this._config.getPeer(1) + " failed for " + OutboundReceiver.this._config);
            }
            OutboundReceiver.this._context.statManager().addRateData("tunnel.outboundLookupSuccess", 0L);
        }
    }

    private class SendJob
    extends JobImpl {
        private final TunnelDataMessage _msg;

        public SendJob(RouterContext ctx, TunnelDataMessage msg) {
            super(ctx);
            this._msg = msg;
        }

        public String getName() {
            return "OBGW send after lookup";
        }

        public void runJob() {
            int stat;
            RouterInfo ri = OutboundReceiver.this._context.netDb().lookupRouterInfoLocally(OutboundReceiver.this._config.getPeer(1));
            if (OutboundReceiver.this._log.shouldLog(10)) {
                OutboundReceiver.this._log.debug("lookup of " + OutboundReceiver.this._config.getPeer(1) + " successful? " + (ri != null));
            }
            if (ri != null) {
                OutboundReceiver.this._nextHopCache = ri;
                OutboundReceiver.this.send(this._msg, ri);
                stat = 1;
            } else {
                stat = 0;
            }
            OutboundReceiver.this._context.statManager().addRateData("tunnel.outboundLookupSuccess", (long)stat);
        }
    }
}

