/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildMessageGenerator {
    public static void createRecord(int recordNum, int hop, TunnelBuildMessage msg, TunnelCreatorConfig cfg, Hash replyRouter, long replyTunnel, I2PAppContext ctx, PublicKey peerKey) {
        byte[] encrypted = new byte[528];
        if (peerKey != null) {
            BuildRequestRecord req = null;
            req = !cfg.isInbound() && hop + 1 == cfg.getLength() ? BuildMessageGenerator.createUnencryptedRecord(ctx, cfg, hop, replyRouter, replyTunnel) : BuildMessageGenerator.createUnencryptedRecord(ctx, cfg, hop, null, -1L);
            Hash peer = cfg.getPeer(hop);
            req.encryptRecord(ctx, peerKey, peer, encrypted, 0);
        } else {
            ctx.random().nextBytes(encrypted);
        }
        msg.setRecord(recordNum, new ByteArray(encrypted));
    }

    private static BuildRequestRecord createUnencryptedRecord(I2PAppContext ctx, TunnelCreatorConfig cfg, int hop, Hash replyRouter, long replyTunnel) {
        if (hop < cfg.getLength()) {
            HopConfig hopConfig = cfg.getConfig(hop);
            Hash peer = cfg.getPeer(hop);
            long recvTunnelId = -1L;
            recvTunnelId = cfg.isInbound() || hop > 0 ? hopConfig.getReceiveTunnel().getTunnelId() : 0L;
            long nextTunnelId = -1L;
            Hash nextPeer = null;
            if (hop + 1 < cfg.getLength()) {
                nextTunnelId = cfg.getConfig(hop + 1).getReceiveTunnel().getTunnelId();
                nextPeer = cfg.getPeer(hop + 1);
            } else if (replyTunnel >= 0L && replyRouter != null) {
                nextTunnelId = replyTunnel;
                nextPeer = replyRouter;
            } else {
                nextTunnelId = 0L;
                nextPeer = peer;
            }
            SessionKey layerKey = hopConfig.getLayerKey();
            SessionKey ivKey = hopConfig.getIVKey();
            SessionKey replyKey = hopConfig.getReplyKey();
            byte[] iv = hopConfig.getReplyIV().getData();
            if (iv == null || iv.length != 16) {
                iv = new byte[16];
                ctx.random().nextBytes(iv);
                hopConfig.getReplyIV().setData(iv);
            }
            boolean isInGW = cfg.isInbound() && hop == 0;
            boolean isOutEnd = !cfg.isInbound() && hop + 1 >= cfg.getLength();
            long nextMsgId = -1L;
            nextMsgId = isOutEnd || cfg.isInbound() && hop + 2 >= cfg.getLength() ? cfg.getReplyMessageId() : ctx.random().nextLong(0xFFFFFFFFL);
            BuildRequestRecord rec = new BuildRequestRecord();
            rec.createRecord(ctx, recvTunnelId, peer, nextTunnelId, nextPeer, nextMsgId, layerKey, ivKey, replyKey, iv, isInGW, isOutEnd);
            return rec;
        }
        return null;
    }

    public static void layeredEncrypt(I2PAppContext ctx, TunnelBuildMessage msg, TunnelCreatorConfig cfg, List<Integer> order) {
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            ByteArray rec = msg.getRecord(i);
            Integer hopNum = order.get(i);
            int hop = hopNum;
            if (BuildMessageGenerator.isBlank(cfg, hop) || !cfg.isInbound() && hop == 1) continue;
            int stop = cfg.isInbound() ? 0 : 1;
            for (int j = hop - 1; j >= stop; --j) {
                HopConfig hopConfig = cfg.getConfig(j);
                SessionKey key = hopConfig.getReplyKey();
                byte[] iv = hopConfig.getReplyIV().getData();
                int off = rec.getOffset();
                ctx.aes().decrypt(rec.getData(), off, rec.getData(), off, key, iv, 528);
            }
        }
    }

    public static boolean isBlank(TunnelCreatorConfig cfg, int hop) {
        if (cfg.isInbound()) {
            return hop + 1 >= cfg.getLength();
        }
        if (hop == 0) {
            return true;
        }
        return hop >= cfg.getLength();
    }
}

