/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPReceiver;
import net.i2p.router.transport.udp.UDPSender;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Log;

class UDPEndpoint {
    private final RouterContext _context;
    private final Log _log;
    private int _listenPort;
    private final UDPTransport _transport;
    private UDPSender _sender;
    private UDPReceiver _receiver;
    private DatagramSocket _socket;
    private final InetAddress _bindAddress;
    private final boolean _isIPv4;
    private final boolean _isIPv6;
    private static final AtomicInteger _counter = new AtomicInteger();
    public static final String PROP_MIN_PORT = "i2np.udp.minPort";
    public static final String PROP_MAX_PORT = "i2np.udp.maxPort";
    private static final int MIN_RANDOM_PORT = 9111;
    private static final int MAX_RANDOM_PORT = 30777;
    private static final int MAX_PORT_RETRIES = 20;

    public UDPEndpoint(RouterContext ctx, UDPTransport transport, int listenPort, InetAddress bindAddress) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPEndpoint.class);
        this._transport = transport;
        this._bindAddress = bindAddress;
        this._listenPort = listenPort;
        this._isIPv4 = bindAddress == null || bindAddress instanceof Inet4Address;
        this._isIPv6 = bindAddress == null || bindAddress instanceof Inet6Address;
    }

    public synchronized void startup() throws SocketException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Starting up the UDP endpoint");
        }
        this.shutdown();
        this._socket = this.getSocket();
        if (this._socket == null) {
            this._log.log(50, "UDP Unable to open a port");
            throw new SocketException("SSU Unable to bind to a port on " + this._bindAddress);
        }
        int count = _counter.incrementAndGet();
        this._sender = new UDPSender(this._context, this._socket, "UDPSender " + count);
        this._sender.startup();
        if (this._transport != null) {
            this._receiver = new UDPReceiver(this._context, this._transport, this._socket, "UDPReceiver " + count);
            this._receiver.startup();
        }
    }

    public synchronized void shutdown() {
        if (this._sender != null) {
            this._sender.shutdown();
            this._receiver.shutdown();
        }
        if (this._socket != null) {
            this._socket.close();
        }
    }

    public void setListenPort(int newPort) {
        this._listenPort = newPort;
    }

    private DatagramSocket getSocket() {
        DatagramSocket socket = null;
        int port = this._listenPort;
        if (port > 0 && port < 1024) {
            this._log.logAlways(30, "Specified UDP port is " + port + ", ports lower than 1024 not recommended");
        }
        for (int i = 0; i < 20; ++i) {
            if (port <= 0) {
                port = UDPEndpoint.selectRandomPort(this._context);
            }
            try {
                if (this._bindAddress == null) {
                    socket = new DatagramSocket(port);
                    break;
                }
                socket = new DatagramSocket(port, this._bindAddress);
                break;
            }
            catch (SocketException se) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Binding to port " + port + " failed", (Throwable)se);
                }
                port = -1;
                continue;
            }
        }
        if (socket == null) {
            this._log.log(50, "SSU Unable to bind to a port on " + this._bindAddress);
        } else if (port != this._listenPort) {
            if (this._listenPort > 0) {
                this._log.error("SSU Unable to bind to requested port " + this._listenPort + ", using random port " + port);
            } else {
                this._log.logAlways(20, "UDP selected random port " + port);
            }
        }
        this._listenPort = port;
        return socket;
    }

    public static int selectRandomPort(RouterContext ctx) {
        int minPort = Math.min(65535, Math.max(1, ctx.getProperty(PROP_MIN_PORT, 9111)));
        int maxPort = Math.min(65535, Math.max(minPort, ctx.getProperty(PROP_MAX_PORT, 30777)));
        return minPort + ctx.random().nextInt(1 + maxPort - minPort);
    }

    public int getListenPort() {
        return this._listenPort;
    }

    public UDPSender getSender() {
        return this._sender;
    }

    public void send(UDPPacket packet) {
        this._sender.add(packet);
    }

    public UDPPacket receive() {
        UDPPacket packet = UDPPacket.acquire(this._context, true);
        try {
            this._socket.receive(packet.getPacket());
            return packet;
        }
        catch (IOException ioe) {
            packet.release();
            return null;
        }
    }

    public void clearOutbound() {
        if (this._sender != null) {
            this._sender.clear();
        }
    }

    public boolean isIPv4() {
        return this._isIPv4;
    }

    public boolean isIPv6() {
        return this._isIPv6;
    }
}

