/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.util.CDQEntry;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class InboundMessageState
implements CDQEntry {
    private final RouterContext _context;
    private final Log _log;
    private final long _messageId;
    private final Hash _from;
    private final ByteArray[] _fragments;
    private int _lastFragment;
    private final long _receiveBegin;
    private long _enqueueTime;
    private int _completeSize;
    private boolean _released;
    private static final long MAX_RECEIVE_TIME = 10000L;
    public static final int MAX_FRAGMENTS = 64;
    private static final int MAX_FRAGMENT_SIZE = 1572;
    private static final ByteCache _fragmentCache = ByteCache.getInstance((int)64, (int)1572);

    public InboundMessageState(RouterContext ctx, long messageId, Hash from) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageState.class);
        this._messageId = messageId;
        this._from = from;
        this._fragments = new ByteArray[64];
        this._lastFragment = -1;
        this._completeSize = -1;
        this._receiveBegin = ctx.clock().now();
    }

    public InboundMessageState(RouterContext ctx, long messageId, Hash from, UDPPacketReader.DataReader data, int dataFragment) throws DataFormatException {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageState.class);
        this._messageId = messageId;
        this._from = from;
        this._fragments = data.readMessageIsLast(dataFragment) ? new ByteArray[1 + data.readMessageFragmentNum(dataFragment)] : new ByteArray[64];
        this._lastFragment = -1;
        this._completeSize = -1;
        this._receiveBegin = ctx.clock().now();
        if (!this.receiveFragment(data, dataFragment)) {
            throw new DataFormatException("corrupt");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean receiveFragment(UDPPacketReader.DataReader data, int dataFragment) {
        int fragmentNum = data.readMessageFragmentNum(dataFragment);
        if (fragmentNum < 0 || fragmentNum >= this._fragments.length) {
            if (!this._log.shouldLog(30)) return false;
            this._log.warn("Invalid fragment " + fragmentNum + '/' + this._fragments.length);
            return false;
        }
        if (this._fragments[fragmentNum] == null) {
            ByteArray message = _fragmentCache.acquire();
            try {
                data.readMessageFragment(dataFragment, message.getData(), 0);
                int size = data.readMessageFragmentSize(dataFragment);
                if (size <= 0 && this._log.shouldLog(30)) {
                    this._log.warn("Zero-length fragment " + fragmentNum + " for message " + this._messageId + " from " + this._from);
                }
                message.setValid(size);
                this._fragments[fragmentNum] = message;
                boolean isLast = data.readMessageIsLast(dataFragment);
                if (isLast) {
                    if (this._lastFragment >= 0) {
                        if (!this._log.shouldLog(40)) return false;
                        this._log.error("Multiple last fragments for message " + this._messageId + " from " + this._from);
                        return false;
                    }
                    this._lastFragment = fragmentNum;
                } else if (this._lastFragment >= 0 && fragmentNum >= this._lastFragment) {
                    if (!this._log.shouldLog(40)) return false;
                    this._log.error("Non-last fragment " + fragmentNum + " when last is " + this._lastFragment + " for message " + this._messageId + " from " + this._from);
                    return false;
                }
                if (!this._log.shouldLog(10)) return true;
                this._log.debug("New fragment " + fragmentNum + " for message " + this._messageId + ", size=" + size + ", isLast=" + isLast);
                return true;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (!this._log.shouldLog(30)) return false;
                this._log.warn("Corrupt SSU fragment " + fragmentNum, (Throwable)aioobe);
                return false;
            }
        } else {
            if (!this._log.shouldLog(10)) return true;
            this._log.debug("Received fragment " + fragmentNum + " for message " + this._messageId + " again, old size=" + this._fragments[fragmentNum].getValid() + " and new size=" + data.readMessageFragmentSize(dataFragment));
        }
        return true;
    }

    public boolean isComplete() {
        int last = this._lastFragment;
        if (last < 0) {
            return false;
        }
        for (int i = 0; i <= last; ++i) {
            if (this._fragments[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isExpired() {
        return this._context.clock().now() > this._receiveBegin + 10000L;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._receiveBegin;
    }

    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    public void drop() {
        this.releaseResources();
    }

    public Hash getFrom() {
        return this._from;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public int getCompleteSize() {
        if (this._completeSize < 0) {
            if (this._lastFragment < 0) {
                throw new IllegalStateException("last fragment not set");
            }
            if (this._released) {
                throw new IllegalStateException("SSU IMS 2 Use after free");
            }
            int size = 0;
            for (int i = 0; i <= this._lastFragment; ++i) {
                ByteArray frag = this._fragments[i];
                if (frag == null) {
                    throw new IllegalStateException("null fragment " + i + '/' + this._lastFragment);
                }
                size += frag.getValid();
            }
            this._completeSize = size;
        }
        return this._completeSize;
    }

    public ACKBitfield createACKBitfield() {
        return new PartialBitfield(this._messageId, this._fragments);
    }

    public void releaseResources() {
        this._released = true;
        for (int i = 0; i < this._fragments.length; ++i) {
            if (this._fragments[i] == null) continue;
            _fragmentCache.release(this._fragments[i]);
            this._fragments[i] = null;
        }
    }

    public ByteArray[] getFragments() {
        if (this._released) {
            IllegalStateException e = new IllegalStateException("Use after free: " + this._messageId);
            this._log.error("SSU IMS", (Throwable)e);
            throw e;
        }
        return this._fragments;
    }

    public int getFragmentCount() {
        return this._lastFragment + 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("IB Message: ").append(this._messageId);
        buf.append(" from ").append(this._from.toString());
        if (this.isComplete()) {
            buf.append(" completely received with ");
            buf.append(this._completeSize).append(" bytes");
        } else {
            for (int i = 0; i <= this._lastFragment; ++i) {
                buf.append(" fragment ").append(i);
                if (this._fragments[i] != null) {
                    buf.append(": known at size ").append(this._fragments[i].getValid());
                    continue;
                }
                buf.append(": unknown");
            }
        }
        buf.append(" lifetime: ").append(this.getLifetime());
        return buf.toString();
    }

    private static final class PartialBitfield
    implements ACKBitfield {
        private final long _bitfieldMessageId;
        private final boolean[] _fragmentsReceived;

        public PartialBitfield(long messageId, Object[] data) {
            this._bitfieldMessageId = messageId;
            boolean[] fragmentsRcvd = null;
            for (int i = data.length - 1; i >= 0; --i) {
                if (data[i] == null) continue;
                if (fragmentsRcvd == null) {
                    fragmentsRcvd = new boolean[i + 1];
                }
                fragmentsRcvd[i] = true;
            }
            this._fragmentsReceived = fragmentsRcvd == null ? new boolean[0] : fragmentsRcvd;
        }

        public int fragmentCount() {
            return this._fragmentsReceived.length;
        }

        public long getMessageId() {
            return this._bitfieldMessageId;
        }

        public boolean received(int fragmentNum) {
            if (fragmentNum < 0 || fragmentNum >= this._fragmentsReceived.length) {
                return false;
            }
            return this._fragmentsReceived[fragmentNum];
        }

        public boolean receivedComplete() {
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Partial ACK of ");
            buf.append(this._bitfieldMessageId);
            buf.append(" with ACKs for: ");
            for (int i = 0; i < this._fragmentsReceived.length; ++i) {
                if (!this._fragmentsReceived[i]) continue;
                buf.append(i).append(" ");
            }
            return buf.toString();
        }
    }
}

