/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterIdentity;
import net.i2p.data.Signature;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

class EstablishState {
    public static final VerifiedEstablishState VERIFIED = new VerifiedEstablishState();
    private final RouterContext _context;
    private final Log _log;
    private final byte[] _X;
    private final byte[] _hX_xor_bobIdentHash;
    private int _aliceIdentSize;
    private ByteArrayOutputStream _sz_aliceIdent_tsA_padding_aliceSig;
    private int _sz_aliceIdent_tsA_padding_aliceSigSize;
    private byte[] _Y;
    private transient byte[] _e_hXY_tsB;
    private transient long _tsB;
    private transient long _tsA;
    private transient byte[] _e_bobSig;
    private byte[] _prevEncrypted;
    private byte[] _curEncrypted;
    private int _curEncryptedOffset;
    private final byte[] _curDecrypted;
    private int _received;
    private byte[] _extra;
    private final DHSessionKeyBuilder _dh;
    private final NTCPTransport _transport;
    private final NTCPConnection _con;
    private boolean _corrupt;
    private String _err;
    private Exception _e;
    private boolean _verified;
    private boolean _confirmWritten;
    private boolean _failedBySkew;

    private EstablishState() {
        this._context = null;
        this._log = null;
        this._X = null;
        this._hX_xor_bobIdentHash = null;
        this._curDecrypted = null;
        this._dh = null;
        this._transport = null;
        this._con = null;
    }

    public EstablishState(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._con = con;
        this._dh = this._transport.getDHBuilder();
        this._hX_xor_bobIdentHash = new byte[32];
        if (this._con.isInbound()) {
            this._X = new byte[256];
            this._sz_aliceIdent_tsA_padding_aliceSig = new ByteArrayOutputStream(512);
        } else {
            this._X = this._dh.getMyPublicValueBytes();
            this._Y = new byte[256];
            ctx.sha().calculateHash(this._X, 0, this._X.length, this._hX_xor_bobIdentHash, 0);
            EstablishState.xor32(con.getRemotePeer().calculateHash().getData(), this._hX_xor_bobIdentHash);
        }
        this._prevEncrypted = new byte[16];
        this._curEncrypted = new byte[16];
        this._curDecrypted = new byte[16];
    }

    public void receive(ByteBuffer src) {
        if (this._corrupt || this._verified) {
            throw new IllegalStateException(this.prefix() + "received after completion [corrupt?" + this._corrupt + " verified? " + this._verified + "] on " + this._con);
        }
        if (!src.hasRemaining()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "receive " + src);
        }
        if (this._con.isInbound()) {
            this.receiveInbound(src);
        } else {
            this.receiveOutbound(src);
        }
    }

    public boolean confirmWritten() {
        return this._confirmWritten;
    }

    public boolean getFailedBySkew() {
        return this._failedBySkew;
    }

    private void receiveInbound(ByteBuffer src) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Receiving inbound: prev received=" + this._received + " src.remaining=" + src.remaining());
        }
        while (this._received < this._X.length && src.hasRemaining()) {
            byte c = src.get();
            this._X[this._received++] = c;
        }
        while (this._received < this._X.length + this._hX_xor_bobIdentHash.length && src.hasRemaining()) {
            byte c;
            int i = this._received - this._X.length;
            ++this._received;
            this._hX_xor_bobIdentHash[i] = c = src.get();
        }
        if (this._received >= this._X.length + this._hX_xor_bobIdentHash.length) {
            if (this._dh.getSessionKey() == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "Enough data for a DH received");
                }
                byte[] realXor = SimpleByteCache.acquire((int)32);
                this._context.sha().calculateHash(this._X, 0, this._X.length, realXor, 0);
                EstablishState.xor32(this._context.routerHash().getData(), realXor);
                if (!DataHelper.eq((byte[])realXor, (byte[])this._hX_xor_bobIdentHash)) {
                    SimpleByteCache.release((byte[])realXor);
                    this._context.statManager().addRateData("ntcp.invalidHXxorBIH", 1L);
                    this.fail("Invalid hX_xor");
                    return;
                }
                SimpleByteCache.release((byte[])realXor);
                if (!this._transport.isHXHIValid(this._hX_xor_bobIdentHash)) {
                    this._context.statManager().addRateData("ntcp.replayHXxorBIH", 1L);
                    this.fail("Replay hX_xor");
                    return;
                }
                try {
                    this._dh.setPeerPublicValue(this._X);
                    this._dh.getSessionKey();
                    System.arraycopy(realXor, 16, this._prevEncrypted, 0, this._prevEncrypted.length);
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "DH session key calculated (" + this._dh.getSessionKey().toBase64() + ")");
                    }
                    this._Y = this._dh.getMyPublicValueBytes();
                    byte[] xy = new byte[this._X.length + this._Y.length];
                    System.arraycopy(this._X, 0, xy, 0, this._X.length);
                    System.arraycopy(this._Y, 0, xy, this._X.length, this._Y.length);
                    byte[] hxy = SimpleByteCache.acquire((int)32);
                    this._context.sha().calculateHash(xy, 0, xy.length, hxy, 0);
                    this._tsB = (this._context.clock().now() + 500L) / 1000L;
                    byte[] toEncrypt = new byte[hxy.length + 16];
                    System.arraycopy(hxy, 0, toEncrypt, 0, hxy.length);
                    byte[] tsB = DataHelper.toLong((int)4, (long)this._tsB);
                    System.arraycopy(tsB, 0, toEncrypt, hxy.length, tsB.length);
                    this._context.random().nextBytes(toEncrypt, hxy.length + 4, 12);
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "h(x+y)=" + Base64.encode((byte[])hxy));
                        this._log.debug(this.prefix() + "tsb=" + Base64.encode((byte[])tsB));
                        this._log.debug(this.prefix() + "unencrypted H(X+Y)+tsB+padding: " + Base64.encode((byte[])toEncrypt));
                        this._log.debug(this.prefix() + "encryption iv= " + Base64.encode((byte[])this._Y, (int)(this._Y.length - 16), (int)16));
                        this._log.debug(this.prefix() + "encryption key= " + this._dh.getSessionKey().toBase64());
                    }
                    SimpleByteCache.release((byte[])hxy);
                    this._e_hXY_tsB = new byte[toEncrypt.length];
                    this._context.aes().encrypt(toEncrypt, 0, this._e_hXY_tsB, 0, this._dh.getSessionKey(), this._Y, this._Y.length - 16, toEncrypt.length);
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "encrypted H(X+Y)+tsB+padding: " + Base64.encode((byte[])this._e_hXY_tsB));
                    }
                    byte[] write = new byte[this._Y.length + this._e_hXY_tsB.length];
                    System.arraycopy(this._Y, 0, write, 0, this._Y.length);
                    System.arraycopy(this._e_hXY_tsB, 0, write, this._Y.length, this._e_hXY_tsB.length);
                    this._transport.getPumper().wantsWrite(this._con, write);
                    if (!src.hasRemaining()) {
                        return;
                    }
                }
                catch (DHSessionKeyBuilder.InvalidPublicParameterException e) {
                    this._context.statManager().addRateData("ntcp.invalidDH", 1L);
                    this.fail("Invalid X", (Exception)((Object)e));
                    return;
                }
            }
            while (src.hasRemaining() && !this._corrupt) {
                while (this._curEncryptedOffset < this._curEncrypted.length && src.hasRemaining()) {
                    this._curEncrypted[this._curEncryptedOffset++] = src.get();
                    ++this._received;
                }
                if (this._curEncryptedOffset >= this._curEncrypted.length) {
                    block27: {
                        this._context.aes().decrypt(this._curEncrypted, 0, this._curDecrypted, 0, this._dh.getSessionKey(), this._prevEncrypted, 0, this._curEncrypted.length);
                        byte[] swap = new byte[16];
                        this._prevEncrypted = this._curEncrypted;
                        this._curEncrypted = swap;
                        this._curEncryptedOffset = 0;
                        if (this._aliceIdentSize <= 0) {
                            int padding;
                            block26: {
                                this._aliceIdentSize = (int)DataHelper.fromLong((byte[])this._curDecrypted, (int)0, (int)2);
                                this._sz_aliceIdent_tsA_padding_aliceSigSize = 2 + this._aliceIdentSize + 4 + Signature.SIGNATURE_BYTES;
                                int rem = this._sz_aliceIdent_tsA_padding_aliceSigSize % 16;
                                padding = 0;
                                if (rem > 0) {
                                    padding = 16 - rem;
                                }
                                this._sz_aliceIdent_tsA_padding_aliceSigSize += padding;
                                try {
                                    this._sz_aliceIdent_tsA_padding_aliceSig.write(this._curDecrypted);
                                }
                                catch (IOException ioe) {
                                    if (!this._log.shouldLog(40)) break block26;
                                    this._log.error(this.prefix() + "Error writing to the baos?", (Throwable)ioe);
                                }
                            }
                            if (!this._log.shouldLog(10)) continue;
                            this._log.debug(this.prefix() + "alice ident size decrypted as " + this._aliceIdentSize + ", making the padding at " + padding + " and total size at " + this._sz_aliceIdent_tsA_padding_aliceSigSize);
                            continue;
                        }
                        try {
                            this._sz_aliceIdent_tsA_padding_aliceSig.write(this._curDecrypted);
                        }
                        catch (IOException ioe) {
                            if (!this._log.shouldLog(40)) break block27;
                            this._log.error(this.prefix() + "Error writing to the baos?", (Throwable)ioe);
                        }
                    }
                    if (this._sz_aliceIdent_tsA_padding_aliceSig.size() < this._sz_aliceIdent_tsA_padding_aliceSigSize) continue;
                    this.verifyInbound();
                    if (!this._corrupt && this._verified && src.hasRemaining()) {
                        this.prepareExtra(src);
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "verifying size (sz=" + this._sz_aliceIdent_tsA_padding_aliceSig.size() + " expected=" + this._sz_aliceIdent_tsA_padding_aliceSigSize + " corrupt=" + this._corrupt + " verified=" + this._verified + " extra=" + (this._extra != null ? this._extra.length : 0) + ")");
                    }
                    return;
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug(this.prefix() + "end of available data with only a partial block read (" + this._curEncryptedOffset + ", " + this._received + ")");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "done with the data, not yet complete or corrupt");
            }
        }
    }

    private void receiveOutbound(ByteBuffer src) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Receive outbound " + src + " received=" + this._received);
        }
        while (this._received < this._Y.length && src.hasRemaining()) {
            byte c = src.get();
            this._Y[this._received++] = c;
            if (this._received < this._Y.length) continue;
            try {
                this._dh.setPeerPublicValue(this._Y);
                this._dh.getSessionKey();
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "DH session key calculated (" + this._dh.getSessionKey().toBase64() + ")");
                }
                this._e_hXY_tsB = new byte[48];
            }
            catch (DHSessionKeyBuilder.InvalidPublicParameterException e) {
                this._context.statManager().addRateData("ntcp.invalidDH", 1L);
                this.fail("Invalid X", (Exception)((Object)e));
                return;
            }
        }
        if (this._e_hXY_tsB == null) {
            return;
        }
        while (this._received < this._Y.length + this._e_hXY_tsB.length && src.hasRemaining()) {
            byte c;
            int i = this._received - this._Y.length;
            ++this._received;
            this._e_hXY_tsB[i] = c = src.get();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "recv _e_hXY_tsB " + c + " received=" + this._received);
            }
            if (i + 1 < this._e_hXY_tsB.length) continue;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "received _e_hXY_tsB fully");
            }
            byte[] hXY_tsB = new byte[this._e_hXY_tsB.length];
            this._context.aes().decrypt(this._e_hXY_tsB, 0, hXY_tsB, 0, this._dh.getSessionKey(), this._Y, this._Y.length - 16, this._e_hXY_tsB.length);
            byte[] XY = new byte[this._X.length + this._Y.length];
            System.arraycopy(this._X, 0, XY, 0, this._X.length);
            System.arraycopy(this._Y, 0, XY, this._X.length, this._Y.length);
            byte[] h = SimpleByteCache.acquire((int)32);
            this._context.sha().calculateHash(XY, 0, XY.length, h, 0);
            if (!DataHelper.eq((byte[])h, (int)0, (byte[])hXY_tsB, (int)0, (int)32)) {
                SimpleByteCache.release((byte[])h);
                this._context.statManager().addRateData("ntcp.invalidHXY", 1L);
                this.fail("Invalid H(X+Y) - mitm attack attempted?");
                return;
            }
            SimpleByteCache.release((byte[])h);
            this._tsB = DataHelper.fromLong((byte[])hXY_tsB, (int)32, (int)4);
            this._tsA = (this._context.clock().now() + 500L) / 1000L;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "h(X+Y) is correct, tsA-tsB=" + (this._tsA - this._tsB));
            }
            long diff = 1000L * Math.abs(this._tsA - this._tsB);
            if (!this._context.clock().getUpdatedSuccessfully()) {
                this._context.clock().setOffset(1000L * (this._tsB - this._tsA), true);
                this._tsA = this._tsB;
                if (diff != 0L) {
                    this._log.logAlways(30, "NTP failure, NTCP adjusting clock by " + DataHelper.formatDuration((long)diff));
                }
            } else {
                if (diff >= 60000L) {
                    this._context.statManager().addRateData("ntcp.invalidOutboundSkew", diff);
                    this._transport.markReachable(this._con.getRemotePeer().calculateHash(), false);
                    this._context.banlist().banlistRouter(DataHelper.formatDuration((long)diff), this._con.getRemotePeer().calculateHash(), EstablishState._x("Excessive clock skew: {0}"));
                    this._transport.setLastBadSkew(this._tsA - this._tsB);
                    this.fail("Clocks too skewed (" + diff + " ms)", null, true);
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "Clock skew: " + diff + " ms");
                }
            }
            int sigSize = this._X.length + this._Y.length + 32 + 4 + 4;
            byte[] preSign = new byte[sigSize];
            System.arraycopy(this._X, 0, preSign, 0, this._X.length);
            System.arraycopy(this._Y, 0, preSign, this._X.length, this._Y.length);
            System.arraycopy(this._con.getRemotePeer().calculateHash().getData(), 0, preSign, this._X.length + this._Y.length, 32);
            DataHelper.toLong((byte[])preSign, (int)(this._X.length + this._Y.length + 32), (int)4, (long)this._tsA);
            DataHelper.toLong((byte[])preSign, (int)(this._X.length + this._Y.length + 32 + 4), (int)4, (long)this._tsB);
            Signature sig = this._context.dsa().sign(preSign, this._context.keyManager().getSigningPrivateKey());
            byte[] ident = this._context.router().getRouterInfo().getIdentity().toByteArray();
            int min = 2 + ident.length + 4 + Signature.SIGNATURE_BYTES;
            int rem = min % 16;
            int padding = 0;
            if (rem > 0) {
                padding = 16 - rem;
            }
            byte[] preEncrypt = new byte[min + padding];
            DataHelper.toLong((byte[])preEncrypt, (int)0, (int)2, (long)ident.length);
            System.arraycopy(ident, 0, preEncrypt, 2, ident.length);
            DataHelper.toLong((byte[])preEncrypt, (int)(2 + ident.length), (int)4, (long)this._tsA);
            if (padding > 0) {
                this._context.random().nextBytes(preEncrypt, 2 + ident.length + 4, padding);
            }
            System.arraycopy(sig.getData(), 0, preEncrypt, 2 + ident.length + 4 + padding, Signature.SIGNATURE_BYTES);
            this._prevEncrypted = new byte[preEncrypt.length];
            this._context.aes().encrypt(preEncrypt, 0, this._prevEncrypted, 0, this._dh.getSessionKey(), this._hX_xor_bobIdentHash, this._hX_xor_bobIdentHash.length - 16, preEncrypt.length);
            this._transport.getPumper().wantsWrite(this._con, this._prevEncrypted);
        }
        if (this._received >= this._Y.length + this._e_hXY_tsB.length && src.hasRemaining()) {
            int off = 0;
            if (this._e_bobSig == null) {
                this._e_bobSig = new byte[48];
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "receiving E(S(X+Y+Alice.identHash+tsA+tsB)+padding, sk, prev) (remaining? " + src.hasRemaining() + ")");
                }
            } else {
                off = this._received - this._Y.length - this._e_hXY_tsB.length;
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "continuing to receive E(S(X+Y+Alice.identHash+tsA+tsB)+padding, sk, prev) (remaining? " + src.hasRemaining() + " off=" + off + " recv=" + this._received + ")");
                }
            }
            while (src.hasRemaining() && off < this._e_bobSig.length) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "recv bobSig received=" + this._received);
                }
                this._e_bobSig[off++] = src.get();
                ++this._received;
                if (off < this._e_bobSig.length) continue;
                byte[] bobSig = new byte[this._e_bobSig.length];
                this._context.aes().decrypt(this._e_bobSig, 0, bobSig, 0, this._dh.getSessionKey(), this._e_hXY_tsB, this._e_hXY_tsB.length - 16, this._e_bobSig.length);
                byte[] bobSigData = new byte[Signature.SIGNATURE_BYTES];
                System.arraycopy(bobSig, 0, bobSigData, 0, Signature.SIGNATURE_BYTES);
                Signature sig = new Signature(bobSigData);
                byte[] toVerify = new byte[this._X.length + this._Y.length + 32 + 4 + 4];
                int voff = 0;
                System.arraycopy(this._X, 0, toVerify, voff, this._X.length);
                System.arraycopy(this._Y, 0, toVerify, voff += this._X.length, this._Y.length);
                System.arraycopy(this._context.routerHash().getData(), 0, toVerify, voff += this._Y.length, 32);
                DataHelper.toLong((byte[])toVerify, (int)(voff += 32), (int)4, (long)this._tsA);
                DataHelper.toLong((byte[])toVerify, (int)(voff += 4), (int)4, (long)this._tsB);
                voff += 4;
                this._verified = this._context.dsa().verifySignature(sig, toVerify, this._con.getRemotePeer().getSigningPublicKey());
                if (!this._verified) {
                    this._context.statManager().addRateData("ntcp.invalidSignature", 1L);
                    this.fail("Signature was invalid - attempt to spoof " + this._con.getRemotePeer().calculateHash().toBase64() + "?");
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "signature verified from Bob.  done!");
                    }
                    this.prepareExtra(src);
                    byte[] nextWriteIV = new byte[16];
                    System.arraycopy(this._prevEncrypted, this._prevEncrypted.length - 16, nextWriteIV, 0, 16);
                    byte[] nextReadIV = new byte[16];
                    System.arraycopy(this._e_bobSig, this._e_bobSig.length - 16, nextReadIV, 0, nextReadIV.length);
                    this._con.finishOutboundEstablishment(this._dh.getSessionKey(), this._tsA - this._tsB, nextWriteIV, nextReadIV);
                    InetAddress ia = this._con.getChannel().socket().getInetAddress();
                    if (ia != null) {
                        this._transport.setIP(this._con.getRemotePeer().calculateHash(), ia.getAddress());
                    }
                }
                return;
            }
        }
    }

    public boolean isCorrupt() {
        return this._err != null;
    }

    public boolean isComplete() {
        return this._verified;
    }

    public void prepareOutbound() {
        if (this._received <= 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "write out the first part of our handshake");
            }
            byte[] toWrite = new byte[this._X.length + this._hX_xor_bobIdentHash.length];
            System.arraycopy(this._X, 0, toWrite, 0, this._X.length);
            System.arraycopy(this._hX_xor_bobIdentHash, 0, toWrite, this._X.length, this._hX_xor_bobIdentHash.length);
            this._transport.getPumper().wantsWrite(this._con, toWrite);
        } else if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "prepare outbound with received=" + this._received);
        }
    }

    private void verifyInbound() {
        if (this._corrupt) {
            return;
        }
        byte[] b = this._sz_aliceIdent_tsA_padding_aliceSig.toByteArray();
        try {
            RouterIdentity alice = new RouterIdentity();
            int sz = (int)DataHelper.fromLong((byte[])b, (int)0, (int)2);
            if (sz <= 0 || sz > b.length - 2 - 4 - Signature.SIGNATURE_BYTES) {
                this._context.statManager().addRateData("ntcp.invalidInboundSize", (long)sz);
                this.fail("size is invalid", new Exception("size is " + sz));
                return;
            }
            byte[] aliceData = new byte[sz];
            System.arraycopy(b, 2, aliceData, 0, sz);
            alice.fromByteArray(aliceData);
            long tsA = DataHelper.fromLong((byte[])b, (int)(2 + sz), (int)4);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(768);
            baos.write(this._X);
            baos.write(this._Y);
            baos.write(this._context.routerHash().getData());
            baos.write(DataHelper.toLong((int)4, (long)tsA));
            baos.write(DataHelper.toLong((int)4, (long)this._tsB));
            byte[] toVerify = baos.toByteArray();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.prefix() + "checking " + Base64.encode((byte[])toVerify, (int)0, (int)16));
            }
            byte[] s = new byte[Signature.SIGNATURE_BYTES];
            System.arraycopy(b, b.length - s.length, s, 0, s.length);
            Signature sig = new Signature(s);
            this._verified = this._context.dsa().verifySignature(sig, toVerify, alice.getSigningPublicKey());
            if (this._verified) {
                byte[] ip;
                InetAddress addr = this._con.getChannel().socket().getInetAddress();
                byte[] byArray = ip = addr == null ? null : addr.getAddress();
                if (this._context.banlist().isBanlistedForever(alice.calculateHash())) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping inbound connection from permanently banlisted peer: " + alice.calculateHash().toBase64());
                    }
                    if (ip != null) {
                        this._context.blocklist().add(ip);
                    }
                    this.fail("Peer is banlisted forever: " + alice.calculateHash().toBase64());
                    return;
                }
                if (ip != null) {
                    this._transport.setIP(alice.calculateHash(), ip);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "verification successful for " + this._con);
                }
                long diff = 1000L * Math.abs(tsA - this._tsB);
                if (!this._context.clock().getUpdatedSuccessfully()) {
                    this._context.clock().setOffset(1000L * (this._tsB - tsA), true);
                    tsA = this._tsB;
                    if (diff != 0L) {
                        this._log.logAlways(30, "NTP failure, NTCP adjusting clock by " + DataHelper.formatDuration((long)diff));
                    }
                } else {
                    if (diff >= 60000L) {
                        this._context.statManager().addRateData("ntcp.invalidInboundSkew", diff);
                        this._transport.markReachable(alice.calculateHash(), true);
                        this._context.banlist().banlistRouter(DataHelper.formatDuration((long)diff), alice.calculateHash(), EstablishState._x("Excessive clock skew: {0}"));
                        this._transport.setLastBadSkew(tsA - this._tsB);
                        this.fail("Clocks too skewed (" + diff + " ms)", null, true);
                        return;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this.prefix() + "Clock skew: " + diff + " ms");
                    }
                }
                this.sendInboundConfirm(alice, tsA);
                this._con.setRemotePeer(alice);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.prefix() + "e_bobSig is " + this._e_bobSig.length + " bytes long");
                }
                byte[] iv = new byte[16];
                System.arraycopy(this._e_bobSig, this._e_bobSig.length - 16, iv, 0, 16);
                this._con.finishInboundEstablishment(this._dh.getSessionKey(), tsA - this._tsB, iv, this._prevEncrypted);
                if (this._log.shouldLog(20)) {
                    this._log.info(this.prefix() + "Verified remote peer as " + alice.calculateHash().toBase64());
                }
            } else {
                this._context.statManager().addRateData("ntcp.invalidInboundSignature", 1L);
                this.fail("Peer verification failed - spoof of " + alice.calculateHash().toBase64() + "?");
            }
        }
        catch (IOException ioe) {
            this._context.statManager().addRateData("ntcp.invalidInboundIOE", 1L);
            this.fail("Error verifying peer", ioe);
        }
        catch (DataFormatException dfe) {
            this._context.statManager().addRateData("ntcp.invalidInboundDFE", 1L);
            this.fail("Error verifying peer", (Exception)((Object)dfe));
        }
        catch (NullPointerException npe) {
            this.fail("Error verifying peer", npe);
        }
    }

    private void sendInboundConfirm(RouterIdentity alice, long tsA) {
        byte[] toSign = new byte[552];
        int off = 0;
        System.arraycopy(this._X, 0, toSign, off, 256);
        System.arraycopy(this._Y, 0, toSign, off += 256, 256);
        Hash h = alice.calculateHash();
        System.arraycopy(h.getData(), 0, toSign, off += 256, 32);
        DataHelper.toLong((byte[])toSign, (int)(off += 32), (int)4, (long)tsA);
        DataHelper.toLong((byte[])toSign, (int)(off += 4), (int)4, (long)this._tsB);
        off += 4;
        Signature sig = this._context.dsa().sign(toSign, this._context.keyManager().getSigningPrivateKey());
        byte[] preSig = new byte[Signature.SIGNATURE_BYTES + 8];
        System.arraycopy(sig.getData(), 0, preSig, 0, Signature.SIGNATURE_BYTES);
        this._context.random().nextBytes(preSig, Signature.SIGNATURE_BYTES, 8);
        this._e_bobSig = new byte[preSig.length];
        this._context.aes().encrypt(preSig, 0, this._e_bobSig, 0, this._dh.getSessionKey(), this._e_hXY_tsB, this._e_hXY_tsB.length - 16, this._e_bobSig.length);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Sending encrypted inbound confirmation");
        }
        this._transport.getPumper().wantsWrite(this._con, this._e_bobSig);
    }

    private void prepareExtra(ByteBuffer buf) {
        int remaining = buf.remaining();
        if (remaining > 0) {
            this._extra = new byte[remaining];
            buf.get(this._extra);
            this._received += remaining;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "prepare extra " + remaining + " (total received: " + this._received + ")");
        }
    }

    public byte[] getExtraBytes() {
        return this._extra;
    }

    private void fail(String reason) {
        this.fail(reason, null);
    }

    private void fail(String reason, Exception e) {
        this.fail(reason, e, false);
    }

    private void fail(String reason, Exception e, boolean bySkew) {
        this._corrupt = true;
        this._failedBySkew = bySkew;
        this._err = reason;
        this._e = e;
        if (this._log.shouldLog(30)) {
            this._log.warn(this.prefix() + "Failed to establish: " + this._err, (Throwable)e);
        }
    }

    public String getError() {
        return this._err;
    }

    public Exception getException() {
        return this._e;
    }

    private static void xor32(byte[] a, byte[] b) {
        for (int i = 0; i < 32; ++i) {
            int n = i;
            b[n] = (byte)(b[n] ^ a[i]);
        }
    }

    private String prefix() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("est").append(System.identityHashCode(this));
        if (this._con.isInbound()) {
            buf.append(" inbound");
        } else {
            buf.append(" outbound");
        }
        if (this._corrupt) {
            buf.append(" corrupt");
        }
        if (this._verified) {
            buf.append(" verified");
        }
        if (this._con.isEstablished()) {
            buf.append(" established");
        }
        buf.append(": ");
        return buf.toString();
    }

    private static final String _x(String s) {
        return s;
    }

    private static class VerifiedEstablishState
    extends EstablishState {
        private VerifiedEstablishState() {
        }

        public boolean isComplete() {
            return true;
        }

        public void prepareOutbound() {
            Log log = RouterContext.getCurrentContext().logManager().getLog(VerifiedEstablishState.class);
            log.warn("prepareOutbound() on verified state, doing nothing!");
        }

        public String toString() {
            return "VerfiedEstablishState";
        }
    }
}

