/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.NoSuchElementException;
import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillVerifyStoreJob;
import net.i2p.router.networkdb.kademlia.StoreJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FloodfillStoreJob
extends StoreJob {
    private final FloodfillNetworkDatabaseFacade _facade;
    private static final String PROP_RI_VERIFY = "router.verifyRouterInfoStore";

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs) {
        this(context, facade, key, data, onSuccess, onFailure, timeoutMs, null);
    }

    public FloodfillStoreJob(RouterContext context, FloodfillNetworkDatabaseFacade facade, Hash key, DatabaseEntry data, Job onSuccess, Job onFailure, long timeoutMs, Set<Hash> toSkip) {
        super(context, facade, key, data, onSuccess, onFailure, timeoutMs, toSkip);
        this._facade = facade;
    }

    @Override
    protected int getParallelization() {
        return 1;
    }

    @Override
    protected int getRedundancy() {
        return 1;
    }

    @Override
    protected void succeed() {
        boolean isRouterInfo;
        super.succeed();
        if (this._facade.isVerifyInProgress(this._state.getTarget())) {
            if (this._log.shouldLog(20)) {
                this._log.info("Skipping verify, one already in progress for: " + this._state.getTarget());
            }
            return;
        }
        if (this.getContext().router().gracefulShutdownInProgress()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Skipping verify, shutdown in progress for: " + this._state.getTarget());
            }
            return;
        }
        DatabaseEntry data = this._state.getData();
        boolean bl = isRouterInfo = data.getType() == 0;
        if (isRouterInfo && !this.getContext().getBooleanProperty(PROP_RI_VERIFY)) {
            this._facade.routerInfoPublishSuccessful();
            return;
        }
        long published = data.getDate();
        Hash sentTo = null;
        try {
            sentTo = this._state.getSuccessful().iterator().next();
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
        this.getContext().jobQueue().addJob(new FloodfillVerifyStoreJob(this.getContext(), this._state.getTarget(), published, isRouterInfo, sentTo, this._facade));
    }

    @Override
    public String getName() {
        return "Floodfill netDb store";
    }
}

