/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.data.SimpleDataStructure;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.SelectionCollector;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.util.RandomIterator;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FloodfillPeerSelector
extends PeerSelector {
    private static final int NO_FAIL_STORE_OK = 600000;
    private static final int NO_FAIL_STORE_GOOD = 1200000;
    private static final int NO_FAIL_LOOKUP_OK = 75000;
    private static final int NO_FAIL_LOOKUP_GOOD = 225000;
    private static final int MAX_GOOD_RESP_TIME = 5000;

    public FloodfillPeerSelector(RouterContext ctx) {
        super(ctx);
    }

    @Override
    List<Hash> selectMostReliablePeers(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, true);
    }

    @Override
    List<Hash> selectNearestExplicitThin(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, false);
    }

    List<Hash> selectNearestExplicitThin(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets, boolean preferConnected) {
        if (peersToIgnore == null) {
            peersToIgnore = Collections.singleton(this._context.routerHash());
        } else {
            peersToIgnore.add(this._context.routerHash());
        }
        FloodfillSelectionCollector matches = new FloodfillSelectionCollector(key, peersToIgnore, maxNumRouters);
        if (kbuckets == null) {
            return new ArrayList<Hash>();
        }
        kbuckets.getAll((SelectionCollector)matches);
        List<Hash> rv = matches.get(maxNumRouters, preferConnected);
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching for " + maxNumRouters + " peers close to " + key + ": " + rv + " (not including " + peersToIgnore + ") [allHashes.size = " + matches.size() + "]", (Throwable)new Exception("Search by"));
        }
        return rv;
    }

    List<Hash> selectFloodfillParticipants(KBucketSet<Hash> kbuckets) {
        Set<Hash> ignore = Collections.singleton(this._context.routerHash());
        return this.selectFloodfillParticipants(ignore, kbuckets);
    }

    private List<Hash> selectFloodfillParticipants(Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        Set<Hash> set = this._context.peerManager().getPeersByCapability('f');
        ArrayList<Hash> rv = new ArrayList<Hash>(set.size());
        for (Hash h : set) {
            if (toIgnore != null && toIgnore.contains(h) || this._context.banlist().isBanlistedForever(h)) continue;
            rv.add(h);
        }
        return rv;
    }

    List<Hash> selectFloodfillParticipants(Hash key, int maxNumRouters, KBucketSet<Hash> kbuckets) {
        Set<Hash> ignore = Collections.singleton(this._context.routerHash());
        return this.selectFloodfillParticipants(key, maxNumRouters, ignore, kbuckets);
    }

    List<Hash> selectFloodfillParticipants(Hash key, int howMany, Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        if (toIgnore == null) {
            toIgnore = Collections.singleton(this._context.routerHash());
        } else if (!toIgnore.contains(this._context.routerHash())) {
            toIgnore = new HashSet<Hash>(toIgnore);
            toIgnore.add(this._context.routerHash());
        }
        return this.selectFloodfillParticipantsIncludingUs(key, howMany, toIgnore, kbuckets);
    }

    private List<Hash> selectFloodfillParticipantsIncludingUs(Hash key, int howMany, Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        Hash entry;
        int i;
        Rate r;
        RateStat rs;
        List<Hash> ffs = this.selectFloodfillParticipants(toIgnore, kbuckets);
        TreeSet<Hash> sorted = new TreeSet<Hash>((Comparator<Hash>)new XORComparator((SimpleDataStructure)key));
        sorted.addAll(ffs);
        ArrayList<Hash> rv = new ArrayList<Hash>(howMany);
        ArrayList<Hash> okff = new ArrayList<Hash>(ffs.size());
        ArrayList<Hash> badff = new ArrayList<Hash>(ffs.size());
        int found = 0;
        long now = this._context.clock().now();
        double maxFailRate = 100.0;
        if (this._context.router().getUptime() > 3600000L && (rs = this._context.statManager().getRate("peer.failedLookupRate")) != null && (r = rs.getRate(3600000L)) != null) {
            double currentFailRate = r.getAverageValue();
            maxFailRate = Math.max(0.2, 1.5 * currentFailRate);
        }
        int limit = Math.max(5, howMany);
        limit = Math.min(limit, ffs.size());
        HashSet<Integer> maskedIPs = new HashSet<Integer>(limit + 4);
        for (i = 0; found < howMany && i < limit && (entry = (Hash)sorted.first()) != null; ++i) {
            Rate tunnelTestTime;
            sorted.remove(entry);
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(entry);
            Set<Integer> entryIPs = this.maskedIPSet(entry, info, 2);
            boolean sameIP = false;
            for (Integer ip : entryIPs) {
                if (maskedIPs.add(ip)) continue;
                sameIP = true;
            }
            if (sameIP) {
                badff.add(entry);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Same /16: " + entry);
                continue;
            }
            if (info != null && now - info.getPublished() > 10800000L) {
                badff.add(entry);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Old: " + entry);
                continue;
            }
            PeerProfile prof = this._context.profileOrganizer().getProfile(entry);
            double maxGoodRespTime = 5000.0;
            RateStat ttst = this._context.statManager().getRate("tunnel.testSuccessTime");
            if (ttst != null && (tunnelTestTime = ttst.getRate(600000L)) != null && tunnelTestTime.getAverageValue() > 500.0) {
                maxGoodRespTime = 2.0 * tunnelTestTime.getAverageValue();
            }
            if (prof != null && prof.getDBHistory() != null && prof.getDbResponseTime().getRate(600000L).getAverageValue() < maxGoodRespTime && prof.getDBHistory().getLastStoreFailed() < now - 1200000L && prof.getDBHistory().getLastLookupFailed() < now - 225000L && prof.getDBHistory().getFailedLookupRate().getRate(3600000L).getAverageValue() < maxFailRate) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Good: " + entry);
                }
                rv.add(entry);
                ++found;
                continue;
            }
            if (prof != null && prof.getDBHistory() != null && (prof.getDBHistory().getLastStoreFailed() <= prof.getDBHistory().getLastStoreSuccessful() || prof.getDBHistory().getLastLookupFailed() <= prof.getDBHistory().getLastLookupSuccessful() || prof.getDBHistory().getLastStoreFailed() < now - 600000L && prof.getDBHistory().getLastLookupFailed() < now - 75000L)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("OK: " + entry);
                }
                okff.add(entry);
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Bad: " + entry);
            }
            badff.add(entry);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Good: " + rv + " OK: " + okff + " Bad: " + badff);
        }
        for (i = 0; found < howMany && i < okff.size(); ++found, ++i) {
            rv.add((Hash)okff.get(i));
        }
        for (i = 0; found < howMany && i < badff.size(); ++found, ++i) {
            rv.add((Hash)badff.get(i));
        }
        return rv;
    }

    private Set<Integer> maskedIPSet(Hash peer, RouterInfo pinfo, int mask) {
        HashSet<Integer> rv = new HashSet<Integer>(4);
        byte[] commIP = this._context.commSystem().getIP(peer);
        if (commIP != null) {
            rv.add(FloodfillPeerSelector.maskedIP(commIP, mask));
        }
        if (pinfo == null) {
            return rv;
        }
        Collection paddr = pinfo.getAddresses();
        for (RouterAddress pa : paddr) {
            byte[] pib = pa.getIP();
            if (pib == null) continue;
            rv.add(FloodfillPeerSelector.maskedIP(pib, mask));
        }
        return rv;
    }

    private static Integer maskedIP(byte[] ip, int mask) {
        int rv = ip[0];
        if (ip.length == 16) {
            for (int i = 1; i < 8; ++i) {
                rv <<= i * 4;
                rv ^= ip[i];
            }
        } else {
            for (int i = 1; i < mask; ++i) {
                rv <<= 8;
                rv ^= ip[i];
            }
        }
        return rv;
    }

    @Override
    List<Hash> selectNearest(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        Hash rkey = this._context.routingKeyGenerator().getRoutingKey(key);
        if (peersToIgnore != null && peersToIgnore.contains(Hash.FAKE_HASH)) {
            peersToIgnore.addAll(this.selectFloodfillParticipants(peersToIgnore, kbuckets));
            FloodfillSelectionCollector matches = new FloodfillSelectionCollector(rkey, peersToIgnore, maxNumRouters);
            kbuckets.getAll((SelectionCollector)matches);
            return matches.get(maxNumRouters);
        }
        return this.selectFloodfillParticipantsIncludingUs(rkey, maxNumRouters, peersToIgnore, kbuckets);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FloodfillSelectionCollector
    implements SelectionCollector<Hash> {
        private final TreeSet<Hash> _sorted;
        private final List<Hash> _floodfillMatches;
        private final Hash _key;
        private final Set<Hash> _toIgnore;
        private int _matches;
        private final int _wanted;
        private static final int EXTRA_MATCHES = 100;

        public FloodfillSelectionCollector(Hash key, Set<Hash> toIgnore, int wanted) {
            this._key = key;
            this._sorted = new TreeSet(new XORComparator((SimpleDataStructure)key));
            this._floodfillMatches = new ArrayList<Hash>(8);
            this._toIgnore = toIgnore;
            this._wanted = wanted;
        }

        public void add(Hash entry) {
            if (this._toIgnore != null && this._toIgnore.contains(entry)) {
                return;
            }
            if (FloodfillPeerSelector.this._context.banlist().isBanlistedForever(entry)) {
                return;
            }
            RouterInfo info = FloodfillPeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
            if (info != null && FloodfillNetworkDatabaseFacade.isFloodfill(info)) {
                this._floodfillMatches.add(entry);
            } else if (!SearchJob.onlyQueryFloodfillPeers(FloodfillPeerSelector.this._context) && this._wanted + 100 > this._matches && this._key != null) {
                this._sorted.add(entry);
            } else {
                return;
            }
            ++this._matches;
        }

        public List<Hash> get(int howMany) {
            return this.get(howMany, false);
        }

        public List<Hash> get(int howMany, boolean preferConnected) {
            int i;
            Hash entry;
            ArrayList<Hash> rv = new ArrayList<Hash>(howMany);
            ArrayList<Hash> badff = new ArrayList<Hash>(howMany);
            ArrayList<Hash> unconnectedff = new ArrayList<Hash>(howMany);
            int found = 0;
            long now = FloodfillPeerSelector.this._context.clock().now();
            RandomIterator<Hash> iter = new RandomIterator<Hash>(this._floodfillMatches);
            while (found < howMany && iter.hasNext()) {
                entry = (Hash)iter.next();
                RouterInfo info = FloodfillPeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
                if (info != null && now - info.getPublished() > 10800000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, published a while ago: " + entry);
                    continue;
                }
                PeerProfile prof = FloodfillPeerSelector.this._context.profileOrganizer().getProfile(entry);
                if (prof != null && now - prof.getLastSendFailed() < 1800000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, recent failed send: " + entry);
                    continue;
                }
                if (preferConnected && !FloodfillPeerSelector.this._context.commSystem().isEstablished(entry)) {
                    unconnectedff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, unconnected: " + entry);
                    continue;
                }
                rv.add(entry);
                ++found;
            }
            for (i = 0; found < howMany && i < unconnectedff.size(); ++found, ++i) {
                rv.add((Hash)unconnectedff.get(i));
            }
            for (i = 0; found < howMany && i < badff.size(); ++found, ++i) {
                rv.add((Hash)badff.get(i));
            }
            for (i = rv.size(); i < howMany && !this._sorted.isEmpty(); ++i) {
                entry = this._sorted.first();
                rv.add(entry);
                this._sorted.remove(entry);
            }
            return rv;
        }

        public int size() {
            return this._matches;
        }
    }
}

