/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Set;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExpireRoutersJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 300000L;

    public ExpireRoutersJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireRoutersJob.class);
        this._facade = facade;
    }

    public String getName() {
        return "Expire Routers Job";
    }

    public void runJob() {
        if (this.getContext().commSystem().getReachabilityStatus() != 3) {
            int removed = this.expireKeys();
            if (this._log.shouldLog(20)) {
                this._log.info("Routers expired: " + removed);
            }
        }
        this.requeue(300000L);
    }

    private int expireKeys() {
        Set<Hash> keys = this._facade.getAllRouters();
        keys.remove(this.getContext().routerHash());
        if (keys.size() < 150) {
            return 0;
        }
        int removed = 0;
        for (Hash key : keys) {
            DatabaseEntry e;
            if (this.getContext().commSystem().isEstablished(key) || (e = this._facade.lookupLocallyWithoutValidation(key)) == null || e.getType() != 0) continue;
            try {
                if (this._facade.validate((RouterInfo)e) == null) continue;
                this._facade.dropAfterLookupFailed(key);
                ++removed;
            }
            catch (IllegalArgumentException iae) {
                this._facade.dropAfterLookupFailed(key);
                ++removed;
            }
        }
        return removed;
    }
}

