/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Locale;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2cp.DestReplyMessage;
import net.i2p.data.i2cp.HostReplyMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SessionId;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;

class LookupDestJob
extends JobImpl {
    private final ClientConnectionRunner _runner;
    private final long _reqID;
    private final long _timeout;
    private final Hash _hash;
    private final String _name;
    private final SessionId _sessID;
    private final Hash _fromLocalDest;
    private static final long DEFAULT_TIMEOUT = 15000L;

    public LookupDestJob(RouterContext context, ClientConnectionRunner runner, Hash h, Hash fromLocalDest) {
        this(context, runner, -1L, 15000L, null, h, null, fromLocalDest);
    }

    public LookupDestJob(RouterContext context, ClientConnectionRunner runner, long reqID, long timeout, SessionId sessID, Hash h, String name, Hash fromLocalDest) {
        super(context);
        byte[] b;
        String nlc;
        if (h == null && name == null || h != null && name != null || reqID >= 0L && sessID == null || reqID < 0L && name != null) {
            throw new IllegalArgumentException();
        }
        this._runner = runner;
        this._reqID = reqID;
        this._timeout = timeout;
        this._sessID = sessID;
        this._fromLocalDest = fromLocalDest;
        if (name != null && name.length() == 60 && (nlc = name.toLowerCase(Locale.US)).endsWith(".b32.i2p") && (b = Base32.decode((String)nlc.substring(0, 52))) != null && b.length == 32) {
            h = Hash.create((byte[])b);
            name = null;
        }
        this._hash = h;
        this._name = name;
    }

    public String getName() {
        return this._name != null ? "HostName Lookup for Client" : "LeaseSet Lookup for Client";
    }

    public void runJob() {
        if (this._name != null) {
            Destination d = this.getContext().namingService().lookup(this._name);
            if (d != null) {
                this.returnDest(d);
            } else {
                this.returnFail();
            }
        } else {
            DoneJob done = new DoneJob(this.getContext());
            this.getContext().netDb().lookupLeaseSet(this._hash, done, done, this._timeout, this._fromLocalDest);
        }
    }

    private void returnDest(Destination d) {
        Object msg = this._reqID >= 0L ? new HostReplyMessage(this._sessID, d, this._reqID) : new DestReplyMessage(d);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException i2CPMessageException) {
            // empty catch block
        }
    }

    private void returnFail() {
        Object msg = this._reqID >= 0L ? new HostReplyMessage(this._sessID, 1, this._reqID) : new DestReplyMessage(this._hash);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException i2CPMessageException) {
            // empty catch block
        }
    }

    private class DoneJob
    extends JobImpl {
        public DoneJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "LeaseSet Lookup Reply to Client";
        }

        public void runJob() {
            LeaseSet ls = this.getContext().netDb().lookupLeaseSetLocally(LookupDestJob.this._hash);
            if (ls != null) {
                LookupDestJob.this.returnDest(ls.getDestination());
            } else {
                LookupDestJob.this.returnFail();
            }
        }
    }
}

