/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.BandwidthLimitsMessage;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.CreateSessionMessage;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.HostLookupMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.ReceiveMessageBeginMessage;
import net.i2p.data.i2cp.ReceiveMessageEndMessage;
import net.i2p.data.i2cp.ReconfigureSessionMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.data.i2cp.SessionStatusMessage;
import net.i2p.data.i2cp.SetDateMessage;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.ClientManager;
import net.i2p.router.client.CreateSessionJob;
import net.i2p.router.client.LookupDestJob;
import net.i2p.util.Log;
import net.i2p.util.PasswordManager;

class ClientMessageEventListener
implements I2CPMessageReader.I2CPMessageEventListener {
    private final Log _log;
    protected final RouterContext _context;
    protected final ClientConnectionRunner _runner;
    private final boolean _enforceAuth;
    private volatile boolean _authorized;
    private static final String PROP_AUTH = "i2cp.auth";
    private static final String PROP_AUTH_STRICT = "i2cp.strictAuth";

    public ClientMessageEventListener(RouterContext context, ClientConnectionRunner runner, boolean enforceAuth) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientMessageEventListener.class);
        this._runner = runner;
        this._enforceAuth = enforceAuth;
        if (!this._enforceAuth || !this._context.getBooleanProperty(PROP_AUTH)) {
            this._authorized = true;
        }
        this._context.statManager().createRateStat("client.distributeTime", "How long it took to inject the client message into the router", "ClientMessages", new long[]{60000L, 600000L, 3600000L});
    }

    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        boolean strict;
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Message received: \n" + message);
        }
        int type = message.getType();
        if (!this._authorized && ((strict = this._context.getBooleanProperty(PROP_AUTH_STRICT)) && type != 32 || type != 1 && type != 32 && type != 34 && type != 8)) {
            this._log.error("Received message type " + type + " without required authentication");
            this._runner.disconnectClient("Authorization required");
            return;
        }
        switch (message.getType()) {
            case 32: {
                this.handleGetDate((GetDateMessage)message);
                break;
            }
            case 33: {
                this.handleSetDate((SetDateMessage)message);
                break;
            }
            case 1: {
                this.handleCreateSession((CreateSessionMessage)message);
                break;
            }
            case 5: {
                this.handleSendMessage((SendMessageMessage)message);
                break;
            }
            case 36: {
                this.handleSendMessage((SendMessageMessage)((SendMessageExpiresMessage)message));
                break;
            }
            case 6: {
                this.handleReceiveBegin((ReceiveMessageBeginMessage)message);
                break;
            }
            case 7: {
                this.handleReceiveEnd((ReceiveMessageEndMessage)message);
                break;
            }
            case 4: {
                this.handleCreateLeaseSet((CreateLeaseSetMessage)message);
                break;
            }
            case 3: {
                this.handleDestroySession((DestroySessionMessage)message);
                break;
            }
            case 34: {
                this.handleDestLookup((DestLookupMessage)message);
                break;
            }
            case 38: {
                this.handleHostLookup((HostLookupMessage)message);
                break;
            }
            case 2: {
                this.handleReconfigureSession((ReconfigureSessionMessage)message);
                break;
            }
            case 8: {
                this.handleGetBWLimits((GetBandwidthLimitsMessage)message);
                break;
            }
            default: {
                if (!this._log.shouldLog(40)) break;
                this._log.error("Unhandled I2CP type received: " + message.getType());
            }
        }
    }

    public void readError(I2CPMessageReader reader, Exception error) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Error occurred", (Throwable)error);
        }
        this._runner.disconnectClient(error.toString());
        this._runner.stopRunning();
    }

    public void disconnected(I2CPMessageReader reader) {
        if (this._runner.isDead()) {
            return;
        }
        this._runner.disconnected();
    }

    private void handleGetDate(GetDateMessage message) {
        block4: {
            Properties props;
            String clientVersion = message.getVersion();
            if (clientVersion != null) {
                this._runner.setClientVersion(clientVersion);
            }
            if (!this.checkAuth(props = message.getOptions())) {
                return;
            }
            try {
                this._runner.doSend((I2CPMessage)new SetDateMessage(clientVersion != null ? "0.9.13" : null));
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(40)) break block4;
                this._log.error("Error writing out the setDate message", (Throwable)ime);
            }
        }
    }

    private void handleSetDate(SetDateMessage message) {
    }

    private void handleCreateSession(CreateSessionMessage message) {
        SessionConfig in = message.getSessionConfig();
        if (in.verifySignature()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Signature verified correctly on create session message");
            }
        } else {
            if (this._log.shouldLog(40)) {
                this._log.error("Signature verification *FAILED* on a create session message.  Hijack attempt?");
            }
            this._runner.disconnectClient("Invalid signature on CreateSessionMessage");
            return;
        }
        Properties inProps = in.getOptions();
        if (!this.checkAuth(inProps)) {
            return;
        }
        SessionId id = this._runner.getSessionId();
        if (id != null) {
            this._runner.disconnectClient("Already have session " + id);
            return;
        }
        SessionConfig cfg = new SessionConfig(in.getDestination());
        cfg.setSignature(in.getSignature());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)in.getOptions());
        cfg.setOptions(props);
        int status = this._runner.sessionEstablished(cfg);
        if (status != 1) {
            if (this._log.shouldLog(40)) {
                this._log.error("Session establish failed: code = " + status);
            }
            String msg = status == 3 ? "duplicate destination" : (status == 4 ? "session limit exceeded" : "unknown error");
            this._runner.disconnectClient(msg);
            return;
        }
        this.sendStatusMessage(status);
        if (this._log.shouldLog(20)) {
            this._log.info("Session " + this._runner.getSessionId() + " established for " + this._runner.getDestHash());
        }
        this.startCreateSessionJob();
    }

    private boolean checkAuth(Properties props) {
        if (this._authorized) {
            return true;
        }
        if (this._enforceAuth && this._context.getBooleanProperty(PROP_AUTH)) {
            String user = null;
            String pw = null;
            if (props != null) {
                user = props.getProperty("i2cp.username");
                pw = props.getProperty("i2cp.password");
            }
            if (user == null || user.length() == 0 || pw == null || pw.length() == 0) {
                this._log.error("I2CP auth failed");
                this._runner.disconnectClient("Authorization required, specify i2cp.username and i2cp.password in options");
                this._authorized = false;
                return false;
            }
            PasswordManager mgr = new PasswordManager((I2PAppContext)this._context);
            if (!mgr.checkHash(PROP_AUTH, user, pw)) {
                this._log.error("I2CP auth failed user: " + user);
                this._runner.disconnectClient("Authorization failed, user = " + user);
                this._authorized = false;
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("I2CP auth success user: " + user);
            }
        }
        this._authorized = true;
        return true;
    }

    protected void startCreateSessionJob() {
        this._context.jobQueue().addJob(new CreateSessionJob(this._context, this._runner));
    }

    private void handleSendMessage(SendMessageMessage message) {
        if (this._log.shouldLog(10)) {
            this._log.debug("handleSendMessage called");
        }
        long beforeDistribute = this._context.clock().now();
        MessageId id = this._runner.distributeMessage(message);
        long timeToDistribute = this._context.clock().now() - beforeDistribute;
        this._runner.ackSendMessage(id, message.getNonce());
        this._context.statManager().addRateData("client.distributeTime", timeToDistribute);
        if (timeToDistribute > 50L && this._log.shouldLog(20)) {
            this._log.info("Took too long to distribute the message (which holds up the ack): " + timeToDistribute);
        }
    }

    private void handleReceiveBegin(ReceiveMessageBeginMessage message) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling recieve begin: id = " + message.getMessageId());
        }
        MessagePayloadMessage msg = new MessagePayloadMessage();
        msg.setMessageId(message.getMessageId());
        msg.setSessionId((long)this._runner.getSessionId().getSessionId());
        Payload payload = this._runner.getPayload(new MessageId(message.getMessageId()));
        if (payload == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Payload for message id [" + message.getMessageId() + "] is null!  Dropped or Unknown message id");
            }
            return;
        }
        msg.setPayload(payload);
        try {
            this._runner.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException ime) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error delivering the payload", (Throwable)ime);
            }
            this._runner.removePayload(new MessageId(message.getMessageId()));
        }
    }

    private void handleReceiveEnd(ReceiveMessageEndMessage message) {
        this._runner.removePayload(new MessageId(message.getMessageId()));
    }

    private void handleDestroySession(DestroySessionMessage message) {
        if (this._log.shouldLog(20)) {
            this._log.info("Destroying client session " + this._runner.getSessionId());
        }
        this._runner.stopRunning();
    }

    protected void handleCreateLeaseSet(CreateLeaseSetMessage message) {
        if (message.getLeaseSet() == null || message.getPrivateKey() == null || message.getSigningPrivateKey() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null lease set granted: " + message);
            }
            this._runner.disconnectClient("Invalid CreateLeaseSetMessage");
            return;
        }
        this._context.keyManager().registerKeys(message.getLeaseSet().getDestination(), message.getSigningPrivateKey(), message.getPrivateKey());
        try {
            this._context.netDb().publish(message.getLeaseSet());
        }
        catch (IllegalArgumentException iae) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid leaseset from client", (Throwable)iae);
            }
            this._runner.disconnectClient("Invalid leaseset: " + iae);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("New lease set granted for destination " + this._runner.getDestHash());
        }
        this._runner.leaseSetCreated(message.getLeaseSet());
    }

    protected void handleDestLookup(DestLookupMessage message) {
        this._context.jobQueue().addJob(new LookupDestJob(this._context, this._runner, message.getHash(), this._runner.getDestHash()));
    }

    protected void handleHostLookup(HostLookupMessage message) {
        this._context.jobQueue().addJob(new LookupDestJob(this._context, this._runner, message.getReqID(), message.getTimeout(), message.getSessionId(), message.getHash(), message.getHostname(), this._runner.getDestHash()));
    }

    private void handleReconfigureSession(ReconfigureSessionMessage message) {
        if (this._log.shouldLog(20)) {
            this._log.info("Updating options - old: " + this._runner.getConfig() + " new: " + message.getSessionConfig());
        }
        if (!message.getSessionConfig().getDestination().equals((Object)this._runner.getConfig().getDestination())) {
            this._log.error("Dest mismatch");
            this.sendStatusMessage(3);
            this._runner.stopRunning();
            return;
        }
        this._runner.getConfig().getOptions().putAll((Map<?, ?>)message.getSessionConfig().getOptions());
        Hash dest = this._runner.getDestHash();
        ClientTunnelSettings settings = new ClientTunnelSettings(dest);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this._runner.getConfig().getOptions());
        settings.readFromProperties(props);
        this._context.tunnelManager().setInboundSettings(dest, settings.getInboundSettings());
        this._context.tunnelManager().setOutboundSettings(dest, settings.getOutboundSettings());
        this.sendStatusMessage(2);
    }

    private void sendStatusMessage(int status) {
        block3: {
            SessionStatusMessage msg = new SessionStatusMessage();
            SessionId id = this._runner.getSessionId();
            if (id == null) {
                id = ClientManager.UNKNOWN_SESSION_ID;
            }
            msg.setSessionId(id);
            msg.setStatus(status);
            try {
                this._runner.doSend((I2CPMessage)msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Error writing out the session status message", (Throwable)ime);
            }
        }
    }

    protected void handleGetBWLimits(GetBandwidthLimitsMessage message) {
        block3: {
            if (this._log.shouldLog(20)) {
                this._log.info("Got BW Limits request");
            }
            int in = this._context.bandwidthLimiter().getInboundKBytesPerSecond() * 4 / 7;
            int out = this._context.bandwidthLimiter().getOutboundKBytesPerSecond() * 4 / 7;
            BandwidthLimitsMessage msg = new BandwidthLimitsMessage(in, out);
            try {
                this._runner.doSend((I2CPMessage)msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Error writing bw limits msg", (Throwable)ime);
            }
        }
    }
}

