/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TransientSessionKeyManager;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.DisconnectMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientManager;
import net.i2p.router.client.ClientMessageEventListener;
import net.i2p.router.client.ClientWriterRunner;
import net.i2p.router.client.LeaseRequestState;
import net.i2p.router.client.MessageReceivedJob;
import net.i2p.router.client.ReportAbuseJob;
import net.i2p.router.client.RequestLeaseSetJob;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class ClientConnectionRunner {
    protected final Log _log;
    protected final RouterContext _context;
    protected final ClientManager _manager;
    private final Socket _socket;
    private OutputStream _out;
    private SessionId _sessionId;
    private SessionConfig _config;
    private String _clientVersion;
    private final Map<MessageId, Payload> _messages;
    private LeaseRequestState _leaseRequest;
    private int _consecutiveLeaseRequestFails;
    private LeaseSet _currentLeaseSet;
    private final Set<MessageId> _acceptedPending;
    protected I2CPMessageReader _reader;
    private SessionKeyManager _sessionKeyManager;
    private final List<MessageId> _alreadyProcessed;
    private ClientWriterRunner _writer;
    private Hash _destHashCache;
    private volatile boolean _dead;
    private boolean _dontSendMSM;
    private boolean _dontSendMSMOnReceive;
    private final AtomicInteger _messageId;
    private static final int MAX_MESSAGE_ID = 0x4000000;
    private static final int MAX_LEASE_FAILS = 5;
    private static final int BUF_SIZE = 32768;
    private static final String PROP_TAGS = "crypto.tagsToSend";
    private static final String PROP_THRESH = "crypto.lowTagThreshold";
    private static final AtomicInteger __id = new AtomicInteger();
    private static final long REQUEUE_DELAY = 500L;
    private static final int MAX_REQUEUE = 60;

    public ClientConnectionRunner(RouterContext context, ClientManager manager, Socket socket) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientConnectionRunner.class);
        this._manager = manager;
        this._socket = socket;
        this._messages = new ConcurrentHashMap<MessageId, Payload>();
        this._alreadyProcessed = new ArrayList<MessageId>();
        this._acceptedPending = new ConcurrentHashSet();
        this._messageId = new AtomicInteger(this._context.random().nextInt());
    }

    public synchronized void startRunning() throws IOException {
        if (this._dead || this._reader != null) {
            throw new IllegalStateException();
        }
        this._reader = new I2CPMessageReader((InputStream)new BufferedInputStream(this._socket.getInputStream(), 32768), this.createListener());
        this._writer = new ClientWriterRunner(this._context, this);
        I2PThread t = new I2PThread((Runnable)this._writer);
        t.setName("I2CP Writer " + __id.incrementAndGet());
        t.setDaemon(true);
        t.start();
        this._out = new BufferedOutputStream(this._socket.getOutputStream());
        this._reader.startReading();
    }

    protected I2CPMessageReader.I2CPMessageEventListener createListener() {
        return new ClientMessageEventListener(this._context, this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopRunning() {
        if (this._dead) {
            return;
        }
        if (this._context.router().isAlive() && this._log.shouldLog(30)) {
            this._log.warn("Stop the I2CP connection!  current leaseSet: " + this._currentLeaseSet, (Throwable)new Exception("Stop client connection"));
        }
        this._dead = true;
        if (this._reader != null) {
            this._reader.stopReading();
        }
        if (this._writer != null) {
            this._writer.stopWriting();
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._messages.clear();
        this._acceptedPending.clear();
        if (this._sessionKeyManager != null) {
            this._sessionKeyManager.shutdown();
        }
        this._manager.unregisterConnection(this);
        if (this._currentLeaseSet != null) {
            this._context.netDb().unpublish(this._currentLeaseSet);
        }
        this._leaseRequest = null;
        List<MessageId> list = this._alreadyProcessed;
        synchronized (list) {
            this._alreadyProcessed.clear();
        }
    }

    public SessionConfig getConfig() {
        return this._config;
    }

    public void setClientVersion(String version) {
        this._clientVersion = version;
    }

    public String getClientVersion() {
        return this._clientVersion;
    }

    public SessionKeyManager getSessionKeyManager() {
        return this._sessionKeyManager;
    }

    public LeaseSet getLeaseSet() {
        return this._currentLeaseSet;
    }

    void setLeaseSet(LeaseSet ls) {
        this._currentLeaseSet = ls;
    }

    public Hash getDestHash() {
        return this._destHashCache;
    }

    SessionId getSessionId() {
        return this._sessionId;
    }

    void setSessionId(SessionId id) {
        if (this._sessionId != null) {
            throw new IllegalStateException();
        }
        this._sessionId = id;
    }

    LeaseRequestState getLeaseRequest() {
        return this._leaseRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failLeaseRequest(LeaseRequestState req) {
        boolean disconnect = false;
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            if (this._leaseRequest == req) {
                this._leaseRequest = null;
                disconnect = ++this._consecutiveLeaseRequestFails > 5;
            }
        }
        if (disconnect) {
            this.disconnectClient("Too many leaseset request fails");
        }
    }

    boolean isDead() {
        return this._dead;
    }

    Payload getPayload(MessageId id) {
        return this._messages.get(id);
    }

    void setPayload(MessageId id, Payload payload) {
        if (!this._dontSendMSMOnReceive) {
            this._messages.put(id, payload);
        }
    }

    void removePayload(MessageId id) {
        this._messages.remove(id);
    }

    public int sessionEstablished(SessionConfig config) {
        this._destHashCache = config.getDestination().calculateHash();
        if (this._log.shouldLog(10)) {
            this._log.debug("SessionEstablished called for destination " + this._destHashCache.toBase64());
        }
        this._config = config;
        Properties opts = config.getOptions();
        if (opts != null) {
            this._dontSendMSM = "none".equals(opts.getProperty("i2cp.messageReliability", "").toLowerCase(Locale.US));
            this._dontSendMSMOnReceive = Boolean.parseBoolean(opts.getProperty("i2cp.fastReceive"));
        }
        if (this._sessionKeyManager == null) {
            int tags = 40;
            int thresh = 30;
            if (opts != null) {
                String pthresh;
                String ptags = opts.getProperty(PROP_TAGS);
                if (ptags != null) {
                    try {
                        tags = Integer.parseInt(ptags);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if ((pthresh = opts.getProperty(PROP_THRESH)) != null) {
                    try {
                        thresh = Integer.parseInt(pthresh);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            this._sessionKeyManager = new TransientSessionKeyManager((I2PAppContext)this._context, tags, thresh);
        } else {
            this._log.error("SessionEstablished called for twice for destination " + this._destHashCache.toBase64().substring(0, 4));
        }
        return this._manager.destinationEstablished(this);
    }

    void updateMessageDeliveryStatus(MessageId id, int status) {
        if (this._dead || this._dontSendMSM) {
            return;
        }
        this._context.jobQueue().addJob(new MessageDeliveryStatusUpdate(id, status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaseSetCreated(LeaseSet ls) {
        LeaseRequestState state = null;
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            state = this._leaseRequest;
            if (state == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("LeaseRequest is null and we've received a new lease?! perhaps this is odd... " + ls);
                }
                return;
            }
            state.setIsSuccessful(true);
            this._currentLeaseSet = ls;
            if (this._log.shouldLog(10)) {
                this._log.debug("LeaseSet created fully: " + state + " / " + ls);
            }
            this._leaseRequest = null;
            this._consecutiveLeaseRequestFails = 0;
        }
        if (state != null && state.getOnGranted() != null) {
            this._context.jobQueue().addJob(state.getOnGranted());
        }
    }

    void disconnectClient(String reason) {
        this.disconnectClient(reason, 40);
    }

    void disconnectClient(String reason, int logLevel) {
        block6: {
            if (this._log.shouldLog(logLevel)) {
                this._log.log(logLevel, "Disconnecting the client - " + reason + " config: " + this._config);
            }
            DisconnectMessage msg = new DisconnectMessage();
            if (reason.length() > 255) {
                reason = reason.substring(0, 255);
            }
            msg.setReason(reason);
            try {
                this.doSend((I2CPMessage)msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block6;
                this._log.warn("Error writing out the disconnect message", (Throwable)ime);
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.stopRunning();
    }

    MessageId distributeMessage(SendMessageMessage message) {
        SessionConfig cfg;
        Payload payload = message.getPayload();
        Destination dest = message.getDestination();
        MessageId id = new MessageId();
        id.setMessageId((long)this.getNextMessageId());
        long expiration = 0L;
        int flags = 0;
        if (message.getType() == 36) {
            SendMessageExpiresMessage msg = (SendMessageExpiresMessage)message;
            expiration = msg.getExpirationTime();
            flags = msg.getFlags();
        }
        if (message.getNonce() != 0L && !this._dontSendMSM) {
            this._acceptedPending.add(id);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("** Receiving message " + id.getMessageId() + " with payload of size " + payload.getSize() + " for session " + this._sessionId.getSessionId());
        }
        if ((cfg = this._config) != null) {
            this._manager.distributeMessage(cfg.getDestination(), dest, payload, id, expiration, flags);
        }
        return id;
    }

    void ackSendMessage(MessageId id, long nonce) {
        block5: {
            if (this._dontSendMSM || nonce == 0L) {
                return;
            }
            SessionId sid = this._sessionId;
            if (sid == null) {
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Acking message send [accepted]" + id + " / " + nonce + " for sessionId " + sid);
            }
            MessageStatusMessage status = new MessageStatusMessage();
            status.setMessageId(id.getMessageId());
            status.setSessionId((long)sid.getSessionId());
            status.setSize(0L);
            status.setNonce(nonce);
            status.setStatus(1);
            try {
                this.doSend((I2CPMessage)status);
                this._acceptedPending.remove(id);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block5;
                this._log.warn("Error writing out the message status message", (Throwable)ime);
            }
        }
    }

    void receiveMessage(Destination toDest, Destination fromDest, Payload payload) {
        if (this._dead) {
            return;
        }
        MessageReceivedJob j = new MessageReceivedJob(this._context, this, toDest, fromDest, payload, this._dontSendMSMOnReceive);
        j.runJob();
    }

    public void reportAbuse(String reason, int severity) {
        if (this._dead) {
            return;
        }
        this._context.jobQueue().addJob(new ReportAbuseJob(this._context, this, reason, severity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestLeaseSet(LeaseSet set, long expirationTime, Job onCreateJob, Job onFailedJob) {
        if (this._dead) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Requesting leaseSet from a dead client: " + set);
            }
            if (onFailedJob != null) {
                this._context.jobQueue().addJob(onFailedJob);
            }
            return;
        }
        int leases = set.getLeaseCount();
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            if (this._currentLeaseSet != null && this._currentLeaseSet.getLeaseCount() == leases) {
                for (int i = 0; i < leases && this._currentLeaseSet.getLease(i).getTunnelId().equals((Object)set.getLease(i).getTunnelId()) && this._currentLeaseSet.getLease(i).getGateway().equals((Object)set.getLease(i).getGateway()); ++i) {
                    if (i != leases - 1) continue;
                    if (this._log.shouldLog(20)) {
                        this._log.info("Requested leaseSet hasn't changed");
                    }
                    if (onCreateJob != null) {
                        this._context.jobQueue().addJob(onCreateJob);
                    }
                    return;
                }
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Current leaseSet " + this._currentLeaseSet + "\nNew leaseSet " + set);
        }
        LeaseRequestState state = null;
        ClientConnectionRunner clientConnectionRunner2 = this;
        synchronized (clientConnectionRunner2) {
            state = this._leaseRequest;
            if (state != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Already requesting " + state);
                }
                LeaseSet requested = state.getRequested();
                LeaseSet granted = state.getGranted();
                long ours = set.getEarliestLeaseDate();
                if (!(requested != null && requested.getEarliestLeaseDate() > ours || granted != null && granted.getEarliestLeaseDate() > ours)) {
                    this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new Rerequest(set, expirationTime, onCreateJob, onFailedJob), 3000L);
                }
                return;
            }
            this._leaseRequest = state = new LeaseRequestState(onCreateJob, onFailedJob, this._context.clock().now() + expirationTime, set);
            if (this._log.shouldLog(10)) {
                this._log.debug("New request: " + state);
            }
        }
        this._context.jobQueue().addJob(new RequestLeaseSetJob(this._context, this, state));
    }

    void disconnected() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Disconnected", (Throwable)new Exception("Disconnected?"));
        }
        this.stopRunning();
    }

    boolean getIsDead() {
        return this._dead;
    }

    void writeMessage(I2CPMessage msg) {
        try {
            msg.writeMessage(this._out);
            this._out.flush();
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error sending I2CP message to client", (Throwable)ime);
            this.stopRunning();
        }
        catch (EOFException eofe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error sending I2CP message - client went away", (Throwable)eofe);
            }
            this.stopRunning();
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("IO Error sending I2CP message to client", (Throwable)ioe);
            }
            this.stopRunning();
        }
        catch (Throwable t) {
            this._log.log(50, "Unhandled exception sending I2CP message to client", t);
            this.stopRunning();
        }
    }

    void doSend(I2CPMessage msg) throws I2CPMessageException {
        if (this._out == null) {
            throw new I2CPMessageException("Output stream is not initialized");
        }
        if (msg == null) {
            throw new I2CPMessageException("Null message?!");
        }
        this._writer.addMessage(msg);
    }

    public int getNextMessageId() {
        return this._messageId.incrementAndGet() & 0x3FFFFFF;
    }

    private boolean alreadyAccepted(MessageId id) {
        if (this._dead) {
            return false;
        }
        return !this._acceptedPending.contains(id);
    }

    private class MessageDeliveryStatusUpdate
    extends JobImpl {
        private final MessageId _messageId;
        private final int _status;
        private long _lastTried;
        private int _requeueCount;

        public MessageDeliveryStatusUpdate(MessageId id, int status) {
            super(ClientConnectionRunner.this._context);
            this._messageId = id;
            this._status = status;
        }

        public String getName() {
            return "Update Delivery Status";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            block19: {
                if (ClientConnectionRunner.this._dead) {
                    return;
                }
                MessageStatusMessage msg = new MessageStatusMessage();
                msg.setMessageId(this._messageId.getMessageId());
                msg.setSessionId((long)ClientConnectionRunner.this._sessionId.getSessionId());
                msg.setNonce(2L);
                msg.setSize(0L);
                msg.setStatus(this._status);
                if (!ClientConnectionRunner.this.alreadyAccepted(this._messageId)) {
                    if (this._requeueCount++ > 60) {
                        ClientConnectionRunner.this._log.error("Abandon update for message " + this._messageId + " to " + MessageStatusMessage.getStatusString((int)msg.getStatus()) + " for session " + ClientConnectionRunner.this._sessionId.getSessionId());
                    } else {
                        if (ClientConnectionRunner.this._log.shouldLog(30)) {
                            ClientConnectionRunner.this._log.warn("Almost send an update for message " + this._messageId + " to " + MessageStatusMessage.getStatusString((int)msg.getStatus()) + " for session " + ClientConnectionRunner.this._sessionId.getSessionId() + " before they knew the messageId!  delaying .5s");
                        }
                        this._lastTried = ClientConnectionRunner.this._context.clock().now();
                        this.requeue(500L);
                    }
                    return;
                }
                boolean alreadyProcessed = false;
                long beforeLock = ClientConnectionRunner.this._context.clock().now();
                long inLock = 0L;
                List list = ClientConnectionRunner.this._alreadyProcessed;
                synchronized (list) {
                    inLock = ClientConnectionRunner.this._context.clock().now();
                    if (ClientConnectionRunner.this._alreadyProcessed.contains(this._messageId)) {
                        ClientConnectionRunner.this._log.warn("Status already updated");
                        alreadyProcessed = true;
                    } else {
                        ClientConnectionRunner.this._alreadyProcessed.add(this._messageId);
                        while (ClientConnectionRunner.this._alreadyProcessed.size() > 10) {
                            ClientConnectionRunner.this._alreadyProcessed.remove(0);
                        }
                    }
                }
                long afterLock = ClientConnectionRunner.this._context.clock().now();
                if (afterLock - beforeLock > 50L) {
                    ClientConnectionRunner.this._log.warn("MessageDeliveryStatusUpdate.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
                }
                if (alreadyProcessed) {
                    return;
                }
                if (this._lastTried > 0L) {
                    if (ClientConnectionRunner.this._log.shouldLog(10)) {
                        ClientConnectionRunner.this._log.info("Updating message status for message " + this._messageId + " to " + MessageStatusMessage.getStatusString((int)msg.getStatus()) + " for session " + ClientConnectionRunner.this._sessionId.getSessionId() + " (with nonce=2), retrying after " + (ClientConnectionRunner.this._context.clock().now() - this._lastTried));
                    }
                } else if (ClientConnectionRunner.this._log.shouldLog(10)) {
                    ClientConnectionRunner.this._log.debug("Updating message status for message " + this._messageId + " to " + MessageStatusMessage.getStatusString((int)msg.getStatus()) + " for session " + ClientConnectionRunner.this._sessionId.getSessionId() + " (with nonce=2)");
                }
                try {
                    ClientConnectionRunner.this.doSend((I2CPMessage)msg);
                }
                catch (I2CPMessageException ime) {
                    if (!ClientConnectionRunner.this._log.shouldLog(30)) break block19;
                    ClientConnectionRunner.this._log.warn("Error updating the status for message ID " + this._messageId, (Throwable)ime);
                }
            }
        }
    }

    private class Rerequest
    implements SimpleTimer.TimedEvent {
        private final LeaseSet _ls;
        private final long _expirationTime;
        private final Job _onCreate;
        private final Job _onFailed;

        public Rerequest(LeaseSet ls, long expirationTime, Job onCreate, Job onFailed) {
            this._ls = ls;
            this._expirationTime = expirationTime;
            this._onCreate = onCreate;
            this._onFailed = onFailed;
        }

        public void timeReached() {
            ClientConnectionRunner.this.requestLeaseSet(this._ls, this._expirationTime, this._onCreate, this._onFailed);
        }
    }
}

