/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.concurrent.atomic.AtomicLong;
import net.i2p.router.Job;
import net.i2p.router.JobTiming;
import net.i2p.router.RouterContext;

public abstract class JobImpl
implements Job {
    private final RouterContext _context;
    private final JobTiming _timing;
    private static final AtomicLong _idSrc = new AtomicLong();
    private final long _id;
    private volatile long _madeReadyOn;

    public JobImpl(RouterContext context) {
        this._context = context;
        this._timing = new JobTiming(context);
        this._id = _idSrc.incrementAndGet();
    }

    public long getJobId() {
        return this._id;
    }

    public JobTiming getTiming() {
        return this._timing;
    }

    public final RouterContext getContext() {
        return this._context;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append(this.getClass().getSimpleName());
        buf.append(": Job ").append(this._id).append(": ").append(this.getName());
        return buf.toString();
    }

    void addedToQueue() {
    }

    public Exception getAddedBy() {
        return null;
    }

    public long getMadeReadyOn() {
        return this._madeReadyOn;
    }

    public void madeReady() {
        this._madeReadyOn = this._context.clock().now();
    }

    public void dropped() {
    }

    protected void requeue(long delayMs) {
        this.getTiming().setStartAfter(this._context.clock().now() + delayMs);
        this._context.jobQueue().addJob(this);
    }
}

