/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessageException;

public class DatabaseStoreMessage
extends FastI2NPMessageImpl {
    public static final int MESSAGE_TYPE = 1;
    private Hash _key;
    private DatabaseEntry _dbEntry;
    private byte[] _byteCache;
    private long _replyToken;
    private TunnelId _replyTunnel;
    private Hash _replyGateway;

    public DatabaseStoreMessage(I2PAppContext context) {
        super(context);
    }

    public Hash getKey() {
        if (this._key != null) {
            return this._key;
        }
        if (this._dbEntry != null) {
            return this._dbEntry.getHash();
        }
        return null;
    }

    public DatabaseEntry getEntry() {
        return this._dbEntry;
    }

    public void setEntry(DatabaseEntry entry) {
        if (this._dbEntry != null) {
            throw new IllegalStateException();
        }
        this._dbEntry = entry;
    }

    public long getReplyToken() {
        return this._replyToken;
    }

    public void setReplyToken(long token) throws IllegalArgumentException {
        if (token > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Token too large: " + token + " (max=" + 0xFFFFFFFFL + ")");
        }
        if (token < 0L) {
            throw new IllegalArgumentException("Token too small: " + token);
        }
        this._replyToken = token;
    }

    public TunnelId getReplyTunnel() {
        return this._replyTunnel;
    }

    public void setReplyTunnel(TunnelId id) {
        this._replyTunnel = id;
    }

    public Hash getReplyGateway() {
        return this._replyGateway;
    }

    public void setReplyGateway(Hash peer) {
        this._replyGateway = peer;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 1) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._key = Hash.create((byte[])data, (int)curIndex);
        type = (int)DataHelper.fromLong((byte[])data, (int)(curIndex += 32), (int)1);
        this._replyToken = DataHelper.fromLong((byte[])data, (int)(++curIndex), (int)4);
        curIndex += 4;
        if (this._replyToken > 0L) {
            long tunnel = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
            if (tunnel > 0L) {
                this._replyTunnel = new TunnelId(tunnel);
            }
            this._replyGateway = Hash.create((byte[])data, (int)(curIndex += 4));
            curIndex += 32;
        } else {
            this._replyTunnel = null;
            this._replyGateway = null;
        }
        if (type == 1) {
            this._dbEntry = new LeaseSet();
            try {
                this._dbEntry.readBytes((InputStream)new ByteArrayInputStream(data, curIndex, data.length - curIndex));
            }
            catch (DataFormatException dfe) {
                throw new I2NPMessageException("Error reading the leaseSet", dfe);
            }
            catch (IOException ioe) {
                throw new I2NPMessageException("Error reading the leaseSet", ioe);
            }
        } else if (type == 0) {
            this._dbEntry = new RouterInfo();
            int compressedSize = (int)DataHelper.fromLong((byte[])data, (int)curIndex, (int)2);
            if (compressedSize <= 0 || (curIndex += 2) + compressedSize > data.length || curIndex + compressedSize > dataSize + offset) {
                throw new I2NPMessageException("Compressed RI length: " + compressedSize + " but remaining bytes: " + Math.min(data.length - curIndex, dataSize + offset - curIndex));
            }
            try {
                byte[] decompressed = DataHelper.decompress((byte[])data, (int)curIndex, (int)compressedSize);
                this._dbEntry.readBytes((InputStream)new ByteArrayInputStream(decompressed));
            }
            catch (DataFormatException dfe) {
                throw new I2NPMessageException("Error reading the routerInfo", dfe);
            }
            catch (IOException ioe) {
                throw new I2NPMessageException("Corrupt compressed routerInfo size = " + compressedSize, ioe);
            }
        } else {
            throw new I2NPMessageException("Invalid type of key read from the structure - " + type);
        }
    }

    protected int calculateWrittenLength() {
        int type;
        if (this._dbEntry == null) {
            throw new IllegalStateException("Missing entry");
        }
        int len = 37;
        if (this._replyToken > 0L) {
            len += 36;
        }
        if ((type = this._dbEntry.getType()) == 1) {
            if (this._byteCache == null) {
                this._byteCache = this._dbEntry.toByteArray();
            }
        } else if (type == 0) {
            if (this._byteCache == null) {
                byte[] uncompressed = this._dbEntry.toByteArray();
                this._byteCache = DataHelper.compress((byte[])uncompressed);
            }
            len += 2;
        } else {
            throw new IllegalStateException("Invalid key type " + type);
        }
        return len += this._byteCache.length;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._dbEntry == null) {
            throw new I2NPMessageException("Missing entry");
        }
        int type = this._dbEntry.getType();
        if (type != 1 && type != 0) {
            throw new I2NPMessageException("Invalid key type " + type);
        }
        System.arraycopy(this.getKey().getData(), 0, out, curIndex, 32);
        curIndex += 32;
        out[curIndex++] = (byte)type;
        byte[] tok = DataHelper.toLong((int)4, (long)this._replyToken);
        System.arraycopy(tok, 0, out, curIndex, 4);
        curIndex += 4;
        if (this._replyToken > 0L) {
            long replyTunnel = 0L;
            if (this._replyTunnel != null) {
                replyTunnel = this._replyTunnel.getTunnelId();
            }
            byte[] id = DataHelper.toLong((int)4, (long)replyTunnel);
            System.arraycopy(id, 0, out, curIndex, 4);
            System.arraycopy(this._replyGateway.getData(), 0, out, curIndex += 4, 32);
            curIndex += 32;
        }
        if (type == 0) {
            byte[] len = DataHelper.toLong((int)2, (long)this._byteCache.length);
            out[curIndex++] = len[0];
            out[curIndex++] = len[1];
        }
        System.arraycopy(this._byteCache, 0, out, curIndex, this._byteCache.length);
        return curIndex += this._byteCache.length;
    }

    public int getType() {
        return 1;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getKey()) + DataHelper.hashCode((Object)this._dbEntry) + (int)this._replyToken + DataHelper.hashCode((Object)this._replyTunnel) + DataHelper.hashCode((Object)this._replyGateway);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseStoreMessage) {
            DatabaseStoreMessage msg = (DatabaseStoreMessage)object;
            return DataHelper.eq((Object)this.getKey(), (Object)msg.getKey()) && DataHelper.eq((Object)this._dbEntry, (Object)msg.getEntry()) && this._replyToken == msg._replyToken && DataHelper.eq((Object)this._replyTunnel, (Object)msg._replyTunnel) && DataHelper.eq((Object)this._replyGateway, (Object)msg._replyGateway);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DatabaseStoreMessage: ");
        buf.append("\n\tExpiration: ").append(new Date(this._expiration));
        buf.append("\n\tUnique ID: ").append(this._uniqueId);
        if (this._replyToken != 0L) {
            buf.append("\n\tReply token: ").append(this._replyToken);
            buf.append("\n\tReply tunnel: ").append(this._replyTunnel);
            buf.append("\n\tReply gateway: ").append(this._replyGateway);
        }
        buf.append("\n\tKey: ").append(this.getKey());
        buf.append("\n\tEntry: ").append(this._dbEntry);
        buf.append(']');
        return buf.toString();
    }
}

