/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.dht;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.dht.InfoHash;
import org.klomp.snark.dht.Peer;
import org.klomp.snark.dht.Peers;
import org.klomp.snark.dht.Torrents;

class DHTTracker {
    private final I2PAppContext _context;
    private final Torrents _torrents;
    private long _expireTime;
    private final Log _log;
    private volatile boolean _isRunning;
    private int _peerCount;
    private int _torrentCount;
    private static final long CLEAN_TIME = 199000L;
    private static final long MAX_EXPIRE_TIME = 2700000L;
    private static final long MIN_EXPIRE_TIME = 900000L;
    private static final long DELTA_EXPIRE_TIME = 180000L;
    private static final int MAX_PEERS = 2000;
    private static final int MAX_PEERS_PER_TORRENT = 150;
    private static final int ABSOLUTE_MAX_PER_TORRENT = 300;
    private static final int MAX_TORRENTS = 400;

    DHTTracker(I2PAppContext ctx) {
        this._context = ctx;
        this._torrents = new Torrents();
        this._expireTime = 2700000L;
        this._log = this._context.logManager().getLog(DHTTracker.class);
    }

    public void start() {
        this._isRunning = true;
        new Cleaner();
    }

    void stop() {
        this._torrents.clear();
        this._isRunning = false;
    }

    void announce(InfoHash ih, Hash hash) {
        Peers peers;
        if (this._log.shouldLog(10)) {
            this._log.debug("Announce " + hash + " for " + ih);
        }
        if ((peers = (Peers)this._torrents.get(ih)) == null) {
            if (this._torrents.size() >= 400) {
                return;
            }
            peers = new Peers();
            Peers peers2 = this._torrents.putIfAbsent(ih, peers);
            if (peers2 != null) {
                peers = peers2;
            }
        }
        if (peers.size() < 300) {
            Peer peer = new Peer(hash.getData());
            Peer peer2 = peers.putIfAbsent(peer, peer);
            if (peer2 != null) {
                peer = peer2;
            }
            peer.setLastSeen(this._context.clock().now());
        }
    }

    void unannounce(InfoHash ih, Hash hash) {
        Peers peers = (Peers)this._torrents.get(ih);
        if (peers == null) {
            return;
        }
        Peer peer = new Peer(hash.getData());
        peers.remove(peer);
    }

    List<Hash> getPeers(InfoHash ih, int max) {
        Peers peers = (Peers)this._torrents.get(ih);
        if (peers == null) {
            return Collections.emptyList();
        }
        int size = peers.size();
        List<Hash> rv = new ArrayList<Hash>(peers.values());
        if (max < size) {
            Collections.shuffle(rv, this._context.random());
            rv = rv.subList(0, max);
        }
        return rv;
    }

    public void renderStatusHTML(StringBuilder buf) {
        buf.append("DHT tracker: ").append(this._torrentCount).append(" torrents ").append(this._peerCount).append(" peers ").append(DataHelper.formatDuration(this._expireTime)).append(" expiration<br>");
    }

    private class Cleaner
    extends SimpleTimer2.TimedEvent {
        public Cleaner() {
            super(SimpleTimer2.getInstance(), 398000L);
        }

        @Override
        public void timeReached() {
            if (!DHTTracker.this._isRunning) {
                return;
            }
            long now = DHTTracker.this._context.clock().now();
            int torrentCount = 0;
            int peerCount = 0;
            boolean tooMany = false;
            Iterator iter = DHTTracker.this._torrents.values().iterator();
            while (iter.hasNext()) {
                Peers p = (Peers)iter.next();
                int recent = 0;
                Iterator iterp = p.values().iterator();
                while (iterp.hasNext()) {
                    Peer peer = (Peer)iterp.next();
                    if (peer.lastSeen() < now - DHTTracker.this._expireTime) {
                        iterp.remove();
                        continue;
                    }
                    ++recent;
                    ++peerCount;
                }
                if (recent > 150) {
                    iterp = p.values().iterator();
                    while (iterp.hasNext() && p.size() > 150) {
                        iterp.next();
                        iterp.remove();
                        --peerCount;
                    }
                    ++torrentCount;
                    tooMany = true;
                    continue;
                }
                if (recent <= 0) {
                    iter.remove();
                    continue;
                }
                ++torrentCount;
            }
            if (peerCount > 2000) {
                tooMany = true;
            }
            if (tooMany) {
                DHTTracker.this._expireTime = Math.max(DHTTracker.this._expireTime - 180000L, 900000L);
            } else {
                DHTTracker.this._expireTime = Math.min(DHTTracker.this._expireTime + 180000L, 2700000L);
            }
            if (DHTTracker.this._log.shouldLog(10)) {
                DHTTracker.this._log.debug("DHT tracker cleaner done, now with " + torrentCount + " torrents, " + peerCount + " peers, " + DataHelper.formatDuration(DHTTracker.this._expireTime) + " expiration");
            }
            DHTTracker.this._peerCount = peerCount;
            DHTTracker.this._torrentCount = torrentCount;
            this.schedule(tooMany ? 66333L : 199000L);
        }
    }
}

