/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;
import org.klomp.snark.CompleteListener;
import org.klomp.snark.ConnectionAcceptor;
import org.klomp.snark.CoordinatorListener;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerAcceptor;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerCoordinatorSet;
import org.klomp.snark.PeerID;
import org.klomp.snark.ShutdownListener;
import org.klomp.snark.Storage;
import org.klomp.snark.StorageListener;
import org.klomp.snark.TrackerClient;

public class Snark
implements StorageListener,
CoordinatorListener,
ShutdownListener {
    private static final int MIN_PORT = 6881;
    private static final int MAX_PORT = 6889;
    private static final String newline = System.getProperty("line.separator");
    String activity = "Not started";
    public static final String PROP_MAX_CONNECTIONS = "i2psnark.maxConnections";
    private String torrent;
    private MetaInfo meta;
    private Storage storage;
    private PeerCoordinator coordinator;
    private ConnectionAcceptor acceptor;
    private TrackerClient trackerclient;
    private String rootDataDir = ".";
    private final CompleteListener completeListener;
    private volatile boolean stopped;
    private volatile boolean starting;
    private byte[] id;
    private final byte[] infoHash;
    private String additionalTrackerURL;
    protected final I2PSnarkUtil _util;
    private final Log _log;
    private final PeerCoordinatorSet _peerCoordinatorSet;
    private volatile String trackerProblems;
    private volatile int trackerSeenPeers;
    private volatile boolean _autoStoppable;
    private long allocated = 0L;
    private boolean allChecked = false;
    private boolean checking = false;
    static final int MIN_TOTAL_UPLOADERS = 4;
    static final int MAX_TOTAL_UPLOADERS = 10;

    Snark(I2PSnarkUtil util, String torrent, String ip, int user_port, StorageListener slistener, CoordinatorListener clistener) {
        this(util, torrent, ip, user_port, slistener, clistener, null, null, null, true, ".");
    }

    public Snark(I2PAppContext ctx, Properties opts, String torrent, StorageListener slistener, boolean start, String rootDir) {
        this(new I2PSnarkUtil(ctx), torrent, null, -1, slistener, null, null, null, null, false, rootDir);
        String host = opts.getProperty("i2cp.hostname");
        int port = 0;
        String s = opts.getProperty("i2cp.port");
        if (s != null) {
            try {
                port = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this._util.setI2CPConfig(host, port, opts);
        s = opts.getProperty("i2psnark.upbw.max");
        if (s != null) {
            try {
                int v = Integer.parseInt(s);
                this._util.setMaxUpBW(v);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((s = opts.getProperty(PROP_MAX_CONNECTIONS)) != null) {
            try {
                int v = Integer.parseInt(s);
                this._util.setMaxConnections(v);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (start) {
            this.startTorrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark(I2PSnarkUtil util, String torrent, String ip, int user_port, StorageListener slistener, CoordinatorListener clistener, CompleteListener complistener, PeerCoordinatorSet peerCoordinatorSet, ConnectionAcceptor connectionAcceptor, boolean start, String rootDir) {
        if (slistener == null) {
            slistener = this;
        }
        this.completeListener = complistener;
        this._util = util;
        this._log = util.getContext().logManager().getLog(Snark.class);
        this._peerCoordinatorSet = peerCoordinatorSet;
        this.acceptor = connectionAcceptor;
        this.torrent = torrent;
        this.rootDataDir = rootDir;
        this.stopped = true;
        this.activity = "Network setup";
        this.id = Snark.generateID();
        if (this._log.shouldLog(20)) {
            this._log.info("My peer id: " + PeerID.idencode(this.id));
        }
        this.meta = null;
        File f = null;
        InputStream in = null;
        byte[] x_infoHash = null;
        try {
            f = new File(torrent);
            if (!f.exists()) {
                throw new IOException("not found");
            }
            in = new FileInputStream(f);
            this.meta = new MetaInfo(in);
            x_infoHash = this.meta.getInfoHash();
        }
        catch (IOException ioe) {
            if (f != null && f.exists()) {
                if (ip == null) {
                    this.fatal("'" + torrent + "' exists," + " but is not a valid torrent metainfo file." + System.getProperty("line.separator"), ioe);
                } else {
                    this.fatal("I2PSnark does not support creating and tracking a torrent at the moment");
                }
            } else {
                this.fatal("Cannot open '" + torrent + "'", ioe);
            }
        }
        catch (OutOfMemoryError oom) {
            this.fatal("ERROR - Out of memory, cannot create torrent " + torrent + ": " + oom.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.infoHash = x_infoHash;
        if (this._log.shouldLog(20)) {
            this._log.info(this.meta.toString());
        }
        if (this.storage == null) {
            try {
                this.activity = "Checking storage";
                this.storage = new Storage(this._util, this.meta, slistener);
                if (this.completeListener != null) {
                    this.storage.check(this.rootDataDir, this.completeListener.getSavedTorrentTime(this), this.completeListener.getSavedTorrentBitField(this));
                } else {
                    this.storage.check(this.rootDataDir);
                }
            }
            catch (IOException ioe) {
                try {
                    this.storage.close();
                }
                catch (IOException ioee) {
                    ioee.printStackTrace();
                }
                this.fatal("Could not check or create storage", ioe);
            }
        }
        if (start) {
            this.startTorrent();
        }
    }

    public Snark(I2PSnarkUtil util, String torrent, byte[] ih, String trackerURL, CompleteListener complistener, PeerCoordinatorSet peerCoordinatorSet, ConnectionAcceptor connectionAcceptor, boolean start, String rootDir) {
        this.completeListener = complistener;
        this._util = util;
        this._log = util.getContext().logManager().getLog(Snark.class);
        this._peerCoordinatorSet = peerCoordinatorSet;
        this.acceptor = connectionAcceptor;
        this.torrent = torrent;
        this.infoHash = ih;
        this.additionalTrackerURL = trackerURL;
        this.rootDataDir = rootDir;
        this.stopped = true;
        this.id = Snark.generateID();
        if (start) {
            this.startTorrent();
        }
    }

    private static byte[] generateID() {
        int i;
        int snark = 3;
        byte[] rv = new byte[20];
        RandomSource random = I2PAppContext.getGlobalContext().random();
        for (i = 0; i < 9; ++i) {
            rv[i] = 0;
        }
        rv[i++] = snark;
        rv[i++] = snark;
        rv[i++] = snark;
        while (i < 20) {
            rv[i++] = (byte)((Random)random).nextInt(256);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startTorrent() {
        this.starting = true;
        try {
            this.x_startTorrent();
        }
        finally {
            this.starting = false;
        }
    }

    private void x_startTorrent() {
        boolean ok = this._util.connect();
        if (!ok) {
            this.fatal("Unable to connect to I2P");
        }
        if (this.coordinator == null) {
            I2PServerSocket serversocket = this._util.getServerSocket();
            if (serversocket == null) {
                this.fatal("Unable to listen for I2P connections");
            } else {
                Destination d = serversocket.getManager().getSession().getMyDestination();
                if (this._log.shouldLog(20)) {
                    this._log.info("Listening on I2P destination " + d.toBase64() + " / " + d.calculateHash().toBase64());
                }
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Starting PeerCoordinator, ConnectionAcceptor, and TrackerClient");
            }
            this.activity = "Collecting pieces";
            this.coordinator = new PeerCoordinator(this._util, this.id, this.infoHash, this.meta, this.storage, this, this);
            if (this._peerCoordinatorSet != null) {
                this._peerCoordinatorSet.add(this.coordinator);
            } else {
                this.acceptor = new ConnectionAcceptor(this._util, new PeerAcceptor(this.coordinator));
            }
            this.trackerclient = new TrackerClient(this._util, this.meta, this.additionalTrackerURL, this.coordinator, this);
        }
        if (this._peerCoordinatorSet != null && this.acceptor != null) {
            this.acceptor.startAccepting();
        }
        this.stopped = false;
        if (this.coordinator.halted()) {
            this.coordinator.restart();
            if (this._peerCoordinatorSet != null) {
                this._peerCoordinatorSet.add(this.coordinator);
            }
        }
        if (!this.trackerclient.started()) {
            this.trackerclient.start();
        } else if (this.trackerclient.halted()) {
            if (this.storage != null) {
                try {
                    this.storage.reopen(this.rootDataDir);
                }
                catch (IOException ioe) {
                    try {
                        this.storage.close();
                    }
                    catch (IOException ioee) {
                        ioee.printStackTrace();
                    }
                    this.fatal("Could not reopen storage", ioe);
                }
            }
            this.trackerclient.start();
        } else if (this._log.shouldLog(20)) {
            this._log.info("NOT starting TrackerClient???");
        }
    }

    public void stopTorrent() {
        this.stopTorrent(false);
    }

    public synchronized void stopTorrent(boolean fast) {
        Storage st;
        PeerCoordinator pc;
        this.stopped = true;
        TrackerClient tc = this.trackerclient;
        if (tc != null) {
            tc.halt(fast);
        }
        if ((pc = this.coordinator) != null) {
            pc.halt();
        }
        if ((st = this.storage) != null) {
            boolean changed = this.storage.isChanged();
            try {
                this.storage.close();
            }
            catch (IOException ioe) {
                System.out.println("Error closing " + this.torrent);
                ioe.printStackTrace();
            }
            if (changed && this.completeListener != null) {
                this.completeListener.updateStatus(this);
            }
        }
        if (pc != null && this._peerCoordinatorSet != null) {
            this._peerCoordinatorSet.remove(pc);
        }
        if (this._peerCoordinatorSet == null) {
            this._util.disconnect();
        }
    }

    public String getName() {
        return this.torrent;
    }

    public String getBaseName() {
        if (this.storage != null) {
            return this.storage.getBaseName();
        }
        return this.torrent;
    }

    public byte[] getID() {
        return this.id;
    }

    public byte[] getInfoHash() {
        if (this.meta != null) {
            return this.meta.getInfoHash();
        }
        return this.infoHash;
    }

    public MetaInfo getMetaInfo() {
        return this.meta;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isStarting() {
        return this.starting && this.stopped;
    }

    public void setStarting() {
        this.starting = true;
    }

    public boolean isChecking() {
        return this.storage != null && this.storage.isChecking();
    }

    public boolean isAllocating() {
        return this.storage != null && this.storage.isAllocating();
    }

    public long getDownloadRate() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            return coord.getDownloadRate();
        }
        return 0L;
    }

    public long getUploadRate() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            return coord.getUploadRate();
        }
        return 0L;
    }

    public long getDownloaded() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            return coord.getDownloaded();
        }
        return 0L;
    }

    public long getUploaded() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            return coord.getUploaded();
        }
        return 0L;
    }

    public int getPeerCount() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            return coord.getPeerCount();
        }
        return 0;
    }

    public List<Peer> getPeerList() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            return coord.peerList();
        }
        return Collections.emptyList();
    }

    public String getTrackerProblems() {
        return this.trackerProblems;
    }

    public void setTrackerProblems(String p) {
        this.trackerProblems = p;
    }

    public int getTrackerSeenPeers() {
        return this.trackerSeenPeers;
    }

    public void setTrackerSeenPeers(int p) {
        this.trackerSeenPeers = p;
    }

    public void updatePiecePriorities() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            coord.updatePiecePriorities();
        }
    }

    public long getTotalLength() {
        if (this.meta != null) {
            return this.meta.getTotalLength();
        }
        return -1L;
    }

    public long getRemainingLength() {
        if (this.meta != null && this.storage != null) {
            long needed = this.storage.needed();
            long length0 = this.meta.getPieceLength(0);
            long remaining = needed * length0;
            int last = this.meta.getPieces() - 1;
            if (last != 0 && !this.storage.getBitField().get(last)) {
                remaining -= length0 - (long)this.meta.getPieceLength(last);
            }
            return remaining;
        }
        return -1L;
    }

    public long getNeededLength() {
        PeerCoordinator coord = this.coordinator;
        if (coord != null) {
            return coord.getNeededLength();
        }
        return -1L;
    }

    public long getNeeded() {
        if (this.storage != null) {
            return this.storage.needed();
        }
        if (this.meta != null) {
            return this.meta.getTotalLength();
        }
        return -1L;
    }

    public int getPieceLength(int p) {
        if (this.meta != null) {
            return this.meta.getPieceLength(p);
        }
        return 16384;
    }

    public int getPieces() {
        if (this.meta != null) {
            return this.meta.getPieces();
        }
        return -1;
    }

    public boolean restartAcceptor() {
        if (this.acceptor == null) {
            return false;
        }
        this.acceptor.restart();
        return true;
    }

    public String getTrackerURL() {
        return this.additionalTrackerURL;
    }

    public boolean isAutoStoppable() {
        return this._autoStoppable;
    }

    public void setAutoStoppable(boolean yes) {
        this._autoStoppable = yes;
    }

    private static Snark parseArguments(String[] args, StorageListener slistener, CoordinatorListener clistener) {
        int user_port = -1;
        String ip = null;
        String torrent = null;
        I2PSnarkUtil util = new I2PSnarkUtil(I2PAppContext.getGlobalContext());
        boolean configured = util.configured();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--port")) {
                if (args.length - 1 < i + 1) {
                    Snark.usage("--port needs port number to listen on");
                }
                try {
                    user_port = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException nfe) {
                    Snark.usage("--port argument must be a number (" + nfe + ")");
                }
                i += 2;
                continue;
            }
            if (args[i].equals("--no-commands")) {
                ++i;
                continue;
            }
            if (args[i].equals("--i2cp")) {
                String i2cpHost = args[i + 1];
                String i2cpPort = args[i + 2];
                Properties opts = null;
                if (i + 3 < args.length && !args[i + 3].startsWith("--")) {
                    opts = new Properties();
                    StringTokenizer tok = new StringTokenizer(args[i + 3], " \t");
                    while (tok.hasMoreTokens()) {
                        String str = tok.nextToken();
                        int split = str.indexOf(61);
                        if (split <= 0) continue;
                        opts.setProperty(str.substring(0, split), str.substring(split + 1));
                    }
                }
                if (!configured) {
                    util.setI2CPConfig(i2cpHost, Integer.parseInt(i2cpPort), opts);
                }
                i += 3 + (opts != null ? 1 : 0);
                continue;
            }
            torrent = args[i];
            ++i;
            break;
        }
        if (torrent == null || i != args.length) {
            if (torrent != null && torrent.startsWith("-")) {
                Snark.usage("Unknow option '" + torrent + "'.");
            } else {
                Snark.usage("Need exactly one <url>, <file> or <dir>.");
            }
        }
        return new Snark(util, torrent, ip, user_port, slistener, clistener);
    }

    private static void usage(String s) {
        System.out.println("snark: " + s);
        Snark.usage();
    }

    private static void usage() {
        System.out.println("Usage: snark [--no-commands] [--port <port>]");
        System.out.println("             [--eepproxy hostname portnum]");
        System.out.println("             [--i2cp routerHost routerPort ['name=val name=val name=val']]");
        System.out.println("             (<url>|<file>)");
        System.out.println("  --no-commands\tDon't read interactive commands or show usage info.");
        System.out.println("  --port\tThe port to listen on for incomming connections");
        System.out.println("        \t(if not given defaults to first free port between 6881-6889).");
        System.out.println("  --share\tStart torrent tracker on <ip> address or <host> name.");
        System.out.println("  --eepproxy\thttp proxy to use (default of 127.0.0.1 port 4444)");
        System.out.println("  --i2cp\tlocation of your I2P router (default of 127.0.0.1 port 7654)");
        System.out.println("        \toptional settings may be included, such as");
        System.out.println("        \tinbound.length=2 outbound.length=2 inbound.lengthVariance=-1 ");
        System.out.println("  <url>  \tURL pointing to .torrent metainfo file to download/share.");
        System.out.println("  <file> \tEither a local .torrent metainfo file to download");
        System.out.println("         \tor (with --share) a file to share.");
    }

    private void fatal(String s) {
        this.fatal(s, null);
    }

    private void fatal(String s, Throwable t) {
        this._log.error(s, t);
        this.stopTorrent();
        if (t != null) {
            s = s + ": " + t;
        }
        if (this.completeListener != null) {
            this.completeListener.fatal(this, s);
        }
        throw new RuntimeException(s, t);
    }

    @Override
    public void peerChange(PeerCoordinator coordinator, Peer peer) {
    }

    @Override
    public void gotMetaInfo(PeerCoordinator coordinator, MetaInfo metainfo) {
        try {
            String newName;
            this.storage = new Storage(this._util, metainfo, this);
            this.storage.check(this.rootDataDir);
            this.meta = metainfo;
            if (this.completeListener != null && (newName = this.completeListener.gotMetaInfo(this)) != null) {
                this.torrent = newName;
            }
            coordinator.setStorage(this.storage);
        }
        catch (IOException ioe) {
            if (this.storage != null) {
                try {
                    this.storage.close();
                }
                catch (IOException ioee) {
                    // empty catch block
                }
            }
            this.fatal("Could not check or create storage", ioe);
        }
    }

    @Override
    public void storageCreateFile(Storage storage, String name, long length) {
    }

    @Override
    public void storageAllocated(Storage storage, long length) {
    }

    @Override
    public void storageChecked(Storage storage, int num, boolean checked) {
        if (!this.allChecked && !this.checking) {
            this.checking = true;
        }
        if (!this.checking) {
            if (this._log.shouldLog(20)) {
                this._log.info("Got " + (checked ? "" : "BAD ") + "piece: " + num);
            }
            if (this.completeListener != null) {
                this.completeListener.gotPiece(this);
            }
        }
    }

    @Override
    public void storageAllChecked(Storage storage) {
        this.allChecked = true;
        this.checking = false;
        if (storage.isChanged() && this.completeListener != null) {
            this.completeListener.updateStatus(this);
        }
    }

    @Override
    public void storageCompleted(Storage storage) {
        if (this._log.shouldLog(20)) {
            this._log.info("Completely received " + this.torrent);
        }
        if (this.completeListener != null) {
            this.completeListener.torrentComplete(this);
        }
    }

    @Override
    public void setWantedPieces(Storage storage) {
        this.coordinator.setWantedPieces();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void addMessage(String message) {
        if (this.completeListener != null) {
            this.completeListener.addMessage(this, message);
        }
    }

    @Override
    public boolean overUploadLimit(int uploaders) {
        if (this._peerCoordinatorSet == null || uploaders <= 0) {
            return false;
        }
        int totalUploaders = 0;
        for (PeerCoordinator c : this._peerCoordinatorSet) {
            if (c.halted()) continue;
            totalUploaders += c.uploaders;
        }
        int limit = this._util.getMaxUploaders();
        return totalUploaders > limit;
    }

    @Override
    public boolean overUpBWLimit() {
        if (this._peerCoordinatorSet == null) {
            return false;
        }
        long total = 0L;
        for (PeerCoordinator c : this._peerCoordinatorSet) {
            if (c.halted()) continue;
            total += c.getCurrentUploadRate();
        }
        long limit = 1024L * (long)this._util.getMaxUpBW();
        if (this._log.shouldLog(20)) {
            this._log.info("Total up bw: " + total + " Limit: " + limit);
        }
        return total > limit;
    }

    @Override
    public boolean overUpBWLimit(long total) {
        long limit = 1024L * (long)this._util.getMaxUpBW();
        return total > limit;
    }
}

