/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.BitField;
import org.klomp.snark.CoordinatorListener;
import org.klomp.snark.ExtensionHandler;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MagnetState;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCheckerTask;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerListener;
import org.klomp.snark.PeerState;
import org.klomp.snark.Piece;
import org.klomp.snark.Request;
import org.klomp.snark.Snark;
import org.klomp.snark.Storage;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;
import org.klomp.snark.dht.DHT;

class PeerCoordinator
implements PeerListener {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerCoordinator.class);
    MetaInfo metainfo;
    Storage storage;
    private final Snark snark;
    static final long CHECK_PERIOD = 40000L;
    static final int MAX_UPLOADERS = 6;
    public static final long MAX_INACTIVE = 480000L;
    int uploaders;
    int interestedAndChoking;
    private long uploaded;
    private long downloaded;
    static final int RATE_DEPTH = 3;
    private final long[] uploaded_old = new long[]{-1L, -1L, -1L};
    private final long[] downloaded_old = new long[]{-1L, -1L, -1L};
    final Queue<Peer> peers;
    private final Set<PeerID> pexPeers;
    private volatile int peerCount;
    private final CheckEvent timer;
    private final byte[] id;
    private final byte[] infohash;
    private final List<Piece> wantedPieces;
    private long wantedBytes;
    private final List<PartialPiece> partialPieces;
    private volatile boolean halted;
    private final MagnetState magnetState;
    private final CoordinatorListener listener;
    private final I2PSnarkUtil _util;
    private final Random _random;
    private static final int END_GAME_THRESHOLD = 8;
    private static final int MAX_PARALLEL_REQUESTS = 4;

    public PeerCoordinator(I2PSnarkUtil util, byte[] id, byte[] infohash, MetaInfo metainfo, Storage storage, CoordinatorListener listener, Snark torrent) {
        this._util = util;
        this._random = util.getContext().random();
        this.id = id;
        this.infohash = infohash;
        this.metainfo = metainfo;
        this.storage = storage;
        this.listener = listener;
        this.snark = torrent;
        this.wantedPieces = new ArrayList<Piece>();
        this.setWantedPieces();
        this.partialPieces = new ArrayList<PartialPiece>(this.getMaxConnections() + 1);
        this.peers = new LinkedBlockingQueue<Peer>();
        this.magnetState = new MagnetState(infohash, metainfo);
        this.pexPeers = new ConcurrentHashSet<PeerID>();
        this.timer = new CheckEvent(this._util.getContext(), new PeerCheckerTask(this._util, this));
        this.timer.schedule(20000L + (long)this._random.nextInt(40000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWantedPieces() {
        if (this.metainfo == null || this.storage == null) {
            this.wantedBytes = -1L;
            return;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            this.wantedPieces.clear();
            BitField bitfield = this.storage.getBitField();
            int[] pri = this.storage.getPiecePriorities();
            long count = 0L;
            for (int i = 0; i < this.metainfo.getPieces(); ++i) {
                if (bitfield.get(i) || pri != null && pri[i] < 0) continue;
                Piece p = new Piece(i);
                if (pri != null) {
                    p.setPriority(pri[i]);
                }
                this.wantedPieces.add(p);
                count += (long)this.metainfo.getPieceLength(i);
            }
            this.wantedBytes = count;
            Collections.shuffle(this.wantedPieces, this._random);
        }
    }

    public Storage getStorage() {
        return this.storage;
    }

    public List<Peer> peerList() {
        return new ArrayList<Peer>(this.peers);
    }

    public byte[] getID() {
        return this.id;
    }

    public String getName() {
        return this.snark.getName();
    }

    public boolean completed() {
        if (this.storage == null) {
            return false;
        }
        return this.storage.complete();
    }

    public int getPeerCount() {
        return this.peerCount;
    }

    public int getPeers() {
        int rv;
        this.peerCount = rv = this.peers.size();
        return rv;
    }

    public long getLeft() {
        if (this.metainfo == null | this.storage == null) {
            return -1L;
        }
        return (long)this.storage.needed() * (long)this.metainfo.getPieceLength(0);
    }

    public long getNeededLength() {
        return this.wantedBytes;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public void setRateHistory(long up, long down) {
        PeerCoordinator.setRate(up, this.uploaded_old);
        PeerCoordinator.setRate(down, this.downloaded_old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRate(long val, long[] array) {
        long[] lArray = array;
        synchronized (array) {
            for (int i = 2; i > 0; --i) {
                array[i] = array[i - 1];
            }
            array[0] = val;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public long getDownloadRate() {
        return PeerCoordinator.getRate(this.downloaded_old);
    }

    public long getUploadRate() {
        return PeerCoordinator.getRate(this.uploaded_old);
    }

    public long getCurrentUploadRate() {
        long r = this.uploaded_old[0];
        if (r <= 0L) {
            return 0L;
        }
        return r * 1000L / 40000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getRate(long[] array) {
        long rate = 0L;
        int factor = 0;
        long[] lArray = array;
        synchronized (array) {
            int i;
            for (i = 0; i < 3 && array[i] >= 0L; ++i) {
                int f = 3 - i;
                rate += array[i] * (long)f;
                factor += f;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (i == 0) {
                return 0L;
            }
            return rate / ((long)factor * 40000L / 1000L);
        }
    }

    public MetaInfo getMetaInfo() {
        return this.metainfo;
    }

    public byte[] getInfoHash() {
        return this.infohash;
    }

    public boolean needPeers() {
        return !this.halted && this.peers.size() < this.getMaxConnections();
    }

    public boolean needOutboundPeers() {
        return this.wantedBytes != 0L && !this.halted && this.peers.size() < this.getMaxConnections() - 2 && (this.storage == null || !this.storage.isChecking());
    }

    private int getMaxConnections() {
        if (this.metainfo == null) {
            return 6;
        }
        int pieces = this.metainfo.getPieces();
        if (pieces <= 2) {
            return 4;
        }
        if (pieces <= 5) {
            return 6;
        }
        int max = this._util.getMaxConnections();
        return max;
    }

    public boolean halted() {
        return this.halted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        this.halted = true;
        ArrayList<Peer> removed = new ArrayList<Peer>();
        Collection<Comparable<Peer>> collection = this.peers;
        synchronized (collection) {
            this.timer.cancel();
            removed.addAll(this.peers);
            this.peers.clear();
            this.peerCount = 0;
        }
        while (!removed.isEmpty()) {
            Peer peer = (Peer)removed.remove(0);
            peer.disconnect();
            this.removePeerFromPieces(peer);
        }
        collection = this.partialPieces;
        synchronized (collection) {
            for (PartialPiece pp : this.partialPieces) {
                pp.release();
            }
            this.partialPieces.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        this.halted = false;
        Object object = this.uploaded_old;
        synchronized (this.uploaded_old) {
            Arrays.fill(this.uploaded_old, 0L);
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            object = this.downloaded_old;
            synchronized (this.downloaded_old) {
                Arrays.fill(this.downloaded_old, 0L);
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                List<Piece> list = this.wantedPieces;
                object = list;
                synchronized (list) {
                    for (Piece pc : this.wantedPieces) {
                        pc.clear();
                    }
                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                    this.timer.schedule(20000L + (long)this._random.nextInt(40000));
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(Peer peer) {
        if (this.halted) {
            peer.disconnect(false);
            return;
        }
        Peer toDisconnect = null;
        Queue<Peer> queue = this.peers;
        synchronized (queue) {
            Peer old = PeerCoordinator.peerIDInList(peer.getPeerID(), this.peers);
            if (old != null && old.getInactiveTime() > 480000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Remomving old peer: " + peer + ": " + old + ", inactive for " + old.getInactiveTime());
                }
                this.peers.remove(old);
                toDisconnect = old;
                old = null;
            }
            if (old != null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Already connected to: " + peer + ": " + old + ", inactive for " + old.getInactiveTime());
                }
                peer.disconnect(false);
            } else if (this.peers.size() >= this.getMaxConnections()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Already at MAX_CONNECTIONS in connected() with peer: " + peer);
                }
                peer.disconnect(false);
            } else {
                if (this._log.shouldLog(20)) {
                    String name = this.metainfo == null ? "Magnet" : this.metainfo.getName();
                    this._log.info("New connection to peer: " + peer + " for " + name);
                }
                if (this.metainfo != null) {
                    peer.setMetaInfo(this.metainfo);
                }
                this.peers.add(peer);
                this.peerCount = this.peers.size();
                this.unchokePeer();
            }
        }
        if (toDisconnect != null) {
            toDisconnect.disconnect(false);
            this.removePeerFromPieces(toDisconnect);
        }
    }

    private static Peer peerIDInList(PeerID pid, Collection<Peer> peers) {
        for (Peer cur : peers) {
            if (!pid.sameID(cur.getPeerID())) continue;
            return cur;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPeer(final Peer peer) {
        boolean need_more;
        if (this.halted) {
            peer.disconnect(false);
            return false;
        }
        int peersize = 0;
        Queue<Peer> queue = this.peers;
        synchronized (queue) {
            peersize = this.peers.size();
            need_more = !peer.isConnected() && peersize < this.getMaxConnections();
            Peer old = PeerCoordinator.peerIDInList(peer.getPeerID(), this.peers);
            need_more = need_more && (old == null || old.getInactiveTime() > 480000L);
        }
        if (need_more) {
            if (this._log.shouldLog(10)) {
                String name = this.metainfo == null ? "Magnet" : this.metainfo.getName();
                this._log.debug("Adding a peer " + peer.getPeerID().toString() + " for " + name, new Exception("add/run"));
            }
            final PeerCoordinator listener = this;
            final BitField bitfield = this.storage != null ? this.storage.getBitField() : null;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    peer.runConnection(PeerCoordinator.this._util, listener, bitfield, PeerCoordinator.this.magnetState);
                }
            };
            String threadName = "Snark peer " + peer.toString();
            new I2PAppThread(r, threadName).start();
            return true;
        }
        if (this._log.shouldLog(10)) {
            if (peer.isConnected()) {
                this._log.info("Add peer already connected: " + peer);
            } else {
                this._log.info("Connections: " + peersize + "/" + this.getMaxConnections() + " not accepting extra peer: " + peer);
            }
        }
        return false;
    }

    void unchokePeer() {
        LinkedList<Peer> interested = new LinkedList<Peer>();
        int count = 0;
        int unchokedCount = 0;
        int maxUploaders = this.allowedUploaders();
        for (Peer peer : this.peers) {
            if (!peer.isChoking() || !peer.isInterested()) continue;
            ++count;
            if (this.uploaders >= maxUploaders) continue;
            if (peer.isInteresting() && !peer.isChoked()) {
                interested.add(unchokedCount++, peer);
                continue;
            }
            interested.add(peer);
        }
        while (this.uploaders < maxUploaders && !interested.isEmpty()) {
            Peer peer;
            peer = (Peer)interested.remove(0);
            if (this._log.shouldLog(10)) {
                this._log.debug("Unchoke: " + peer);
            }
            peer.setChoking(false);
            ++this.uploaders;
            --count;
            this.peers.remove(peer);
            this.peers.add(peer);
            this.peerCount = this.peers.size();
        }
        this.interestedAndChoking = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotHave(Peer peer, int piece) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece pc : this.wantedPieces) {
                if (pc.getId() != piece) continue;
                pc.addPeer(peer);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotBitField(Peer peer, BitField bitfield) {
        boolean rv = false;
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece p : this.wantedPieces) {
                int i = p.getId();
                if (!bitfield.get(i)) continue;
                p.addPeer(peer);
                rv = true;
            }
        }
        return rv;
    }

    @Override
    public int wantPiece(Peer peer, BitField havePieces) {
        Piece pc = this.wantPiece(peer, havePieces, true);
        return pc != null ? pc.getId() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Piece wantPiece(Peer peer, BitField havePieces, boolean record) {
        if (this.halted) {
            if (this._log.shouldLog(30)) {
                this._log.warn("We don't want anything from the peer, as we are halted!  peer=" + peer);
            }
            return null;
        }
        Piece piece = null;
        ArrayList<Piece> requested = new ArrayList<Piece>();
        int wantedSize = 9;
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Piece p;
            if (record) {
                Collections.sort(this.wantedPieces);
            }
            Iterator<Piece> it = this.wantedPieces.iterator();
            while (piece == null && it.hasNext() && !(p = it.next()).isDisabled()) {
                if (havePieces.get(p.getId()) && !p.isRequested()) {
                    boolean hasPartial = false;
                    for (PartialPiece pp : this.partialPieces) {
                        if (pp.getPiece() != p.getId()) continue;
                        if (this._log.shouldLog(20)) {
                            this._log.info("wantPiece() skipping partial for " + peer + ": piece = " + pp);
                        }
                        hasPartial = true;
                        break;
                    }
                    if (hasPartial) continue;
                    piece = p;
                    continue;
                }
                if (!p.isRequested()) continue;
                requested.add(p);
            }
            if (piece == null) {
                wantedSize = this.wantedPieces.size();
            }
            if (piece == null) {
                if (wantedSize > 8) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Nothing to request, " + requested.size() + " being requested and " + wantedSize + " still wanted");
                    }
                    return null;
                }
                if (record) {
                    Collections.shuffle(requested, this._random);
                }
                Iterator it2 = requested.iterator();
                while (piece == null && it2.hasNext()) {
                    int requestedCount;
                    Piece p2 = (Piece)it2.next();
                    if (!havePieces.get(p2.getId()) || (requestedCount = p2.getRequestCount()) >= 4 || p2.isRequestedBy(peer)) continue;
                    piece = p2;
                    break;
                }
                if (piece == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("nothing to even rerequest from " + peer + ": requested = " + requested);
                    }
                    return null;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("parallel request (end game?) for " + peer + ": piece = " + piece);
                }
            }
            if (record) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Now requesting from " + peer + ": piece " + piece + " priority " + piece.getPriority() + " peers " + piece.getPeerCount() + '/' + this.peers.size());
                }
                piece.setRequested(peer, true);
            }
            return piece;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePiecePriorities() {
        if (this.storage == null) {
            return;
        }
        int[] pri = this.storage.getPiecePriorities();
        if (pri == null) {
            this._log.debug("Updated piece priorities called but no priorities to set?");
            return;
        }
        ArrayList<Piece> toCancel = new ArrayList<Piece>();
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            BitField want = new BitField(pri.length);
            for (Piece p : this.wantedPieces) {
                want.set(p.getId());
            }
            BitField bitfield = this.storage.getBitField();
            for (int i = 0; i < pri.length; ++i) {
                if (pri[i] < 0 || bitfield.get(i) || want.get(i)) continue;
                Piece piece = new Piece(i);
                this.wantedPieces.add(piece);
                this.wantedBytes += (long)this.metainfo.getPieceLength(i);
                for (Peer p : this.peers) {
                    BitField bf;
                    PeerState s = p.state;
                    if (s == null || (bf = s.bitfield) == null || !bf.get(i)) continue;
                    piece.addPeer(p);
                }
            }
            Iterator<Piece> iter = this.wantedPieces.iterator();
            while (iter.hasNext()) {
                Piece p = iter.next();
                int priority = pri[p.getId()];
                if (priority >= 0) {
                    p.setPriority(priority);
                    continue;
                }
                iter.remove();
                toCancel.add(p);
                this.wantedBytes -= (long)this.metainfo.getPieceLength(p.getId());
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Updated piece priorities, now wanted: " + this.wantedPieces);
            }
            Collections.shuffle(this.wantedPieces, this._random);
        }
        if (!toCancel.isEmpty()) {
            for (Peer peer : this.peers) {
                for (Piece p : toCancel) {
                    peer.cancel(p.getId());
                }
            }
        }
        for (Peer peer : this.peers) {
            peer.request();
        }
    }

    @Override
    public ByteArray gotRequest(Peer peer, int piece, int off, int len) {
        if (this.halted) {
            return null;
        }
        if (this.metainfo == null || this.storage == null) {
            return null;
        }
        try {
            return this.storage.getPiece(piece, off, len);
        }
        catch (IOException ioe) {
            this.snark.stopTorrent();
            String msg = "Error reading the storage (piece " + piece + ") for " + this.metainfo.getName() + ": " + ioe;
            this._log.error(msg, ioe);
            if (this.listener != null) {
                this.listener.addMessage(msg);
                this.listener.addMessage("Fatal storage error: Stopping torrent " + this.metainfo.getName());
            }
            throw new RuntimeException(msg, ioe);
        }
    }

    @Override
    public void uploaded(Peer peer, int size) {
        this.uploaded += (long)size;
    }

    @Override
    public void downloaded(Peer peer, int size) {
        this.downloaded += (long)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotPiece(Peer peer, PartialPiece pp) {
        if (this.metainfo == null || this.storage == null || this.storage.isChecking() || this.halted) {
            pp.release();
            return true;
        }
        int piece = pp.getPiece();
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Piece p;
            block20: {
                p = new Piece(piece);
                if (!this.wantedPieces.contains(p)) {
                    this._log.info("Got unwanted piece " + piece + "/" + this.metainfo.getPieces() + " from " + peer + " for " + this.metainfo.getName());
                    if (this.storage.getBitField().get(piece)) {
                        pp.release();
                        return true;
                    }
                }
                try {
                    if (this.storage.putPiece(pp)) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Got valid piece " + piece + "/" + this.metainfo.getPieces() + " from " + peer + " for " + this.metainfo.getName());
                        }
                        break block20;
                    }
                    this.downloaded -= (long)this.metainfo.getPieceLength(piece);
                    this._log.warn("Got BAD piece " + piece + "/" + this.metainfo.getPieces() + " from " + peer + " for " + this.metainfo.getName());
                    return false;
                }
                catch (IOException ioe) {
                    String msg = "Error writing storage (piece " + piece + ") for " + this.metainfo.getName() + ": " + ioe;
                    this._log.error(msg, ioe);
                    if (this.listener != null) {
                        this.listener.addMessage(msg);
                        this.listener.addMessage("Fatal storage error: Stopping torrent " + this.metainfo.getName());
                    }
                    this.snark.stopTorrent();
                    throw new RuntimeException(msg, ioe);
                }
            }
            this.wantedPieces.remove(p);
            this.wantedBytes -= (long)this.metainfo.getPieceLength(p.getId());
        }
        this.removePartialPiece(piece);
        boolean done = this.wantedBytes <= 0L;
        ArrayList<Peer> toDisconnect = done ? new ArrayList<Peer>() : null;
        for (Peer p : this.peers) {
            if (!p.isConnected()) continue;
            if (done && p.isCompleted()) {
                toDisconnect.add(p);
                continue;
            }
            p.have(piece);
        }
        if (done) {
            for (Peer p : toDisconnect) {
                p.disconnect(true);
            }
            if (!this.completed()) {
                this.snark.storageCompleted(this.storage);
            }
            List<PartialPiece> list2 = this.partialPieces;
            synchronized (list2) {
                for (PartialPiece ppp : this.partialPieces) {
                    ppp.release();
                }
                this.partialPieces.clear();
            }
        }
        return true;
    }

    @Override
    public void gotChoke(Peer peer, boolean choke) {
        if (this._log.shouldLog(20)) {
            this._log.info("Got choke(" + choke + "): " + peer);
        }
    }

    @Override
    public void gotInterest(Peer peer, boolean interest) {
        if (interest && this.uploaders < this.allowedUploaders() && peer.isChoking()) {
            ++this.uploaders;
            peer.setChoking(false);
            if (this._log.shouldLog(20)) {
                this._log.info("Unchoke: " + peer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(Peer peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Disconnected " + peer, new Exception("Disconnected by"));
        }
        Queue<Peer> queue = this.peers;
        synchronized (queue) {
            if (this.peers.remove(peer)) {
                this.unchokePeer();
                this.removePeerFromPieces(peer);
            }
            this.peerCount = this.peers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePeerFromPieces(Peer peer) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece piece : this.wantedPieces) {
                piece.removePeer(peer);
                piece.setRequested(peer, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePartialPieces(Peer peer, List<Request> partials) {
        if (this._log.shouldLog(20)) {
            this._log.info("Partials received from " + peer + ": " + partials);
        }
        if (this.halted || this.completed()) {
            for (Request req : partials) {
                PartialPiece pp = req.getPartialPiece();
                pp.release();
            }
            return;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Request req : partials) {
                PartialPiece pp = req.getPartialPiece();
                if (req.off > 0) {
                    int idx = this.partialPieces.indexOf(pp);
                    if (idx < 0) {
                        this.partialPieces.add(pp);
                        if (this._log.shouldLog(20)) {
                            this._log.info("Saving orphaned partial piece (new) " + pp);
                        }
                    } else if (idx >= 0 && pp.getDownloaded() > this.partialPieces.get(idx).getDownloaded()) {
                        this.partialPieces.get(idx).release();
                        this.partialPieces.set(idx, pp);
                        if (this._log.shouldLog(20)) {
                            this._log.info("Saving orphaned partial piece (bigger) " + pp);
                        }
                    } else {
                        pp.release();
                        if (this._log.shouldLog(20)) {
                            this._log.info("Discarding partial piece (not bigger)" + pp);
                        }
                    }
                    int max = this.getMaxConnections();
                    if (this.partialPieces.size() > max) {
                        Collections.sort(this.partialPieces);
                        PartialPiece gone = this.partialPieces.remove(max);
                        gone.release();
                        if (this._log.shouldLog(20)) {
                            this._log.info("Discarding orphaned partial piece (list full)" + gone);
                        }
                    }
                } else {
                    pp.release();
                }
                this.markUnrequested(peer, pp.getPiece());
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Partial list size now: " + this.partialPieces.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialPiece getPartialPiece(Peer peer, BitField havePieces) {
        if (this.metainfo == null) {
            return null;
        }
        if (this.storage != null && this.storage.isChecking()) {
            return null;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Collections.sort(this.partialPieces);
            Iterator<PartialPiece> iter = this.partialPieces.iterator();
            while (iter.hasNext()) {
                PartialPiece pp = iter.next();
                int savedPiece = pp.getPiece();
                if (!havePieces.get(savedPiece)) continue;
                boolean skipped = false;
                for (Piece piece : this.wantedPieces) {
                    if (piece.getId() != savedPiece) continue;
                    if (peer.isCompleted() && piece.getPeerCount() > 1) {
                        boolean nonSeeds = false;
                        for (Peer pr : this.peers) {
                            BitField bf;
                            PeerState state = pr.state;
                            if (state == null || (bf = state.bitfield) == null || !bf.get(savedPiece) || pr.isCompleted()) continue;
                            nonSeeds = true;
                            break;
                        }
                        if (nonSeeds) {
                            skipped = true;
                            break;
                        }
                    }
                    iter.remove();
                    piece.setRequested(peer, true);
                    if (this._log.shouldLog(20)) {
                        this._log.info("Restoring orphaned partial piece " + pp + " Partial list size now: " + this.partialPieces.size());
                    }
                    return pp;
                }
                if (!this._log.shouldLog(20)) continue;
                if (skipped) {
                    this._log.info("Partial piece " + pp + " with multiple peers skipped for seeder");
                    continue;
                }
                this._log.info("Partial piece " + pp + " NOT in wantedPieces??");
            }
            if (this._log.shouldLog(20) && !this.partialPieces.isEmpty()) {
                this._log.info("Peer " + peer + " has none of our partials " + this.partialPieces);
            }
        }
        Piece piece = this.wantPiece(peer, havePieces, true);
        if (piece != null) {
            return new PartialPiece(piece, this.metainfo.getPieceLength(piece.getId()), this._util.getTempDir());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("We have no partial piece to return");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needPiece(Peer peer, BitField havePieces) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (PartialPiece pp : this.partialPieces) {
                int savedPiece = pp.getPiece();
                if (!havePieces.get(savedPiece)) continue;
                for (Piece piece : this.wantedPieces) {
                    if (piece.getId() != savedPiece) continue;
                    if (this._log.shouldLog(20)) {
                        this._log.info("We could restore orphaned partial piece " + pp);
                    }
                    return true;
                }
            }
        }
        return this.wantPiece(peer, havePieces, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePartialPiece(int piece) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Iterator<PartialPiece> iter = this.partialPieces.iterator();
            while (iter.hasNext()) {
                PartialPiece pp = iter.next();
                if (pp.getPiece() != piece) continue;
                iter.remove();
                pp.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnrequested(Peer peer, int piece) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece pc : this.wantedPieces) {
                if (pc.getId() != piece) continue;
                pc.setRequested(peer, false);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotExtension(Peer peer, int id, byte[] bs) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Got extension message " + id + " from " + peer);
        }
        if (this.metainfo == null && id == 1) {
            MagnetState magnetState = this.magnetState;
            synchronized (magnetState) {
                if (this.magnetState.isComplete()) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Got completed metainfo via extension");
                    }
                    this.metainfo = this.magnetState.getMetaInfo();
                    this.listener.gotMetaInfo(this, this.metainfo);
                }
            }
        } else if (id == 0) {
            this.sendPeers(peer);
            this.sendDHT(peer);
        }
    }

    void sendPeers(Peer peer) {
        if (this.metainfo != null && this.metainfo.isPrivate()) {
            return;
        }
        Map<String, BEValue> handshake = peer.getHandshakeMap();
        if (handshake == null) {
            return;
        }
        BEValue bev = handshake.get("m");
        if (bev == null) {
            return;
        }
        try {
            if (bev.getMap().get("i2p_pex") != null) {
                List<Peer> pList = this.peerList();
                pList.remove(peer);
                if (!pList.isEmpty()) {
                    ExtensionHandler.sendPEX(peer, pList);
                }
            }
        }
        catch (InvalidBEncodingException ibee) {
            // empty catch block
        }
    }

    void sendDHT(Peer peer) {
        DHT dht = this._util.getDHT();
        if (dht == null) {
            return;
        }
        Map<String, BEValue> handshake = peer.getHandshakeMap();
        if (handshake == null) {
            return;
        }
        BEValue bev = handshake.get("m");
        if (bev == null) {
            return;
        }
        try {
            if (bev.getMap().get("i2p_dht") != null) {
                ExtensionHandler.sendDHT(peer, dht.getPort(), dht.getRPort());
            }
        }
        catch (InvalidBEncodingException ibee) {
            // empty catch block
        }
    }

    public void setStorage(Storage stg) {
        this.storage = stg;
        this.setWantedPieces();
        for (Peer p : this.peers) {
            p.setMetaInfo(this.metainfo);
        }
    }

    @Override
    public void gotPort(Peer peer, int port, int rport) {
        DHT dht = this._util.getDHT();
        if (dht != null && port > 0 && port < 65535 && rport == port + 1) {
            dht.ping(peer.getDestination(), port);
        }
    }

    @Override
    public void gotPeers(Peer peer, List<PeerID> peers) {
        if (!this.needOutboundPeers()) {
            return;
        }
        Destination myDest = this._util.getMyDestination();
        if (myDest == null) {
            return;
        }
        byte[] myHash = myDest.calculateHash().getData();
        List<Peer> pList = this.peerList();
        for (PeerID id : peers) {
            if (PeerCoordinator.peerIDInList(id, pList) != null || DataHelper.eq(myHash, id.getDestHash())) continue;
            this.pexPeers.add(id);
        }
    }

    Set<PeerID> getPEXPeers() {
        return this.pexPeers;
    }

    public int allowedUploaders() {
        if (this.listener != null && this.listener.overUploadLimit(this.uploaders)) {
            return this.uploaders - 1;
        }
        if (this.uploaders < 6) {
            return this.uploaders + 1;
        }
        return 6;
    }

    public int getUploaders() {
        return this.uploaders;
    }

    public boolean overUpBWLimit() {
        if (this.listener != null) {
            return this.listener.overUpBWLimit();
        }
        return false;
    }

    public boolean overUpBWLimit(long total) {
        if (this.listener != null) {
            return this.listener.overUpBWLimit(total * 1000L / 40000L);
        }
        return false;
    }

    @Override
    public I2PSnarkUtil getUtil() {
        return this._util;
    }

    private static class CheckEvent
    extends SimpleTimer2.TimedEvent {
        private final PeerCheckerTask _task;

        public CheckEvent(I2PAppContext ctx, PeerCheckerTask task) {
            super(ctx.simpleTimer2());
            this._task = task;
        }

        @Override
        public void timeReached() {
            this._task.run();
            this.schedule(40000L);
        }
    }
}

