/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.i2p.router.web.HelperBase;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class ConfigStatsHelper
extends HelperBase {
    private Log _log;
    private String _filter;
    private final Set<String> _filters;
    private final Set<String> _graphs;
    private final List<String> _stats = new ArrayList<String>();
    private String _currentStatName;
    private String _currentGraphName;
    private String _currentStatDescription;
    private String _currentGroup;
    private boolean _currentIsFirstInGroup;
    private boolean _currentIsLogged;
    private boolean _currentIsGraphed;
    private boolean _currentCanBeGraphed;

    public ConfigStatsHelper() {
        this._filters = new HashSet<String>();
        this._graphs = new HashSet<String>();
    }

    public void setContextId(String contextId) {
        super.setContextId(contextId);
        this._log = this._context.logManager().getLog(ConfigStatsHelper.class);
        Map<String, SortedSet<String>> unsorted = this._context.statManager().getStatsByGroup();
        TreeMap<String, SortedSet<String>> groups = new TreeMap<String, SortedSet<String>>(new AlphaComparator());
        groups.putAll(unsorted);
        for (Set stats : groups.values()) {
            this._stats.addAll(stats);
        }
        this._filter = this._context.statManager().getStatFilter();
        if (this._filter == null) {
            this._filter = "";
        }
        StringTokenizer tok = new StringTokenizer(this._filter, ",");
        while (tok.hasMoreTokens()) {
            this._filters.add(tok.nextToken().trim());
        }
        String specs = this._context.getProperty("stat.summaries", "bw.sendRate.60000,bw.recvRate.60000,router.memoryUsed.60000,router.activePeers.60000");
        tok = new StringTokenizer(specs, ",");
        while (tok.hasMoreTokens()) {
            this._graphs.add(tok.nextToken().trim());
        }
    }

    public boolean shouldShowLog() {
        return !this._filters.isEmpty();
    }

    public String getFilename() {
        return this._context.statManager().getStatFile();
    }

    public boolean hasMoreStats() {
        if (this._stats.isEmpty()) {
            return false;
        }
        this._currentIsGraphed = false;
        this._currentStatName = this._stats.remove(0);
        RateStat rs = this._context.statManager().getRate(this._currentStatName);
        if (rs != null) {
            this._currentStatDescription = rs.getDescription();
            this._currentIsFirstInGroup = this._currentGroup == null ? true : !rs.getGroupName().equals(this._currentGroup);
            this._currentGroup = rs.getGroupName();
            long period = rs.getPeriods()[0];
            if (period <= 600000L) {
                Rate r = rs.getRate(period);
                boolean bl = this._currentCanBeGraphed = r != null;
                if (this._currentCanBeGraphed) {
                    this._currentGraphName = this._currentStatName + "." + period;
                    this._currentIsGraphed = this._graphs.contains(this._currentGraphName);
                }
            } else {
                this._currentCanBeGraphed = false;
            }
        } else {
            FrequencyStat fs = this._context.statManager().getFrequency(this._currentStatName);
            if (fs != null) {
                this._currentStatDescription = fs.getDescription();
                this._currentIsFirstInGroup = this._currentGroup == null ? true : !fs.getGroupName().equals(this._currentGroup);
                this._currentGroup = fs.getGroupName();
                this._currentCanBeGraphed = false;
            } else {
                if (this._log.shouldLog(40)) {
                    this._log.error("Stat does not exist?!  [" + this._currentStatName + "]");
                }
                return false;
            }
        }
        this._currentIsLogged = this._filters.contains("*") || this._filters.contains(this._currentStatName);
        return true;
    }

    public boolean groupRequired() {
        if (this._currentIsFirstInGroup) {
            this._currentIsFirstInGroup = false;
            return true;
        }
        return false;
    }

    public String getCurrentGroupName() {
        return this._currentGroup;
    }

    public String getCurrentStatName() {
        return this._currentStatName;
    }

    public String getCurrentGraphName() {
        return this._currentGraphName;
    }

    public String getCurrentStatDescription() {
        return this._currentStatDescription;
    }

    public boolean getCurrentIsLogged() {
        return this._currentIsLogged;
    }

    public boolean getCurrentIsGraphed() {
        return this._currentIsGraphed;
    }

    public boolean getCurrentCanBeGraphed() {
        return this._currentCanBeGraphed;
    }

    public String getExplicitFilter() {
        return this._filter;
    }

    public boolean getIsFull() {
        return this._context.getBooleanProperty("stat.full");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlphaComparator
    implements Comparator<String> {
        private AlphaComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            String lname = ConfigStatsHelper.this._(lhs);
            String rname = ConfigStatsHelper.this._(rhs);
            return Collator.getInstance().compare(lname, rname);
        }
    }
}

