/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.util.RFC822Date;
import net.i2p.update.UpdateType;
import net.i2p.util.EepHead;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnsignedUpdateChecker
extends UpdateRunner {
    private final long _ms;
    private boolean _unsignedUpdateAvailable;
    protected static final String SIGNED_UPDATE_FILE = "i2pupdate.sud";

    public UnsignedUpdateChecker(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris, long lastUpdateTime) {
        super(ctx, mgr, UpdateType.ROUTER_UNSIGNED, uris);
        this._ms = lastUpdateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._isRunning = true;
        boolean success = false;
        try {
            success = this.fetchUnsignedHead();
        }
        finally {
            this._mgr.notifyCheckComplete(this, this._unsignedUpdateAvailable, success);
            this._isRunning = false;
        }
    }

    private boolean fetchUnsignedHead() {
        if (this._urls.isEmpty()) {
            return false;
        }
        this._currentURI = (URI)this._urls.get(0);
        String url = this._currentURI.toString();
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = this._context.getProperty("router.updateProxyPort", 4444);
        try {
            EepHead get = new EepHead((I2PAppContext)this._context, proxyHost, proxyPort, 0, url);
            if (get.fetch()) {
                String lastmod = get.getLastModified();
                if (lastmod != null) {
                    long modtime = RFC822Date.parse822Date(lastmod);
                    if (modtime <= 0L) {
                        return false;
                    }
                    if (this._ms <= 0L) {
                        return false;
                    }
                    if (modtime > this._ms) {
                        this._unsignedUpdateAvailable = true;
                        this._mgr.notifyVersionAvailable(this, (URI)this._urls.get(0), this.getType(), "", this.getMethod(), this._urls, Long.toString(modtime), "");
                    }
                }
                return true;
            }
        }
        catch (Throwable t) {
            this._log.error("Error fetching the unsigned update", t);
        }
        return false;
    }
}

