/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.PartialEepGet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginUpdateChecker
extends UpdateRunner {
    private final String _appName;
    private final String _oldVersion;

    public PluginUpdateChecker(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris, String appName, String oldVersion) {
        super(ctx, mgr, UpdateType.PLUGIN, uris, oldVersion);
        if (!uris.isEmpty()) {
            this._currentURI = uris.get(0);
        }
        this._appName = appName;
        this._oldVersion = oldVersion;
    }

    @Override
    public String getID() {
        return this._appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._isRunning = true;
        try {
            this.update();
        }
        finally {
            this._isRunning = false;
        }
    }

    @Override
    protected void update() {
        this._isPartial = true;
        this.updateStatus("<b>" + this._("Checking for update of plugin {0}", this._appName) + "</b>");
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        this._baos.reset();
        try {
            this._get = new PartialEepGet((I2PAppContext)this._context, proxyHost, proxyPort, this._baos, this._currentURI.toString(), TrustedUpdate.HEADER_BYTES);
            this._get.addStatusListener(this);
            this._get.fetch(55000L);
        }
        catch (Throwable t) {
            this._log.error("Error checking update for plugin", t);
        }
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        boolean newer;
        super.transferComplete(alreadyTransferred, bytesTransferred, bytesRemaining, url, outputFile, notModified);
        boolean bl = newer = this._newVersion != null;
        if (newer) {
            this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.PLUGIN, this._appName, UpdateMethod.HTTP, this._urls, this._newVersion, this._oldVersion);
        }
        this._mgr.notifyCheckComplete(this, newer, true);
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        File f = new File(this._updateFile);
        f.delete();
        this._mgr.notifyCheckComplete(this, false, false);
    }
}

