/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.NewsHelper;
import net.i2p.update.UpdateType;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class NewsTimerTask
implements SimpleTimer.TimedEvent {
    private final RouterContext _context;
    private final Log _log;
    private final ConsoleUpdateManager _mgr;
    private volatile boolean _firstRun = true;
    private static final long INITIAL_DELAY = 300000L;
    private static final long NEW_INSTALL_DELAY = 1500000L;
    private static final long RUN_DELAY = 600000L;

    public NewsTimerTask(RouterContext ctx, ConsoleUpdateManager mgr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(NewsTimerTask.class);
        this._mgr = mgr;
        long installed = ctx.getProperty("router.firstInstalled", 0L);
        boolean isNew = ctx.clock().now() - installed < 1800000L;
        long delay = isNew ? 1500000L : 300000L;
        delay += this._context.random().nextLong(300000L);
        if (this._log.shouldLog(20)) {
            this._log.info("Scheduling first news check in " + DataHelper.formatDuration(delay));
        }
        ctx.simpleScheduler().addPeriodicEvent(this, delay, 600000L);
    }

    public void timeReached() {
        if (this.shouldFetchNews()) {
            Fetcher t = new Fetcher();
            t.start();
        } else if (this._firstRun && this._mgr.shouldInstall() && !this._mgr.isCheckInProgress() && !this._mgr.isUpdateInProgress()) {
            this._mgr.update(UpdateType.ROUTER_SIGNED);
        }
        this._firstRun = false;
    }

    private boolean shouldFetchNews() {
        if (this._context.router().gracefulShutdownInProgress()) {
            return false;
        }
        if (this._mgr.isCheckInProgress() || this._mgr.isUpdateInProgress()) {
            return false;
        }
        long lastFetch = NewsHelper.lastChecked(this._context);
        String freq = this._context.getProperty("router.newsRefreshFrequency", ConfigUpdateHandler.DEFAULT_REFRESH_FREQUENCY);
        try {
            long ms = Long.parseLong(freq);
            if (ms <= 0L) {
                return false;
            }
            if (lastFetch + ms < this._context.clock().now()) {
                return true;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Last fetched " + DataHelper.formatDuration(this._context.clock().now() - lastFetch) + " ago");
            }
            return false;
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid refresh frequency: " + freq);
            }
            return false;
        }
    }

    private void fetchNews() {
        this._mgr.checkAvailable(UpdateType.NEWS, 60000L);
    }

    private boolean shouldFetchUnsigned() {
        String url = this._context.getProperty("router.updateUnsignedURL");
        return url != null && url.length() > 0 && this._context.getBooleanProperty("router.updateUnsigned") && !NewsHelper.dontInstall(this._context);
    }

    private void fetchUnsignedHead() {
        this._mgr.check(UpdateType.ROUTER_UNSIGNED);
    }

    private class Fetcher
    extends I2PAppThread {
        public Fetcher() {
            super("News Fetcher");
            this.setDaemon(true);
        }

        public void run() {
            NewsTimerTask.this.fetchNews();
            if (NewsTimerTask.this.shouldFetchUnsigned()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!NewsTimerTask.this._mgr.isCheckInProgress() && !NewsTimerTask.this._mgr.isUpdateInProgress()) {
                    NewsTimerTask.this.fetchUnsignedHead();
                }
            }
        }
    }
}

