/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SU3File;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.update.DummyHandler;
import net.i2p.router.update.NewsFetcher;
import net.i2p.router.update.NewsHandler;
import net.i2p.router.update.NewsTimerTask;
import net.i2p.router.update.PluginUpdateHandler;
import net.i2p.router.update.UnsignedUpdateHandler;
import net.i2p.router.update.UpdateHandler;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.PluginStarter;
import net.i2p.update.Checker;
import net.i2p.update.UpdateManager;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.update.Updater;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleUpdateManager
implements UpdateManager {
    private final RouterContext _context;
    private final Log _log;
    private final Collection<RegisteredUpdater> _registeredUpdaters;
    private final Collection<RegisteredChecker> _registeredCheckers;
    private final Collection<UpdateTask> _activeCheckers;
    private final Map<UpdateTask, List<RegisteredUpdater>> _downloaders;
    private final ConcurrentHashMap<UpdateItem, VersionAvailable> _available;
    private final Map<UpdateItem, Version> _downloaded;
    private final Map<UpdateItem, Version> _installed;
    private final boolean _allowTorrent;
    private static final DecimalFormat _pct = new DecimalFormat("0.0%");
    private volatile String _status;
    private static final long DEFAULT_MAX_TIME = 10800000L;
    private static final long DEFAULT_CHECK_TIME = 60000L;
    private static final long STATUS_CLEAN_TIME = 1200000L;
    private static final long TASK_CLEANER_TIME = 900000L;
    private static final String PROP_UNSIGNED_AVAILABLE = "router.updateUnsignedAvailable";

    public ConsoleUpdateManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ConsoleUpdateManager.class);
        this._registeredUpdaters = new ConcurrentHashSet<RegisteredUpdater>();
        this._registeredCheckers = new ConcurrentHashSet<RegisteredChecker>();
        this._activeCheckers = new ConcurrentHashSet<UpdateTask>();
        this._downloaders = new ConcurrentHashMap<UpdateTask, List<RegisteredUpdater>>();
        this._available = new ConcurrentHashMap();
        this._downloaded = new ConcurrentHashMap<UpdateItem, Version>();
        this._installed = new ConcurrentHashMap<UpdateItem, Version>();
        this._status = "";
        this._allowTorrent = this._context.random().nextInt(100) < 60;
    }

    public static ConsoleUpdateManager getInstance() {
        return (ConsoleUpdateManager)I2PAppContext.getGlobalContext().updateManager();
    }

    @Override
    public void start() {
        this.notifyInstalled(UpdateType.NEWS, "", Long.toString(NewsHelper.lastUpdated(this._context)));
        this.notifyInstalled(UpdateType.ROUTER_SIGNED, "", "0.9.10");
        this.notifyInstalled(UpdateType.ROUTER_SIGNED_SU3, "", "0.9.10");
        new NewsFetcher(this._context, this, Collections.<URI>emptyList()).checkForUpdates();
        for (String plugin : PluginStarter.getPlugins()) {
            Properties props = PluginStarter.pluginProperties(this._context, plugin);
            String ver = props.getProperty("version");
            if (ver == null) continue;
            this.notifyInstalled(UpdateType.PLUGIN, plugin, ver);
        }
        this._context.registerUpdateManager(this);
        DummyHandler dh = new DummyHandler(this._context, this);
        this.register(dh, UpdateType.TYPE_DUMMY, UpdateMethod.METHOD_DUMMY, 0);
        this.register(dh, UpdateType.TYPE_DUMMY, UpdateMethod.METHOD_DUMMY, 0);
        VersionAvailable dummyVA = new VersionAvailable("", "", UpdateMethod.METHOD_DUMMY, Collections.<URI>emptyList());
        this._available.put(new UpdateItem(UpdateType.TYPE_DUMMY, ""), dummyVA);
        NewsHandler c = new NewsHandler(this._context, this);
        this.register(c, UpdateType.NEWS, UpdateMethod.HTTP, 0);
        this.register(c, UpdateType.ROUTER_SIGNED, UpdateMethod.HTTP, 0);
        UpdateHandler u = new UpdateHandler(this._context, this);
        this.register(u, UpdateType.ROUTER_SIGNED, UpdateMethod.HTTP, 0);
        if (ConfigUpdateHandler.USE_SU3_UPDATE) {
            this.register(c, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.HTTP, 0);
            this.register(u, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.HTTP, 0);
        }
        UnsignedUpdateHandler uuh = new UnsignedUpdateHandler(this._context, this);
        this.register(uuh, UpdateType.ROUTER_UNSIGNED, UpdateMethod.HTTP, 0);
        this.register(uuh, UpdateType.ROUTER_UNSIGNED, UpdateMethod.HTTP, 0);
        String newVersion = this._context.getProperty(PROP_UNSIGNED_AVAILABLE);
        if (newVersion != null) {
            List<URI> updateSources = uuh.getUpdateSources();
            if (uuh != null) {
                VersionAvailable newVA = new VersionAvailable(newVersion, "", UpdateMethod.HTTP, updateSources);
                this._available.put(new UpdateItem(UpdateType.ROUTER_UNSIGNED, ""), newVA);
            }
        }
        PluginUpdateHandler puh = new PluginUpdateHandler(this._context, this);
        this.register(puh, UpdateType.PLUGIN, UpdateMethod.HTTP, 0);
        this.register(puh, UpdateType.PLUGIN, UpdateMethod.HTTP, 0);
        new NewsTimerTask(this._context, this);
        this._context.simpleScheduler().addPeriodicEvent(new TaskCleaner(), 900000L);
    }

    @Override
    public void shutdown() {
        this._context.unregisterUpdateManager(this);
        this.stopChecks();
        this.stopUpdates();
        this._registeredUpdaters.clear();
        this._registeredCheckers.clear();
        this._available.clear();
        this._downloaded.clear();
        this._installed.clear();
    }

    public String getStatus() {
        return this._status;
    }

    public String checkAvailable(UpdateType type, long maxWait) {
        return this.checkAvailable(type, "", maxWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkAvailable(UpdateType type, String id, long maxWait) {
        if (this.isCheckInProgress(type, id) || this.isUpdateInProgress(type, id)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Check or update already in progress for: " + (Object)((Object)type) + ' ' + id);
            }
            return null;
        }
        for (RegisteredChecker r : this._registeredCheckers) {
            UpdateTask t;
            if (r.type != type) continue;
            String current = this.getDownloadedOrInstalledVersion(type, id);
            Object object = this._activeCheckers;
            synchronized (object) {
                t = r.checker.check(type, r.method, id, current, maxWait);
                if (t != null) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Starting " + r);
                    }
                    this._activeCheckers.add(t);
                    t.start();
                }
            }
            if (t == null) continue;
            object = t;
            synchronized (object) {
                try {
                    t.wait(maxWait);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            return this.getUpdateAvailable(type, id);
        }
        return null;
    }

    public void check(UpdateType type) {
        this.check(type, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(UpdateType type, String id) {
        if (this.isCheckInProgress(type, id)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Check already in progress for: " + (Object)((Object)type) + ' ' + id);
            }
            return;
        }
        for (RegisteredChecker r : this._registeredCheckers) {
            if (r.type != type) continue;
            String current = this.getDownloadedOrInstalledVersion(type, id);
            Collection<UpdateTask> collection = this._activeCheckers;
            synchronized (collection) {
                UpdateTask t = r.checker.check(type, r.method, id, current, 60000L);
                if (t != null) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Starting " + r);
                    }
                    this._activeCheckers.add(t);
                    t.start();
                    break;
                }
            }
        }
    }

    public String getUpdateAvailable(UpdateType type) {
        return this.getUpdateAvailable(type, "");
    }

    public String getUpdateAvailable(UpdateType type, String id) {
        Version v = this._available.get(new UpdateItem(type, id));
        if (v == null) {
            return null;
        }
        return v.version;
    }

    public String getUpdateDownloaded(UpdateType type) {
        return this.getUpdateDownloaded(type, "");
    }

    public String getUpdateDownloaded(UpdateType type, String id) {
        Version v = this._downloaded.get(new UpdateItem(type, id));
        if (v == null) {
            return null;
        }
        return v.version;
    }

    private String getDownloadedOrInstalledVersion(UpdateType type, String id) {
        UpdateItem ui = new UpdateItem(type, id);
        Version vi = this._installed.get(ui);
        Version vd = this._downloaded.get(ui);
        if (vi != null) {
            if (vd != null) {
                return vi.compareTo(vd) > 0 ? vi.version : vd.version;
            }
            return vi.version;
        }
        return vd != null ? vd.version : null;
    }

    public boolean isUpdateInProgress() {
        return !this._downloaders.isEmpty();
    }

    public boolean isUpdateInProgress(UpdateType type) {
        return this.isUpdateInProgress(type, "");
    }

    public boolean isUpdateInProgress(UpdateType type, String id) {
        for (UpdateTask t : this._downloaders.keySet()) {
            if (t.getType() != type || !id.equals(t.getID())) continue;
            return true;
        }
        return false;
    }

    public void stopUpdates() {
        for (UpdateTask t : this._downloaders.keySet()) {
            t.shutdown();
        }
        this._downloaders.clear();
    }

    public void stopUpdate(UpdateType type) {
        this.stopUpdate(type, "");
    }

    public void stopUpdate(UpdateType type, String id) {
        Iterator<UpdateTask> iter = this._downloaders.keySet().iterator();
        while (iter.hasNext()) {
            UpdateTask t = iter.next();
            if (t.getType() != type || !id.equals(t.getID())) continue;
            iter.remove();
            t.shutdown();
        }
    }

    public boolean isCheckInProgress() {
        return !this._activeCheckers.isEmpty();
    }

    public boolean isCheckInProgress(UpdateType type) {
        return this.isCheckInProgress(type, "");
    }

    public boolean isCheckInProgress(UpdateType type, String id) {
        for (UpdateTask t : this._activeCheckers) {
            if (t.getType() != type || !id.equals(t.getID())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopChecks() {
        Collection<UpdateTask> collection = this._activeCheckers;
        synchronized (collection) {
            for (UpdateTask t : this._activeCheckers) {
                t.shutdown();
            }
            this._activeCheckers.clear();
        }
    }

    public void stopCheck(UpdateType type) {
        this.stopCheck(type, "");
    }

    public void stopCheck(UpdateType type, String id) {
        Iterator<UpdateTask> iter = this._activeCheckers.iterator();
        while (iter.hasNext()) {
            UpdateTask t = iter.next();
            if (t.getType() != type || !id.equals(t.getID())) continue;
            iter.remove();
            t.shutdown();
        }
    }

    public boolean installPlugin(String name, URI uri) {
        if (name == null) {
            name = Long.toString(this._context.random().nextLong());
        }
        List<URI> uris = Collections.singletonList(uri);
        UpdateItem item = new UpdateItem(UpdateType.PLUGIN, name);
        VersionAvailable va = this._available.get(item);
        if (va == null) {
            va = new VersionAvailable("", "", UpdateMethod.HTTP, uris);
            this._available.putIfAbsent(item, va);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Install plugin: " + name + ' ' + va);
        }
        return this.update(UpdateType.PLUGIN, name);
    }

    public boolean update(UpdateType type) {
        return this.update(type, "", 10800000L);
    }

    public boolean update(UpdateType type, String id) {
        return this.update(type, id, 10800000L);
    }

    public boolean update(UpdateType type, long maxTime) {
        return this.update(type, "", maxTime);
    }

    public boolean update(UpdateType type, String id, long maxTime) {
        if (this.isCheckInProgress(type, id)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Check already in progress for: " + (Object)((Object)type) + ' ' + id);
            }
            return false;
        }
        return this.update_fromCheck(type, id, maxTime);
    }

    private boolean update_fromCheck(UpdateType type, String id, long maxTime) {
        if (this.isUpdateInProgress(type, id)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Update already in progress for: " + (Object)((Object)type) + ' ' + id);
            }
            return false;
        }
        UpdateItem ui = new UpdateItem(type, id);
        VersionAvailable va = this._available.get(ui);
        if (va == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No version available for: " + (Object)((Object)type) + ' ' + id);
            }
            return false;
        }
        ArrayList<RegisteredUpdater> sorted = new ArrayList<RegisteredUpdater>(4);
        for (RegisteredUpdater ru : this._registeredUpdaters) {
            if (ru.type != type) continue;
            sorted.add(ru);
        }
        Collections.sort(sorted);
        return this.retry(ui, va.sourceMap, sorted, maxTime) != null;
    }

    private UpdateTask retry(UpdateItem ui, Map<UpdateMethod, List<URI>> sourceMap, List<RegisteredUpdater> toTry, long maxTime) {
        Iterator<RegisteredUpdater> iter = toTry.iterator();
        while (iter.hasNext()) {
            RegisteredUpdater r = iter.next();
            iter.remove();
            if (!this._registeredUpdaters.contains(r)) continue;
            VersionAvailable va = this._available.get(ui);
            String newVer = va != null ? va.version : "";
            for (Map.Entry<UpdateMethod, List<URI>> e : sourceMap.entrySet()) {
                UpdateMethod meth = e.getKey();
                if (r.type != ui.type || r.method != meth) continue;
                UpdateTask t = r.updater.update(ui.type, meth, e.getValue(), ui.id, newVer, maxTime);
                if (t != null) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Starting " + r);
                    }
                    this._downloaders.put(t, toTry);
                    t.start();
                    return t;
                }
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Updater refused: " + r + " for " + (Object)((Object)meth) + ' ' + e.getValue());
            }
            if (!this._log.shouldLog(30)) continue;
            this._log.warn("Nothing left to try for: " + r);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Nothing left to try for: " + ui);
        }
        return null;
    }

    @Override
    public void register(Updater updater, UpdateType type, UpdateMethod method, int priority) {
        if ((type == UpdateType.ROUTER_SIGNED || type == UpdateType.ROUTER_UNSIGNED || type == UpdateType.ROUTER_SIGNED_SU3) && NewsHelper.dontInstall(this._context)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Ignoring registration for " + (Object)((Object)type) + ", router updates disabled");
            }
            return;
        }
        if (type == UpdateType.ROUTER_SIGNED_SU3 && !ConfigUpdateHandler.USE_SU3_UPDATE) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Ignoring registration for " + (Object)((Object)type) + ", SU3 updates disabled");
            }
            return;
        }
        if (method == UpdateMethod.TORRENT && !this._allowTorrent) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Ignoring torrent registration");
            }
            return;
        }
        RegisteredUpdater ru = new RegisteredUpdater(updater, type, method, priority);
        if (this._log.shouldLog(20)) {
            this._log.info("Registering " + ru);
        }
        if (!this._registeredUpdaters.add(ru) && this._log.shouldLog(30)) {
            this._log.warn("Duplicate registration " + ru);
        }
    }

    @Override
    public void unregister(Updater updater, UpdateType type, UpdateMethod method) {
        RegisteredUpdater ru = new RegisteredUpdater(updater, type, method, 0);
        if (this._log.shouldLog(20)) {
            this._log.info("Unregistering " + ru);
        }
        this._registeredUpdaters.remove(ru);
    }

    @Override
    public void register(Checker updater, UpdateType type, UpdateMethod method, int priority) {
        RegisteredChecker rc = new RegisteredChecker(updater, type, method, priority);
        if (this._log.shouldLog(20)) {
            this._log.info("Registering " + rc);
        }
        if (!this._registeredCheckers.add(rc) && this._log.shouldLog(30)) {
            this._log.warn("Duplicate registration " + rc);
        }
    }

    @Override
    public void unregister(Checker updater, UpdateType type, UpdateMethod method) {
        RegisteredChecker rc = new RegisteredChecker(updater, type, method, 0);
        if (this._log.shouldLog(20)) {
            this._log.info("Unregistering " + rc);
        }
        this._registeredCheckers.remove(rc);
    }

    @Override
    public boolean notifyVersionAvailable(UpdateTask task, URI newsSource, UpdateType type, String id, UpdateMethod method, List<URI> updateSources, String newVersion, String minVersion) {
        return this.notifyVersionAvailable(task, newsSource, type, id, Collections.singletonMap(method, updateSources), newVersion, minVersion);
    }

    @Override
    public boolean notifyVersionAvailable(UpdateTask task, URI newsSource, UpdateType type, String id, Map<UpdateMethod, List<URI>> sourceMap, String newVersion, String minVersion) {
        if (type == UpdateType.NEWS) {
            this.notifyInstalled(UpdateType.NEWS, "", newVersion);
            return true;
        }
        UpdateItem ui = new UpdateItem(type, id);
        boolean shouldUpdate = false;
        for (Map.Entry<UpdateMethod, List<URI>> e : sourceMap.entrySet()) {
            UpdateMethod method = e.getKey();
            List<URI> updateSources = e.getValue();
            VersionAvailable newVA = new VersionAvailable(newVersion, minVersion, method, updateSources);
            Version old = this._installed.get(ui);
            if (this._log.shouldLog(20)) {
                this._log.info("notifyVersionAvailable " + ui + ' ' + newVA + " old: " + old);
            }
            if (old != null && old.compareTo(newVA) >= 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(ui.toString() + ' ' + old + " already installed");
                }
                return false;
            }
            old = this._downloaded.get(ui);
            if (old != null && old.compareTo(newVA) >= 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(ui.toString() + ' ' + old + " already downloaded");
                }
                return false;
            }
            VersionAvailable oldVA = this._available.get(ui);
            if (oldVA != null) {
                int comp = oldVA.compareTo(newVA);
                if (comp > 0) {
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn(ui.toString() + ' ' + oldVA + " already available");
                    continue;
                }
                if (comp == 0) {
                    List<URI> oldSources = oldVA.sourceMap.putIfAbsent(method, updateSources);
                    if (oldSources == null) {
                        if (!this._log.shouldLog(30)) continue;
                        this._log.warn(ui.toString() + ' ' + oldVA + " updated with new source method");
                        continue;
                    }
                    if (!oldSources.containsAll(updateSources)) {
                        for (URI uri : updateSources) {
                            if (oldSources.contains(uri)) continue;
                            if (this._log.shouldLog(30)) {
                                this._log.warn(ui.toString() + ' ' + oldVA + " adding " + uri + " to method " + (Object)((Object)method));
                            }
                            oldSources.add(uri);
                        }
                        continue;
                    }
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn(ui.toString() + ' ' + oldVA + " already available");
                    continue;
                }
            }
            if (this._log.shouldLog(20)) {
                this._log.info(ui.toString() + ' ' + newVA + " now available");
            }
            this._available.put(ui, newVA);
            shouldUpdate = true;
        }
        if (!shouldUpdate) {
            return false;
        }
        String msg = null;
        switch (type) {
            case NEWS: {
                break;
            }
            case ROUTER_UNSIGNED: {
                this._context.router().saveConfig(PROP_UNSIGNED_AVAILABLE, newVersion);
            }
            case ROUTER_SIGNED: 
            case ROUTER_SIGNED_SU3: {
                if (this.shouldInstall() && !this.isUpdateInProgress(UpdateType.ROUTER_SIGNED) && !this.isUpdateInProgress(UpdateType.ROUTER_SIGNED_SU3) && !this.isUpdateInProgress(UpdateType.ROUTER_UNSIGNED)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Updating " + ui + " after notify");
                    }
                    this.update_fromCheck(type, id, 10800000L);
                    break;
                }
                if (!this._log.shouldLog(20)) break;
                this._log.info("Not updating " + ui + ", update disabled or in progress");
                break;
            }
            case PLUGIN: {
                msg = "<b>" + this._("New plugin version {0} is available", newVersion) + "</b>";
                break;
            }
        }
        if (msg != null) {
            this.finishStatus(msg);
        }
        return true;
    }

    @Override
    public void notifyVersionConstraint(UpdateTask task, URI newsSource, UpdateType type, String id, String newVersion, String message) {
        UpdateItem ui = new UpdateItem(type, id);
        Version old = this._installed.get(ui);
        VersionAvailable newVA = new VersionAvailable(newVersion, message);
        if (this._log.shouldLog(20)) {
            this._log.info("notifyVersionConstraint " + ui + ' ' + newVA + " old: " + old);
        }
        if (old != null && old.compareTo(newVA) >= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn(ui.toString() + ' ' + old + " already installed");
            }
            return;
        }
        old = this._downloaded.get(ui);
        if (old != null && old.compareTo(newVA) >= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn(ui.toString() + ' ' + old + " already downloaded");
            }
            return;
        }
        VersionAvailable oldVA = this._available.get(ui);
        if (oldVA != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(ui.toString() + ' ' + oldVA + " already available");
            }
            if (oldVA.compareTo(newVA) >= 0) {
                return;
            }
            if (oldVA.constraint == null) {
                return;
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(ui.toString() + ' ' + newVA + " now available");
        }
        this._available.put(ui, newVA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCheckComplete(UpdateTask task, boolean newer, boolean success) {
        if (this._log.shouldLog(20)) {
            this._log.info("Checker " + task + " for " + (Object)((Object)task.getType()) + " complete");
        }
        Collection<UpdateTask> collection = this._activeCheckers;
        synchronized (collection) {
            this._activeCheckers.remove(task);
        }
        String msg = null;
        switch (task.getType()) {
            case NEWS: 
            case ROUTER_UNSIGNED: 
            case ROUTER_SIGNED: 
            case ROUTER_SIGNED_SU3: {
                break;
            }
            case PLUGIN: {
                if (!success) {
                    msg = "<b>" + this._("Update check failed for plugin {0}", task.getID()) + "</b>";
                    break;
                }
                if (newer) break;
                msg = "<b>" + this._("No new version is available for plugin {0}", task.getID()) + "</b>";
                break;
            }
        }
        if (msg != null) {
            this.finishStatus(msg);
        }
        UpdateTask updateTask = task;
        synchronized (updateTask) {
            task.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProgress(UpdateTask task, String status, long downloaded, long totalSize) {
        StringBuilder buf = new StringBuilder(64);
        buf.append(status).append(' ');
        double pct = (double)downloaded / (double)totalSize;
        DecimalFormat decimalFormat = _pct;
        synchronized (decimalFormat) {
            buf.append(_pct.format(pct));
        }
        buf.append("<br>\n");
        buf.append(this._("{0}B transferred", DataHelper.formatSize2(downloaded)));
        this.updateStatus(buf.toString());
    }

    @Override
    public void notifyProgress(UpdateTask task, String status) {
        this.updateStatus(status);
    }

    public void notifyComplete(UpdateTask task, String status) {
        this.finishStatus(status);
    }

    @Override
    public void notifyAttemptFailed(UpdateTask task, String reason, Throwable t) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Attempt failed " + task + " for " + (Object)((Object)task.getType()) + ": " + reason, t);
        }
    }

    @Override
    public void notifyTaskFailed(UpdateTask task, String reason, Throwable t) {
        UpdateTask next;
        UpdateItem ui;
        VersionAvailable va;
        List<RegisteredUpdater> toTry;
        if (this._log.shouldLog(30)) {
            this._log.warn("Failed " + task + " for " + (Object)((Object)task.getType()) + ": " + reason, t);
        }
        if ((toTry = this._downloaders.get(task)) != null && (va = this._available.get(ui = new UpdateItem(task.getType(), task.getID()))) != null && (next = this.retry(ui, va.sourceMap, toTry, 10800000L)) != null && this._log.shouldLog(30)) {
            this._log.warn("Retrying with " + next);
        }
        this._downloaders.remove(task);
        this._activeCheckers.remove(task);
        if (task.getURI() != null && task.getType() != UpdateType.TYPE_DUMMY) {
            this.finishStatus("<b>" + this._("Transfer failed from {0}", ConsoleUpdateManager.linkify(task.getURI().toString())) + "</b>");
        }
    }

    @Override
    public boolean notifyComplete(UpdateTask task, String actualVersion, File file) {
        if (this._log.shouldLog(20)) {
            this._log.info("Updater " + task + " for " + (Object)((Object)task.getType()) + " complete");
        }
        boolean rv = false;
        switch (task.getType()) {
            case NEWS: 
            case TYPE_DUMMY: {
                rv = true;
                break;
            }
            case ROUTER_SIGNED: {
                rv = this.handleSudFile(task.getURI(), actualVersion, file);
                if (!rv) break;
                this.notifyDownloaded(task.getType(), task.getID(), actualVersion);
                break;
            }
            case ROUTER_SIGNED_SU3: {
                rv = this.handleSu3File(task.getURI(), actualVersion, file);
                if (!rv) break;
                this.notifyDownloaded(task.getType(), task.getID(), actualVersion);
                break;
            }
            case ROUTER_UNSIGNED: {
                rv = this.handleUnsignedFile(task.getURI(), actualVersion, file);
                if (!rv) break;
                this._context.router().saveConfig(PROP_UNSIGNED_AVAILABLE, null);
                this.notifyDownloaded(task.getType(), task.getID(), actualVersion);
                break;
            }
            default: {
                rv = true;
                this.notifyInstalled(task.getType(), task.getID(), actualVersion);
            }
        }
        if (rv) {
            this._downloaders.remove(task);
        }
        return rv;
    }

    private void notifyInstalled(UpdateType type, String id, String version) {
        UpdateItem ui = new UpdateItem(type, id);
        if (version == null) {
            this._installed.remove(ui);
            if (this._log.shouldLog(20)) {
                this._log.info(ui + " removed");
            }
            return;
        }
        Version ver = new Version(version);
        if (this._log.shouldLog(20)) {
            this._log.info(ui + " " + ver + " installed");
        }
        this._installed.put(ui, ver);
        Version old = this._downloaded.get(ui);
        if (old != null && old.compareTo(ver) <= 0) {
            this._downloaded.remove(ui);
        }
        if ((old = (Version)this._available.get(ui)) != null && old.compareTo(ver) <= 0) {
            this._available.remove(ui);
        }
    }

    private void notifyDownloaded(UpdateType type, String id, String version) {
        UpdateItem altui;
        UpdateItem ui = new UpdateItem(type, id);
        Version ver = new Version(version);
        if (this._log.shouldLog(20)) {
            this._log.info(ui + " " + ver + " downloaded");
        }
        this._downloaded.put(ui, ver);
        if (type == UpdateType.ROUTER_SIGNED) {
            this._downloaded.remove(new UpdateItem(UpdateType.ROUTER_UNSIGNED, ""));
            this._downloaded.remove(new UpdateItem(UpdateType.ROUTER_SIGNED_SU3, ""));
            altui = new UpdateItem(UpdateType.ROUTER_SIGNED_SU3, id);
            Version old = this._available.get(altui);
            if (old != null && old.compareTo(ver) <= 0) {
                this._available.remove(altui);
            }
            this._downloaded.put(altui, ver);
        } else if (type == UpdateType.ROUTER_SIGNED_SU3) {
            this._downloaded.remove(new UpdateItem(UpdateType.ROUTER_SIGNED, ""));
            this._downloaded.remove(new UpdateItem(UpdateType.ROUTER_UNSIGNED, ""));
            altui = new UpdateItem(UpdateType.ROUTER_SIGNED, id);
            Version old = this._available.get(altui);
            if (old != null && old.compareTo(ver) <= 0) {
                this._available.remove(altui);
            }
            this._downloaded.put(altui, ver);
        } else if (type == UpdateType.ROUTER_UNSIGNED) {
            this._downloaded.remove(new UpdateItem(UpdateType.ROUTER_SIGNED, ""));
            this._downloaded.remove(new UpdateItem(UpdateType.ROUTER_SIGNED_SU3, ""));
        }
        Version old = this._available.get(ui);
        if (old != null && old.compareTo(ver) <= 0) {
            this._available.remove(ui);
        }
    }

    boolean shouldInstall() {
        String policy = this._context.getProperty("router.updatePolicy");
        if ("notify".equals(policy) || NewsHelper.dontInstall(this._context)) {
            return false;
        }
        File zip = new File(this._context.getRouterDir(), "i2pupdate.zip");
        return !zip.exists();
    }

    public List<URI> getUpdateURLs(UpdateType type, String id, UpdateMethod method) {
        List<URI> rv;
        VersionAvailable va = this._available.get(new UpdateItem(type, id));
        if (va != null && (rv = va.sourceMap.get((Object)method)) != null) {
            return rv;
        }
        switch (type) {
            case NEWS: {
                break;
            }
            case ROUTER_SIGNED: {
                String URLs = this._context.getProperty("router.updateURL", ConfigUpdateHandler.DEFAULT_UPDATE_URL);
                StringTokenizer tok = new StringTokenizer(URLs, " ,\r\n");
                ArrayList<URI> rv2 = new ArrayList<URI>();
                while (tok.hasMoreTokens()) {
                    try {
                        rv2.add(new URI(tok.nextToken().trim()));
                    }
                    catch (URISyntaxException use) {}
                }
                Collections.shuffle(rv2, this._context.random());
                return rv2;
            }
            case ROUTER_SIGNED_SU3: {
                String URLs = ConfigUpdateHandler.SU3_UPDATE_URLS;
                StringTokenizer tok = new StringTokenizer(URLs, " ,\r\n");
                ArrayList<URI> rv3 = new ArrayList<URI>();
                while (tok.hasMoreTokens()) {
                    try {
                        rv3.add(new URI(tok.nextToken().trim()));
                    }
                    catch (URISyntaxException use) {}
                }
                Collections.shuffle(rv3, this._context.random());
                return rv3;
            }
            case ROUTER_UNSIGNED: {
                String url = this._context.getProperty("router.updateUnsignedURL");
                if (url == null) break;
                try {
                    return Collections.singletonList(new URI(url));
                }
                catch (URISyntaxException use) {
                    break;
                }
            }
            case PLUGIN: {
                Properties props = PluginStarter.pluginProperties(this._context, id);
                String xpi2pURL = props.getProperty("updateURL");
                if (xpi2pURL == null) break;
                try {
                    return Collections.singletonList(new URI(xpi2pURL));
                }
                catch (URISyntaxException use) {
                    break;
                }
            }
        }
        return Collections.emptyList();
    }

    public String getUpdateConstraint(UpdateType type, String id) {
        VersionAvailable va = this._available.get(new UpdateItem(type, id));
        if (va != null) {
            return va.constraint;
        }
        return null;
    }

    private boolean handleSudFile(URI uri, String actualVersion, File f) {
        return this.handleRouterFile(uri, actualVersion, f, false);
    }

    private boolean handleSu3File(URI uri, String actualVersion, File f) {
        return this.handleRouterFile(uri, actualVersion, f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRouterFile(URI uri, String actualVersion, File f, boolean isSU3) {
        String err;
        Object up;
        String url = uri.toString();
        this.updateStatus("<b>" + this._("Update downloaded") + "</b>");
        File to = new File(this._context.getRouterDir(), "i2pupdate.zip");
        if (isSU3) {
            up = new SU3File(this._context, f);
            File temp = new File(this._context.getTempDir(), "su3out-" + this._context.random().nextLong() + ".zip");
            try {
                if (((SU3File)up).verifyAndMigrate(temp)) {
                    String ver = ((SU3File)up).getVersionString();
                    int type = ((SU3File)up).getContentType();
                    if (ver == null || VersionComparator.comp("0.9.10", ver) >= 0) {
                        err = "Old version " + ver;
                    }
                    if (type != 1) {
                        err = "Bad su3 content type " + type;
                    }
                    if (!FileUtil.copy(temp, to, true, false)) {
                        err = "Failed copy to " + to;
                    }
                    err = null;
                }
                err = "Signature failed, signer " + DataHelper.stripHTML(((SU3File)up).getSignerString()) + ' ' + (Object)((Object)((SU3File)up).getSigType());
            }
            catch (IOException ioe) {
                this._log.error("SU3 extract error", ioe);
                err = DataHelper.stripHTML(ioe.toString());
            }
            finally {
                temp.delete();
            }
        } else {
            up = new TrustedUpdate(this._context);
            err = ((TrustedUpdate)up).migrateVerified("0.9.10", f, to);
        }
        if (err == null) {
            String policy = this._context.getProperty("router.updatePolicy");
            long modtime = this._context.clock().now();
            this._context.router().saveConfig("router.updateLastDownloaded", Long.toString(modtime));
            if ("install".equals(policy)) {
                this._log.log(50, "Update was VERIFIED, restarting to install it");
                this.updateStatus("<b>" + this._("Update verified") + "</b><br>" + this._("Restarting"));
                this.restart();
            } else {
                this._log.log(50, "Update was VERIFIED, will be installed at next restart");
                this.updateStatus("");
            }
        } else {
            this._log.log(50, err + " from " + url);
            this.updateStatus("<b>" + err + ' ' + this._("from {0}", ConsoleUpdateManager.linkify(url)) + " </b>");
        }
        return err == null;
    }

    private boolean handleUnsignedFile(URI uri, String lastmod, File updFile) {
        if (!FileUtil.verifyZip(updFile)) {
            updFile.delete();
            String url = uri.toString();
            this.updateStatus("<b>" + this._("Unsigned update file from {0} is corrupt", url) + "</b>");
            this._log.log(50, "Corrupt zip file from " + url);
            return false;
        }
        this.updateStatus("<b>" + this._("Update downloaded") + "</b>");
        File to = new File(this._context.getRouterDir(), "i2pupdate.zip");
        boolean copied = FileUtil.copy(updFile, to, true, false);
        if (copied) {
            updFile.delete();
            String policy = this._context.getProperty("router.updatePolicy");
            long modtime = 0L;
            if (lastmod != null) {
                try {
                    modtime = Long.parseLong(lastmod);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (modtime <= 0L) {
                modtime = this._context.clock().now();
            }
            this._context.router().saveConfig("router.updateLastDownloaded", Long.toString(modtime));
            if ("install".equals(policy)) {
                this._log.log(50, "Update was downloaded, restarting to install it");
                this.updateStatus("<b>" + this._("Update downloaded") + "</b><br>" + this._("Restarting"));
                this.restart();
            } else {
                this._log.logAlways(30, "Update was downloaded, will be installed at next restart");
                this.updateStatus("");
            }
        } else {
            this._log.log(50, "Failed copy to " + to);
            this.updateStatus("<b>" + this._("Failed copy to {0}", to.getAbsolutePath()) + "</b>");
        }
        return copied;
    }

    private boolean handlePluginFile(URI uri, String actualVersion, File sudFile) {
        return false;
    }

    private void restart() {
        if (this._context.hasWrapper()) {
            ConfigServiceHandler.registerWrapperNotifier(this._context, 5, false);
        }
        this._context.router().shutdownGracefully(5);
    }

    static String linkify(String url) {
        String durl = url.length() <= 28 ? url : url.substring(0, 25) + "&hellip;";
        return "<a target=\"_blank\" href=\"" + url + "\"/>" + durl + "</a>";
    }

    public String _(String s) {
        return Messages.getString(s, this._context);
    }

    public String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    public String _(String s, Object o, Object o2) {
        return Messages.getString(s, o, o2, (I2PAppContext)this._context);
    }

    private void updateStatus(String s) {
        this._status = s;
    }

    private void finishStatus(String msg) {
        this.updateStatus(msg);
        this._context.simpleScheduler().addEvent(new StatusCleaner(msg), 1200000L);
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h2>Update Manager</h2>");
        buf.append("<h3>Installed</h3>");
        ConsoleUpdateManager.toString(buf, this._installed);
        buf.append("<h3>Available</h3>");
        ConsoleUpdateManager.toString(buf, this._available);
        buf.append("<h3>Downloaded</h3>");
        ConsoleUpdateManager.toString(buf, this._downloaded);
        buf.append("<h3>Registered Checkers</h3>");
        ConsoleUpdateManager.toString(buf, this._registeredCheckers);
        buf.append("<h3>Registered Updaters</h3>");
        ConsoleUpdateManager.toString(buf, this._registeredUpdaters);
        buf.append("<h3>Active Checkers</h3>");
        ConsoleUpdateManager.toString(buf, this._activeCheckers);
        buf.append("<h3>Active Updaters</h3>");
        ConsoleUpdateManager.toString(buf, this._downloaders);
        out.write(buf.toString());
    }

    private static void toString(StringBuilder buf, Collection<?> col) {
        ArrayList<String> list = new ArrayList<String>(col.size());
        for (Object o : col) {
            list.add(o.toString());
        }
        Collections.sort(list);
        for (String e : list) {
            buf.append("[").append(e).append("]<br>");
        }
    }

    private static void toString(StringBuilder buf, Map<?, ?> map) {
        ArrayList<String> list = new ArrayList<String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            String val = entry.getValue().toString();
            list.add("[" + key + "] = [" + val + "]<br>");
        }
        Collections.sort(list);
        for (String e : list) {
            buf.append(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegisteredChecker
    implements Comparable<RegisteredChecker> {
        public final Checker checker;
        public final UpdateType type;
        public final UpdateMethod method;
        public final int priority;

        public RegisteredChecker(Checker u, UpdateType t, UpdateMethod m, int priority) {
            this.checker = u;
            this.type = t;
            this.method = m;
            this.priority = priority;
        }

        @Override
        public int compareTo(RegisteredChecker r) {
            int p = r.priority - this.priority;
            if (p != 0) {
                return p;
            }
            return this.hashCode() - r.hashCode();
        }

        public int hashCode() {
            return this.checker.hashCode() ^ this.type.hashCode() ^ this.method.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegisteredChecker)) {
                return false;
            }
            RegisteredChecker r = (RegisteredChecker)o;
            return this.type == r.type && this.method == r.method && this.checker.equals(r.checker);
        }

        public String toString() {
            return "RegisteredChecker " + this.checker.getClass().getName() + " for " + (Object)((Object)this.type) + ' ' + (Object)((Object)this.method) + " @pri " + this.priority;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegisteredUpdater
    implements Comparable<RegisteredUpdater> {
        public final Updater updater;
        public final UpdateType type;
        public final UpdateMethod method;
        public final int priority;

        public RegisteredUpdater(Updater u, UpdateType t, UpdateMethod m, int priority) {
            this.updater = u;
            this.type = t;
            this.method = m;
            this.priority = priority;
        }

        @Override
        public int compareTo(RegisteredUpdater r) {
            int p = r.priority - this.priority;
            if (p != 0) {
                return p;
            }
            return this.hashCode() - r.hashCode();
        }

        public int hashCode() {
            return this.updater.hashCode() ^ this.type.hashCode() ^ this.method.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegisteredUpdater)) {
                return false;
            }
            RegisteredUpdater r = (RegisteredUpdater)o;
            return this.type == r.type && this.method == r.method && this.updater.equals(r.updater);
        }

        public String toString() {
            return "RegisteredUpdater " + this.updater.getClass().getName() + " for " + (Object)((Object)this.type) + ' ' + (Object)((Object)this.method) + " @pri " + this.priority;
        }
    }

    private class StatusCleaner
    implements SimpleTimer.TimedEvent {
        private final String _msg;

        public StatusCleaner(String msg) {
            this._msg = msg;
        }

        public void timeReached() {
            if (this._msg.equals(ConsoleUpdateManager.this.getStatus())) {
                ConsoleUpdateManager.this.updateStatus("");
            }
        }
    }

    private class TaskCleaner
    implements SimpleTimer.TimedEvent {
        private TaskCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            if (!ConsoleUpdateManager.this._activeCheckers.isEmpty()) {
                Collection collection = ConsoleUpdateManager.this._activeCheckers;
                synchronized (collection) {
                    Iterator iter = ConsoleUpdateManager.this._activeCheckers.iterator();
                    while (iter.hasNext()) {
                        UpdateTask t = (UpdateTask)iter.next();
                        if (t.isRunning()) continue;
                        if (ConsoleUpdateManager.this._log.shouldLog(30)) {
                            ConsoleUpdateManager.this._log.warn("Failsafe remove checker " + t);
                        }
                        iter.remove();
                    }
                }
            }
            if (!ConsoleUpdateManager.this._downloaders.isEmpty()) {
                Iterator iter = ConsoleUpdateManager.this._downloaders.keySet().iterator();
                while (iter.hasNext()) {
                    UpdateTask t = (UpdateTask)iter.next();
                    if (t.isRunning()) continue;
                    if (ConsoleUpdateManager.this._log.shouldLog(30)) {
                        ConsoleUpdateManager.this._log.warn("Failsafe remove downloader " + t);
                    }
                    iter.remove();
                }
            }
        }
    }

    private static class UpdateItem {
        public final UpdateType type;
        public final String id;

        public UpdateItem(UpdateType t, String id) {
            this.type = t;
            this.id = id;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof UpdateItem)) {
                return false;
            }
            UpdateItem r = (UpdateItem)o;
            return this.type == r.type && this.id.equals(r.id);
        }

        public String toString() {
            if ("".equals(this.id)) {
                return "UpdateItem " + (Object)((Object)this.type);
            }
            return "UpdateItem " + (Object)((Object)this.type) + ' ' + this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Version
    implements Comparable<Version> {
        public final String version;

        public Version(String version) {
            this.version = version;
        }

        @Override
        public int compareTo(Version r) {
            return VersionComparator.comp(this.version, r.version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Version && this.version.equals(((Version)o).version);
        }

        public String toString() {
            return "Version " + this.version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VersionAvailable
    extends Version {
        public final String minVersion;
        public final ConcurrentHashMap<UpdateMethod, List<URI>> sourceMap;
        public volatile String constraint;

        public VersionAvailable(String version, String min, UpdateMethod method, List<URI> updateSources) {
            super(version);
            this.minVersion = min;
            this.sourceMap = new ConcurrentHashMap(4);
            this.sourceMap.put(method, updateSources);
        }

        public VersionAvailable(String version, String constraint) {
            super(version);
            this.minVersion = "";
            this.sourceMap = new ConcurrentHashMap(4);
            this.constraint = constraint;
        }

        @Override
        public String toString() {
            return "VersionAvailable \"" + this.version + "\" " + this.sourceMap + (this.constraint != null ? " \"" + this.constraint + '\"' : "");
        }
    }
}

