/*
 * Decompiled with CFR 0.152.
 */
package org.xlattice.crypto.filters;

public class KeySelector {
    private final int m;
    private final int k;
    private final BitSelector bitSel;
    private final WordSelector wordSel;
    private static final int[] UNMASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int[] MASK = new int[]{-1, -2, -4, -8, -16, -32, -64, -128, -256, -512, -1024, -2048, -4096, -8192, -16384, Short.MIN_VALUE};
    private static final int TWO_UP_15 = 32768;

    public KeySelector(int m, int k) {
        this.m = m;
        this.k = k;
        this.bitSel = new GenericBitSelector();
        this.wordSel = new GenericWordSelector();
    }

    public void getOffsets(byte[] key, int[] bitOffset, int[] wordOffset) {
        this.getOffsets(key, 0, key.length, bitOffset, wordOffset);
    }

    public void getOffsets(byte[] key, int off, int len, int[] bitOffset, int[] wordOffset) {
        this.bitSel.getBitSelectors(key, off, len, bitOffset);
        this.wordSel.getWordSelectors(key, off, len, wordOffset);
    }

    public static interface BitSelector {
        public void getBitSelectors(byte[] var1, int var2, int var3, int[] var4);
    }

    public class GenericBitSelector
    implements BitSelector {
        public void getBitSelectors(byte[] b, int offset, int length, int[] bitOffset) {
            int curBit = 8 * offset;
            for (int j = 0; j < KeySelector.this.k; ++j) {
                int curByte = curBit / 8;
                int bitsUnused = (curByte + 1) * 8 - curBit;
                bitOffset[j] = bitsUnused > 5 ? (0xFF & b[curByte]) >> bitsUnused - 5 & UNMASK[5] : (bitsUnused == 5 ? b[curByte] & UNMASK[5] : b[curByte] & UNMASK[bitsUnused] | (0xFF & b[curByte + 1]) >> 3 & MASK[bitsUnused]);
                curBit += 5;
            }
        }
    }

    public class GenericWordSelector
    implements WordSelector {
        public void getWordSelectors(byte[] b, int offset, int length, int[] wordOffset) {
            int stride = KeySelector.this.m - 5;
            int curBit = KeySelector.this.k * 5 + offset * 8;
            for (int j = 0; j < KeySelector.this.k; ++j) {
                int curByte = curBit / 8;
                int bitsUnused = (curByte + 1) * 8 - curBit;
                if (bitsUnused > stride) {
                    wordOffset[j] = (0xFF & b[curByte]) >> bitsUnused - stride & UNMASK[stride];
                } else if (bitsUnused == stride) {
                    wordOffset[j] = b[curByte] & UNMASK[stride];
                } else {
                    wordOffset[j] = b[curByte] & UNMASK[bitsUnused];
                    int bitsToGet = stride - bitsUnused;
                    if (bitsToGet >= 8) {
                        int n = j;
                        wordOffset[n] = wordOffset[n] | (0xFF & b[curByte + 1]) << bitsUnused;
                        if ((bitsToGet -= 8) > 0) {
                            int n2 = j;
                            wordOffset[n2] = wordOffset[n2] | (0xFF & b[curByte + 2]) >> 8 - bitsToGet << stride - bitsToGet;
                        }
                    } else {
                        int n = j;
                        wordOffset[n] = wordOffset[n] | (b[curByte + 1] >> 8 - bitsToGet & UNMASK[bitsToGet]) << bitsUnused;
                    }
                }
                curBit += stride;
            }
        }
    }

    public static interface WordSelector {
        public void getWordSelectors(byte[] var1, int var2, int var3, int[] var4);
    }
}

