/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.OutboundMessageDistributor;
import net.i2p.router.tunnel.RouterFragmentHandler;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.util.Log;

class OutboundTunnelEndpoint {
    private final RouterContext _context;
    private final Log _log;
    private final HopConfig _config;
    private final HopProcessor _processor;
    private final FragmentHandler _handler;
    private final OutboundMessageDistributor _outDistributor;

    public OutboundTunnelEndpoint(RouterContext ctx, HopConfig config, HopProcessor processor) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundTunnelEndpoint.class);
        this._config = config;
        this._processor = processor;
        this._handler = new RouterFragmentHandler(ctx, new DefragmentedHandler());
        this._outDistributor = new OutboundMessageDistributor(ctx, 200);
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        this._config.incrementProcessedMessages();
        boolean ok = this._processor.process(msg.getData(), 0, msg.getData().length, recvFrom);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid IV, dropping at OBEP " + this._config);
            }
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L, 1L);
            return;
        }
        this._handler.receiveTunnelMessage(msg.getData(), 0, msg.getData().length);
    }

    public String toString() {
        return "OBEP " + this._config.getReceiveTunnel();
    }

    private class DefragmentedHandler
    implements FragmentHandler.DefragmentedReceiver {
        private DefragmentedHandler() {
        }

        public void receiveComplete(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
            if (toRouter == null) {
                if (OutboundTunnelEndpoint.this._log.shouldLog(30)) {
                    OutboundTunnelEndpoint.this._log.warn("Dropping msg at OBEP with unsupported delivery instruction type LOCAL");
                }
                return;
            }
            if (OutboundTunnelEndpoint.this._log.shouldLog(10)) {
                OutboundTunnelEndpoint.this._log.debug("outbound tunnel " + OutboundTunnelEndpoint.this._config + " received a full message: " + msg + " to be forwarded on to " + toRouter.toBase64().substring(0, 4) + (toTunnel != null ? ":" + toTunnel.getTunnelId() : ""));
            }
            int size = msg.getMessageSize();
            boolean toUs = OutboundTunnelEndpoint.this._context.routerHash().equals((Object)toRouter);
            if (!toUs && OutboundTunnelEndpoint.this._context.tunnelDispatcher().shouldDropParticipatingMessage(TunnelDispatcher.Location.OBEP, msg.getType(), size)) {
                return;
            }
            if (!toUs) {
                OutboundTunnelEndpoint.this._context.bandwidthLimiter().sentParticipatingMessage(size);
            }
            OutboundTunnelEndpoint.this._outDistributor.distribute(msg, toRouter, toTunnel);
        }
    }
}

