/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class OutboundMessageDistributor {
    private final RouterContext _context;
    private final int _priority;
    private final Log _log;
    private static final long MAX_DISTRIBUTE_TIME = 15000L;

    public OutboundMessageDistributor(RouterContext ctx, int priority) {
        this._context = ctx;
        this._priority = priority;
        this._log = ctx.logManager().getLog(OutboundMessageDistributor.class);
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(target);
        if (info == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("outbound distributor to " + target + "." + (tunnel != null ? tunnel.getTunnelId() + "" : "") + ": no info locally, searching...");
            }
            this._context.netDb().lookupRouterInfo(target, new DistributeJob(this._context, msg, target, tunnel), null, 15000L);
            return;
        }
        this.distribute(msg, info, tunnel);
    }

    public void distribute(I2NPMessage msg, RouterInfo target, TunnelId tunnel) {
        I2NPMessage m = msg;
        if (tunnel != null) {
            TunnelGatewayMessage t = new TunnelGatewayMessage(this._context);
            t.setMessage(msg);
            t.setTunnelId(tunnel);
            t.setMessageExpiration(m.getMessageExpiration());
            m = t;
        }
        if (this._context.routerHash().equals((Object)target.getIdentity().calculateHash())) {
            if (this._log.shouldLog(10)) {
                this._log.debug("queueing inbound message to ourselves: " + m);
            }
            this._context.inNetMessagePool().add(m, null, null);
            return;
        }
        OutNetMessage out = new OutNetMessage(this._context, m, this._context.clock().now() + 15000L, this._priority, target);
        if (this._log.shouldLog(10)) {
            this._log.debug("queueing outbound message to " + target.getIdentity().calculateHash());
        }
        this._context.outNetMessagePool().add(out);
    }

    private class DistributeJob
    extends JobImpl {
        private final I2NPMessage _message;
        private final Hash _target;
        private final TunnelId _tunnel;

        public DistributeJob(RouterContext ctx, I2NPMessage msg, Hash target, TunnelId id) {
            super(ctx);
            this._message = msg;
            this._target = target;
            this._tunnel = id;
        }

        public String getName() {
            return "OBEP distribute after lookup";
        }

        public void runJob() {
            int stat;
            RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(this._target);
            if (info != null) {
                if (OutboundMessageDistributor.this._log.shouldLog(10)) {
                    OutboundMessageDistributor.this._log.debug("outbound distributor to " + this._target + "." + (this._tunnel != null ? this._tunnel.getTunnelId() + "" : "") + ": found on search");
                }
                OutboundMessageDistributor.this.distribute(this._message, info, this._tunnel);
                stat = 1;
            } else {
                if (OutboundMessageDistributor.this._log.shouldLog(30)) {
                    OutboundMessageDistributor.this._log.warn("outbound distributor to " + this._target + "." + (this._tunnel != null ? this._tunnel.getTunnelId() + "" : "") + ": NOT found on search");
                }
                stat = 0;
            }
            OutboundMessageDistributor.this._context.statManager().addRateData("tunnel.distributeLookupSuccess", (long)stat, 0L);
        }
    }
}

