/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.Payload;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicMessageReceiver;
import net.i2p.util.Log;

class InboundMessageDistributor
implements GarlicMessageReceiver.CloveReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final Hash _client;
    private final GarlicMessageReceiver _receiver;

    public InboundMessageDistributor(RouterContext ctx, Hash client) {
        this._context = ctx;
        this._client = client;
        this._log = ctx.logManager().getLog(InboundMessageDistributor.class);
        this._receiver = new GarlicMessageReceiver(ctx, this, client);
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("IBMD for " + this._client + " to " + target + " / " + tunnel + " : " + msg);
        }
        int type = msg.getType();
        if (this._client != null && type == 3) {
            DatabaseSearchReplyMessage orig = (DatabaseSearchReplyMessage)msg;
            if (orig.getNumReplies() > 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Removing replies from a DSRM down a tunnel for " + this._client + ": " + msg);
                }
                DatabaseSearchReplyMessage newMsg = new DatabaseSearchReplyMessage(this._context);
                newMsg.setFromHash(orig.getFromHash());
                newMsg.setSearchKey(orig.getSearchKey());
                msg = newMsg;
            }
        } else {
            if (this._client != null && type == 1 && ((DatabaseStoreMessage)msg).getEntry().getType() == 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping DSM down a tunnel for " + this._client + ": " + msg);
                }
                return;
            }
            if (this._client != null && type != 10 && type != 11 && (type != 1 || ((DatabaseStoreMessage)msg).getReplyToken() != 0L) && type != 22 && type != 24) {
                this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, (long)type);
                this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + msg, (Throwable)new Exception("cause"));
                return;
            }
        }
        if (target == null || tunnel == null && this._context.routerHash().equals((Object)target)) {
            if (type == 11) {
                this._context.inNetMessagePool().handleReplies(msg);
                this._receiver.receive((GarlicMessage)msg);
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("distributing inbound tunnel message into our inNetMessagePool: " + msg);
                }
                this._context.inNetMessagePool().add(msg, null, null);
            }
        } else {
            TunnelId outId;
            TunnelInfo out = this._context.tunnelManager().selectOutboundTunnel(this._client);
            if (out == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("no outbound tunnel to send the client message for " + this._client + ": " + msg);
                }
                return;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("distributing inbound tunnel message back out " + out + " targetting " + target);
            }
            if ((outId = out.getSendTunnelId(0)) == null) {
                if (this._log.shouldLog(40)) {
                    this._log.error("wtf, outbound tunnel has no outboundId? " + out + " failing to distribute " + msg);
                }
                return;
            }
            if (msg.getMessageExpiration() < this._context.clock().now() + 10000L) {
                msg.setMessageExpiration(this._context.clock().now() + 10000L);
            }
            this._context.tunnelDispatcher().dispatchOutbound(msg, outId, tunnel, target);
        }
    }

    public void handleClove(DeliveryInstructions instructions, I2NPMessage data) {
        switch (instructions.getDeliveryMode()) {
            case 0: {
                int type;
                if (this._log.shouldLog(10)) {
                    this._log.debug("local delivery instructions for clove: " + data.getClass().getName());
                }
                if ((type = data.getType()) == 11) {
                    this._receiver.receive((GarlicMessage)data);
                } else if (type == 1) {
                    DatabaseStoreMessage dsm = (DatabaseStoreMessage)data;
                    dsm.setReplyToken(0L);
                    dsm.setReplyTunnel(null);
                    dsm.setReplyGateway(null);
                    if (dsm.getEntry().getType() == 1) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Storing garlic LS down tunnel for: " + dsm.getKey() + " sent to: " + this._client);
                        }
                        this._context.inNetMessagePool().add(dsm, null, null);
                    } else {
                        if (this._client != null) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, 1L);
                            this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + dsm, (Throwable)new Exception("cause"));
                            return;
                        }
                        if (this._log.shouldLog(20)) {
                            this._log.info("Storing garlic RI down tunnel for: " + dsm.getKey() + " sent to: " + this._client);
                        }
                        this._context.inNetMessagePool().add(dsm, null, null);
                    }
                } else if (this._client != null && type == 3) {
                    DatabaseSearchReplyMessage orig = (DatabaseSearchReplyMessage)data;
                    if (orig.getNumReplies() > 0) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Removing replies from a garlic DSRM down a tunnel for " + this._client + ": " + data);
                        }
                        DatabaseSearchReplyMessage newMsg = new DatabaseSearchReplyMessage(this._context);
                        newMsg.setFromHash(orig.getFromHash());
                        newMsg.setSearchKey(orig.getSearchKey());
                        orig = newMsg;
                    }
                    this._context.inNetMessagePool().add(orig, null, null);
                } else if (type == 20) {
                    this._context.statManager().addRateData("tunnel.handleLoadClove", 1L, 0L);
                    data = null;
                } else if (this._client != null && type != 10) {
                    this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, (long)data.getType());
                    this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + data, (Throwable)new Exception("cause"));
                } else {
                    this._context.inNetMessagePool().add(data, null, null);
                }
                return;
            }
            case 1: {
                if (!(data instanceof DataMessage)) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("cant send a " + data.getClass().getName() + " to a destination");
                    }
                } else if (this._client != null && this._client.equals((Object)instructions.getDestination())) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("data message came down a tunnel for " + this._client);
                    }
                    DataMessage dm = (DataMessage)data;
                    Payload payload = new Payload();
                    payload.setEncryptedData(dm.getData());
                    ClientMessage m = new ClientMessage(this._client, payload);
                    this._context.clientManager().messageReceived(m);
                } else if (this._log.shouldLog(40)) {
                    this._log.error("this data message came down a tunnel for " + (this._client == null ? "no one" : this._client) + " but targetted " + instructions.getDestination());
                }
                return;
            }
            case 2: 
            case 3: {
                if (this._log.shouldLog(20)) {
                    this._log.info("clove targetted " + instructions.getRouter() + ":" + instructions.getTunnelId() + ", treat recursively to prevent leakage");
                }
                this.distribute(data, instructions.getRouter(), instructions.getTunnelId());
                return;
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Unknown instruction " + instructions.getDeliveryMode() + ": " + (Object)((Object)instructions));
        }
    }
}

