/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterIdentity;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PacketBuilder {
    private final I2PAppContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    static final int TYPE_FIRST = 42;
    static final int TYPE_ACK = 42;
    static final int TYPE_PUNCH = 43;
    static final int TYPE_RESP = 44;
    static final int TYPE_INTRO = 45;
    static final int TYPE_RREQ = 46;
    static final int TYPE_TCB = 47;
    static final int TYPE_TBC = 48;
    static final int TYPE_TTA = 49;
    static final int TYPE_TFA = 50;
    static final int TYPE_CONF = 51;
    static final int TYPE_SREQ = 52;
    static final int TYPE_CREAT = 53;
    public static final int HEADER_SIZE = 37;
    public static final int DATA_HEADER_SIZE = 46;
    public static final int IP_HEADER_SIZE = 20;
    public static final int UDP_HEADER_SIZE = 8;
    public static final int MIN_DATA_PACKET_OVERHEAD = 74;
    public static final int IPV6_HEADER_SIZE = 40;
    public static final int MIN_IPV6_DATA_PACKET_OVERHEAD = 94;
    public static final int ABSOLUTE_MAX_ACKS = 255;
    private static final int MAX_RESEND_ACKS_LARGE = 9;
    private static final int MAX_RESEND_ACKS_SMALL = 4;
    private static final String PROP_PADDING = "i2np.udp.padding";
    private static final boolean DEFAULT_ENABLE_PADDING = true;
    private static final byte SESSION_CREATED_FLAG_BYTE = 16;
    private static final byte SESSION_REQUEST_FLAG_BYTE = 0;
    private static final int MAX_IDENTITY_FRAGMENT_SIZE = 512;
    private static final byte SESSION_CONFIRMED_FLAG_BYTE = 32;
    private static final byte PEER_TEST_FLAG_BYTE = 112;
    private static final byte PEER_RELAY_REQUEST_FLAG_BYTE = 48;
    private static final byte PEER_RELAY_INTRO_FLAG_BYTE = 80;
    private static final byte PEER_RELAY_RESPONSE_FLAG_BYTE = 64;
    private static final int MAX_PAD2 = 16;

    public PacketBuilder(I2PAppContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._transport = transport;
        this._log = ctx.logManager().getLog(PacketBuilder.class);
    }

    public UDPPacket buildPacket(OutboundMessageState state, int fragment, PeerState peer, List<Long> ackIdsRemaining, int newAckCount, List<ACKBitfield> partialACKsRemaining) {
        int explicitToSend;
        int ipHeaderSize;
        int dataSize;
        UDPPacket packet = this.buildPacketHeader((byte)96);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        StringBuilder msg = null;
        if (this._log.shouldLog(20)) {
            msg = new StringBuilder(128);
            msg.append("Data pkt to ").append(peer.getRemotePeer().toBase64());
            msg.append(" msg ").append(state.getMessageId()).append(" frag:").append(fragment);
            msg.append('/').append(state.getFragmentCount());
        }
        if ((dataSize = state.fragmentSize(fragment)) < 0) {
            packet.release();
            return null;
        }
        int currentMTU = peer.getMTU();
        int availableForAcks = currentMTU - dataSize;
        if (peer.getRemoteIP().length == 4) {
            availableForAcks -= 74;
            ipHeaderSize = 20;
        } else {
            availableForAcks -= 94;
            ipHeaderSize = 40;
        }
        int availableForExplicitAcks = availableForAcks;
        int n = off;
        data[n] = (byte)(data[n] | 4);
        int partialAcksToSend = 0;
        if (availableForExplicitAcks >= 6 && !partialACKsRemaining.isEmpty()) {
            for (ACKBitfield bf : partialACKsRemaining) {
                if (partialAcksToSend >= 255) break;
                if (bf.receivedComplete()) continue;
                int acksz = 4 + bf.fragmentCount() / 7 + 1;
                if (partialAcksToSend == 0) {
                    ++acksz;
                }
                if (availableForExplicitAcks < acksz) break;
                availableForExplicitAcks -= acksz;
                ++partialAcksToSend;
            }
            if (partialAcksToSend > 0) {
                int n2 = off;
                data[n2] = (byte)(data[n2] | 0x40);
            }
        }
        if (availableForExplicitAcks >= 5 && !ackIdsRemaining.isEmpty()) {
            int n3 = off;
            data[n3] = (byte)(data[n3] | 0xFFFFFF80);
        }
        ++off;
        if (msg != null) {
            msg.append(" data: ").append(dataSize).append(" bytes, mtu: ").append(currentMTU).append(", ").append(newAckCount).append(" new full acks requested, ").append(ackIdsRemaining.size() - newAckCount).append(" resend acks requested, ").append(partialACKsRemaining.size()).append(" partial acks requested, ").append(availableForAcks).append(" avail. for all acks, ").append(availableForExplicitAcks).append(" for full acks, ");
        }
        if ((explicitToSend = Math.min(255, Math.min(newAckCount + (currentMTU > 620 ? 9 : 4), Math.min((availableForExplicitAcks - 1) / 4, ackIdsRemaining.size())))) > 0) {
            if (msg != null) {
                msg.append(explicitToSend).append(" full acks included:");
            }
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)explicitToSend);
            ++off;
            Iterator<Long> iter = ackIdsRemaining.iterator();
            for (int i = 0; i < explicitToSend && iter.hasNext(); ++i) {
                Long ackId = iter.next();
                iter.remove();
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)ackId);
                off += 4;
                if (msg == null) continue;
                msg.append(" full ack: ").append(ackId);
            }
        }
        if (partialAcksToSend > 0) {
            if (msg != null) {
                msg.append(partialAcksToSend).append(" partial acks included:");
            }
            int origNumRemaining = partialACKsRemaining.size();
            int numPartialOffset = off++;
            Iterator<ACKBitfield> iter = partialACKsRemaining.iterator();
            for (int i = 0; i < partialAcksToSend && iter.hasNext(); ++i) {
                ACKBitfield bitfield = iter.next();
                if (bitfield.receivedComplete()) continue;
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)bitfield.getMessageId());
                off += 4;
                int bits = bitfield.fragmentCount();
                int size = bits / 7 + 1;
                for (int curByte = 0; curByte < size; ++curByte) {
                    if (curByte + 1 < size) {
                        int n4 = off;
                        data[n4] = (byte)(data[n4] | 0xFFFFFF80);
                    }
                    for (int curBit = 0; curBit < 7; ++curBit) {
                        if (!bitfield.received(curBit + 7 * curByte)) continue;
                        int n5 = off;
                        data[n5] = (byte)(data[n5] | (byte)(1 << curBit));
                    }
                    ++off;
                }
                iter.remove();
                if (msg == null) continue;
                msg.append(" partial ack: ").append(bitfield);
            }
            DataHelper.toLong((byte[])data, (int)numPartialOffset, (int)1, (long)(origNumRemaining - partialACKsRemaining.size()));
        }
        DataHelper.toLong((byte[])data, (int)off, (int)1, (long)1L);
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)state.getMessageId());
        int n6 = off += 4;
        data[n6] = (byte)(data[n6] | fragment << 1);
        if (fragment == state.getFragmentCount() - 1) {
            int n7 = off;
            data[n7] = (byte)(data[n7] | 1);
        }
        DataHelper.toLong((byte[])data, (int)(++off), (int)2, (long)dataSize);
        int n8 = off;
        data[n8] = (byte)(data[n8] & 0x3F);
        int sizeWritten = state.writeFragment(data, off += 2, fragment);
        if (sizeWritten != dataSize) {
            if (sizeWritten < 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Write failed for fragment " + fragment + " of " + state.getMessageId());
                }
            } else {
                this._log.error("Size written: " + sizeWritten + " but size: " + dataSize + " for fragment " + fragment + " of " + state.getMessageId());
            }
            packet.release();
            return null;
        }
        if (dataSize == 0) {
            this._log.error("Sending zero-size fragment " + fragment + " of " + state + " for " + peer);
        }
        off += dataSize;
        off = this.pad1(data, off);
        off = this.pad2(data, off, currentMTU - (ipHeaderSize + 8));
        pkt.setLength(off);
        this.authenticate(packet, peer.getCurrentCipherKey(), peer.getCurrentMACKey());
        PacketBuilder.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        if (this._log.shouldLog(20)) {
            msg.append(" pkt size ").append(off + (ipHeaderSize + 8));
            this._log.info(msg.toString());
        }
        if (off + (ipHeaderSize + 8) > 1484) {
            this._log.error("Size is " + off + " for " + packet + " fragment " + fragment + " data size " + dataSize + " pkt size " + (off + (ipHeaderSize + 8)) + " MTU " + currentMTU + ' ' + availableForAcks + " for all acks " + availableForExplicitAcks + " for full acks " + explicitToSend + " full acks included " + partialAcksToSend + " partial acks included " + " OMS " + state, (Throwable)new Exception());
        }
        return packet;
    }

    public UDPPacket buildPing(PeerState peer) {
        return this.buildACK(peer, Collections.<ACKBitfield>emptyList());
    }

    public UDPPacket buildACK(PeerState peer, List<ACKBitfield> ackBitfields) {
        int i;
        UDPPacket packet = this.buildPacketHeader((byte)96);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        StringBuilder msg = null;
        if (this._log.shouldLog(10)) {
            msg = new StringBuilder(128);
            msg.append("building ACK packet to ").append(peer.getRemotePeer().toBase64().substring(0, 6));
        }
        int fullACKCount = 0;
        int partialACKCount = 0;
        for (i = 0; i < ackBitfields.size(); ++i) {
            if (ackBitfields.get(i).receivedComplete()) {
                ++fullACKCount;
                continue;
            }
            ++partialACKCount;
        }
        if (fullACKCount > 255 || partialACKCount > 255) {
            throw new IllegalArgumentException("Too many acks full/partial " + fullACKCount + '/' + partialACKCount);
        }
        if (fullACKCount > 0) {
            int n = off;
            data[n] = (byte)(data[n] | 0xFFFFFF80);
        }
        if (partialACKCount > 0) {
            int n = off;
            data[n] = (byte)(data[n] | 0x40);
        }
        ++off;
        if (fullACKCount > 0) {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)fullACKCount);
            ++off;
            for (i = 0; i < ackBitfields.size(); ++i) {
                ACKBitfield bf = ackBitfields.get(i);
                if (!bf.receivedComplete()) continue;
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)bf.getMessageId());
                off += 4;
                if (msg == null) continue;
                msg.append(" full ack: ").append(bf.getMessageId());
            }
        }
        if (partialACKCount > 0) {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)partialACKCount);
            ++off;
            for (i = 0; i < ackBitfields.size(); ++i) {
                ACKBitfield bitfield = ackBitfields.get(i);
                if (bitfield.receivedComplete()) continue;
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)bitfield.getMessageId());
                off += 4;
                int bits = bitfield.fragmentCount();
                int size = bits / 7 + 1;
                for (int curByte = 0; curByte < size; ++curByte) {
                    if (curByte + 1 < size) {
                        int n = off;
                        data[n] = (byte)(data[n] | 0xFFFFFF80);
                    }
                    for (int curBit = 0; curBit < 7; ++curBit) {
                        if (!bitfield.received(curBit + 7 * curByte)) continue;
                        int n = off;
                        data[n] = (byte)(data[n] | (byte)(1 << curBit));
                    }
                    ++off;
                }
                if (msg == null) continue;
                msg.append(" partial ack: ").append(bitfield);
            }
        }
        DataHelper.toLong((byte[])data, (int)off, (int)1, (long)0L);
        ++off;
        if (msg != null) {
            this._log.debug(msg.toString());
        }
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, peer.getCurrentCipherKey(), peer.getCurrentMACKey());
        PacketBuilder.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        return packet;
    }

    public UDPPacket buildSessionCreatedPacket(InboundEstablishState state, int externalPort, SessionKey ourIntroKey) {
        UDPPacket packet = this.buildPacketHeader((byte)16);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(state.getSentIP());
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did we think this was a valid IP?  " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        state.prepareSessionCreated();
        byte[] sentIP = state.getSentIP();
        if (sentIP == null || sentIP.length <= 0 || !this._transport.isValid(sentIP)) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did our sent IP become invalid? " + state);
            }
            state.fail();
            packet.release();
            return null;
        }
        System.arraycopy(state.getSentY(), 0, data, off, state.getSentY().length);
        DataHelper.toLong((byte[])data, (int)(off += state.getSentY().length), (int)1, (long)sentIP.length);
        System.arraycopy(sentIP, 0, data, ++off, sentIP.length);
        DataHelper.toLong((byte[])data, (int)(off += sentIP.length), (int)2, (long)state.getSentPort());
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)4, (long)state.getSentRelayTag());
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)4, (long)state.getSentSignedOnTime());
        System.arraycopy(state.getSentSignature().getData(), 0, data, off += 4, Signature.SIGNATURE_BYTES);
        off += Signature.SIGNATURE_BYTES;
        long l = this._context.random().nextLong();
        if (l < 0L) {
            l = 0L - l;
        }
        DataHelper.toLong((byte[])data, (int)off, (int)8, (long)l);
        off += 8;
        if (this._log.shouldLog(10)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Sending sessionCreated:");
            buf.append(" Alice: ").append(Addresses.toString((byte[])sentIP, (int)state.getSentPort()));
            buf.append(" Bob: ").append(Addresses.toString((byte[])state.getReceivedOurIP(), (int)externalPort));
            buf.append(" RelayTag: ").append(state.getSentRelayTag());
            buf.append(" SignedOn: ").append(state.getSentSignedOnTime());
            buf.append(" signature: ").append(Base64.encode((byte[])state.getSentSignature().getData()));
            buf.append("\nRawCreated: ").append(Base64.encode((byte[])data, (int)0, (int)off));
            buf.append("\nsignedTime: ").append(Base64.encode((byte[])data, (int)(off - 8 - Signature.SIGNATURE_BYTES - 4), (int)4));
            this._log.debug(buf.toString());
        }
        byte[] iv = SimpleByteCache.acquire((int)16);
        this._context.random().nextBytes(iv);
        int encrWrite = Signature.SIGNATURE_BYTES + 8;
        int sigBegin = off - encrWrite;
        this._context.aes().encrypt(data, sigBegin, data, sigBegin, state.getCipherKey(), iv, encrWrite);
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, ourIntroKey, ourIntroKey, iv);
        PacketBuilder.setTo(packet, to, state.getSentPort());
        SimpleByteCache.release((byte[])iv);
        packet.setMessageType(53);
        return packet;
    }

    public UDPPacket buildSessionRequestPacket(OutboundEstablishState state) {
        UDPPacket packet = this.buildPacketHeader((byte)0);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        byte[] toIP = state.getSentIP();
        if (!this._transport.isValid(toIP)) {
            packet.release();
            return null;
        }
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(toIP);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did we think this was a valid IP?  " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending request to " + Addresses.toString((byte[])toIP));
        }
        byte[] x = state.getSentX();
        System.arraycopy(x, 0, data, off, x.length);
        DataHelper.toLong((byte[])data, (int)(off += x.length), (int)1, (long)toIP.length);
        System.arraycopy(toIP, 0, data, ++off, toIP.length);
        int port = state.getSentPort();
        DataHelper.toLong((byte[])data, (int)(off += toIP.length), (int)2, (long)port);
        off += 2;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, state.getIntroKey(), state.getIntroKey());
        PacketBuilder.setTo(packet, to, port);
        packet.setMessageType(52);
        return packet;
    }

    public UDPPacket[] buildSessionConfirmedPackets(OutboundEstablishState state, RouterIdentity ourIdentity) {
        byte[] identity = ourIdentity.toByteArray();
        int numFragments = identity.length / 512;
        if (numFragments * 512 != identity.length) {
            ++numFragments;
        }
        UDPPacket[] packets = new UDPPacket[numFragments];
        for (int i = 0; i < numFragments; ++i) {
            packets[i] = this.buildSessionConfirmedPacket(state, i, numFragments, identity);
        }
        return packets;
    }

    private UDPPacket buildSessionConfirmedPacket(OutboundEstablishState state, int fragmentNum, int numFragments, byte[] identity) {
        UDPPacket packet = this.buildPacketHeader((byte)32);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(state.getSentIP());
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did we think this was a valid IP?  " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        int n = off;
        data[n] = (byte)(data[n] | fragmentNum << 4);
        int n2 = off++;
        data[n2] = (byte)(data[n2] | numFragments & 0xF);
        int curFragSize = 512;
        if (fragmentNum == numFragments - 1 && identity.length % 512 != 0) {
            curFragSize = identity.length % 512;
        }
        DataHelper.toLong((byte[])data, (int)off, (int)2, (long)curFragSize);
        int curFragOffset = fragmentNum * 512;
        System.arraycopy(identity, curFragOffset, data, off += 2, curFragSize);
        off += curFragSize;
        if (fragmentNum == numFragments - 1) {
            DataHelper.toLong((byte[])data, (int)off, (int)4, (long)state.getSentSignedOnTime());
            int mod = (off += 4) + Signature.SIGNATURE_BYTES & 0xF;
            if (mod != 0) {
                int paddingRequired = 16 - mod;
                this._context.random().nextBytes(data, off, paddingRequired);
                off += paddingRequired;
            }
            System.arraycopy(state.getSentSignature().getData(), 0, data, off, Signature.SIGNATURE_BYTES);
            off += Signature.SIGNATURE_BYTES;
        } else {
            off = this.pad1(data, off);
        }
        pkt.setLength(off);
        this.authenticate(packet, state.getCipherKey(), state.getMACKey());
        PacketBuilder.setTo(packet, to, state.getSentPort());
        packet.setMessageType(51);
        return packet;
    }

    public UDPPacket buildSessionDestroyPacket(PeerState peer) {
        if (this._log.shouldLog(10)) {
            this._log.debug("building session destroy packet to " + peer.getRemotePeer());
        }
        return this.buildSessionDestroyPacket(peer.getCurrentCipherKey(), peer.getCurrentMACKey(), peer.getRemoteIPAddress(), peer.getRemotePort());
    }

    public UDPPacket buildSessionDestroyPacket(OutboundEstablishState peer) {
        InetAddress addr;
        SessionKey cipherKey = peer.getCipherKey();
        SessionKey macKey = peer.getMACKey();
        byte[] ip = peer.getSentIP();
        int port = peer.getSentPort();
        if (cipherKey == null || macKey == null || ip == null || port <= 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Cannot send destroy, incomplete " + peer);
            }
            return null;
        }
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("building session destroy packet to " + peer);
        }
        return this.buildSessionDestroyPacket(cipherKey, macKey, addr, port);
    }

    public UDPPacket buildSessionDestroyPacket(InboundEstablishState peer) {
        InetAddress addr;
        SessionKey cipherKey = peer.getCipherKey();
        SessionKey macKey = peer.getMACKey();
        byte[] ip = peer.getSentIP();
        int port = peer.getSentPort();
        if (cipherKey == null || macKey == null || ip == null || port <= 0) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Cannot send destroy, incomplete " + peer);
            }
            return null;
        }
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("building session destroy packet to " + peer);
        }
        return this.buildSessionDestroyPacket(cipherKey, macKey, addr, port);
    }

    private UDPPacket buildSessionDestroyPacket(SessionKey cipherKey, SessionKey macKey, InetAddress addr, int port) {
        UDPPacket packet = this.buildPacketHeader((byte)-128);
        int off = 37;
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, cipherKey, macKey);
        PacketBuilder.setTo(packet, addr, port);
        return packet;
    }

    public UDPPacket buildPeerTestFromAlice(InetAddress toIP, int toPort, SessionKey toIntroKey, long nonce, SessionKey aliceIntroKey) {
        return this.buildPeerTestFromAlice(toIP, toPort, toIntroKey, toIntroKey, nonce, aliceIntroKey);
    }

    public UDPPacket buildPeerTestFromAlice(InetAddress toIP, int toPort, SessionKey toCipherKey, SessionKey toMACKey, long nonce, SessionKey aliceIntroKey) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Bob");
        }
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)nonce);
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)0L);
        DataHelper.toLong((byte[])data, (int)(++off), (int)2, (long)0L);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, toCipherKey, toMACKey);
        PacketBuilder.setTo(packet, toIP, toPort);
        packet.setMessageType(50);
        return packet;
    }

    public UDPPacket buildPeerTestToAlice(InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, SessionKey charlieIntroKey, long nonce) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Alice");
        }
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)nonce);
        byte[] ip = aliceIP.getAddress();
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alicePort);
        System.arraycopy(charlieIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, aliceIntroKey, aliceIntroKey);
        PacketBuilder.setTo(packet, aliceIP, alicePort);
        packet.setMessageType(49);
        return packet;
    }

    public UDPPacket buildPeerTestToCharlie(InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, long nonce, InetAddress charlieIP, int charliePort, SessionKey charlieCipherKey, SessionKey charlieMACKey) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Charlie");
        }
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)nonce);
        byte[] ip = aliceIP.getAddress();
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alicePort);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, charlieCipherKey, charlieMACKey);
        PacketBuilder.setTo(packet, charlieIP, charliePort);
        packet.setMessageType(48);
        return packet;
    }

    public UDPPacket buildPeerTestToBob(InetAddress bobIP, int bobPort, InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, long nonce, SessionKey bobCipherKey, SessionKey bobMACKey) {
        UDPPacket packet = this.buildPacketHeader((byte)112);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Bob");
        }
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)nonce);
        byte[] ip = aliceIP.getAddress();
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alicePort);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        off += 32;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, bobCipherKey, bobMACKey);
        PacketBuilder.setTo(packet, bobIP, bobPort);
        packet.setMessageType(47);
        return packet;
    }

    private byte[] getOurExplicitIP() {
        return null;
    }

    private int getOurExplicitPort() {
        return 0;
    }

    public List<UDPPacket> buildRelayRequest(UDPTransport transport, OutboundEstablishState state, SessionKey ourIntroKey) {
        UDPAddress addr = state.getRemoteAddress();
        int count = addr.getIntroducerCount();
        ArrayList<UDPPacket> rv = new ArrayList<UDPPacket>(count);
        for (int i = 0; i < count; ++i) {
            InetAddress iaddr = addr.getIntroducerHost(i);
            int iport = addr.getIntroducerPort(i);
            byte[] ikey = addr.getIntroducerKey(i);
            long tag = addr.getIntroducerTag(i);
            if (ikey == null || iport < 1024 || iport > 65535 || iaddr == null || tag <= 0L || iaddr.getAddress().length != 4 || !this._transport.isValid(iaddr.getAddress()) || Arrays.equals(iaddr.getAddress(), this._transport.getExternalIP()) && !this._transport.allowLocal()) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Cannot build a relay request to " + state.getRemoteIdentity().calculateHash() + ", as their UDP address is invalid: addr=" + addr + " index=" + i);
                continue;
            }
            rv.add(this.buildRelayRequest(iaddr, iport, ikey, tag, ourIntroKey, state.getIntroNonce(), true));
        }
        return rv;
    }

    private UDPPacket buildRelayRequest(InetAddress introHost, int introPort, byte[] introKey, long introTag, SessionKey ourIntroKey, long introNonce, boolean encrypt) {
        UDPPacket packet = this.buildPacketHeader((byte)48);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        byte[] ourIP = this.getOurExplicitIP();
        int ourPort = this.getOurExplicitPort();
        if (this._log.shouldLog(20)) {
            this._log.info("Sending intro relay request to " + introHost + ":" + introPort);
        }
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)introTag);
        off += 4;
        if (ourIP != null) {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)ourIP.length);
            System.arraycopy(ourIP, 0, data, ++off, ourIP.length);
            off += ourIP.length;
        } else {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)0L);
            ++off;
        }
        DataHelper.toLong((byte[])data, (int)off, (int)2, (long)ourPort);
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)1, (long)0L);
        System.arraycopy(ourIntroKey.getData(), 0, data, ++off, 32);
        off += 32;
        if (this._log.shouldLog(10)) {
            this._log.debug("wrote alice intro key: " + Base64.encode((byte[])data, (int)(off - 32), (int)32) + " with nonce " + introNonce + " size=" + (off + 4 + (16 - (off + 4) % 16)) + " and data: " + Base64.encode((byte[])data, (int)0, (int)off));
        }
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)introNonce);
        off += 4;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        if (encrypt) {
            this.authenticate(packet, new SessionKey(introKey), new SessionKey(introKey));
        }
        PacketBuilder.setTo(packet, introHost, introPort);
        packet.setMessageType(46);
        return packet;
    }

    UDPPacket buildRelayIntro(RemoteHostId alice, PeerState charlie, UDPPacketReader.RelayRequestReader request) {
        UDPPacket packet = this.buildPacketHeader((byte)80);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldLog(20)) {
            this._log.info("Sending intro to " + charlie + " for " + alice);
        }
        byte[] ip = alice.getIP();
        DataHelper.toLong((byte[])data, (int)off, (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alice.getPort());
        int sz = request.readChallengeSize();
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)1, (long)sz);
        ++off;
        if (sz > 0) {
            request.readChallengeSize(data, off);
            off += sz;
        }
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, charlie.getCurrentCipherKey(), charlie.getCurrentMACKey());
        PacketBuilder.setTo(packet, charlie.getRemoteIPAddress(), charlie.getRemotePort());
        packet.setMessageType(45);
        return packet;
    }

    UDPPacket buildRelayResponse(RemoteHostId alice, PeerState charlie, long nonce, SessionKey aliceIntroKey) {
        InetAddress aliceAddr = null;
        try {
            aliceAddr = InetAddress.getByAddress(alice.getIP());
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        UDPPacket packet = this.buildPacketHeader((byte)64);
        DatagramPacket pkt = packet.getPacket();
        byte[] data = pkt.getData();
        int off = 37;
        if (this._log.shouldLog(20)) {
            this._log.info("Sending relay response to " + alice + " for " + charlie + " with alice's intro key " + aliceIntroKey);
        }
        byte[] charlieIP = charlie.getRemoteIP();
        DataHelper.toLong((byte[])data, (int)off, (int)1, (long)charlieIP.length);
        System.arraycopy(charlieIP, 0, data, ++off, charlieIP.length);
        DataHelper.toLong((byte[])data, (int)(off += charlieIP.length), (int)2, (long)charlie.getRemotePort());
        byte[] aliceIP = alice.getIP();
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)1, (long)aliceIP.length);
        System.arraycopy(aliceIP, 0, data, ++off, aliceIP.length);
        DataHelper.toLong((byte[])data, (int)(off += aliceIP.length), (int)2, (long)alice.getPort());
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)4, (long)nonce);
        off += 4;
        off = this.pad1(data, off);
        off = this.pad2(data, off);
        pkt.setLength(off);
        this.authenticate(packet, aliceIntroKey, aliceIntroKey);
        PacketBuilder.setTo(packet, aliceAddr, alice.getPort());
        packet.setMessageType(44);
        return packet;
    }

    public UDPPacket buildHolePunch(InetAddress to, int port) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        if (this._log.shouldLog(20)) {
            this._log.info("Sending relay hole punch to " + to + ":" + port);
        }
        packet.getPacket().setLength(0);
        PacketBuilder.setTo(packet, to, port);
        packet.setMessageType(43);
        return packet;
    }

    public UDPPacket buildPacket(byte[] data, InetAddress to, int port) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] d = packet.getPacket().getData();
        System.arraycopy(data, 0, d, 0, data.length);
        packet.getPacket().setLength(data.length);
        PacketBuilder.setTo(packet, to, port);
        return packet;
    }

    private UDPPacket buildPacketHeader(byte flagByte) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = flagByte;
        long now = (this._context.clock().now() + 500L) / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        return packet;
    }

    private static void setTo(UDPPacket packet, InetAddress ip, int port) {
        DatagramPacket pkt = packet.getPacket();
        pkt.setAddress(ip);
        pkt.setPort(port);
    }

    private int pad1(byte[] data, int off) {
        int mod = off & 0xF;
        if (mod == 0) {
            return off;
        }
        int padSize = 16 - mod;
        this._context.random().nextBytes(data, off, padSize);
        return off + padSize;
    }

    private int pad2(byte[] data, int off) {
        if (!this._context.getProperty(PROP_PADDING, true)) {
            return off;
        }
        int padSize = this._context.random().nextInt(16);
        if (padSize == 0) {
            return off;
        }
        this._context.random().nextBytes(data, off, padSize);
        return off + padSize;
    }

    private int pad2(byte[] data, int off, int maxLen) {
        if (!this._context.getProperty(PROP_PADDING, true)) {
            return off;
        }
        if (off >= maxLen) {
            return off;
        }
        int padSize = this._context.random().nextInt(Math.min(16, 1 + maxLen - off));
        if (padSize == 0) {
            return off;
        }
        this._context.random().nextBytes(data, off, padSize);
        return off + padSize;
    }

    private void authenticate(UDPPacket packet, SessionKey cipherKey, SessionKey macKey) {
        byte[] iv = SimpleByteCache.acquire((int)16);
        this._context.random().nextBytes(iv);
        this.authenticate(packet, cipherKey, macKey, iv);
        SimpleByteCache.release((byte[])iv);
    }

    private void authenticate(UDPPacket packet, SessionKey cipherKey, SessionKey macKey, byte[] iv) {
        int off;
        long before = System.currentTimeMillis();
        DatagramPacket pkt = packet.getPacket();
        int hmacOff = off = pkt.getOffset();
        int encryptOffset = off + 16 + 16;
        int totalSize = pkt.getLength() - 16 - 16 - off;
        int mod = totalSize & 0xF;
        int encryptSize = totalSize - mod;
        byte[] data = pkt.getData();
        this._context.aes().encrypt(data, encryptOffset, data, encryptOffset, cipherKey, iv, encryptSize);
        System.arraycopy(data, encryptOffset, data, off, totalSize);
        System.arraycopy(iv, 0, data, off += totalSize, 16);
        DataHelper.toLong((byte[])data, (int)(off += 16), (int)2, (long)totalSize);
        int hmacLen = totalSize + 16 + 2;
        byte[] ba = SimpleByteCache.acquire((int)32);
        this._context.hmac().calculate(macKey, data, hmacOff, hmacLen, ba, 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("Authenticating " + pkt.getLength() + "\nIV: " + Base64.encode((byte[])iv) + "\nraw mac: " + Base64.encode((byte[])ba) + "\nMAC key: " + macKey);
        }
        System.arraycopy(data, hmacOff, data, encryptOffset, totalSize);
        System.arraycopy(ba, 0, data, hmacOff, 16);
        SimpleByteCache.release((byte[])ba);
        System.arraycopy(iv, 0, data, hmacOff + 16, 16);
        long timeToAuth = System.currentTimeMillis() - before;
        this._context.statManager().addRateData("udp.packetAuthTime", timeToAuth, timeToAuth);
        if (timeToAuth > 100L) {
            this._context.statManager().addRateData("udp.packetAuthTimeSlow", timeToAuth, timeToAuth);
        }
    }
}

