/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundMessageRegistry {
    private final Log _log;
    private final List<MessageSelector> _selectors;
    private final Map<MessageSelector, Object> _selectorToMessage;
    private final Set<OutNetMessage> _activeMessages;
    private final CleanupTask _cleanupTask;
    private final RouterContext _context;

    public OutboundMessageRegistry(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(OutboundMessageRegistry.class);
        this._selectors = new ArrayList<MessageSelector>(64);
        this._selectorToMessage = new HashMap<MessageSelector, Object>(64);
        this._activeMessages = new ConcurrentHashSet(64);
        this._cleanupTask = new CleanupTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this._selectors;
        synchronized (object) {
            this._selectors.clear();
        }
        object = this._selectorToMessage;
        synchronized (object) {
            this._selectorToMessage.clear();
        }
        this._activeMessages.clear();
    }

    public void restart() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutNetMessage> getOriginalMessages(I2NPMessage message) {
        ArrayList<MessageSelector> matchedSelectors = null;
        ArrayList<MessageSelector> removedSelectors = null;
        List<MessageSelector> list = this._selectors;
        synchronized (list) {
            for (int i = 0; i < this._selectors.size(); ++i) {
                MessageSelector sel = this._selectors.get(i);
                boolean isMatch = sel.isMatch(message);
                if (!isMatch) continue;
                if (matchedSelectors == null) {
                    matchedSelectors = new ArrayList<MessageSelector>(1);
                }
                matchedSelectors.add(sel);
                if (sel.continueMatching()) continue;
                if (removedSelectors == null) {
                    removedSelectors = new ArrayList<MessageSelector>(1);
                }
                removedSelectors.add(sel);
                this._selectors.remove(i);
                --i;
            }
        }
        List<OutNetMessage> rv = null;
        if (matchedSelectors != null) {
            rv = new ArrayList<OutNetMessage>(matchedSelectors.size());
            for (MessageSelector sel : matchedSelectors) {
                boolean removed = false;
                OutNetMessage msg = null;
                List msgs = null;
                Map<MessageSelector, Object> map = this._selectorToMessage;
                synchronized (map) {
                    Object o = null;
                    if (removedSelectors != null && removedSelectors.contains(sel)) {
                        o = this._selectorToMessage.remove(sel);
                        removed = true;
                    } else {
                        o = this._selectorToMessage.get(sel);
                    }
                    if (o instanceof OutNetMessage) {
                        msg = (OutNetMessage)o;
                        rv.add(msg);
                    } else if (o instanceof List) {
                        msgs = (List)o;
                        rv.addAll(msgs);
                    }
                }
                if (!removed) continue;
                if (msg != null) {
                    this._activeMessages.remove(msg);
                    continue;
                }
                if (msgs == null) continue;
                this._activeMessages.removeAll(msgs);
            }
        } else {
            rv = Collections.emptyList();
        }
        return rv;
    }

    public OutNetMessage registerPending(MessageSelector replySelector, ReplyJob onReply, Job onTimeout, int timeoutMs) {
        OutNetMessage msg = new OutNetMessage(this._context, this._context.clock().now() + (long)timeoutMs);
        msg.setOnFailedReplyJob(onTimeout);
        msg.setOnFailedSendJob(onTimeout);
        msg.setOnReplyJob(onReply);
        msg.setReplySelector(replySelector);
        this.registerPending(msg, true);
        return msg;
    }

    public void registerPending(OutNetMessage msg) {
        this.registerPending(msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPending(OutNetMessage msg, boolean allowEmpty) {
        if (!allowEmpty && msg.getMessage() == null) {
            throw new IllegalArgumentException("OutNetMessage doesn't contain an I2NPMessage? wtf");
        }
        MessageSelector sel = msg.getReplySelector();
        if (sel == null) {
            throw new IllegalArgumentException("No reply selector?  wtf");
        }
        if (!this._activeMessages.add(msg)) {
            return;
        }
        Object object = this._selectorToMessage;
        synchronized (object) {
            Object oldMsg = this._selectorToMessage.put(sel, msg);
            if (oldMsg != null) {
                List<OutNetMessage> multi = null;
                if (oldMsg instanceof OutNetMessage) {
                    multi = new ArrayList<OutNetMessage>(4);
                    multi.add((OutNetMessage)oldMsg);
                    multi.add(msg);
                    this._selectorToMessage.put(sel, multi);
                } else if (oldMsg instanceof List) {
                    multi = (List)oldMsg;
                    multi.add(msg);
                    this._selectorToMessage.put(sel, multi);
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("a single message selector [" + sel + "] with multiple messages (" + multi + ")");
                }
            }
        }
        object = this._selectors;
        synchronized (object) {
            this._selectors.add(sel);
        }
        this._cleanupTask.scheduleExpiration(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPending(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        MessageSelector sel = msg.getReplySelector();
        boolean stillActive = false;
        Object object = this._selectorToMessage;
        synchronized (object) {
            Object old = this._selectorToMessage.remove(sel);
            if (old != null && old instanceof List) {
                List l = (List)old;
                l.remove(msg);
                if (!l.isEmpty()) {
                    this._selectorToMessage.put(sel, l);
                    stillActive = true;
                }
            }
        }
        if (!stillActive) {
            object = this._selectors;
            synchronized (object) {
                this._selectors.remove(sel);
            }
        }
        this._activeMessages.remove(msg);
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    private class CleanupTask
    extends SimpleTimer2.TimedEvent {
        private long _nextExpire;

        public CleanupTask() {
            super(OutboundMessageRegistry.this._context.simpleTimer2());
            this._nextExpire = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            long now = OutboundMessageRegistry.this._context.clock().now();
            ArrayList<MessageSelector> removing = new ArrayList<MessageSelector>(8);
            List list = OutboundMessageRegistry.this._selectors;
            synchronized (list) {
                for (int i = 0; i < OutboundMessageRegistry.this._selectors.size(); ++i) {
                    MessageSelector sel = (MessageSelector)OutboundMessageRegistry.this._selectors.get(i);
                    long expiration = sel.getExpiration();
                    if (expiration <= now) {
                        removing.add(sel);
                        OutboundMessageRegistry.this._selectors.remove(i);
                        --i;
                        continue;
                    }
                    if (expiration >= this._nextExpire && this._nextExpire >= now) continue;
                    this._nextExpire = expiration;
                }
            }
            if (!removing.isEmpty()) {
                for (MessageSelector sel : removing) {
                    OutNetMessage msg = null;
                    List msgs = null;
                    Map map = OutboundMessageRegistry.this._selectorToMessage;
                    synchronized (map) {
                        Object o = OutboundMessageRegistry.this._selectorToMessage.remove(sel);
                        if (o instanceof OutNetMessage) {
                            msg = (OutNetMessage)o;
                        } else if (o instanceof List) {
                            msgs = (List)o;
                        }
                    }
                    if (msg != null) {
                        OutboundMessageRegistry.this._activeMessages.remove(msg);
                        Job fail = msg.getOnFailedReplyJob();
                        if (fail == null) continue;
                        OutboundMessageRegistry.this._context.jobQueue().addJob(fail);
                        continue;
                    }
                    if (msgs == null) continue;
                    OutboundMessageRegistry.this._activeMessages.removeAll(msgs);
                    for (OutNetMessage m : msgs) {
                        Job fail = m.getOnFailedReplyJob();
                        if (fail == null) continue;
                        OutboundMessageRegistry.this._context.jobQueue().addJob(fail);
                    }
                }
            }
            if (this._nextExpire <= now) {
                this._nextExpire = now + 10000L;
            }
            this.schedule(this._nextExpire - now);
        }

        public void scheduleExpiration(MessageSelector sel) {
            long now = OutboundMessageRegistry.this._context.clock().now();
            if (this._nextExpire <= now || sel.getExpiration() < this._nextExpire) {
                this._nextExpire = sel.getExpiration();
                this.reschedule(this._nextExpire - now);
            }
        }
    }
}

