/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.BadCountries;
import net.i2p.router.transport.GeoIP;
import net.i2p.router.transport.GetBidsJob;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportManager;
import net.i2p.util.Addresses;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommSystemFacadeImpl
extends CommSystemFacade {
    private final Log _log;
    private final RouterContext _context;
    private final TransportManager _manager;
    private final GeoIP _geoIP;
    private volatile boolean _netMonitorStatus;
    private boolean _wasStarted;
    private static final String PROP_DISABLED = "i2np.disable";
    private static final int START_DELAY = 300000;
    private static final int LOOKUP_TIME = 1800000;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final String COUNTRY_BUNDLE_NAME = "net.i2p.router.countries.messages";
    private static final int TIME_START_DELAY = 300000;
    private static final int TIME_REPEAT_DELAY = 600000;

    public CommSystemFacadeImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(CommSystemFacadeImpl.class);
        this._netMonitorStatus = true;
        this._geoIP = new GeoIP(this._context);
        this._manager = new TransportManager(this._context);
        this.startGeoIP();
    }

    @Override
    public synchronized void startup() {
        this._log.info("Starting up the comm system");
        this._manager.startListening();
        this.startTimestamper();
        this.startNetMonitor();
        this._wasStarted = true;
    }

    @Override
    public synchronized void shutdown() {
        this._manager.shutdown();
        this._geoIP.shutdown();
    }

    @Override
    public synchronized void restart() {
        if (!this._wasStarted) {
            this.startup();
        } else {
            this._manager.restart();
        }
    }

    @Override
    public int countActivePeers() {
        return this._manager.countActivePeers();
    }

    @Override
    public int countActiveSendPeers() {
        return this._manager.countActiveSendPeers();
    }

    @Override
    public boolean haveInboundCapacity(int pct) {
        return this._manager.haveInboundCapacity(pct);
    }

    @Override
    public boolean haveOutboundCapacity(int pct) {
        return this._manager.haveOutboundCapacity(pct);
    }

    @Override
    public boolean haveHighOutboundCapacity() {
        return this._manager.haveHighOutboundCapacity();
    }

    @Override
    public long getFramedAveragePeerClockSkew(int percentToInclude) {
        Vector<Long> skews = this._manager.getClockSkews();
        if (skews == null || skews.isEmpty() || skews.size() < 5 && this._context.clock().getUpdatedSuccessfully()) {
            return this._context.clock().getOffset();
        }
        Collections.sort(skews);
        if (this._log.shouldLog(10)) {
            this._log.debug("Clock skews: " + skews);
        }
        int frameSize = Math.max(skews.size() * percentToInclude / 100, 1);
        int first = skews.size() / 2 - frameSize / 2;
        int last = Math.min(skews.size() / 2 + frameSize / 2, skews.size() - 1);
        long sum = 0L;
        for (int i = first; i <= last; ++i) {
            long value = skews.get(i);
            sum += value;
        }
        return sum * 1000L / (long)frameSize;
    }

    @Override
    public void processMessage(OutNetMessage msg) {
        if (this.isDummy()) {
            GetBidsJob.fail(this._context, msg);
            return;
        }
        GetBidsJob.getBids(this._context, this._manager, msg);
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        return this._manager.isBacklogged(dest);
    }

    @Override
    public boolean isEstablished(Hash dest) {
        return this._manager.isEstablished(dest);
    }

    @Override
    public boolean wasUnreachable(Hash dest) {
        return this._manager.wasUnreachable(dest);
    }

    @Override
    public byte[] getIP(Hash dest) {
        return this._manager.getIP(dest);
    }

    @Override
    public List<String> getMostRecentErrorMessages() {
        return this._manager.getMostRecentErrorMessages();
    }

    @Override
    public short getReachabilityStatus() {
        if (!this._netMonitorStatus) {
            return 3;
        }
        short rv = this._manager.getReachabilityStatus();
        if (rv != 4 && this._context.router().isHidden()) {
            return 0;
        }
        return rv;
    }

    @Override
    public void recheckReachability() {
        this._manager.recheckReachability();
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this._manager.renderStatusHTML(out, urlBase, sortFlags);
    }

    @Override
    public List<RouterAddress> createAddresses() {
        ArrayList<RouterAddress> addresses = new ArrayList<RouterAddress>(this._manager.getAddresses());
        if (this._log.shouldLog(20)) {
            this._log.info("Creating addresses: " + addresses, (Throwable)new Exception("creator"));
        }
        return addresses;
    }

    @Override
    public void notifyReplaceAddress(RouterAddress udpAddr) {
        Transport udp;
        int port;
        byte[] ip = udpAddr != null ? udpAddr.getIP() : null;
        int n = port = udpAddr != null ? udpAddr.getPort() : 0;
        if (port < 0 && (udp = this._manager.getTransport("SSU")) != null) {
            port = udp.getRequestedPort();
        }
        this._manager.externalAddressReceived(Transport.AddressSource.SOURCE_SSU, ip, port);
    }

    private void startGeoIP() {
        this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new QueueAll(), 300000L);
    }

    @Override
    public void queueLookup(byte[] ip) {
        this._geoIP.add(ip);
    }

    @Override
    public String getOurCountry() {
        return this._context.getProperty("i2np.lastCountry");
    }

    @Override
    public boolean isInBadCountry() {
        String us = this.getOurCountry();
        return us != null && (BadCountries.contains(us) || this._context.getBooleanProperty("router.forceBadCountry"));
    }

    @Override
    public String getCountry(Hash peer) {
        byte[] ip = TransportImpl.getIP(peer);
        if (ip != null) {
            return this._geoIP.get(ip);
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return null;
        }
        ip = CommSystemFacadeImpl.getIP(ri);
        if (ip != null) {
            return this._geoIP.get(ip);
        }
        return null;
    }

    private static byte[] getIP(RouterInfo ri) {
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    @Override
    public String getCountryName(String c) {
        if (this._geoIP == null) {
            return c;
        }
        String n = this._geoIP.fullName(c);
        if (n == null) {
            return c;
        }
        return n;
    }

    @Override
    public String renderPeerHTML(Hash peer) {
        boolean found;
        String h = peer.toBase64().substring(0, 4);
        StringBuilder buf = new StringBuilder(128);
        String c = this.getCountry(peer);
        if (c != null) {
            String countryName = this.getCountryName(c);
            if (countryName.length() > 2) {
                countryName = Translate.getString((String)countryName, (I2PAppContext)this._context, (String)COUNTRY_BUNDLE_NAME);
            }
            buf.append("<img height=\"11\" width=\"16\" alt=\"").append(c.toUpperCase(Locale.US)).append("\" title=\"");
            buf.append(countryName);
            buf.append("\" src=\"/flags.jsp?c=").append(c).append("\"> ");
        }
        buf.append("<tt>");
        boolean bl = found = this._context.netDb().lookupRouterInfoLocally(peer) != null;
        if (found) {
            buf.append("<a title=\"").append(this._("NetDb entry")).append("\" href=\"netdb?r=").append(h).append("\">");
        }
        buf.append(h);
        if (found) {
            buf.append("</a>");
        }
        buf.append("</tt>");
        return buf.toString();
    }

    @Override
    public boolean isDummy() {
        return this._context.getBooleanProperty(PROP_DISABLED);
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private void startTimestamper() {
        this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new Timestamper(), 300000L, 600000L);
    }

    private void startNetMonitor() {
        new NetMonitor();
    }

    private class Lookup
    implements SimpleTimer.TimedEvent {
        private Lookup() {
        }

        public void timeReached() {
            new LookupThread().start();
        }
    }

    private class LookupThread
    extends I2PThread {
        public LookupThread() {
            super("GeoIP Lookup");
            this.setDaemon(true);
        }

        public void run() {
            long start = System.currentTimeMillis();
            CommSystemFacadeImpl.this._geoIP.blockingLookup();
            if (CommSystemFacadeImpl.this._log.shouldLog(20)) {
                CommSystemFacadeImpl.this._log.info("GeoIP lookup took " + (System.currentTimeMillis() - start));
            }
        }
    }

    private class NetMonitor
    extends SimpleTimer2.TimedEvent {
        private static final long SHORT_DELAY = 15000L;
        private static final long LONG_DELAY = 180000L;

        public NetMonitor() {
            super(CommSystemFacadeImpl.this._context.simpleTimer2(), 0L);
        }

        public void timeReached() {
            boolean good = Addresses.isConnected();
            if (CommSystemFacadeImpl.this._netMonitorStatus != good) {
                CommSystemFacadeImpl.this._context.router().eventLog().addEvent("network", good ? "connected" : "disconnected");
                CommSystemFacadeImpl.this._netMonitorStatus = good;
            }
            this.reschedule(good ? 180000L : 15000L);
        }
    }

    private class QueueAll
    implements SimpleTimer.TimedEvent {
        private QueueAll() {
        }

        public void timeReached() {
            for (Hash h : CommSystemFacadeImpl.this._context.netDb().getAllRouters()) {
                byte[] ip;
                RouterInfo ri = CommSystemFacadeImpl.this._context.netDb().lookupRouterInfoLocally(h);
                if (ri == null || (ip = CommSystemFacadeImpl.getIP(ri)) == null) continue;
                CommSystemFacadeImpl.this._geoIP.add(ip);
            }
            CommSystemFacadeImpl.this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new Lookup(), 5000L, 1800000L);
        }
    }

    private class Timestamper
    implements SimpleTimer.TimedEvent {
        private Timestamper() {
        }

        public void timeReached() {
            long peerOffset = CommSystemFacadeImpl.this.getFramedAveragePeerClockSkew(50);
            if (peerOffset == 0L) {
                return;
            }
            long currentOffset = CommSystemFacadeImpl.this._context.clock().getOffset();
            long newOffset = currentOffset - peerOffset;
            CommSystemFacadeImpl.this._context.clock().setOffset(newOffset);
        }
    }
}

