/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.tasks.ThreadDump;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class OOMListener
implements I2PThread.OOMEventListener {
    private final RouterContext _context;
    private final AtomicBoolean _wasCalled = new AtomicBoolean();

    public OOMListener(RouterContext ctx) {
        this._context = ctx;
    }

    public void outOfMemory(OutOfMemoryError oom) {
        try {
            if (this._context.router().isFinalShutdownInProgress()) {
                return;
            }
        }
        catch (OutOfMemoryError oome) {
            // empty catch block
        }
        try {
            if (this._wasCalled.getAndSet(true)) {
                return;
            }
        }
        catch (OutOfMemoryError oome) {
            // empty catch block
        }
        try {
            Thread.currentThread().setPriority(9);
        }
        catch (OutOfMemoryError oome) {
            // empty catch block
        }
        try {
            Router.clearCaches();
        }
        catch (OutOfMemoryError oome) {
            // empty catch block
        }
        Log log = null;
        try {
            log = this._context.logManager().getLog(Router.class);
            log.log(50, "Thread ran out of memory, shutting down I2P", (Throwable)oom);
            log.log(50, "free mem: " + Runtime.getRuntime().freeMemory() + " total mem: " + Runtime.getRuntime().totalMemory());
            if (this._context.hasWrapper()) {
                log.log(50, "To prevent future shutdowns, increase wrapper.java.maxmemory in $I2P/wrapper.config");
            }
        }
        catch (OutOfMemoryError oome) {
            // empty catch block
        }
        try {
            ThreadDump.dump(this._context, 1);
        }
        catch (OutOfMemoryError oome) {
            // empty catch block
        }
        try {
            this._context.router().eventLog().addEvent("oom");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        this._context.router().shutdown(10);
    }
}

