/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Hash;
import net.i2p.data.SimpleDataStructure;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.RouterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchState {
    private final RouterContext _context;
    private final HashSet<Hash> _pendingPeers;
    private final Map<Hash, Long> _pendingPeerTimes;
    private final HashSet<Hash> _attemptedPeers;
    private final HashSet<Hash> _failedPeers;
    private final HashSet<Hash> _successfulPeers;
    private final HashSet<Hash> _repliedPeers;
    private final Hash _searchKey;
    private volatile long _completed;
    private volatile long _started;

    public SearchState(RouterContext context, Hash key) {
        this._context = context;
        this._searchKey = key;
        this._pendingPeers = new HashSet(16);
        this._attemptedPeers = new HashSet(16);
        this._failedPeers = new HashSet(16);
        this._successfulPeers = new HashSet(16);
        this._pendingPeerTimes = new HashMap<Hash, Long>(16);
        this._repliedPeers = new HashSet(16);
        this._completed = -1L;
        this._started = this._context.clock().now();
    }

    public Hash getTarget() {
        return this._searchKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getPending() {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            return new HashSet<Hash>(this._pendingPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getAttempted() {
        HashSet<Hash> hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            return new HashSet<Hash>(this._attemptedPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getClosestAttempted(int max) {
        HashSet<Hash> hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            return this.locked_getClosest(this._attemptedPeers, max, this._searchKey);
        }
    }

    private Set<Hash> locked_getClosest(Set<Hash> peers, int max, Hash target) {
        if (this._attemptedPeers.size() <= max) {
            return new HashSet<Hash>(this._attemptedPeers);
        }
        TreeSet<Hash> closest = new TreeSet<Hash>((Comparator<Hash>)new XORComparator((SimpleDataStructure)target));
        closest.addAll(this._attemptedPeers);
        HashSet<Hash> rv = new HashSet<Hash>(max);
        Iterator iter = closest.iterator();
        for (int i = 0; iter.hasNext() && i < max; ++i) {
            rv.add((Hash)iter.next());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasAttempted(Hash peer) {
        HashSet<Hash> hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            return this._attemptedPeers.contains(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getSuccessful() {
        HashSet<Hash> hashSet = this._successfulPeers;
        synchronized (hashSet) {
            return new HashSet<Hash>(this._successfulPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getFailed() {
        HashSet<Hash> hashSet = this._failedPeers;
        synchronized (hashSet) {
            return new HashSet<Hash>(this._failedPeers);
        }
    }

    public boolean completed() {
        return this._completed != -1L;
    }

    public void complete(boolean completed) {
        if (completed) {
            this._completed = this._context.clock().now();
        }
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getWhenCompleted() {
        return this._completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Collection<Hash> pending) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.addAll(pending);
            for (Hash peer : pending) {
                this._pendingPeerTimes.put(peer, this._context.clock().now());
            }
        }
        hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.addAll(pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Hash peer) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.add(peer);
            this._pendingPeerTimes.put(peer, this._context.clock().now());
        }
        hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePending(Hash peer) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
            this._pendingPeerTimes.remove(peer);
        }
        hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            this._attemptedPeers.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long dataFound(Hash peer) {
        long rv = -1L;
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
            Long when = this._pendingPeerTimes.remove(peer);
            if (when != null) {
                rv = this._context.clock().now() - when;
            }
        }
        hashSet = this._successfulPeers;
        synchronized (hashSet) {
            this._successfulPeers.add(peer);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replyFound(Hash peer) {
        HashSet<Hash> hashSet = this._repliedPeers;
        synchronized (hashSet) {
            this._repliedPeers.add(peer);
        }
        hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
            Long when = this._pendingPeerTimes.remove(peer);
            if (when != null) {
                return this._context.clock().now() - when;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getRepliedPeers() {
        HashSet<Hash> hashSet = this._repliedPeers;
        synchronized (hashSet) {
            return new HashSet<Hash>(this._repliedPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyTimeout(Hash peer) {
        HashSet<Hash> hashSet = this._pendingPeers;
        synchronized (hashSet) {
            this._pendingPeers.remove(peer);
            this._pendingPeerTimes.remove(peer);
        }
        hashSet = this._failedPeers;
        synchronized (hashSet) {
            this._failedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("Searching for ").append(this._searchKey);
        buf.append(" ");
        if (this._completed <= 0L) {
            buf.append(" completed? false ");
        } else {
            buf.append(" completed on ").append(new Date(this._completed));
        }
        buf.append("\n\tAttempted: ");
        HashSet<Hash> hashSet = this._attemptedPeers;
        synchronized (hashSet) {
            buf.append(this._attemptedPeers.size()).append(' ');
            for (Hash peer : this._attemptedPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append("\n\tPending: ");
        hashSet = this._pendingPeers;
        synchronized (hashSet) {
            buf.append(this._pendingPeers.size()).append(' ');
            for (Hash peer : this._pendingPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append("\n\tFailed: ");
        hashSet = this._failedPeers;
        synchronized (hashSet) {
            buf.append(this._failedPeers.size()).append(' ');
            for (Hash peer : this._failedPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        buf.append("\n\tSuccessful: ");
        hashSet = this._successfulPeers;
        synchronized (hashSet) {
            buf.append(this._successfulPeers.size()).append(' ');
            for (Hash peer : this._successfulPeers) {
                buf.append(peer.toBase64()).append(" ");
            }
        }
        return buf.toString();
    }
}

