/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.client.SendMessageOptions;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.Certificate;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.ClientMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.OutboundCache;
import net.i2p.router.message.OutboundClientMessageJobHelper;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.Log;

public class OutboundClientMessageOneShotJob
extends JobImpl {
    private final Log _log;
    private final OutboundCache _cache;
    private final long _overallExpiration;
    private final ClientMessage _clientMessage;
    private final MessageId _clientMessageId;
    private final int _clientMessageSize;
    private final Destination _from;
    private final Destination _to;
    private final String _toString;
    private LeaseSet _leaseSet;
    private Lease _lease;
    private PayloadGarlicConfig _clove;
    private long _cloveId;
    private final long _start;
    private final AtomicBoolean _finished = new AtomicBoolean();
    private long _leaseSetLookupBegin;
    private TunnelInfo _outTunnel;
    private TunnelInfo _inTunnel;
    private boolean _wantACK;
    private final OutboundCache.HashPair _hashPair;
    public static final String OVERALL_TIMEOUT_MS_PARAM = "clientMessageTimeout";
    private static final long OVERALL_TIMEOUT_MS_DEFAULT = 60000L;
    private static final long OVERALL_TIMEOUT_MS_MIN = 8000L;
    public static final String BUNDLE_REPLY_LEASESET = "shouldBundleReplyInfo";
    private static final int REPLY_REQUEST_INTERVAL = 60000;

    public OutboundClientMessageOneShotJob(RouterContext ctx, OutboundCache cache, ClientMessage msg) {
        super(ctx);
        this._cache = cache;
        this._log = ctx.logManager().getLog(OutboundClientMessageOneShotJob.class);
        long timeoutMs = 60000L;
        this._clientMessage = msg;
        this._clientMessageId = msg.getMessageId();
        this._clientMessageSize = msg.getPayload().getSize();
        this._from = msg.getFromDestination();
        this._to = msg.getDestination();
        this._hashPair = new OutboundCache.HashPair(this._from.calculateHash(), this._to.calculateHash());
        this._toString = this._to.calculateHash().toBase64().substring(0, 4);
        this._start = this.getContext().clock().now();
        long overallExpiration = msg.getExpiration();
        if (overallExpiration > 0L) {
            if (overallExpiration < 86400000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Client bug - interval instead of timestamp " + overallExpiration);
                }
                overallExpiration += this._start;
            }
            if (overallExpiration > this._start) {
                overallExpiration = Math.max(overallExpiration, this._start + 8000L);
                overallExpiration = Math.min(overallExpiration, this._start + 60000L);
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Message Expiration (ms): " + (overallExpiration - this._start));
                }
            } else if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Expired before we got to it");
            }
        } else {
            String param = msg.getSenderConfig().getOptions().getProperty(OVERALL_TIMEOUT_MS_PARAM);
            if (param == null) {
                param = ctx.router().getConfigSetting(OVERALL_TIMEOUT_MS_PARAM);
            }
            if (param != null) {
                try {
                    timeoutMs = Long.parseLong(param);
                }
                catch (NumberFormatException nfe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Invalid client message timeout specified [" + param + "], defaulting to " + 60000L, (Throwable)nfe);
                    }
                    timeoutMs = 60000L;
                }
            }
            overallExpiration = timeoutMs + this._start;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + " Default Expiration (ms): " + timeoutMs);
            }
        }
        this._overallExpiration = overallExpiration;
    }

    public static void init(RouterContext ctx) {
        ctx.statManager().createFrequencyStat("client.sendMessageFailFrequency", "How often does a client fail to send a message?", "ClientMessages", new long[]{60000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.sendMessageSize", "How large are messages sent by the client?", "ClientMessages", new long[]{60000L, 3600000L, 86400000L});
        ctx.statManager().createRequiredRateStat("client.sendAckTime", "Message round trip time (ms)", "ClientMessages", new long[]{60000L, 300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionTunnel", "How lagged our tunnels are when a send times out?", "ClientMessages", new long[]{60000L, 300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionMessage", "How fast we process messages locally when a send times out?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.timeoutCongestionInbound", "How much faster we are receiving data than our average bps when a send times out?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFoundLocally", "How often we tried to look for a leaseSet and found it locally?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFoundRemoteTime", "How long we tried to look for a remote leaseSet (when we succeeded)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.leaseSetFailedRemoteTime", "How long we tried to look for a remote leaseSet (when we failed)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchPrepareTime", "How long until we've queued up the dispatch job (since we started)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchTime", "How long until we've dispatched the message (since we started)?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchSendTime", "How long the actual dispatching takes?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchNoTunnels", "How long after start do we run out of tunnels to send/receive with?", "ClientMessages", new long[]{300000L, 3600000L, 86400000L});
        ctx.statManager().createRateStat("client.dispatchNoACK", "Repeated message sends to a peer (no ack required)", "ClientMessages", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRateStat("crypto.garlic.decryptFail", "How often garlic messages are undecryptable", "Encryption", new long[]{300000L, 3600000L, 86400000L});
    }

    public String getName() {
        return "Outbound client message";
    }

    public void runJob() {
        long now = this.getContext().clock().now();
        if (now >= this._overallExpiration) {
            this.dieFatal(14);
            return;
        }
        long timeoutMs = this._overallExpiration - now;
        Hash key = this._to.calculateHash();
        SendJob success = new SendJob(this.getContext());
        this._leaseSet = this.getContext().netDb().lookupLeaseSetLocally(key);
        if (this._leaseSet != null) {
            this.getContext().statManager().addRateData("client.leaseSetFoundLocally", 1L, 0L);
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Send outbound client message - leaseSet found locally for " + this._toString);
            }
            success.runJob();
        } else {
            this._leaseSetLookupBegin = this.getContext().clock().now();
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Send outbound client message - sending off leaseSet lookup job for " + this._toString);
            }
            LookupLeaseSetFailedJob failed = new LookupLeaseSetFailedJob(this.getContext());
            this.getContext().netDb().lookupLeaseSet(key, success, failed, timeoutMs, this._from.calculateHash());
        }
    }

    private LeaseSet getReplyLeaseSet(boolean force) {
        LeaseSet newLS = this.getContext().netDb().lookupLeaseSetLocally(this._from.calculateHash());
        if (newLS == null) {
            return null;
        }
        LeaseSet ls = this._cache.leaseSetCache.put(this._hashPair, newLS);
        if (!force && ls != null) {
            if (ls.equals((Object)newLS)) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Found in cache - NOT including reply leaseset for " + this._toString);
                }
                return null;
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Expired from cache - reply leaseset for " + this._toString);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Added to cache - reply leaseset for " + this._toString);
        }
        return newLS;
    }

    private boolean getNextLease() {
        int i;
        if (this._leaseSet == null) {
            this._leaseSet = this.getContext().netDb().lookupLeaseSetLocally(this._to.calculateHash());
            if (this._leaseSet == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getJobId() + ": Lookup locally didn't find the leaseSet for " + this._toString);
                }
                return false;
            }
        }
        this._lease = this._cache.leaseCache.get(this._hashPair);
        if (this._lease != null) {
            if (!this._lease.isExpired(60000L)) {
                for (int i2 = 0; i2 < this._leaseSet.getLeaseCount(); ++i2) {
                    Lease lease = this._leaseSet.getLease(i2);
                    if (!this._lease.getTunnelId().equals((Object)lease.getTunnelId()) || !this._lease.getGateway().equals((Object)lease.getGateway())) continue;
                    if (this._log.shouldLog(20)) {
                        this._log.info(this.getJobId() + ": Found in cache - lease for " + this._toString);
                    }
                    return true;
                }
            }
            this._cache.leaseCache.remove(this._hashPair, this._lease);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": Expired from cache - lease for " + this._toString);
            }
        }
        ArrayList<Lease> leases = new ArrayList<Lease>(this._leaseSet.getLeaseCount());
        for (i = 0; i < this._leaseSet.getLeaseCount(); ++i) {
            Lease lease = this._leaseSet.getLease(i);
            if (lease.isExpired(60000L)) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info(this.getJobId() + ": getNextLease() - expired lease! - " + lease + " for " + this._toString);
                continue;
            }
            leases.add(lease);
        }
        if (leases.isEmpty()) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": No leases found from: " + this._leaseSet);
            }
            return false;
        }
        Collections.shuffle(leases, (Random)this.getContext().random());
        for (i = 0; i < leases.size(); ++i) {
            Lease l = (Lease)leases.get(i);
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(l.getGateway());
            if (ri == null || ri.getCapabilities().indexOf(85) < 0) {
                this._lease = l;
                break;
            }
            if (!this._log.shouldLog(30)) continue;
            this._log.warn(this.getJobId() + ": Skipping unreachable gateway " + l.getGateway() + " for " + this._toString);
        }
        if (this._lease == null) {
            this._lease = (Lease)leases.get(0);
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": All leases are unreachable for " + this._toString);
            }
        }
        this._cache.leaseCache.put(this._hashPair, this._lease);
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Added to cache - lease for " + this._toString);
        }
        this._wantACK = true;
        return true;
    }

    private void send() {
        long token;
        LeaseSet replyLeaseSet;
        boolean allowLeaseBundle;
        if (this._finished.get()) {
            return;
        }
        long now = this.getContext().clock().now();
        if (now >= this._overallExpiration) {
            this.dieFatal(14);
            return;
        }
        this._outTunnel = this.selectOutboundTunnel(this._to);
        Long lastReplyRequestSent = this._cache.lastReplyRequestCache.get(this._hashPair);
        boolean shouldRequestReply = lastReplyRequestSent == null || lastReplyRequestSent < now - 60000L;
        int sendFlags = this._clientMessage.getFlags();
        int tagsRequired = SendMessageOptions.getTagThreshold((int)sendFlags);
        boolean wantACK = this._wantACK || shouldRequestReply || GarlicMessageBuilder.needsTags(this.getContext(), this._leaseSet.getEncryptionKey(), this._from.calculateHash(), tagsRequired);
        PublicKey key = this._leaseSet.getEncryptionKey();
        SessionKey sessKey = new SessionKey();
        HashSet<SessionTag> tags = new HashSet<SessionTag>();
        String allow = this._clientMessage.getSenderConfig().getOptions().getProperty(BUNDLE_REPLY_LEASESET);
        boolean bl = allowLeaseBundle = SendMessageOptions.getSendLeaseSet((int)sendFlags) && (allow == null || Boolean.parseBoolean(allow));
        if (allowLeaseBundle) {
            replyLeaseSet = this.getReplyLeaseSet(false);
            if (replyLeaseSet != null) {
                wantACK = true;
            }
        } else {
            replyLeaseSet = null;
        }
        if (wantACK) {
            this._cache.lastReplyRequestCache.put(this._hashPair, now);
            token = this.getContext().random().nextLong(0xFFFFFFFFL);
            this._inTunnel = this.selectInboundTunnel();
        } else {
            token = -1L;
        }
        boolean ok = this.buildClove();
        if (!ok) {
            this.dieFatal(17);
            return;
        }
        long msgExpiration = this._overallExpiration;
        int tagsToSend = SendMessageOptions.getTagsToSend((int)sendFlags);
        GarlicMessage msg = OutboundClientMessageJobHelper.createGarlicMessage(this.getContext(), token, msgExpiration, key, this._clove, this._from.calculateHash(), this._to, this._inTunnel, tagsToSend, tagsRequired, sessKey, tags, wantACK, replyLeaseSet);
        if (msg == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Unable to create the garlic message (no tunnels left or too lagged) to " + this._toString);
            }
            this.getContext().statManager().addRateData("client.dispatchNoTunnels", now - this._start, 0L);
            this.dieFatal(16);
            return;
        }
        SendSuccessJob onReply = null;
        SendTimeoutJob onFail = null;
        ReplySelector selector = null;
        if (wantACK) {
            SessionKeyManager skm;
            TagSetHandle tsh = null;
            if (!tags.isEmpty() && (skm = this.getContext().clientManager().getClientSessionKeyManager(this._from.calculateHash())) != null) {
                tsh = skm.tagsDelivered(this._leaseSet.getEncryptionKey(), sessKey, tags);
            }
            onReply = new SendSuccessJob(this.getContext(), sessKey, tsh);
            onFail = new SendTimeoutJob(this.getContext(), sessKey, tsh);
            selector = new ReplySelector(token);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": GarlicMessage in new tunnel msg for " + this._toString + " at " + this._lease.getTunnelId() + " on " + this._lease.getGateway());
        }
        if (this._outTunnel != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Sending msg out " + this._outTunnel.getSendTunnelId(0) + " to " + this._toString + " at " + this._lease.getTunnelId() + " on " + this._lease.getGateway());
            }
            DispatchJob dispatchJob = new DispatchJob(this.getContext(), msg, selector, onReply, onFail, (int)(this._overallExpiration - this.getContext().clock().now()));
            dispatchJob.runJob();
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Could not find any outbound tunnels to send the payload through... this might take a while");
            }
            this.getContext().statManager().addRateData("client.dispatchNoTunnels", now - this._start, 0L);
            this.dieFatal(16);
        }
        this._clove = null;
        this.getContext().statManager().addRateData("client.dispatchPrepareTime", now - this._start, 0L);
        if (!wantACK) {
            this.getContext().statManager().addRateData("client.dispatchNoACK", 1L, 0L);
        }
    }

    private void clearCaches() {
        this._cache.clearCaches(this._hashPair, this._lease, this._inTunnel, this._outTunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TunnelInfo selectOutboundTunnel(Destination to) {
        TunnelInfo tunnel;
        Map<OutboundCache.HashPair, TunnelInfo> map = this._cache.tunnelCache;
        synchronized (map) {
            tunnel = this._cache.backloggedTunnelCache.get(this._hashPair);
            if (tunnel != null) {
                if (this.getContext().tunnelManager().isValidTunnel(this._from.calculateHash(), tunnel)) {
                    if (!this.getContext().commSystem().isBacklogged(tunnel.getPeer(1))) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Switching back to tunnel " + tunnel + " for " + this._toString);
                        }
                        this._cache.backloggedTunnelCache.remove(this._hashPair);
                        this._cache.tunnelCache.put(this._hashPair, tunnel);
                        this._wantACK = true;
                        return tunnel;
                    }
                } else {
                    this._cache.backloggedTunnelCache.remove(this._hashPair);
                }
            }
            if ((tunnel = this._cache.tunnelCache.get(this._hashPair)) != null) {
                if (this.getContext().tunnelManager().isValidTunnel(this._from.calculateHash(), tunnel)) {
                    if (tunnel.getLength() <= 1 || !this.getContext().commSystem().isBacklogged(tunnel.getPeer(1))) {
                        return tunnel;
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Switching from backlogged " + tunnel + " for " + this._toString);
                    }
                    this._cache.backloggedTunnelCache.put(this._hashPair, tunnel);
                }
                this._cache.tunnelCache.remove(this._hashPair);
            }
            if ((tunnel = this.selectOutboundTunnel()) != null) {
                this._cache.tunnelCache.put(this._hashPair, tunnel);
            }
            this._wantACK = true;
        }
        return tunnel;
    }

    private TunnelInfo selectOutboundTunnel() {
        Hash gw = this._lease.getGateway();
        return this.getContext().tunnelManager().selectOutboundTunnel(this._from.calculateHash(), gw);
    }

    private TunnelInfo selectInboundTunnel() {
        return this.getContext().tunnelManager().selectInboundTunnel(this._from.calculateHash());
    }

    private void dieFatal(int status) {
        if (this._finished.getAndSet(true)) {
            return;
        }
        long sendTime = this.getContext().clock().now() - this._start;
        if (this._log.shouldLog(30)) {
            this._log.warn(this.getJobId() + ": Send failed (cause: " + status + ") " + this._clientMessageId + " to " + this._toString + " out " + this._outTunnel + " in " + this._lease + " ack " + this._inTunnel + " after " + sendTime + "ms");
        }
        long messageDelay = this.getContext().throttle().getMessageDelay();
        long tunnelLag = this.getContext().throttle().getTunnelLag();
        long inboundDelta = (long)this.getContext().throttle().getInboundRateDelta();
        this.getContext().statManager().addRateData("client.timeoutCongestionTunnel", tunnelLag, 1L);
        this.getContext().statManager().addRateData("client.timeoutCongestionMessage", messageDelay, 1L);
        this.getContext().statManager().addRateData("client.timeoutCongestionInbound", inboundDelta, 1L);
        this.clearCaches();
        this.getContext().messageHistory().sendPayloadMessage(this._clientMessageId.getMessageId(), false, sendTime);
        this.getContext().clientManager().messageDeliveryStatusUpdate(this._from, this._clientMessageId, status);
        this.getContext().statManager().updateFrequency("client.sendMessageFailFrequency");
        this._clove = null;
    }

    private boolean buildClove() {
        PayloadGarlicConfig clove = new PayloadGarlicConfig();
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(1);
        instructions.setDestination(this._to.calculateHash());
        clove.setCertificate(Certificate.NULL_CERT);
        clove.setDeliveryInstructions(instructions);
        clove.setExpiration(60000L + this.getContext().clock().now());
        clove.setId(this.getContext().random().nextLong(0xFFFFFFFFL));
        DataMessage msg = new DataMessage(this.getContext());
        Payload p = this._clientMessage.getPayload();
        if (p == null) {
            return false;
        }
        byte[] d = p.getEncryptedData();
        if (d == null) {
            return false;
        }
        msg.setData(d);
        msg.setMessageExpiration(clove.getExpiration());
        clove.setPayload(msg);
        this._clove = clove;
        this._cloveId = this._clove.getId();
        return true;
    }

    private class DispatchJob
    extends JobImpl {
        private final GarlicMessage _msg;
        private final ReplySelector _selector;
        private final SendSuccessJob _replyFound;
        private final SendTimeoutJob _replyTimeout;
        private final int _timeoutMs;

        public DispatchJob(RouterContext ctx, GarlicMessage msg, ReplySelector sel, SendSuccessJob success, SendTimeoutJob timeout, int timeoutMs) {
            super(ctx);
            this._msg = msg;
            this._selector = sel;
            this._replyFound = success;
            this._replyTimeout = timeout;
            this._timeoutMs = timeoutMs;
        }

        public String getName() {
            return "Outbound client message dispatch";
        }

        public void runJob() {
            if (this._selector != null) {
                this.getContext().messageRegistry().registerPending(this._selector, this._replyFound, this._replyTimeout, this._timeoutMs);
            }
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": Dispatching message to " + OutboundClientMessageOneShotJob.this._toString + ": " + this._msg);
            }
            long before = this.getContext().clock().now();
            this.getContext().tunnelDispatcher().dispatchOutbound(this._msg, OutboundClientMessageOneShotJob.this._outTunnel.getSendTunnelId(0), OutboundClientMessageOneShotJob.this._lease.getTunnelId(), OutboundClientMessageOneShotJob.this._lease.getGateway());
            long dispatchSendTime = this.getContext().clock().now() - before;
            this.getContext().statManager().addRateData("client.dispatchTime", this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._start, 0L);
            this.getContext().statManager().addRateData("client.dispatchSendTime", dispatchSendTime, 0L);
        }
    }

    private class LookupLeaseSetFailedJob
    extends JobImpl {
        public LookupLeaseSetFailedJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "Outbound client message lease lookup failed";
        }

        public void runJob() {
            if (OutboundClientMessageOneShotJob.this._leaseSetLookupBegin > 0L) {
                long lookupTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._leaseSetLookupBegin;
                this.getContext().statManager().addRateData("client.leaseSetFailedRemoteTime", lookupTime, lookupTime);
            }
            if (!OutboundClientMessageOneShotJob.this._finished.get() && OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                OutboundClientMessageOneShotJob.this._log.warn("Unable to send to " + OutboundClientMessageOneShotJob.this._toString + " because we couldn't find their leaseSet");
            }
            OutboundClientMessageOneShotJob.this.dieFatal(21);
        }
    }

    private class ReplySelector
    implements MessageSelector {
        private final long _pendingToken;

        public ReplySelector(long token) {
            this._pendingToken = token;
        }

        public boolean continueMatching() {
            return false;
        }

        public long getExpiration() {
            return OutboundClientMessageOneShotJob.this._overallExpiration;
        }

        public boolean isMatch(I2NPMessage inMsg) {
            if (inMsg.getType() == 10) {
                return this._pendingToken == ((DeliveryStatusMessage)inMsg).getMessageId();
            }
            return false;
        }

        public String toString() {
            return "sending " + OutboundClientMessageOneShotJob.this._toString + " waiting for token " + this._pendingToken + " for cloveId " + OutboundClientMessageOneShotJob.this._cloveId;
        }
    }

    private class SendJob
    extends JobImpl {
        public SendJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "Outbound client message send";
        }

        public void runJob() {
            if (OutboundClientMessageOneShotJob.this._leaseSetLookupBegin > 0L) {
                long lookupTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._leaseSetLookupBegin;
                this.getContext().statManager().addRateData("client.leaseSetFoundRemoteTime", lookupTime, 0L);
            }
            OutboundClientMessageOneShotJob.this._wantACK = false;
            boolean ok = OutboundClientMessageOneShotJob.this.getNextLease();
            if (ok) {
                OutboundClientMessageOneShotJob.this.send();
            } else {
                if (OutboundClientMessageOneShotJob.this._log.shouldLog(30)) {
                    OutboundClientMessageOneShotJob.this._log.warn("Unable to send on a random lease, as getNext returned null (to=" + OutboundClientMessageOneShotJob.this._toString + ")");
                }
                OutboundClientMessageOneShotJob.this.dieFatal(21);
            }
        }
    }

    private class SendSuccessJob
    extends JobImpl
    implements ReplyJob {
        private final SessionKey _key;
        private final TagSetHandle _tags;

        public SendSuccessJob(RouterContext enclosingContext, SessionKey key, TagSetHandle tags) {
            super(enclosingContext);
            this._key = key;
            this._tags = tags;
        }

        public String getName() {
            return "Outbound client message send success";
        }

        public void runJob() {
            int i;
            SessionKeyManager skm;
            if (OutboundClientMessageOneShotJob.this._finished.getAndSet(true)) {
                return;
            }
            long sendTime = this.getContext().clock().now() - OutboundClientMessageOneShotJob.this._start;
            if (OutboundClientMessageOneShotJob.this._log.shouldLog(20)) {
                OutboundClientMessageOneShotJob.this._log.info(OutboundClientMessageOneShotJob.this.getJobId() + ": SUCCESS!  msg " + OutboundClientMessageOneShotJob.this._clientMessageId + " acked by DSM after " + sendTime + "ms");
            }
            if (this._key != null && this._tags != null && OutboundClientMessageOneShotJob.this._leaseSet != null && (skm = this.getContext().clientManager().getClientSessionKeyManager(OutboundClientMessageOneShotJob.this._from.calculateHash())) != null) {
                skm.tagsAcked(OutboundClientMessageOneShotJob.this._leaseSet.getEncryptionKey(), this._key, this._tags);
            }
            long dataMsgId = OutboundClientMessageOneShotJob.this._cloveId;
            this.getContext().messageHistory().sendPayloadMessage(dataMsgId, true, sendTime);
            this.getContext().clientManager().messageDeliveryStatusUpdate(OutboundClientMessageOneShotJob.this._from, OutboundClientMessageOneShotJob.this._clientMessageId, 4);
            int size = OutboundClientMessageOneShotJob.this._clientMessageSize;
            this.getContext().statManager().addRateData("client.sendAckTime", sendTime, 0L);
            this.getContext().statManager().addRateData("client.sendMessageSize", (long)OutboundClientMessageOneShotJob.this._clientMessageSize, sendTime);
            if (OutboundClientMessageOneShotJob.this._outTunnel != null) {
                if (OutboundClientMessageOneShotJob.this._outTunnel.getLength() > 0) {
                    size = (size + 1023) / 1024 * 1024;
                }
                for (i = 0; i < OutboundClientMessageOneShotJob.this._outTunnel.getLength(); ++i) {
                    this.getContext().profileManager().tunnelTestSucceeded(OutboundClientMessageOneShotJob.this._outTunnel.getPeer(i), sendTime);
                    this.getContext().profileManager().tunnelDataPushed(OutboundClientMessageOneShotJob.this._outTunnel.getPeer(i), sendTime, size);
                }
                OutboundClientMessageOneShotJob.this._outTunnel.incrementVerifiedBytesTransferred(size);
            }
            if (OutboundClientMessageOneShotJob.this._inTunnel != null) {
                for (i = 0; i < OutboundClientMessageOneShotJob.this._inTunnel.getLength(); ++i) {
                    this.getContext().profileManager().tunnelTestSucceeded(OutboundClientMessageOneShotJob.this._inTunnel.getPeer(i), sendTime);
                }
            }
        }

        public void setMessage(I2NPMessage msg) {
        }
    }

    private class SendTimeoutJob
    extends JobImpl {
        private final SessionKey _key;
        private final TagSetHandle _tags;

        public SendTimeoutJob(RouterContext enclosingContext, SessionKey key, TagSetHandle tags) {
            super(enclosingContext);
            this._key = key;
            this._tags = tags;
        }

        public String getName() {
            return "Outbound client message send timeout";
        }

        public void runJob() {
            SessionKeyManager skm;
            if (this._key != null && this._tags != null && OutboundClientMessageOneShotJob.this._leaseSet != null && (skm = this.getContext().clientManager().getClientSessionKeyManager(OutboundClientMessageOneShotJob.this._from.calculateHash())) != null) {
                skm.failTags(OutboundClientMessageOneShotJob.this._leaseSet.getEncryptionKey(), this._key, this._tags);
            }
            OutboundClientMessageOneShotJob.this.dieFatal(3);
        }
    }
}

