/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Map;
import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class CreateSessionJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;

    public CreateSessionJob(RouterContext context, ClientConnectionRunner runner) {
        super(context);
        this._log = context.logManager().getLog(CreateSessionJob.class);
        this._runner = runner;
        if (this._log.shouldLog(10)) {
            this._log.debug("CreateSessionJob for runner " + this._runner + " / config: " + this._runner.getConfig());
        }
    }

    public String getName() {
        return "Request tunnels for a new client";
    }

    public void runJob() {
        SessionConfig cfg = this._runner.getConfig();
        if (cfg == null || cfg.getDestination() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("No session config on runner " + this._runner);
            }
            return;
        }
        Hash dest = cfg.getDestination().calculateHash();
        if (this._log.shouldLog(20)) {
            this._log.info("Requesting lease set for destination " + dest);
        }
        ClientTunnelSettings settings = new ClientTunnelSettings(dest);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)cfg.getOptions());
        settings.readFromProperties(props);
        this.getContext().tunnelManager().buildTunnels(cfg.getDestination(), settings);
    }
}

