/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.RouterThrottleImpl;

class RouterDoSThrottle
extends RouterThrottleImpl {
    private volatile long _currentLookupPeriod;
    private final AtomicInteger _currentLookupCount = new AtomicInteger();
    private static final long LOOKUP_THROTTLE_PERIOD = 10000L;
    private static final long LOOKUP_THROTTLE_MAX = 20L;

    public RouterDoSThrottle(RouterContext context) {
        super(context);
        context.statManager().createRateStat("router.throttleNetDbDoS", "How many netDb lookup messages have we received so far during a period with a DoS detected", "Throttle", new long[]{60000L, 600000L, 3600000L, 86400000L});
    }

    public boolean acceptNetDbLookupRequest(Hash key) {
        boolean shouldAccept = super.acceptNetDbLookupRequest(key);
        if (!shouldAccept) {
            return false;
        }
        long now = this._context.clock().now();
        if (this._currentLookupPeriod + 10000L > now) {
            int cnt = this._currentLookupCount.incrementAndGet();
            if ((long)cnt >= 20L) {
                this._context.statManager().addRateData("router.throttleNetDbDoS", (long)cnt, 0L);
                int rand = this._context.random().nextInt(cnt);
                return (long)rand <= 20L;
            }
            return true;
        }
        this._currentLookupPeriod = now;
        this._currentLookupCount.set(1);
        return true;
    }
}

