/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionConfig;

public class ClientMessage {
    private final Payload _payload;
    private final Destination _destination;
    private final Destination _fromDestination;
    private final SessionConfig _senderConfig;
    private final Hash _destinationHash;
    private final MessageId _messageId;
    private final long _expiration;
    private final int _flags;

    public ClientMessage(Destination toDest, Payload payload, SessionConfig config, Destination fromDest, MessageId msgID, long expiration, int flags) {
        this._destination = toDest;
        this._destinationHash = null;
        this._payload = payload;
        this._senderConfig = config;
        this._fromDestination = fromDest;
        this._messageId = msgID;
        this._expiration = expiration;
        this._flags = flags;
    }

    public ClientMessage(Hash toDestHash, Payload payload) {
        this._destination = null;
        this._destinationHash = toDestHash;
        this._payload = payload;
        this._senderConfig = null;
        this._fromDestination = null;
        this._messageId = null;
        this._expiration = 0L;
        this._flags = 0;
    }

    public Payload getPayload() {
        return this._payload;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public Destination getFromDestination() {
        return this._fromDestination;
    }

    public Hash getDestinationHash() {
        return this._destinationHash;
    }

    public MessageId getMessageId() {
        return this._messageId;
    }

    public SessionConfig getSenderConfig() {
        return this._senderConfig;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public int getFlags() {
        return this._flags;
    }
}

