/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ResettableGZIPOutputStream
extends DeflaterOutputStream {
    private boolean _headerWritten;
    private long _writtenSize;
    private final CRC32 _crc32 = new CRC32();
    private static final boolean DEBUG = false;
    private static final byte[] HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 2, -1};

    public ResettableGZIPOutputStream(OutputStream o) {
        super(o, new Deflater(9, true));
    }

    public void reset() {
        this.def.reset();
        this._crc32.reset();
        this._writtenSize = 0L;
        this._headerWritten = false;
    }

    private void ensureHeaderIsWritten() throws IOException {
        if (this._headerWritten) {
            return;
        }
        this.out.write(HEADER);
        this._headerWritten = true;
    }

    private void writeFooter() throws IOException {
        long crcVal = this._crc32.getValue();
        this.out.write((int)(crcVal & 0xFFL));
        this.out.write((int)(crcVal >>> 8 & 0xFFL));
        this.out.write((int)(crcVal >>> 16 & 0xFFL));
        this.out.write((int)(crcVal >>> 24 & 0xFFL));
        long sizeVal = this._writtenSize;
        this.out.write((int)(sizeVal & 0xFFL));
        this.out.write((int)(sizeVal >>> 8 & 0xFFL));
        this.out.write((int)(sizeVal >>> 16 & 0xFFL));
        this.out.write((int)(sizeVal >>> 24 & 0xFFL));
        this.out.flush();
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    public void finish() throws IOException {
        this.ensureHeaderIsWritten();
        super.finish();
        this.writeFooter();
    }

    public void write(int b) throws IOException {
        this.ensureHeaderIsWritten();
        this._crc32.update(b);
        ++this._writtenSize;
        super.write(b);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.ensureHeaderIsWritten();
        this._crc32.update(buf, off, len);
        this._writtenSize += (long)len;
        super.write(buf, off, len);
    }
}

