/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.util.EepGet;

public class PartialEepGet
extends EepGet {
    long _fetchSize;

    public PartialEepGet(I2PAppContext ctx, String proxyHost, int proxyPort, OutputStream outputStream, String url, long size) {
        super(ctx, proxyHost != null && proxyPort > 0, proxyHost, proxyPort, 0, size, size, null, outputStream, url, true, null, null);
        this._fetchSize = size;
    }

    public static void main(String[] args) {
        PartialEepGet get;
        FileOutputStream out;
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        long size = 56L;
        String url = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-p")) {
                    proxyHost = args[i + 1].substring(0, args[i + 1].indexOf(58));
                    String port = args[i + 1].substring(args[i + 1].indexOf(58) + 1);
                    proxyPort = Integer.parseInt(port);
                    ++i;
                    continue;
                }
                if (args[i].equals("-l")) {
                    size = Long.parseLong(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    PartialEepGet.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PartialEepGet.usage();
            return;
        }
        if (url == null) {
            PartialEepGet.usage();
            return;
        }
        String saveAs = PartialEepGet.suggestName(url);
        try {
            out = new FileOutputStream(saveAs);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create output file " + saveAs);
            return;
        }
        PartialEepGet partialEepGet = get = new PartialEepGet(I2PAppContext.getGlobalContext(), proxyHost, proxyPort, out, url, size);
        partialEepGet.getClass();
        get.addStatusListener(partialEepGet.new EepGet.CLIStatusListener(1024, 40));
        if (get.fetch(45000L, -1L, 60000L)) {
            System.err.println("Last-Modified: " + get.getLastModified());
            System.err.println("Etag: " + get.getETag());
        } else {
            System.err.println("Failed " + url);
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("PartialEepGet [-p 127.0.0.1:4444] [-l #bytes] url\n              (use -p :0 for no proxy)");
    }

    protected String getRequest() throws IOException {
        String urlToSend;
        StringBuilder buf = new StringBuilder(2048);
        URL url = new URL(this._actualURL);
        String host = url.getHost();
        if (host == null || host.length() <= 0) {
            throw new MalformedURLException("Bad URL, no host");
        }
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        if (this._log.shouldLog(10)) {
            this._log.debug("Requesting " + this._actualURL);
        }
        if (this._shouldProxy) {
            urlToSend = this._actualURL;
            if (!(path != null && path.length() > 0 || query != null && query.length() > 0)) {
                urlToSend = urlToSend + "/";
            }
        } else {
            urlToSend = path;
            if (urlToSend == null || urlToSend.length() <= 0) {
                urlToSend = "/";
            }
            if (query != null) {
                urlToSend = urlToSend + '?' + query;
            }
        }
        buf.append("GET ").append(urlToSend).append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(host);
        if (port >= 0) {
            buf.append(':').append(port);
        }
        buf.append("\r\n");
        buf.append("Range: bytes=");
        buf.append(this._alreadyTransferred);
        buf.append('-');
        buf.append(this._fetchSize - 1L);
        buf.append("\r\n");
        buf.append("Cache-control: no-cache\r\nPragma: no-cache\r\nAccept-Encoding: \r\nConnection: close\r\n");
        boolean uaOverridden = false;
        if (this._extraHeaders != null) {
            for (String hdr : this._extraHeaders) {
                if (hdr.toLowerCase(Locale.US).startsWith("user-agent: ")) {
                    uaOverridden = true;
                }
                buf.append(hdr).append("\r\n");
            }
        }
        if (!uaOverridden) {
            buf.append("User-Agent: Wget/1.11.4\r\n");
        }
        buf.append("\r\n");
        if (this._log.shouldLog(10)) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }
}

