/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.crypto.prng.AsyncFortunaStandalone;
import java.security.SecureRandom;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EntropyHarvester;
import net.i2p.util.RandomSource;

public class FortunaRandomSource
extends RandomSource
implements EntropyHarvester {
    private final AsyncFortunaStandalone _fortuna;
    private double _nextGaussian;
    private boolean _haveNextGaussian;

    public FortunaRandomSource(I2PAppContext context) {
        super(context);
        this._fortuna = new AsyncFortunaStandalone(context);
        byte[] seed = new byte[1024];
        if (this.initSeed(seed)) {
            this._fortuna.seed(seed);
        } else {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(seed);
            this._fortuna.seed(seed);
        }
        this._fortuna.startup();
        this._fortuna.nextBytes(seed);
        this._haveNextGaussian = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            this._fortuna.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeed(byte[] buf) {
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            this._fortuna.addRandomBytes(buf);
        }
    }

    public int nextInt(int n) {
        if (n == 0) {
            return 0;
        }
        int rv = this.signedNextInt(n);
        if (rv < 0) {
            rv = 0 - rv;
        }
        return rv %= n;
    }

    public int nextInt() {
        return this.signedNextInt(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int signedNextInt(int n) {
        int rv;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int numBits = n > 1048575 ? 31 : (n > 4095 ? 24 : (n > 15 ? 16 : 8));
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            rv = this.nextBits(numBits);
        }
        return rv % n;
    }

    public long nextLong(long n) {
        if (n == 0L) {
            return 0L;
        }
        long rv = this.signedNextLong();
        if (rv < 0L) {
            rv = 0L - rv;
        }
        return rv %= n;
    }

    public long nextLong() {
        return this.signedNextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long signedNextLong() {
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            return ((long)this.nextBits(32) << 32) + (long)this.nextBits(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextBoolean() {
        byte val;
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            val = this._fortuna.nextByte();
        }
        return (val & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] buf) {
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            this._fortuna.nextBytes(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] buf, int offset, int length) {
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            this._fortuna.nextBytes(buf, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double nextDouble() {
        long d;
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            d = ((long)this.nextBits(26) << 27) + (long)this.nextBits(27);
        }
        return (double)d / 9.007199254740992E15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float nextFloat() {
        int d;
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            d = this.nextBits(24);
        }
        return (float)d / 1.6777216E7f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double nextGaussian() {
        FortunaRandomSource fortunaRandomSource = this;
        synchronized (fortunaRandomSource) {
            double v2;
            double v1;
            double s;
            if (this._haveNextGaussian) {
                this._haveNextGaussian = false;
                return this._nextGaussian;
            }
            while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
            }
            double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
            this._nextGaussian = v2 * multiplier;
            this._haveNextGaussian = true;
            return v1 * multiplier;
        }
    }

    protected int nextBits(int numBits) {
        long rv = 0L;
        int bytes = (numBits + 7) / 8;
        for (int i = 0; i < bytes; ++i) {
            rv += (long)((this._fortuna.nextByte() & 0xFF) << i * 8);
        }
        if (rv < 0L) {
            rv = 0L - rv;
        }
        int off = 8 * bytes - numBits;
        return (int)(rv >>>= off);
    }

    public EntropyHarvester harvester() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedEntropy(String source, long data, int bitoffset, int bits) {
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            this._fortuna.addRandomByte((byte)(data & 0xFFL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedEntropy(String source, byte[] data, int offset, int len) {
        AsyncFortunaStandalone asyncFortunaStandalone = this._fortuna;
        synchronized (asyncFortunaStandalone) {
            this._fortuna.addRandomBytes(data, offset, len);
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty("prng.buffers", "12");
            I2PAppContext ctx = new I2PAppContext(props);
            RandomSource rand = ctx.random();
            byte[] buf = new byte[65536];
            while (true) {
                rand.nextBytes(buf);
                System.out.write(buf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

