/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.kademlia;

import java.util.Comparator;
import net.i2p.data.SimpleDataStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XORComparator<T extends SimpleDataStructure>
implements Comparator<T> {
    private final byte[] _base;

    public XORComparator(T target) {
        this._base = ((SimpleDataStructure)target).getData();
    }

    @Override
    public int compare(T lhs, T rhs) {
        byte[] lhsb = ((SimpleDataStructure)lhs).getData();
        byte[] rhsb = ((SimpleDataStructure)rhs).getData();
        for (int i = 0; i < this._base.length; ++i) {
            int ld = (lhsb[i] ^ this._base[i]) & 0xFF;
            int rd = (rhsb[i] ^ this._base[i]) & 0xFF;
            if (ld < rd) {
                return -1;
            }
            if (ld <= rd) continue;
            return 1;
        }
        return 0;
    }
}

