/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import gnu.crypto.hash.Sha256Standalone;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;

public final class SHA256Generator {
    private final LinkedBlockingQueue<MessageDigest> _digests = new LinkedBlockingQueue(32);
    private static final boolean _useGnu;

    public SHA256Generator(I2PAppContext context) {
    }

    public static final SHA256Generator getInstance() {
        return I2PAppContext.getGlobalContext().sha();
    }

    public final Hash calculateHash(byte[] source) {
        return this.calculateHash(source, 0, source.length);
    }

    public final Hash calculateHash(byte[] source, int start, int len) {
        MessageDigest digest = this.acquire();
        digest.update(source, start, len);
        byte[] rv = digest.digest();
        this.release(digest);
        return Hash.create(rv);
    }

    public final void calculateHash(byte[] source, int start, int len, byte[] out, int outOffset) {
        MessageDigest digest = this.acquire();
        digest.update(source, start, len);
        byte[] rv = digest.digest();
        this.release(digest);
        System.arraycopy(rv, 0, out, outOffset, rv.length);
    }

    private MessageDigest acquire() {
        MessageDigest rv = this._digests.poll();
        if (rv != null) {
            rv.reset();
        } else {
            rv = SHA256Generator.getDigestInstance();
        }
        return rv;
    }

    private void release(MessageDigest digest) {
        this._digests.offer(digest);
    }

    public static MessageDigest getDigestInstance() {
        if (!_useGnu) {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return new GnuMessageDigest();
    }

    static {
        boolean useGnu = false;
        try {
            MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            useGnu = true;
            System.out.println("INFO: Using GNU SHA-256");
        }
        _useGnu = useGnu;
    }

    private static class GnuMessageDigest
    extends MessageDigest {
        private final Sha256Standalone _gnu = new Sha256Standalone();

        protected GnuMessageDigest() {
            super("SHA-256");
        }

        protected byte[] engineDigest() {
            return this._gnu.digest();
        }

        protected void engineReset() {
            this._gnu.reset();
        }

        protected void engineUpdate(byte input) {
            this._gnu.update(input);
        }

        protected void engineUpdate(byte[] input, int offset, int len) {
            this._gnu.update(input, offset, len);
        }
    }
}

