/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CertUtil;
import net.i2p.data.Base32;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

public class KeyStoreUtil {
    public static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String DEFAULT_KEY_ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 2048;
    private static final int DEFAULT_KEY_VALID_DAYS = 3652;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore createKeyStore(File ksFile, String password) throws GeneralSecurityException, IOException {
        KeyStore ks;
        char[] pwchars;
        boolean exists;
        block11: {
            exists = ksFile != null && ksFile.exists();
            pwchars = password != null ? password.toCharArray() : null;
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            if (exists) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(ksFile);
                    ks.load(fis, pwchars);
                    Object var7_6 = null;
                    if (fis == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (fis == null) throw throwable;
                    try {
                        ((InputStream)fis).close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ioe) {}
                ((InputStream)fis).close();
            }
        }
        if (ksFile == null) return ks;
        if (exists) return ks;
        SecureFileOutputStream fos = null;
        try {
            fos = new SecureFileOutputStream(ksFile);
            ks.store(fos, pwchars);
            Object var10_11 = null;
            if (fos == null) return ks;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (fos == null) throw throwable;
            try {
                ((OutputStream)fos).close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            return ks;
        }
        ((OutputStream)fos).close();
        return ks;
    }

    public static KeyStore loadSystemKeyStore() {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Key Store init error", gse);
            return null;
        }
        boolean success = false;
        String override = System.getProperty("javax.net.ssl.keyStore");
        if (override != null) {
            success = KeyStoreUtil.loadCerts(new File(override), ks);
        }
        if (!success) {
            if (SystemVersion.isAndroid()) {
                success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "etc/security/cacerts.bks"), ks);
            } else {
                success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "lib/security/jssecacerts"), ks);
                if (!success) {
                    success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "lib/security/cacerts"), ks);
                }
            }
        }
        if (!success) {
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            }
            catch (Exception exception) {
                // empty catch block
            }
            KeyStoreUtil.error("All key store loads failed, will only load local certificates", null);
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean loadCerts(File file, KeyStore ks) {
        block20: {
            if (!file.exists()) {
                return false;
            }
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            ks.load(fis, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            KeyStoreUtil.info("Certs loaded from " + file);
            Object var6_3 = null;
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
                break block20;
            }
            catch (IOException foo2) {}
            break block20;
            {
                catch (GeneralSecurityException gse) {
                    KeyStoreUtil.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), gse);
                    try {
                        ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
                    }
                    catch (Exception foo) {
                        // empty catch block
                    }
                    boolean foo = false;
                    Object var6_4 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo2) {
                        // empty catch block
                    }
                    return foo;
                }
                catch (IOException ioe) {
                    boolean bl;
                    try {
                        KeyStoreUtil.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), ioe);
                        try {
                            ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
                        }
                        catch (Exception foo) {
                            // empty catch block
                        }
                        bl = false;
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        try {
                            if (fis != null) {
                                ((InputStream)fis).close();
                            }
                        }
                        catch (IOException foo2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    public static int countCerts(KeyStore ks) {
        int count = 0;
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (!ks.isCertificateEntry(alias)) continue;
                KeyStoreUtil.info("Found cert " + alias);
                ++count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static int addCerts(File dir, KeyStore ks) {
        File[] files;
        KeyStoreUtil.info("Looking for X509 Certificates in " + dir.getAbsolutePath());
        int added = 0;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean success;
                File f = files[i];
                if (!f.isFile()) continue;
                String alias = f.getName().toLowerCase(Locale.US);
                if (alias.endsWith(".crt") || alias.endsWith(".pem") || alias.endsWith(".key") || alias.endsWith(".der") || alias.endsWith(".key") || alias.endsWith(".p7b") || alias.endsWith(".p7c") || alias.endsWith(".pfx") || alias.endsWith(".p12")) {
                    alias = alias.substring(0, alias.length() - 4);
                }
                if (!(success = KeyStoreUtil.addCert(f, alias, ks))) continue;
                ++added;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean addCert(File file, String alias, KeyStore ks) {
        block23: {
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
            KeyStoreUtil.info("Read X509 Certificate from " + file.getAbsolutePath() + " Issuer: " + cert.getIssuerX500Principal() + "; Valid From: " + cert.getNotBefore() + " To: " + cert.getNotAfter());
            try {
                cert.checkValidity();
            }
            catch (CertificateExpiredException cee) {
                KeyStoreUtil.error("Rejecting expired X509 Certificate: " + file.getAbsolutePath(), cee);
                boolean bl = false;
                Object var9_14 = null;
                try {
                    if (fis != null) {
                        ((InputStream)fis).close();
                    }
                }
                catch (IOException foo) {
                    // empty catch block
                }
                return bl;
            }
            catch (CertificateNotYetValidException cnyve) {
                KeyStoreUtil.error("Rejecting X509 Certificate not yet valid: " + file.getAbsolutePath(), cnyve);
                boolean bl = false;
                Object var9_15 = null;
                try {
                    if (fis != null) {
                        ((InputStream)fis).close();
                    }
                }
                catch (IOException foo) {
                    // empty catch block
                }
                return bl;
            }
            ks.setCertificateEntry(alias, cert);
            KeyStoreUtil.info("Now trusting X509 Certificate, Issuer: " + cert.getIssuerX500Principal());
            Object var9_16 = null;
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
                break block23;
            }
            catch (IOException foo) {}
            break block23;
            {
                catch (GeneralSecurityException gse) {
                    KeyStoreUtil.error("Error reading X509 Certificate: " + file.getAbsolutePath(), gse);
                    boolean bl = false;
                    Object var9_17 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (IOException ioe) {
                    KeyStoreUtil.error("Error reading X509 Certificate: " + file.getAbsolutePath(), ioe);
                    boolean bl = false;
                    Object var9_18 = null;
                    try {
                        if (fis != null) {
                            ((InputStream)fis).close();
                        }
                    }
                    catch (IOException foo) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var9_19 = null;
                try {
                    if (fis != null) {
                        ((InputStream)fis).close();
                    }
                }
                catch (IOException foo) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    public static String randomString() {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] rand = new byte[30];
        ctx.random().nextBytes(rand);
        return Base32.encode(rand);
    }

    public static boolean createKeys(File ks, String alias, String cname, String ou, String keyPW) {
        return KeyStoreUtil.createKeys(ks, DEFAULT_KEYSTORE_PASSWORD, alias, cname, ou, 3652, DEFAULT_KEY_ALGORITHM, 2048, keyPW);
    }

    public static boolean createKeys(File ks, String ksPW, String alias, String cname, String ou, int validDays, String keyAlg, int keySize, String keyPW) {
        String keytool;
        String[] args;
        boolean success;
        block14: {
            SecureDirectory sdir;
            if (ks.exists()) {
                try {
                    if (KeyStoreUtil.getCert(ks, ksPW, alias) != null) {
                        KeyStoreUtil.error("Not overwriting key " + alias + ", already exists in " + ks, null);
                        return false;
                    }
                    break block14;
                }
                catch (Exception e) {
                    KeyStoreUtil.error("Not overwriting key \"" + alias + "\", already exists in " + ks, e);
                    return false;
                }
            }
            File dir = ks.getParentFile();
            if (dir != null && !dir.exists() && !((File)(sdir = new SecureDirectory(dir.getAbsolutePath()))).mkdir()) {
                KeyStoreUtil.error("Can't create directory " + dir, null);
                return false;
            }
        }
        if (success = new ShellCommand().executeSilentAndWaitTimed(args = new String[]{keytool = new File(System.getProperty("java.home"), "bin/keytool").getAbsolutePath(), "-genkey", "-storetype", KeyStore.getDefaultType(), "-keystore", ks.getAbsolutePath(), "-storepass", ksPW, "-alias", alias, "-dname", "CN=" + cname + ",OU=" + ou + ",O=I2P Anonymous Network,L=XX,ST=XX,C=XX", "-validity", Integer.toString(validDays), "-keyalg", keyAlg, "-sigalg", KeyStoreUtil.getSigAlg(keySize, keyAlg), "-keysize", Integer.toString(keySize), "-keypass", keyPW}, 240)) {
            success = ks.exists();
            if (success) {
                try {
                    boolean bl = success = KeyStoreUtil.getPrivateKey(ks, ksPW, alias, keyPW) != null;
                    if (!success) {
                        KeyStoreUtil.error("Key gen failed to get private key", null);
                    }
                }
                catch (Exception e) {
                    KeyStoreUtil.error("Key gen failed to get private key", e);
                    success = false;
                }
            }
            if (!success) {
                KeyStoreUtil.error("Key gen failed for unknown reasons", null);
            }
        }
        if (success) {
            SecureFileOutputStream.setPerms(ks);
            KeyStoreUtil.info("Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath());
        } else {
            StringBuilder buf = new StringBuilder(256);
            for (int i = 0; i < args.length; ++i) {
                buf.append('\"').append(args[i]).append("\" ");
            }
            KeyStoreUtil.error("Failed to generate keys using command line: " + buf, null);
        }
        return success;
    }

    private static String getSigAlg(int size, String keyalg) {
        if (keyalg.equals("EC")) {
            keyalg = "ECDSA";
        }
        String hash = keyalg.equals("ECDSA") ? (size <= 256 ? "SHA256" : (size <= 384 ? "SHA384" : "SHA512")) : (size <= 1024 ? "SHA1" : (size <= 2048 ? "SHA256" : (size <= 3072 ? "SHA384" : "SHA512")));
        return hash + "with" + keyalg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKey(File ks, String ksPW, String alias, String keyPW) throws GeneralSecurityException, IOException {
        PrivateKey privateKey;
        block5: {
            FileInputStream fis = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                fis = new FileInputStream(ks);
                char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
                keyStore.load(fis, pwchars);
                char[] keypwchars = keyPW.toCharArray();
                privateKey = (PrivateKey)keyStore.getKey(alias, keypwchars);
                Object var10_9 = null;
                if (fis == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_10 = null;
                    if (fis == null) break block6;
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (IOException ioe) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fis).close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCert(File ks, String ksPW, String alias) throws GeneralSecurityException, IOException {
        Certificate certificate;
        block5: {
            FileInputStream fis = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                fis = new FileInputStream(ks);
                char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
                keyStore.load(fis, pwchars);
                certificate = keyStore.getCertificate(alias);
                Object var8_7 = null;
                if (fis == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (fis == null) break block6;
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (IOException ioe) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)fis).close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return certificate;
    }

    public static boolean exportCert(File ks, String ksPW, String alias, File certFile) {
        Object fis = null;
        try {
            Certificate cert = KeyStoreUtil.getCert(ks, ksPW, alias);
            if (cert != null) {
                return CertUtil.saveCert(cert, certFile);
            }
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Error saving ASCII SSL keys", gse);
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("Error saving ASCII SSL keys", ioe);
        }
        return false;
    }

    private static void info(String msg) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 20, msg, null);
    }

    private static void error(String msg, Throwable t) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 40, msg, t);
    }

    private static void log(I2PAppContext ctx, int level, String msg, Throwable t) {
        if (level >= 30 && !ctx.isRouterContext()) {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
        Log l = ctx.logManager().getLog(KeyStoreUtil.class);
        l.log(level, msg, t);
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                File ksf = new File(args[0]);
                KeyStoreUtil.createKeyStore(ksf, DEFAULT_KEYSTORE_PASSWORD);
                System.out.println("Created empty keystore " + ksf);
            } else {
                KeyStore ks = KeyStoreUtil.loadSystemKeyStore();
                if (ks != null) {
                    System.out.println("Loaded system keystore");
                    int count = KeyStoreUtil.countCerts(ks);
                    System.out.println("Found " + count + " certs");
                } else {
                    System.out.println("FAIL");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

